#!/bin/sh
# -----------------------------------------------------------------------------
# Author : yongchan jeon (Kris) poucotm@gmail.com
# File   : run.sh
# Create : 2020-11-15 11:52:40
# Editor : sublime text3, tab size (3)
# -----------------------------------------------------------------------------

if [[ $# -gt 0 ]]; then
	for l01 in `echo $@`; do
		if [[ ${#l01} -ge 2 ]]; then
			Ol0=`expr "${l01}" : "\([+-][a-zA-Z]\w*\)"`
			lO1=`expr "${l01}" : "${Ol0}=\(.*\)"`
			if [[ "${Ol0:0:1}" == "+" ]]; then
				eval ${Ol0:1}="'${l01}'"
				eval ${Ol0:1}S="+"
				eval ${Ol0:1}V="'${lO1}'"
			elif [[ "${Ol0:0:1}" == "-" ]]; then
				eval ${Ol0:1}="'${l01}'"
				eval ${Ol0:1}S="-"
				eval ${Ol0:1}V="'${lO1}'"
			fi
		fi
	done
fi

# log directory
if [ ! -e "logs" ]; then
	mkdir logs
fi
\rm -rf logs/*

# option
CMPOPT="-full64 -sverilog -timescale=1ns/1ps +notimingchecks +nospecify -debug_access=dmptf +vcs+lic+wait -l logs/comp.log"
if [ "${uvmS}" == "+" ]; then
	CMPOPT="$CMPOPT -ntb_opts uvm-1.2"
fi
SIMOPT="+vcs+lic+wait -l logs/run.log"
if [ "${seedS}" == "+" ]; then
	SIMOPT="$SIMOPT +ntb_random_seed=${seedV}"
else
	SIMOPT="$SIMOPT +ntb_random_seed_automatic"
fi

# compile
vcs ${CMPOPT} -f v.f

# simulation
./simv ${SIMOPT} ${fsdb}
