#!/bin/sh
# -----------------------------------------------------------------------------
# Author : yongchan jeon (Kris) poucotm@gmail.com
# File   : regression.sh
# Create : 2020-11-15 11:52:55
# Editor : sublime text3, tab size (3)
# -----------------------------------------------------------------------------

if [[ $# -gt 0 ]]; then
	for l01 in `echo $@`; do
		if [[ ${#l01} -ge 2 ]]; then
			Ol0=`expr "${l01}" : "\([+-][a-zA-Z]\w*\)"`
			lO1=`expr "${l01}" : "${Ol0}=\(.*\)"`
			if [[ "${Ol0:0:1}" == "+" ]]; then
				eval ${Ol0:1}="'${l01}'"
				eval ${Ol0:1}S="+"
				eval ${Ol0:1}V="'${lO1}'"
			elif [[ "${Ol0:0:1}" == "-" ]]; then
				eval ${Ol0:1}="'${l01}'"
				eval ${Ol0:1}S="-"
				eval ${Ol0:1}V="'${lO1}'"
			fi
		fi
	done
fi

# log, result directory
if [ ! -e "logs" ]; then
	mkdir logs
fi
\rm -rf logs/*
if [ ! -e "result" ]; then
	mkdir result
fi
\rm -rf result/*.log

# option
CMPOPT="-full64 -sverilog +notimingchecks +nospecify -debug_access=dmptf -timescale=1ns/1ps +vcs+lic+wait -l logs/comp.log"
if [ "${uvmS}" == "+" ]; then
	CMPOPT="$CMPOPT -ntb_opts uvm-1.2"
fi
SIMOPT="+vcs+lic+wait -l logs/run.log"
if [ "${seedS}" == "+" ]; then
	SIMOPT="$SIMOPT +ntb_random_seed=${seedV}"
else
	SIMOPT="$SIMOPT +ntb_random_seed_automatic"
fi

# iteration log
echo "{{MODULE NAME}} regression " > logs/iter.log

# regression
for (( i = 0; i < $1; i++ )); do
	RND=`head -c4 /dev/urandom | od -N4 -tu4 | sed -ne '1s/.* //p'`
	TYPE=`expr ${RND} % 2`

	# vcs ${CMPOPT} -f v.f +define+TYPE="\"${TYPE}\""
	echo ${CMPOPT} -f v.f
	touch logs/cmp.log
	# ./simv ${SIMOPT}
	echo ${SIMOPT}
	touch logs/run.log

	pass=`grep -E "PASS|SUCCESS" logs/run.log`
	fail=`grep -E "FAIL" logs/run.log`
	if [[ "$pass" == "" || "$fail" != "" ]]; then
		\cp -f logs/run.log result/run_xxx.log
		exit
	else
		echo "[ ${i} - TYPE=${TYPE} ]">> logs/iter.log
	fi
done
