"""
CSS 3 definitions - requires CSS 1 and CSS 2 modules.
"""

import textwrap

from codeintel2.constants_css1 import CSS_ATTR_DICT as CSS1_SPECIFIC_ATTRS_DICT
from codeintel2.constants_css1 import CSS_PROPERTY_ATTRIBUTE_CALLTIPS_DICT as CSS1_SPECIFIC_CALLTIP_DICT
from codeintel2.constants_css2 import CSS2_SPECIFIC_ATTRS_DICT, CSS2_SPECIFIC_CALLTIP_DICT

CSS_PSEUDO_CLASS_NAMES = """
    root
    nth-child(
    nth-last-child(
    nth-of-type(
    nth-last-of-type(
    first-child
    last-child
    first-of-type
    last-of-type
    only-child
    only-of-type
    empty
    link
    visited
    active
    hover
    focus
    target
    lang(
    enabled
    disabled
    checked
    first-line
    first-letter
    before
    after
    not(
""".split()


### START: Auto generated
CSS3_DATA = {

    'alignment-adjust':
    {'description': "The 'alignment-adjust' property allows more\nprecise alignment of elements, such as graphics, that do not have a\nbaseline-table or lack the desired baseline in their baseline-table. With the 'alignment-adjust' property, the position\nof the baseline identified by the 'alignment-baseline' can be explicitly\ndetermined. It also determines precisely the alignment point for each glyph\nwithin a textual element. The user agent should use heuristics to determine\nthe position of a non existing baseline for a given element. Values for the property have the following meaning: 4.7. Repositioning\nthe dominant baseline: the 'baseline-shift' property Name: baseline-shift Value: baseline | sub | super | <percentage> | <length> Initial: baseline Applies to: inline-level elements Inherited: no Percentages: refers to the 'line-height' of the parent element Media: visual Computed value: see text",
        'values': {'<length>': "The alignment-point is on the start-edge of the inline box. Its position\nalong the start-edge relative to the intersection of the dominant-baseline\nand the start-edge is offset by the <length> value. The offset is\nopposite to the shift-direction (positive value) or in the shift-direction\n(negative value). A value of '0cm' makes the dominant-baseline the alignment\npoint.",
                   '<percentage>': "The computed value of the property is this percentage multiplied by the\ncomputed 'line-height' of the element. The alignment point is on the\nstart-edge of the inline box. Its position along the start-edge relative to\nthe intersection of the dominant-baseline and the start-edge is offset by the\ncomputed value. The offset is opposite to the shift-direction (positive\nvalue) or in the shift-direction (negative value). A value of '0%' makes the\ndominant-baseline the alignment point.",
                   'after-edge': 'The alignment point is at the intersection of the start-edge of the\nelement and the after-edge of the extended inline box of the element. This may include or not the line-height of the element, depending on the line-stacking-strategy.',
                   'alphabetic': "The alignment point is at the intersection of the start-edge of the\nelement and the 'alphabetic' baseline of the element.",
                   'auto': "For each glyph corresponding to textual information within the element,\nthe alignment-point is the intersection of the start-edge of the glyph box\nand the block-progression-direction position of the alignment point from the\nfont. Padding, border or margin do not affect that alignment point. The\nalignment point of the inline-level element itself is at the intersection of\nthe start-edge of the first inline box and the baseline identified by the 'alignment-baseline' property if this\nbaseline exists in the baseline-table for the element dominant-baseline. If\nthat specific baseline does not exist, the user agent may use heuristics to\ndetermine where that missing baseline would be. For other inline box content\nlike images, the user agent will use heuristics to determine the position of\nthe alignment point. For example when the resulting baseline is 'alphabetic'\nor 'ideographic', it is expected that the alignment point will be at the\nintersection of the start-edge and the after-edge of the inline box,\nincluding its respective margin. If the resulting baseline is 'hanging', the\nintersection of the start-edge and the before-edge of the inline box,\nincluding its respective margin should be used instead.",
                   'baseline': 'The alignment point is at the intersection of the start-edge of the\nelement and the dominant-baseline of the element.',
                   'before-edge': 'The alignment point is at the intersection of the start-edge of the\nelement and the before-edge of the extended inline box of the element. This may include or not the line-height of the element, depending on the line-stacking-strategy.',
                   'central': "The alignment point is at the intersection of the start-edge of the\nelement and the 'central' baseline of the element.",
                   'hanging': "The alignment point is at the intersection of the start-edge of the\nelement and the 'hanging' baseline of the element.",
                   'ideographic': "The alignment point is at the intersection of the start-edge of the\nelement and the 'ideographic' baseline of the element.",
                   'mathematical': "The alignment point is at the intersection of the start-edge of the\nelement and the 'mathematical' baseline of the element.",
                   'middle': "The alignment point is at the intersection of the start-edge of the\nelement and the 'middle' baseline of the element.",
                   'text-after-edge': "The alignment point is at the intersection of the start-edge of the\nelement and the 'text-after-edge' baseline of the\nelement.",
                   'text-before-edge': "The alignment point is at the intersection of the start-edge of the\nelement and the 'text-before-edge' baseline of the\nelement."}},

    'alignment-baseline':
{'description': "This property specifies how an inline-level element is aligned with\nrespect to its parent. That is, to which of the parent's baselines the\nalignment point of this element is aligned. Unlike the 'dominant-baseline'\nproperty the 'alignment-baseline' property has no effect on its children\ndominant-baselines. Note: The 'alignment-adjust' property specifies how\nthe alignment point is determined and defaults to the baseline with the same\nname as the computed value of the alignment-baseline property. Except for 'use-script', all baseline values refer to the respective\nbaseline-identifier components of the dominant-baseline of the parent, and\nglyphs within the element are aligned similarly to the element itself. The\ndescription for 'use-script' covers these points specifically. The property\nvalues have the following meanings:",
 'values': {'after-edge': "The alignment point of the box is aligned with the 'after-edge' baseline\nof the line box.",
                          'alphabetic': 'The alignment-point of the element being aligned is aligned with the\nlower baseline of the parent.',
                          'baseline': 'The alignment-point of the element being aligned is aligned with the\ndominant baseline of the parent.',
                          'before-edge': "The alignment point of the box is aligned with the 'before-edge' baseline\nof the line box.",
                          'central': "The alignment point of the box is aligned with the 'central' baseline of\nthe parent.",
                          'hanging': 'The alignment-point of the element being aligned is aligned with the\nhanging baseline of the parent.',
                          'ideographic': "The alignment-point of the element being aligned is aligned with the\n'ideographic' baseline of the parent.",
                          'mathematical': 'The alignment-point of the element being aligned is aligned with the\nmathematical baseline of the parent.',
                          'middle': "The alignment point of the box is aligned with the 'middle' baseline of\nthe parent.",
                          'text-after-edge': "The alignment-point of the element being aligned is aligned with the 'text-after-edge' baseline of the parent.",
                          'text-before-edge': "The alignment-point of the element being aligned is aligned with the 'text-before-edge' baseline of the parent.",
                          'use-script': "If the element 'script' property value is 'auto', the alignment\npoint of each glyph is aligned with the baseline-identifier of the script to\nwhich the glyph belongs. If the element 'script' property value is other than 'auto', the\nalignment point of each glyph is aligned with the baseline-identifier\nspecified by the 'script' property. The baseline-identifier position is determined by using the\nrelevant information related to the parent element dominant-baseline set. The\nalignment point of the element itself is aligned as for the 'baseline' value."}},

    'animation':
{'description': "The 'animation' shorthand property combines six of the animation properties into a single property. Name: animation Value: [<animation-name> || <animation-duration> || <animation-timing-function> || <animation-delay> || <animation-iteration-count> || <animation-direction>] [, [<animation-name> || <animation-duration> || <animation-timing-function> || <animation-delay> || <animation-iteration-count> || <animation-direction>] ]* Initial: see individual properties Applies to: block-level and inline-level elements Inherited: no Percentages: N/A Media: visual Computed value: Same as specified value. ======================================================================================================= 4 Animation Events",
 'values': {}},

    'animation-delay':
{'description': "The 'animation-delay' property defines when the animation will start. It allows an animation to begin execution some time after it is applied. An 'animation-delay' value of '0' means the animation will execute as soon as it is applied. Otherwise, the value specifies an offset from the moment the animation is applied, and the animation will delay execution by that offset. If the value for 'animation-delay' is a negative time offset then the animation will execute the moment it is applied, but will appear to have begun execution at the specified offset. That is, the animation will appear to begin part-way through its play cycle. In the case where an animation has implied starting values and a negative 'animation-delay', the starting values are taken from the moment the animation is applied. Name: animation-delay Value: <time> [, <time>]* Initial: 0 Applies to: block-level and inline-level elements Inherited: no Percentages: N/A Media: visual Computed value: Same as specified value. ======================================================================================================= 3.9 The 'animation' Shorthand Property",
 'values': {}},

    'animation-direction':
{'description': "The 'animation-direction' property defines whether or not the animation should play in reverse on alternate cycles. If 'alternate' is specified, the animation cycle iterations that are odd counts are played in the normal direction, and the animation cycle iterations that are even counts are played in a reverse direction. When an animation is played in reverse the timing functions are also reversed. For example, when played in reverse an ease-in animation would appear to be an ease-out animation. Name: animation-direction Value: normal | alternate [, normal | alternate]* Initial: normal Applies to: block-level and inline-level elements Inherited: no Percentages: N/A Media: visual Computed value: Same as specified value. ======================================================================================================= 3.7 The 'animation-play-state' Property We are considering removing 'animation-play-state' since its behaviour can be replicated using other techniques. For example, by querying the computed style, removing the animation and then setting style.",
 'values': {}},

    'animation-duration':
{'description': "The 'animation-duration' property defines the length of time that an animation takes to complete one cycle. Name: animation-duration Value: <time> [, <time>]* Initial: 0 Applies to: block-level and inline-level elements Inherited: no Percentages: N/A Media: visual Computed value: Same as specified value. By default the value is '0', meaning that the animation cycle is immediate (i.e. there will be no animation). A negative value for animation-duration is treated as '0'.",
 'values': {}},

    'animation-iteration-count':
{'description': "The 'animation-iteration-count' property defines the number of times an animation cycle is played. The default value is one, meaning the animation will play from beginning to end once. A value of 'infinite' will cause the animation to repeat forever. Non-integer numbers will cause the animation to end part-way through a cycle. Negative values for 'animation-iteration-count' are treated as zero. This property is often used with an 'animation-direction' value of 'alternate', which will cause the animation to play in reverse on alternate cycles. Name: animation-iteration-count Value: infinite | <number> [, infinite | <number>]* Initial: 1 Applies to: block-level and inline-level elements Inherited: no Percentages: N/A Media: visual Computed value: Same as specified value. ======================================================================================================= 3.6 The 'animation-direction' Property",
 'values': {}},

    'animation-name':
{'description': 'The \'animation-name\' property defines a list of animations that apply. Each name is used to select the keyframe at-rule that provides the property values for the animation. If the name does not match any keyframe at-rule, there are no properties to be animated and the animation will not execute. Furthermore, if the animation name is \'none\' then there will be no animation. This can be used to override any animations coming from the cascade. Name: animation-name Value: none | IDENT [, none | IDENT ]* Initial: none Applies to: block-level and inline-level elements Inherited: no Percentages: N/A Media: visual Computed value: Same as specified value. <p> It is possible for elements to have multiple animations running that change the same property or properties. In this case the animations combine in a manner defined by the property. For example, animations on <span class="prop-name">opacity</span> will add together and animations on <span class="prop-name">transform</span> will have their transformation matrices multiplied. </p> <div class="example"> <p style="display:none"> Example(s): </p> <pre> @keyframes \'border-bloat\' { from { border-width: 0; } to { border-width: 10px; } } @keyframes \'border-diet\' { from { border-width: 4px; } to { border-width: 2px; } } div { animation-name: \'border-bloat\', \'border-diet\'; animation-duration: 10s, 4s; } </pre> <p> The above example has two animations executing on the same property, <span class="prop-name">border-width</span>. The animations are additive. That is, the resulting value for the property will be the addition of the values from the two animations. </p> <p> At time \'<code class=css>0s</code>\' the element\'s border will be 4px wide (0px from \'<code class=property>border-bloat</code>\' plus 4px from \'<code class=property>border-diet</code>\'). At time \'<code class=css>4s</code>\' the element\'s border will be 6px wide (4px from \'<code class=property>border-bloat</code>\' plus 2px from \'<code class=property>border-diet</code>\'). At time \'<code class=css>10s</code>\' the element\'s border will be 10px wide (10px from \'<code class=property>border-bloat</code>\' and no addition from \'<code class=property>border-diet</code>\' as it is no longer executing). </p> </div> ======================================================================================================= 3.3 The \'animation-duration\' Property',
 'values': {}},

    'animation-play-state':
{'description': "The 'animation-play-state' property defines whether the animation is running or paused. A running animation can be paused by setting this property to 'paused'. To continue running a paused animation this property can be set to 'running'. A paused animation will continue to display the current value of the animation in a static state, as if the time of the animation is constant. When a paused animation is resumed, it restarts from the current value, not necessarily from the beginning of the animation. Name: animation-play-state Value: running | paused [, running | paused]* Initial: running Applies to: block-level and inline-level elements Inherited: no Percentages: N/A Media: visual Computed value: Same as specified value. ======================================================================================================= 3.8 The 'animation-delay' Property",
 'values': {}},

    'animation-timing-function':
{'description': "The 'animation-timing-function' property describes how the animation will progress over one cycle of its duration. See the 'transition-timing-function' property [CSS3-TRANSITIONS] {{!CSS3-TRANSITIONS}} for a complete description of timing function calculation. Name: animation-timing-function Value: ease | linear | ease-in | ease-out | ease-in-out | cubic-bezier(<number>, <number>, <number>, <number>) [, ease | linear | ease-in | ease-out | ease-in-out | cubic-bezier(<number>, <number>, <number>, <number>)]* Initial: ease Applies to: block-level and inline-level elements Inherited: no Percentages: N/A Media: visual Computed value: Same as specified value. For a keyframed animation, the 'animation-timing-function' applies between keyframes, not over the entire animation. For example, in the case of an ease-in-out timing function, an animation will ease in at the start of the keyframe and ease out at the end of the keyframe. A 'animation-timing-function' defined within a keyframe block applies to that keyframe, otherwise the timing function specified for the animation is used.",
 'values': {}},

    'appearance':
{'description': 'This document introduces the \'appearance\' property which can be used to\nmake an element look like a standard user interface element on the platform. Example(s): A few \'appearance\' values demonstrated using HTML4 \'appearance\' HTML4 demonstration normal hello button Search push-button hyperlink CSS home page radio-button Sticky checkbox Gift\nwrap pop-up-menu Honey Water White Extra White White Extra Light Amber Light Amber Amber Dark Amber list-menu Honey Water White Extra White White Extra Light Amber Light Amber Amber Dark Amber radio-group tea Earl\nGrey lemon ginger green tea jasmine tea checkbox-group pizza toppings fresh\nbasil fresh garlic fresh spinach green\npeppers mushrooms olives onions pineapple tomatoes field Note to self. password \'appearance\' property detailsExample(s):The \'appearance\' property is a shorthand for \'appearance \', \'color \', \'font \', and \'cursor \'. It sets \'appearance\' to the specified value and the\nother properties to their appropriate system value; \'normal\' resets \'appearance\'to\' normal \' and the others to \'inherit\'. The \'appearance\' property does not affect the\nspecified or computed values of any other properties. If \'appearance\' is not \'normal\', the UA must render the element as\nif it was the specified user interface (UI) control from the platform. The UA\nshould use the computed values of the \'background-*\', \'border-*\', \'padding-*\', \'outline-*\', and \'text-decoration\' properties when they do not have\ntheir initial values and the computed values of \'color\', \'font\', and \'cursor\' (whatever their values) to influence the\nrendering where possible. Any values from those properties that cannot be\nused to influence the rendering of the UI control must not affect the\nrendering at all. For example, the UA should not draw a second border\naround a UI control that already has a border. If \'background-color\'or\'background-image\' have non-initial values and the UA\nis using their values for influencing the rendering of the UI control, then\nthe UA must ensure that the \'color\' property is\nalso used to influence the rendering. Similarly if <span class="property">\'color\'</span> is used to influence the rendering, then <span class="property">\'background-color\'</span> must be used to influence the rendering, and the other <span class="property">\'background-*\'</span> properties should be used to influence the rendering as well. Other properties must not affect the handling of \'appearance\' and must\ninstead be applied according to normal CSS rules. In particular \'margin\', \'display\', \'float\', \'height\', \'width\', and \'line-height\', are not ignored and affect the\nelement as normal. This specification does not define the term "platform". For example, it could be the native graphical rendering\nengine of the operating system, or it could be a user-agent-specific skin. In\naddition, which of several toolkits to use could also be decided on an\nelement-by-element basis depending on the values of the \'background-color\', \'background-image\', \'border-*-style\', and \'outline-style\' properties, so that the\nauthor styles could be honored while still honoring \'appearance\' even though the UA is unable to\ninfluence the rendering of OS native UI controls. Note. The exact list of properties set\nby, influencing, and not affected by \'appearance\' given in the lists above may be\nadjusted based on UA implementor feedback. Appearance values take into account the user interface state (if any) of\nthe element; thus there is no need for separate values for enabled vs.\ndisabled checkboxes for example. Example(s): Influencing the color and\nbackground-color of a button This example demonstrates setting the color and background-color of an\nelement that is set to \' appearance:push-button \'. sample CSS: input[type=button] { appearance:push-button; /* expected from UA defaults */\n} input[type=button].custom { color: #393; background-color: #9cf; } sample (X)HTML fragment: <input type="button" value="Plain button" /> <input type="button" value="With color" class="custom" /> A graphical browser might render\nthese buttons as follows: First, a rounded button\nwith black text on a white background, with shades of gray being used near\nthe edges to give the impression of depth. Second, a similar rounded button but\nwith blue text on a light blue background, and with shades of blue used to\ngive the impression of depth. Your browser on your system: 5.3. System fontsExample(s):This example demonstrates setting the color and background-color of an\nelement that is set to \' appearance:push-button \'. First, a rounded button\nwith black text on a white background, with shades of gray being used near\nthe edges to give the impression of depth. Second, a similar rounded button but\nwith blue text on a light blue background, and with shades of blue used to\ngive the impression of depth.',
 'values': {}},

    'background-clip':
{'description': 'Determines the background painting area.',
 'values': {'border-box': "The background is painted within (clipped to) the border box.",
                          'content-box': "The background is painted within (clipped to) the content box.",
                          'padding-box': "The background is painted within (clipped to) the padding box."}},

    'background-origin':
{'description': "For elements rendered as a single box, specifies the background positioning area. For elements rendered as multiple boxes (e.g., inline boxes on several lines, boxes on several pages) specifies which boxes 'box-decoration-break' operates on to determine the background positioning area(s).",
 'values': {'content-box': "The position is relative to the content box."}},

    'background-size':
{'description': "Specifies the size of the background images. Where <bg-size> = [ <length> | <percentage> | auto ]{1,2} | cover | contain. Values have the following meanings: Here are some examples. The first example stretches the background image independently in both dimensions to completely cover the content area: div { background-image: url(plasma.png); background-repeat: no-repeat; background-size: 100% 100%; background-origin: content-box } The second example stretches the image so that exactly two copies fit horizontally. The aspect ratio is preserved: p { background-image: url(tubes.png); background-size: 50% auto; background-origin: border-box } This example forces the background image to be 15 by 15 pixels: para { background-size: 15px 15px; background-image: url(tile.png)} This example uses the image's intrinsic size. Note that this is the only possible behavior in CSS level 1 and 2. body { background-size: auto; /* default */ background-image: url(flower.png) } The following example rounds the height of the image to 25%, down from the specified value of 30%. At 30%, three images would fit entirely and a fourth only partially. After rounding, four images fit. The width of the image is 20% of the background area width and is not rounded. p { background-image: url(chain.png); background-repeat: no-repeat round; background-size: 20% 30% }",
 'values': {'cover': "Scale the image, while preserving its intrinsic aspect ratio (if any), to the smallest size such that both its width and its height can completely cover the background positioning area.",
            'contain': "Specifies that the background image should be scaled to be as large as possible while ensuring both its dimensions are less than or equal to the corresponding dimensions of the background positioning area.",
            'auto': "[ <length> | <percentage> | auto ]{1,2}. The first value gives the width of the corresponding image, the second value its height. If only one value is given the second is assumed to be 'auto'. A percentage is relative to the background positioning area. An 'auto' value for one dimension is resolved by using the image's intrinsic ratio and the size of the other dimension, or failing that, using the image's intrinsic size, or failing that, treating it as 100%. If both values are 'auto' then the intrinsic width and/or height of the image should be used, if any, the missing dimension (if any) behaving as ''auto'' as described above. If the image has neither an intrinsic width nor an intrinsic height, its size is determined as for 'contain'. Negative values are not allowed."}},

    'baseline-shift':
{'description': "The 'baseline-shift' property allows\nrepositioning of the dominant-baseline relative to the dominant-baseline. The\nshifted object might be a sub- or superscript. Within the shifted element,\nthe whole baseline table is offset; not just a single baseline. For sub- and\nsuperscript, the amount of offset is determined from the nominal font of the\nparent. Values for the property have the following meaning:",
 'values': {'<length>': "The dominant-baseline is shifted in the shift-direction (positive value)\nor opposite to the shift-direction (negative value) of the parent area by the\n<length> value. A value of '0cm' is equivalent to 'baseline'.",
            '<percentage>': "The computed value of the property is this percentage multiplied by the\ncomputed 'line-height' of the parent element. The dominant-baseline is\nshifted in the shift-direction (positive value) or opposite to the\nshift-direction (negative value) of the parent area by the computed value. A\nvalue of '0%' is equivalent to 'baseline'.",
            'baseline': 'There is no baseline shift; the dominant baseline remains in its original\nposition.',
            'sub': 'The dominant baseline is shifted to the default position for subscripts.\nThe offset for this position is determined by the font data for the parent\nnominal font as adjusted by the dominant baseline-table font-size of the\nparent element. If there is no applicable font data the User Agent may use\nheuristic to determine the offset.',
            'super': 'The dominant baseline is shifted to the default position for\nsuperscripts. The offset for this position is determined by the font data for\nthe parent nominal font as adjusted by the dominant baseline-table font-size\nof the parent element. If there is no applicable font data the User Agent may\nuse heuristic to determine the offset.'}},

    'binding':
{'description': 'A property to attach a binding to a particular element.',
 'values': {'url(': 'The specified binding is attached. More than one binding can be specified, resulting in the bindings being attached in the specified order. The relevant language specification(s) define how multiple bindings interact. When the bindings interact through linear inheritance, the last binding specified must inherit from the previous one, and so forth, up to the first binding.',
            'none': 'No bindings are to be attached through CSS.'}},

    'bookmark-label':
{'description': 'This property specifies the label of the bookmark, i.e., the text that will represent the bookmark in the bookmark structure. a { bookmark-label: attr(title, string) }\nh1 { bookmark-label: content() }\nh2 { bookmark-label: content(before) }\n#frog { bookmark-label: "The green frog" } Name: bookmark-target Value: none | <uri> | <attr> Initial: none Applies to: all elements Inherited: no Percentages: N/A Media: all Computed value: For URI values, the absolute URI; for attr() values, the resulting URI or string; for other keywords, as specified. This property specifies the target of the bookmark link..bookmark { bookmark-label: attr(title, string); bookmark-target: attr(href, url);\n}\n...\n<a class="bookmark" title="The green pear" href="#pears"/>.exable { bookmark-label: url(http://www.example.com) } Name: bookmark-state Value: open | closed Initial: open Applies to: block-level elements Inherited: no Percentages: N/A Media: all Computed value: specified valueThis property describes the initial state of a bookmark. * { bookmark-state: closed }\n#open { bookmark-state: open } 11. CMYK colors',
 'values': {}},

    'bookmark-level':
{'description': 'This property describes what level a certain bookmark has in a hierarchical bookmark structure. The highest level is 1, then 2, 3 etc. h1 { bookmark-level: 1 }\nh2 { bookmark-level: 2 }\nh3 { bookmark-level: 3 } Name: bookmark-label Value: content() | attr() | <string> Initial: content() Applies to: all elements Inherited: no Percentages: N/A Media: all Computed value: specified valueThis property specifies the label of the bookmark, i.e., the text that will represent the bookmark in the bookmark structure. a { bookmark-label: attr(title, string) }\nh1 { bookmark-label: content() }\nh2 { bookmark-label: content(before) }\n#frog { bookmark-label: "The green frog" } Name: bookmark-target Value: none | <uri> | <attr> Initial: none Applies to: all elements Inherited: no Percentages: N/A Media: all Computed value: For URI values, the absolute URI; for attr() values, the resulting URI or string; for other keywords, as specified. This property specifies the target of the bookmark link..bookmark { bookmark-label: attr(title, string); bookmark-target: attr(href, url);\n}\n...\n<a class="bookmark" title="The green pear" href="#pears"/>.exable { bookmark-label: url(http://www.example.com) } Name: bookmark-state Value: open | closed Initial: open Applies to: block-level elements Inherited: no Percentages: N/A Media: all Computed value: specified valueThis property describes the initial state of a bookmark. * { bookmark-state: closed }\n#open { bookmark-state: open } 11. CMYK colors',
 'values': {}},

    'bookmark-target':
{'description': 'This property specifies the target of the bookmark link..bookmark { bookmark-label: attr(title, string); bookmark-target: attr(href, url);\n}\n...\n<a class="bookmark" title="The green pear" href="#pears"/>.exable { bookmark-label: url(http://www.example.com) } Name: bookmark-state Value: open | closed Initial: open Applies to: block-level elements Inherited: no Percentages: N/A Media: all Computed value: specified valueThis property describes the initial state of a bookmark. * { bookmark-state: closed }\n#open { bookmark-state: open } 11. CMYK colors',
 'values': {}},

    'border-bottom-left-radius':
{'description': "The two length or percentage values of the 'border-*-radius' properties define the radii of a quarter ellipse that defines the shape of the corner of the outer border edge (see the diagram below). The first value is the horizontal radius, the second the vertical radius. If the second value is omitted it is copied from the first. If either length is zero, the corner is square, not rounded. Percentages for the horizontal radius refer to the width of the border box, whereas percentages for the vertical radius refer to the height of the border box. The two values of ' border-top-left-radius: 55pt 25pt ' define the curvature of the corner. The two values of ' border-top-left-radius: 55pt 25pt ' define the curvature of the corner. The 'border-radius' shorthand sets all four 'border-*-radius' properties. If values are given before and after the slash, then the values before the slash set the horizontal radius and the values after the slash set the vertical radius. If there is no slash, then the values set both radii equally. The four values for each radii are given in the order top-left, top-right, bottom-right, bottom-left. If bottom-left is omitted it is the same as top-right. If bottom-right is omitted it is the same as top-left. If top-right is omitted it is the same as top-left. border-radius: 4em; is equivalent to border-top-left-radius: 4em;\nborder-top-right-radius: 4em;\nborder-bottom-right-radius: 4em;\nborder-bottom-left-radius: 4em; and border-radius: 2em 1em 4em / 0.5em 3em; is equivalent to border-top-left-radius: 2em 0.5em;\nborder-top-right-radius: 1em 3em;\nborder-bottom-right-radius: 4em 0.5em;\nborder-bottom-left-radius: 1em 3em; 4.4.1. Corner ShapingThe padding edge (inner border) radius is the outer border radius minus the corresponding border thickness. In the case where this results in a negative value, the inner radius is zero. (In such cases its center might not coincide with that of the outer border curve.) Likewise the content edge radius is the padding edge radius minus the corresponding padding, or if that is negative, zero. The border and padding thicknesses in the curved region are thus interpolated from the adjoining sides, and when two adjoining borders are of different thicknesses the corner will show a smooth transition between the thicker and thinner borders. Note that this means that if the outer curve extends past the adjacent corner's padding edge, the inner curve may not be a full quarter ellipse. All border styles ('solid', 'dotted', 'inset', etc.) follow the curve of the border. The effect of a rounded corner when the two borders it connects are of unequal thickness (left) and the effect of a rounded corner on borders that are thicker than the radius of the corner (right). 4.4.2. Corner ClippingThe effect of a rounded corner when the two borders it connects are of unequal thickness (left) and the effect of a rounded corner on borders that are thicker than the radius of the corner (right). A box's backgrounds, but not its border-image, are clipped to the appropriate curve (as determined by 'background-clip'). Other effects that clip to the border or padding edge (such as 'overflow' other than 'visible') also must clip to the curve. The content of replaced elements is always trimmed to the content edge curve. Also, the area outside the curve of the border edge does not accept mouse events on behalf of the element. This example adds appropriate padding, so that the contents do not overflow the corners. Note that there is no border, but the background will still have rounded corners. DIV { background: black; color: white; border-radius: 1em; padding: 1em } 4.4.3. Color and Style TransitionsThis example adds appropriate padding, so that the contents do not overflow the corners. Note that there is no border, but the background will still have rounded corners. DIV { background: black; color: white; border-radius: 1em; padding: 1em }Color and style transitions must be contained within the segment of the border that intersects the smallest rectangle that contains both border radii as well as the center of the inner curve (which may be a point representing the corner of the padding edge, if the border radii are smaller than the border-width). The center of color and style transitions between adjoining borders is at the point on the curve that is at an angle that is proportional to the ratio of the border widths. For example, if the top and right border widths are equal, that point is at a 45 angle from the horizontal, and if the top is twice the width of the right the point is at a 30 angle from the horizontal. The line demarcating this transition is drawn between the point at that angle on the outer arc and the point at that angle on the inner arc. It is not defined what these transitions look like, but a gradient is recommended for color transitions that don't involve dotted or dashed borders. Given these corner shapes, color and style transitions must be contained within the green region. In case D the rectangle defined by the border radii does not include the center of the inner curve (which is a sharp corner), so the transition region is expanded to include that corner. Transitions may take up the entire transition region, but are not required to: For example, a gradient color transition between two solid border styles might take up only the region bounded by the tips of the outer radii and the tips of the inner radii (represented in case D by the dark green region). 4.4.4. Overlapping CurvesGiven these corner shapes, color and style transitions must be contained within the green region. In case D the rectangle defined by the border radii does not include the center of the inner curve (which is a sharp corner), so the transition region is expanded to include that corner. Transitions may take up the entire transition region, but are not required to: For example, a gradient color transition between two solid border styles might take up only the region bounded by the tips of the outer radii and the tips of the inner radii (represented in case D by the dark green region). Corner curves must not overlap: When the sum of any two adjacent border radii exceeds the size of the border box, UAs must proportionally reduce the used value of all border radii until none of them overlap. The algorithm for reducing radii is as follows:Let f = min( L i / S i ), where i ? {top, right, bottom, left}, S i is the sum of the radii of the corners on side i, and L top = L bottom = the width of the box, and L left = L right = the height of the box. If f < 1, then all corner radii are reduced by multiplying them by f. Note that this formula ensures that quarter circles remain quarter circles and large radii remain larger than smaller ones, but it may reduce corners that were already small enough, which may make borders of nearby elements that should look the same look different. If the curve interferes with UI elements such as scrollbars, the UA may further reduce the used value of the affected border radii (and only the affected border radii) as much as necessary, but no more. The rendering of the box must be exactly the same as if the reduced border-radius values were those originally specified. For example, the borders A and D of the figure below might be the result of box-sizing: border-box;\nwidth: 6em;\nheight: 2.5em;\nborder-radius: 0.5em 2em 0.5em 2em The height (2.5em) is enough for the specified radii (0.5em plus 2.5em). However, if the height is only 2em, box-sizing: border-box;\nwidth: 6em;\nheight: 2em;\nborder-radius: 0.5em 2em 0.5em 2em all corners need to be reduced by a factor 0.8 to make them fit. The used border radii thus are 0.4em (instead of 0.5em) and 1.6em (instead of 2em). See borders B and C in the figure. These rounded corner might be the result of ' width: 6em; height: 2.5em; border-radius: 0.5em 2em 0.5em 2em ' for A and D; and ditto but with ' height: 2em ' for B and C. 4.4.5. Effect on TablesFor example, the borders A and D of the figure below might be the result of box-sizing: border-box;\nwidth: 6em;\nheight: 2.5em;\nborder-radius: 0.5em 2em 0.5em 2emThe height (2.5em) is enough for the specified radii (0.5em plus 2.5em). However, if the height is only 2em, box-sizing: border-box;\nwidth: 6em;\nheight: 2em;\nborder-radius: 0.5em 2em 0.5em 2emall corners need to be reduced by a factor 0.8 to make them fit. The used border radii thus are 0.4em (instead of 0.5em) and 1.6em (instead of 2em). See borders B and C in the figure. These rounded corner might be the result of ' width: 6em; height: 2.5em; border-radius: 0.5em 2em 0.5em 2em ' for A and D; and ditto but with ' height: 2em ' for B and C. These rounded corner might be the result of ' width: 6em; height: 2.5em; border-radius: 0.5em 2em 0.5em 2em ' for A and D; and ditto but with ' height: 2em ' for B and C. The 'border-radius' properties do apply to 'table'and'inline-table' elements. When 'border-collapse'is'collapse', the UA may apply the border-radius properties to 'table'and'inline-table' elements, but is not required to. In this case not only must the border radii of adjacent corners not intersect, but the horizontal and vertical radii of a single corner may not extend past the boundaries of the cell at that corner (i.e. the cell's other corners must not be affected by this corner's border-radius). If the computed values of the border radii would cause this effect, then the used values of all the border radii of the table must be reduced by the same factor so that the radii neither intersect nor extend past the boundaries of their respective corner cells. The effect of border-radius on internal table elements is undefined in CSS3 Backgrounds and Borders, but may be defined in a future specification. CSS3 UAs should ignore border-radius properties applied to internal table elements when 'border-collapse'is'collapse'. This example draws ovals of 15em wide and 10em high: DIV.standout { width: 13em; height: 8em; border: solid black 1em; border-radius: 7.5em 5em } 4.5. The border shorthand properties Name: border-top, border-right, border-bottom, border-left Value: <border-width> || <border-style> || <color> Initial: See individual properties Applies to: all elements Inherited: no Percentages: N/A Media: visual Computed value: see individual propertiesThis example draws ovals of 15em wide and 10em high: DIV.standout { width: 13em; height: 8em; border: solid black 1em; border-radius: 7.5em 5em }",
 'values': {}},

    'border-bottom-right-radius':
{'description': "The two length or percentage values of the 'border-*-radius' properties define the radii of a quarter ellipse that defines the shape of the corner of the outer border edge (see the diagram below). The first value is the horizontal radius, the second the vertical radius. If the second value is omitted it is copied from the first. If either length is zero, the corner is square, not rounded. Percentages for the horizontal radius refer to the width of the border box, whereas percentages for the vertical radius refer to the height of the border box. The two values of ' border-top-left-radius: 55pt 25pt ' define the curvature of the corner. The two values of ' border-top-left-radius: 55pt 25pt ' define the curvature of the corner. The 'border-radius' shorthand sets all four 'border-*-radius' properties. If values are given before and after the slash, then the values before the slash set the horizontal radius and the values after the slash set the vertical radius. If there is no slash, then the values set both radii equally. The four values for each radii are given in the order top-left, top-right, bottom-right, bottom-left. If bottom-left is omitted it is the same as top-right. If bottom-right is omitted it is the same as top-left. If top-right is omitted it is the same as top-left. border-radius: 4em; is equivalent to border-top-left-radius: 4em;\nborder-top-right-radius: 4em;\nborder-bottom-right-radius: 4em;\nborder-bottom-left-radius: 4em; and border-radius: 2em 1em 4em / 0.5em 3em; is equivalent to border-top-left-radius: 2em 0.5em;\nborder-top-right-radius: 1em 3em;\nborder-bottom-right-radius: 4em 0.5em;\nborder-bottom-left-radius: 1em 3em; 4.4.1. Corner ShapingThe padding edge (inner border) radius is the outer border radius minus the corresponding border thickness. In the case where this results in a negative value, the inner radius is zero. (In such cases its center might not coincide with that of the outer border curve.) Likewise the content edge radius is the padding edge radius minus the corresponding padding, or if that is negative, zero. The border and padding thicknesses in the curved region are thus interpolated from the adjoining sides, and when two adjoining borders are of different thicknesses the corner will show a smooth transition between the thicker and thinner borders. Note that this means that if the outer curve extends past the adjacent corner's padding edge, the inner curve may not be a full quarter ellipse. All border styles ('solid', 'dotted', 'inset', etc.) follow the curve of the border. The effect of a rounded corner when the two borders it connects are of unequal thickness (left) and the effect of a rounded corner on borders that are thicker than the radius of the corner (right). 4.4.2. Corner ClippingThe effect of a rounded corner when the two borders it connects are of unequal thickness (left) and the effect of a rounded corner on borders that are thicker than the radius of the corner (right). A box's backgrounds, but not its border-image, are clipped to the appropriate curve (as determined by 'background-clip'). Other effects that clip to the border or padding edge (such as 'overflow' other than 'visible') also must clip to the curve. The content of replaced elements is always trimmed to the content edge curve. Also, the area outside the curve of the border edge does not accept mouse events on behalf of the element. This example adds appropriate padding, so that the contents do not overflow the corners. Note that there is no border, but the background will still have rounded corners. DIV { background: black; color: white; border-radius: 1em; padding: 1em } 4.4.3. Color and Style TransitionsThis example adds appropriate padding, so that the contents do not overflow the corners. Note that there is no border, but the background will still have rounded corners. DIV { background: black; color: white; border-radius: 1em; padding: 1em }Color and style transitions must be contained within the segment of the border that intersects the smallest rectangle that contains both border radii as well as the center of the inner curve (which may be a point representing the corner of the padding edge, if the border radii are smaller than the border-width). The center of color and style transitions between adjoining borders is at the point on the curve that is at an angle that is proportional to the ratio of the border widths. For example, if the top and right border widths are equal, that point is at a 45 angle from the horizontal, and if the top is twice the width of the right the point is at a 30 angle from the horizontal. The line demarcating this transition is drawn between the point at that angle on the outer arc and the point at that angle on the inner arc. It is not defined what these transitions look like, but a gradient is recommended for color transitions that don't involve dotted or dashed borders. Given these corner shapes, color and style transitions must be contained within the green region. In case D the rectangle defined by the border radii does not include the center of the inner curve (which is a sharp corner), so the transition region is expanded to include that corner. Transitions may take up the entire transition region, but are not required to: For example, a gradient color transition between two solid border styles might take up only the region bounded by the tips of the outer radii and the tips of the inner radii (represented in case D by the dark green region). 4.4.4. Overlapping CurvesGiven these corner shapes, color and style transitions must be contained within the green region. In case D the rectangle defined by the border radii does not include the center of the inner curve (which is a sharp corner), so the transition region is expanded to include that corner. Transitions may take up the entire transition region, but are not required to: For example, a gradient color transition between two solid border styles might take up only the region bounded by the tips of the outer radii and the tips of the inner radii (represented in case D by the dark green region). Corner curves must not overlap: When the sum of any two adjacent border radii exceeds the size of the border box, UAs must proportionally reduce the used value of all border radii until none of them overlap. The algorithm for reducing radii is as follows:Let f = min( L i / S i ), where i ? {top, right, bottom, left}, S i is the sum of the radii of the corners on side i, and L top = L bottom = the width of the box, and L left = L right = the height of the box. If f < 1, then all corner radii are reduced by multiplying them by f. Note that this formula ensures that quarter circles remain quarter circles and large radii remain larger than smaller ones, but it may reduce corners that were already small enough, which may make borders of nearby elements that should look the same look different. If the curve interferes with UI elements such as scrollbars, the UA may further reduce the used value of the affected border radii (and only the affected border radii) as much as necessary, but no more. The rendering of the box must be exactly the same as if the reduced border-radius values were those originally specified. For example, the borders A and D of the figure below might be the result of box-sizing: border-box;\nwidth: 6em;\nheight: 2.5em;\nborder-radius: 0.5em 2em 0.5em 2em The height (2.5em) is enough for the specified radii (0.5em plus 2.5em). However, if the height is only 2em, box-sizing: border-box;\nwidth: 6em;\nheight: 2em;\nborder-radius: 0.5em 2em 0.5em 2em all corners need to be reduced by a factor 0.8 to make them fit. The used border radii thus are 0.4em (instead of 0.5em) and 1.6em (instead of 2em). See borders B and C in the figure. These rounded corner might be the result of ' width: 6em; height: 2.5em; border-radius: 0.5em 2em 0.5em 2em ' for A and D; and ditto but with ' height: 2em ' for B and C. 4.4.5. Effect on TablesFor example, the borders A and D of the figure below might be the result of box-sizing: border-box;\nwidth: 6em;\nheight: 2.5em;\nborder-radius: 0.5em 2em 0.5em 2emThe height (2.5em) is enough for the specified radii (0.5em plus 2.5em). However, if the height is only 2em, box-sizing: border-box;\nwidth: 6em;\nheight: 2em;\nborder-radius: 0.5em 2em 0.5em 2emall corners need to be reduced by a factor 0.8 to make them fit. The used border radii thus are 0.4em (instead of 0.5em) and 1.6em (instead of 2em). See borders B and C in the figure. These rounded corner might be the result of ' width: 6em; height: 2.5em; border-radius: 0.5em 2em 0.5em 2em ' for A and D; and ditto but with ' height: 2em ' for B and C. These rounded corner might be the result of ' width: 6em; height: 2.5em; border-radius: 0.5em 2em 0.5em 2em ' for A and D; and ditto but with ' height: 2em ' for B and C. The 'border-radius' properties do apply to 'table'and'inline-table' elements. When 'border-collapse'is'collapse', the UA may apply the border-radius properties to 'table'and'inline-table' elements, but is not required to. In this case not only must the border radii of adjacent corners not intersect, but the horizontal and vertical radii of a single corner may not extend past the boundaries of the cell at that corner (i.e. the cell's other corners must not be affected by this corner's border-radius). If the computed values of the border radii would cause this effect, then the used values of all the border radii of the table must be reduced by the same factor so that the radii neither intersect nor extend past the boundaries of their respective corner cells. The effect of border-radius on internal table elements is undefined in CSS3 Backgrounds and Borders, but may be defined in a future specification. CSS3 UAs should ignore border-radius properties applied to internal table elements when 'border-collapse'is'collapse'. This example draws ovals of 15em wide and 10em high: DIV.standout { width: 13em; height: 8em; border: solid black 1em; border-radius: 7.5em 5em } 4.5. The border shorthand properties Name: border-top, border-right, border-bottom, border-left Value: <border-width> || <border-style> || <color> Initial: See individual properties Applies to: all elements Inherited: no Percentages: N/A Media: visual Computed value: see individual propertiesThis example draws ovals of 15em wide and 10em high: DIV.standout { width: 13em; height: 8em; border: solid black 1em; border-radius: 7.5em 5em }",
 'values': {}},

    'border-image':
{'description': "This is a shorthand property for setting 'border-image-source', 'border-image-slice', 'border-image-width', 'border-image-outset'and'border-image-repeat'. Omitted values are set to their initial values. 6. Miscellaneous Effects 6.1. The 'box-decoration-break' property Name: box-decoration-break Value: slice | clone Initial: slice Applies to: all elements Inherited: no Percentages: N/A Media: visual Computed value: as specified",
 'values': {}},

    'border-radius':
{'description': "The two length or percentage values of the 'border-*-radius' properties define the radii of a quarter ellipse that defines the shape of the corner of the outer border edge (see the diagram below). The first value is the horizontal radius, the second the vertical radius. If the second value is omitted it is copied from the first. If either length is zero, the corner is square, not rounded. Percentages for the horizontal radius refer to the width of the border box, whereas percentages for the vertical radius refer to the height of the border box. The two values of ' border-top-left-radius: 55pt 25pt ' define the curvature of the corner. The two values of ' border-top-left-radius: 55pt 25pt ' define the curvature of the corner. The 'border-radius' shorthand sets all four 'border-*-radius' properties. If values are given before and after the slash, then the values before the slash set the horizontal radius and the values after the slash set the vertical radius. If there is no slash, then the values set both radii equally. The four values for each radii are given in the order top-left, top-right, bottom-right, bottom-left. If bottom-left is omitted it is the same as top-right. If bottom-right is omitted it is the same as top-left. If top-right is omitted it is the same as top-left. border-radius: 4em; is equivalent to border-top-left-radius: 4em;\nborder-top-right-radius: 4em;\nborder-bottom-right-radius: 4em;\nborder-bottom-left-radius: 4em; and border-radius: 2em 1em 4em / 0.5em 3em; is equivalent to border-top-left-radius: 2em 0.5em;\nborder-top-right-radius: 1em 3em;\nborder-bottom-right-radius: 4em 0.5em;\nborder-bottom-left-radius: 1em 3em; 4.4.1. Corner ShapingThe padding edge (inner border) radius is the outer border radius minus the corresponding border thickness. In the case where this results in a negative value, the inner radius is zero. (In such cases its center might not coincide with that of the outer border curve.) Likewise the content edge radius is the padding edge radius minus the corresponding padding, or if that is negative, zero. The border and padding thicknesses in the curved region are thus interpolated from the adjoining sides, and when two adjoining borders are of different thicknesses the corner will show a smooth transition between the thicker and thinner borders. Note that this means that if the outer curve extends past the adjacent corner's padding edge, the inner curve may not be a full quarter ellipse. All border styles ('solid', 'dotted', 'inset', etc.) follow the curve of the border. The effect of a rounded corner when the two borders it connects are of unequal thickness (left) and the effect of a rounded corner on borders that are thicker than the radius of the corner (right). 4.4.2. Corner ClippingThe effect of a rounded corner when the two borders it connects are of unequal thickness (left) and the effect of a rounded corner on borders that are thicker than the radius of the corner (right). A box's backgrounds, but not its border-image, are clipped to the appropriate curve (as determined by 'background-clip'). Other effects that clip to the border or padding edge (such as 'overflow' other than 'visible') also must clip to the curve. The content of replaced elements is always trimmed to the content edge curve. Also, the area outside the curve of the border edge does not accept mouse events on behalf of the element. This example adds appropriate padding, so that the contents do not overflow the corners. Note that there is no border, but the background will still have rounded corners. DIV { background: black; color: white; border-radius: 1em; padding: 1em } 4.4.3. Color and Style TransitionsThis example adds appropriate padding, so that the contents do not overflow the corners. Note that there is no border, but the background will still have rounded corners. DIV { background: black; color: white; border-radius: 1em; padding: 1em }Color and style transitions must be contained within the segment of the border that intersects the smallest rectangle that contains both border radii as well as the center of the inner curve (which may be a point representing the corner of the padding edge, if the border radii are smaller than the border-width). The center of color and style transitions between adjoining borders is at the point on the curve that is at an angle that is proportional to the ratio of the border widths. For example, if the top and right border widths are equal, that point is at a 45 angle from the horizontal, and if the top is twice the width of the right the point is at a 30 angle from the horizontal. The line demarcating this transition is drawn between the point at that angle on the outer arc and the point at that angle on the inner arc. It is not defined what these transitions look like, but a gradient is recommended for color transitions that don't involve dotted or dashed borders. Given these corner shapes, color and style transitions must be contained within the green region. In case D the rectangle defined by the border radii does not include the center of the inner curve (which is a sharp corner), so the transition region is expanded to include that corner. Transitions may take up the entire transition region, but are not required to: For example, a gradient color transition between two solid border styles might take up only the region bounded by the tips of the outer radii and the tips of the inner radii (represented in case D by the dark green region). 4.4.4. Overlapping CurvesGiven these corner shapes, color and style transitions must be contained within the green region. In case D the rectangle defined by the border radii does not include the center of the inner curve (which is a sharp corner), so the transition region is expanded to include that corner. Transitions may take up the entire transition region, but are not required to: For example, a gradient color transition between two solid border styles might take up only the region bounded by the tips of the outer radii and the tips of the inner radii (represented in case D by the dark green region). Corner curves must not overlap: When the sum of any two adjacent border radii exceeds the size of the border box, UAs must proportionally reduce the used value of all border radii until none of them overlap. The algorithm for reducing radii is as follows:Let f = min( L i / S i ), where i ? {top, right, bottom, left}, S i is the sum of the radii of the corners on side i, and L top = L bottom = the width of the box, and L left = L right = the height of the box. If f < 1, then all corner radii are reduced by multiplying them by f. Note that this formula ensures that quarter circles remain quarter circles and large radii remain larger than smaller ones, but it may reduce corners that were already small enough, which may make borders of nearby elements that should look the same look different. If the curve interferes with UI elements such as scrollbars, the UA may further reduce the used value of the affected border radii (and only the affected border radii) as much as necessary, but no more. The rendering of the box must be exactly the same as if the reduced border-radius values were those originally specified. For example, the borders A and D of the figure below might be the result of box-sizing: border-box;\nwidth: 6em;\nheight: 2.5em;\nborder-radius: 0.5em 2em 0.5em 2em The height (2.5em) is enough for the specified radii (0.5em plus 2.5em). However, if the height is only 2em, box-sizing: border-box;\nwidth: 6em;\nheight: 2em;\nborder-radius: 0.5em 2em 0.5em 2em all corners need to be reduced by a factor 0.8 to make them fit. The used border radii thus are 0.4em (instead of 0.5em) and 1.6em (instead of 2em). See borders B and C in the figure. These rounded corner might be the result of ' width: 6em; height: 2.5em; border-radius: 0.5em 2em 0.5em 2em ' for A and D; and ditto but with ' height: 2em ' for B and C. 4.4.5. Effect on TablesFor example, the borders A and D of the figure below might be the result of box-sizing: border-box;\nwidth: 6em;\nheight: 2.5em;\nborder-radius: 0.5em 2em 0.5em 2emThe height (2.5em) is enough for the specified radii (0.5em plus 2.5em). However, if the height is only 2em, box-sizing: border-box;\nwidth: 6em;\nheight: 2em;\nborder-radius: 0.5em 2em 0.5em 2emall corners need to be reduced by a factor 0.8 to make them fit. The used border radii thus are 0.4em (instead of 0.5em) and 1.6em (instead of 2em). See borders B and C in the figure. These rounded corner might be the result of ' width: 6em; height: 2.5em; border-radius: 0.5em 2em 0.5em 2em ' for A and D; and ditto but with ' height: 2em ' for B and C. These rounded corner might be the result of ' width: 6em; height: 2.5em; border-radius: 0.5em 2em 0.5em 2em ' for A and D; and ditto but with ' height: 2em ' for B and C. The 'border-radius' properties do apply to 'table'and'inline-table' elements. When 'border-collapse'is'collapse', the UA may apply the border-radius properties to 'table'and'inline-table' elements, but is not required to. In this case not only must the border radii of adjacent corners not intersect, but the horizontal and vertical radii of a single corner may not extend past the boundaries of the cell at that corner (i.e. the cell's other corners must not be affected by this corner's border-radius). If the computed values of the border radii would cause this effect, then the used values of all the border radii of the table must be reduced by the same factor so that the radii neither intersect nor extend past the boundaries of their respective corner cells. The effect of border-radius on internal table elements is undefined in CSS3 Backgrounds and Borders, but may be defined in a future specification. CSS3 UAs should ignore border-radius properties applied to internal table elements when 'border-collapse'is'collapse'. This example draws ovals of 15em wide and 10em high: DIV.standout { width: 13em; height: 8em; border: solid black 1em; border-radius: 7.5em 5em } 4.5. The border shorthand properties Name: border-top, border-right, border-bottom, border-left Value: <border-width> || <border-style> || <color> Initial: See individual properties Applies to: all elements Inherited: no Percentages: N/A Media: visual Computed value: see individual propertiesThis example draws ovals of 15em wide and 10em high: DIV.standout { width: 13em; height: 8em; border: solid black 1em; border-radius: 7.5em 5em }",
 'values': {}},

    'border-top-left-radius':
{'description': "The two length or percentage values of the 'border-*-radius' properties define the radii of a quarter ellipse that defines the shape of the corner of the outer border edge (see the diagram below). The first value is the horizontal radius, the second the vertical radius. If the second value is omitted it is copied from the first. If either length is zero, the corner is square, not rounded. Percentages for the horizontal radius refer to the width of the border box, whereas percentages for the vertical radius refer to the height of the border box. The two values of ' border-top-left-radius: 55pt 25pt ' define the curvature of the corner. The two values of ' border-top-left-radius: 55pt 25pt ' define the curvature of the corner. The 'border-radius' shorthand sets all four 'border-*-radius' properties. If values are given before and after the slash, then the values before the slash set the horizontal radius and the values after the slash set the vertical radius. If there is no slash, then the values set both radii equally. The four values for each radii are given in the order top-left, top-right, bottom-right, bottom-left. If bottom-left is omitted it is the same as top-right. If bottom-right is omitted it is the same as top-left. If top-right is omitted it is the same as top-left. border-radius: 4em; is equivalent to border-top-left-radius: 4em;\nborder-top-right-radius: 4em;\nborder-bottom-right-radius: 4em;\nborder-bottom-left-radius: 4em; and border-radius: 2em 1em 4em / 0.5em 3em; is equivalent to border-top-left-radius: 2em 0.5em;\nborder-top-right-radius: 1em 3em;\nborder-bottom-right-radius: 4em 0.5em;\nborder-bottom-left-radius: 1em 3em; 4.4.1. Corner ShapingThe padding edge (inner border) radius is the outer border radius minus the corresponding border thickness. In the case where this results in a negative value, the inner radius is zero. (In such cases its center might not coincide with that of the outer border curve.) Likewise the content edge radius is the padding edge radius minus the corresponding padding, or if that is negative, zero. The border and padding thicknesses in the curved region are thus interpolated from the adjoining sides, and when two adjoining borders are of different thicknesses the corner will show a smooth transition between the thicker and thinner borders. Note that this means that if the outer curve extends past the adjacent corner's padding edge, the inner curve may not be a full quarter ellipse. All border styles ('solid', 'dotted', 'inset', etc.) follow the curve of the border. The effect of a rounded corner when the two borders it connects are of unequal thickness (left) and the effect of a rounded corner on borders that are thicker than the radius of the corner (right). 4.4.2. Corner ClippingThe effect of a rounded corner when the two borders it connects are of unequal thickness (left) and the effect of a rounded corner on borders that are thicker than the radius of the corner (right). A box's backgrounds, but not its border-image, are clipped to the appropriate curve (as determined by 'background-clip'). Other effects that clip to the border or padding edge (such as 'overflow' other than 'visible') also must clip to the curve. The content of replaced elements is always trimmed to the content edge curve. Also, the area outside the curve of the border edge does not accept mouse events on behalf of the element. This example adds appropriate padding, so that the contents do not overflow the corners. Note that there is no border, but the background will still have rounded corners. DIV { background: black; color: white; border-radius: 1em; padding: 1em } 4.4.3. Color and Style TransitionsThis example adds appropriate padding, so that the contents do not overflow the corners. Note that there is no border, but the background will still have rounded corners. DIV { background: black; color: white; border-radius: 1em; padding: 1em }Color and style transitions must be contained within the segment of the border that intersects the smallest rectangle that contains both border radii as well as the center of the inner curve (which may be a point representing the corner of the padding edge, if the border radii are smaller than the border-width). The center of color and style transitions between adjoining borders is at the point on the curve that is at an angle that is proportional to the ratio of the border widths. For example, if the top and right border widths are equal, that point is at a 45 angle from the horizontal, and if the top is twice the width of the right the point is at a 30 angle from the horizontal. The line demarcating this transition is drawn between the point at that angle on the outer arc and the point at that angle on the inner arc. It is not defined what these transitions look like, but a gradient is recommended for color transitions that don't involve dotted or dashed borders. Given these corner shapes, color and style transitions must be contained within the green region. In case D the rectangle defined by the border radii does not include the center of the inner curve (which is a sharp corner), so the transition region is expanded to include that corner. Transitions may take up the entire transition region, but are not required to: For example, a gradient color transition between two solid border styles might take up only the region bounded by the tips of the outer radii and the tips of the inner radii (represented in case D by the dark green region). 4.4.4. Overlapping CurvesGiven these corner shapes, color and style transitions must be contained within the green region. In case D the rectangle defined by the border radii does not include the center of the inner curve (which is a sharp corner), so the transition region is expanded to include that corner. Transitions may take up the entire transition region, but are not required to: For example, a gradient color transition between two solid border styles might take up only the region bounded by the tips of the outer radii and the tips of the inner radii (represented in case D by the dark green region). Corner curves must not overlap: When the sum of any two adjacent border radii exceeds the size of the border box, UAs must proportionally reduce the used value of all border radii until none of them overlap. The algorithm for reducing radii is as follows:Let f = min( L i / S i ), where i ? {top, right, bottom, left}, S i is the sum of the radii of the corners on side i, and L top = L bottom = the width of the box, and L left = L right = the height of the box. If f < 1, then all corner radii are reduced by multiplying them by f. Note that this formula ensures that quarter circles remain quarter circles and large radii remain larger than smaller ones, but it may reduce corners that were already small enough, which may make borders of nearby elements that should look the same look different. If the curve interferes with UI elements such as scrollbars, the UA may further reduce the used value of the affected border radii (and only the affected border radii) as much as necessary, but no more. The rendering of the box must be exactly the same as if the reduced border-radius values were those originally specified. For example, the borders A and D of the figure below might be the result of box-sizing: border-box;\nwidth: 6em;\nheight: 2.5em;\nborder-radius: 0.5em 2em 0.5em 2em The height (2.5em) is enough for the specified radii (0.5em plus 2.5em). However, if the height is only 2em, box-sizing: border-box;\nwidth: 6em;\nheight: 2em;\nborder-radius: 0.5em 2em 0.5em 2em all corners need to be reduced by a factor 0.8 to make them fit. The used border radii thus are 0.4em (instead of 0.5em) and 1.6em (instead of 2em). See borders B and C in the figure. These rounded corner might be the result of ' width: 6em; height: 2.5em; border-radius: 0.5em 2em 0.5em 2em ' for A and D; and ditto but with ' height: 2em ' for B and C. 4.4.5. Effect on TablesFor example, the borders A and D of the figure below might be the result of box-sizing: border-box;\nwidth: 6em;\nheight: 2.5em;\nborder-radius: 0.5em 2em 0.5em 2emThe height (2.5em) is enough for the specified radii (0.5em plus 2.5em). However, if the height is only 2em, box-sizing: border-box;\nwidth: 6em;\nheight: 2em;\nborder-radius: 0.5em 2em 0.5em 2emall corners need to be reduced by a factor 0.8 to make them fit. The used border radii thus are 0.4em (instead of 0.5em) and 1.6em (instead of 2em). See borders B and C in the figure. These rounded corner might be the result of ' width: 6em; height: 2.5em; border-radius: 0.5em 2em 0.5em 2em ' for A and D; and ditto but with ' height: 2em ' for B and C. These rounded corner might be the result of ' width: 6em; height: 2.5em; border-radius: 0.5em 2em 0.5em 2em ' for A and D; and ditto but with ' height: 2em ' for B and C. The 'border-radius' properties do apply to 'table'and'inline-table' elements. When 'border-collapse'is'collapse', the UA may apply the border-radius properties to 'table'and'inline-table' elements, but is not required to. In this case not only must the border radii of adjacent corners not intersect, but the horizontal and vertical radii of a single corner may not extend past the boundaries of the cell at that corner (i.e. the cell's other corners must not be affected by this corner's border-radius). If the computed values of the border radii would cause this effect, then the used values of all the border radii of the table must be reduced by the same factor so that the radii neither intersect nor extend past the boundaries of their respective corner cells. The effect of border-radius on internal table elements is undefined in CSS3 Backgrounds and Borders, but may be defined in a future specification. CSS3 UAs should ignore border-radius properties applied to internal table elements when 'border-collapse'is'collapse'. This example draws ovals of 15em wide and 10em high: DIV.standout { width: 13em; height: 8em; border: solid black 1em; border-radius: 7.5em 5em } 4.5. The border shorthand properties Name: border-top, border-right, border-bottom, border-left Value: <border-width> || <border-style> || <color> Initial: See individual properties Applies to: all elements Inherited: no Percentages: N/A Media: visual Computed value: see individual propertiesThis example draws ovals of 15em wide and 10em high: DIV.standout { width: 13em; height: 8em; border: solid black 1em; border-radius: 7.5em 5em }",
 'values': {}},

    'border-top-right-radius':
{'description': "The two length or percentage values of the 'border-*-radius' properties define the radii of a quarter ellipse that defines the shape of the corner of the outer border edge (see the diagram below). The first value is the horizontal radius, the second the vertical radius. If the second value is omitted it is copied from the first. If either length is zero, the corner is square, not rounded. Percentages for the horizontal radius refer to the width of the border box, whereas percentages for the vertical radius refer to the height of the border box. The two values of ' border-top-left-radius: 55pt 25pt ' define the curvature of the corner. The two values of ' border-top-left-radius: 55pt 25pt ' define the curvature of the corner. The 'border-radius' shorthand sets all four 'border-*-radius' properties. If values are given before and after the slash, then the values before the slash set the horizontal radius and the values after the slash set the vertical radius. If there is no slash, then the values set both radii equally. The four values for each radii are given in the order top-left, top-right, bottom-right, bottom-left. If bottom-left is omitted it is the same as top-right. If bottom-right is omitted it is the same as top-left. If top-right is omitted it is the same as top-left. border-radius: 4em; is equivalent to border-top-left-radius: 4em;\nborder-top-right-radius: 4em;\nborder-bottom-right-radius: 4em;\nborder-bottom-left-radius: 4em; and border-radius: 2em 1em 4em / 0.5em 3em; is equivalent to border-top-left-radius: 2em 0.5em;\nborder-top-right-radius: 1em 3em;\nborder-bottom-right-radius: 4em 0.5em;\nborder-bottom-left-radius: 1em 3em; 4.4.1. Corner ShapingThe padding edge (inner border) radius is the outer border radius minus the corresponding border thickness. In the case where this results in a negative value, the inner radius is zero. (In such cases its center might not coincide with that of the outer border curve.) Likewise the content edge radius is the padding edge radius minus the corresponding padding, or if that is negative, zero. The border and padding thicknesses in the curved region are thus interpolated from the adjoining sides, and when two adjoining borders are of different thicknesses the corner will show a smooth transition between the thicker and thinner borders. Note that this means that if the outer curve extends past the adjacent corner's padding edge, the inner curve may not be a full quarter ellipse. All border styles ('solid', 'dotted', 'inset', etc.) follow the curve of the border. The effect of a rounded corner when the two borders it connects are of unequal thickness (left) and the effect of a rounded corner on borders that are thicker than the radius of the corner (right). 4.4.2. Corner ClippingThe effect of a rounded corner when the two borders it connects are of unequal thickness (left) and the effect of a rounded corner on borders that are thicker than the radius of the corner (right). A box's backgrounds, but not its border-image, are clipped to the appropriate curve (as determined by 'background-clip'). Other effects that clip to the border or padding edge (such as 'overflow' other than 'visible') also must clip to the curve. The content of replaced elements is always trimmed to the content edge curve. Also, the area outside the curve of the border edge does not accept mouse events on behalf of the element. This example adds appropriate padding, so that the contents do not overflow the corners. Note that there is no border, but the background will still have rounded corners. DIV { background: black; color: white; border-radius: 1em; padding: 1em } 4.4.3. Color and Style TransitionsThis example adds appropriate padding, so that the contents do not overflow the corners. Note that there is no border, but the background will still have rounded corners. DIV { background: black; color: white; border-radius: 1em; padding: 1em }Color and style transitions must be contained within the segment of the border that intersects the smallest rectangle that contains both border radii as well as the center of the inner curve (which may be a point representing the corner of the padding edge, if the border radii are smaller than the border-width). The center of color and style transitions between adjoining borders is at the point on the curve that is at an angle that is proportional to the ratio of the border widths. For example, if the top and right border widths are equal, that point is at a 45 angle from the horizontal, and if the top is twice the width of the right the point is at a 30 angle from the horizontal. The line demarcating this transition is drawn between the point at that angle on the outer arc and the point at that angle on the inner arc. It is not defined what these transitions look like, but a gradient is recommended for color transitions that don't involve dotted or dashed borders. Given these corner shapes, color and style transitions must be contained within the green region. In case D the rectangle defined by the border radii does not include the center of the inner curve (which is a sharp corner), so the transition region is expanded to include that corner. Transitions may take up the entire transition region, but are not required to: For example, a gradient color transition between two solid border styles might take up only the region bounded by the tips of the outer radii and the tips of the inner radii (represented in case D by the dark green region). 4.4.4. Overlapping CurvesGiven these corner shapes, color and style transitions must be contained within the green region. In case D the rectangle defined by the border radii does not include the center of the inner curve (which is a sharp corner), so the transition region is expanded to include that corner. Transitions may take up the entire transition region, but are not required to: For example, a gradient color transition between two solid border styles might take up only the region bounded by the tips of the outer radii and the tips of the inner radii (represented in case D by the dark green region). Corner curves must not overlap: When the sum of any two adjacent border radii exceeds the size of the border box, UAs must proportionally reduce the used value of all border radii until none of them overlap. The algorithm for reducing radii is as follows:Let f = min( L i / S i ), where i ? {top, right, bottom, left}, S i is the sum of the radii of the corners on side i, and L top = L bottom = the width of the box, and L left = L right = the height of the box. If f < 1, then all corner radii are reduced by multiplying them by f. Note that this formula ensures that quarter circles remain quarter circles and large radii remain larger than smaller ones, but it may reduce corners that were already small enough, which may make borders of nearby elements that should look the same look different. If the curve interferes with UI elements such as scrollbars, the UA may further reduce the used value of the affected border radii (and only the affected border radii) as much as necessary, but no more. The rendering of the box must be exactly the same as if the reduced border-radius values were those originally specified. For example, the borders A and D of the figure below might be the result of box-sizing: border-box;\nwidth: 6em;\nheight: 2.5em;\nborder-radius: 0.5em 2em 0.5em 2em The height (2.5em) is enough for the specified radii (0.5em plus 2.5em). However, if the height is only 2em, box-sizing: border-box;\nwidth: 6em;\nheight: 2em;\nborder-radius: 0.5em 2em 0.5em 2em all corners need to be reduced by a factor 0.8 to make them fit. The used border radii thus are 0.4em (instead of 0.5em) and 1.6em (instead of 2em). See borders B and C in the figure. These rounded corner might be the result of ' width: 6em; height: 2.5em; border-radius: 0.5em 2em 0.5em 2em ' for A and D; and ditto but with ' height: 2em ' for B and C. 4.4.5. Effect on TablesFor example, the borders A and D of the figure below might be the result of box-sizing: border-box;\nwidth: 6em;\nheight: 2.5em;\nborder-radius: 0.5em 2em 0.5em 2emThe height (2.5em) is enough for the specified radii (0.5em plus 2.5em). However, if the height is only 2em, box-sizing: border-box;\nwidth: 6em;\nheight: 2em;\nborder-radius: 0.5em 2em 0.5em 2emall corners need to be reduced by a factor 0.8 to make them fit. The used border radii thus are 0.4em (instead of 0.5em) and 1.6em (instead of 2em). See borders B and C in the figure. These rounded corner might be the result of ' width: 6em; height: 2.5em; border-radius: 0.5em 2em 0.5em 2em ' for A and D; and ditto but with ' height: 2em ' for B and C. These rounded corner might be the result of ' width: 6em; height: 2.5em; border-radius: 0.5em 2em 0.5em 2em ' for A and D; and ditto but with ' height: 2em ' for B and C. The 'border-radius' properties do apply to 'table'and'inline-table' elements. When 'border-collapse'is'collapse', the UA may apply the border-radius properties to 'table'and'inline-table' elements, but is not required to. In this case not only must the border radii of adjacent corners not intersect, but the horizontal and vertical radii of a single corner may not extend past the boundaries of the cell at that corner (i.e. the cell's other corners must not be affected by this corner's border-radius). If the computed values of the border radii would cause this effect, then the used values of all the border radii of the table must be reduced by the same factor so that the radii neither intersect nor extend past the boundaries of their respective corner cells. The effect of border-radius on internal table elements is undefined in CSS3 Backgrounds and Borders, but may be defined in a future specification. CSS3 UAs should ignore border-radius properties applied to internal table elements when 'border-collapse'is'collapse'. This example draws ovals of 15em wide and 10em high: DIV.standout { width: 13em; height: 8em; border: solid black 1em; border-radius: 7.5em 5em } 4.5. The border shorthand properties Name: border-top, border-right, border-bottom, border-left Value: <border-width> || <border-style> || <color> Initial: See individual properties Applies to: all elements Inherited: no Percentages: N/A Media: visual Computed value: see individual propertiesThis example draws ovals of 15em wide and 10em high: DIV.standout { width: 13em; height: 8em; border: solid black 1em; border-radius: 7.5em 5em }",
 'values': {}},

    'box-align':
{'description': "When the size of the containing box is larger than the size of a child, extra space will be available. The 'box-align' property specifies how a box's children are placed and aligned along the direction perpendicular to the box orientation, and where the extra space, if any, is positioned. For horizontal orientation, it specifies how the children are positioned vertically. For vertical orientation, it specifies how the children are positioned horizontally. The amount of extra space may be different for each child. For example, if the containing box has a height of 200 pixels, and it contains two children at 100 and 150 pixels respectively, there will be 100 pixels of extra space for the first child and 50 pixels of space for the second child. The following values are valid for the box-align property, but see the text afterward for more specifics as to how children are positioned.",
 'values': {'baseline': "If this box orientation is inline-axis or horizontal, all children are placed with their baselines aligned, and extra space placed before or after as necessary. For block flows, the baseline of the first non-empty line box located within the element is used. For tables, the baseline of the first cell is used. The children, once aligned on their baselines, should then be placed into the box so that the child with the earliest extent margin has its top margin edge (or bottom margin edge for reverse direction boxes) flush with the top (or bottom) edge of the box's content area. If the box does not have an 'auto' height, overflow will always be on the bottom (or top for reverse direction boxes) edge. If the box orientation is block-axis or vertical, then baseline is interpreted as center.",
            'center': 'Any extra space is divided evenly, with half placed above the child and the other half placed after the child.',
            'end': 'For normal direction boxes, the bottom edge of each child is placed along the bottom of the box. Extra space is placed above the element. For reverse direction boxes, the top edge of each child is placed along the top of the box. Extra space is placed below the element.',
            'start': 'For normal direction boxes, the top edge of each child is placed along the top of the box. Extra space is placed below the element. For reverse direction boxes, the bottom edge of each child is placed along the bottom of the box. Extra space is placed above the element.',
            'stretch': 'The height of each child is adjusted to that of the containing block. However, note the text below.'}},

    'box-decoration-break':
{'description': "When a box is broken at a page break, column break, or, for inline elements, at a line break, the 'box-decoration-break' property specifies whether individual boxes are treated as broken pieces of one continuous box, or whether each box is individually wrapped with the border and padding. For backgrounds it defines how the background positioning area is derived from these multiple boxes and how the element's background is drawn within them. Values have the following meanings: Two possibilities for 'box-decoration-break': on the left, the value 'slice', on the right the value 'clone'.",
 'values': {'slice': "No border and no padding are inserted at the break. No box-shadow is drawn at the broken edge; 'border-radius' has no effect at its corners; and the 'border-image' is rendered for the whole box as if it were unbroken. The effect is as though the element were rendered with no break present, and then sliced by the break afterward. Backgrounds are drawn as if, after the element has been laid out (including any justification, bidi reordering, page breaks, etc.), all the element's boxes are taken and put one after the other in visual order. The background is applied to the bounding box of this composite box and then the boxes are put back, with their share of the background. For boxes broken across lines, first boxes on the same line are connected in visual order. Then boxes on subsequent lines are ordered according to the element's inline progression direction and aligned on the baseline. For example in a left-to-right containing block ('direction'is'ltr'), the first box is the leftmost box on the first line and boxes from subsequent lines are put to the right of it. In a right-to-left containing block, the first box is the rightmost on the first line and subsequent boxes are put to the left of it. For boxes broken across columns, the columns are treated as one continuous element, as if the column boxes were glued together in the block progression direction of the multi-column element. For boxes broken across pages, the page content areas are glued together in the block progression direction of the root element. In these cases, if the pieces have different widths (heights, if the root element / multi-column element is in vertical text mode), then each piece draws its background assuming that the whole element has the same width (height) as this piece. This ensures that right-aligned images stay aligned to the right edge, left-aligned images stay aligned to the left edge, and centered images stay centered."}},

    'box-direction':
{'description': "The 'box-direction' property specifies the direction in which children of a box are displayed.",
 'values': {'normal': 'A box with a computed value of horizontal for box-orient displays its children from left to right. A box with a computed value of vertical displays its children from top to bottom.',
            'reverse': 'A box with a computed value of horizontal for box-orient displays its children from right to left. A box with a computed value of vertical displays its children from bottom to top.'}},

    'box-flex':
{'description': 'An element is flexible when the box-flex property is specified. The box-flex property is a floating point value representing the flexibility of the element. Its initial value is 0, which indicates that the element is inflexible. Elements that are flexible can shrink or grow as the box shrinks and grows. Whenever there is extra space left over in a box, the flexible elements are expanded to fill that space. All flex is relative. For example, a child with a box-flex of 2 is twice as flexible as a child with a box-flex of 1. A negative value for box-flex is not allowed. Flexible elements can be assigned to flex groups using the \'box-flex-group\' property. This property is a natural number value (the first flex group is 1 and higher values are later flex groups). The initial value is 1. In a horizontally oriented box, the preferred width of each child is computed. If the width of the margin box of each child is equal to the width of the containing block, then there is no extra space available, so the preferred widths are used for each child. If the width of the margin box adds up to a value smaller than the width of the containing block, then extra space is available. This extra space is divided up among the flexible children, as described below. If the width of the margin box adds up to a value larger than the width of the containing block, then the flexible children shrink as much as necessary to prevent overflow. Flexibility only applies to elements in normal flow. As absolute and fixed positioned elements are not in flow, any flexibility or flexgroup specified on them is ignored. In addition, as the \'float\' property does not apply to children of flexible boxes, they are considered part of normal flow and flexibility does apply. When dividing up extra space, first take all elements within the first flex group. Each element within that group should be given extra width based on the ratio of that element\'s flexibility compared to the flexibility of other elements within the same flex group. However, if the preferred width of the element plus the extra width allotted to it is larger than the maximum width of the element, then the width is set to that maximum width, and any remaining extra width beyond that is divided up among the other children. In this example there is 60 pixels of extra space available in the containing box. #div1 { display: box; width: 300px; } #button1 { box-flex: 1.0; width: 100px; } #button2 { box-flex: 2.0; width: 140px; } <div id="div1"> <button id="button1">Hello</button> <button id="button2">Goodbye</button> </div> As both child buttons are flexible, the extra space will be divided up between them. The first child button has a flexibility of 1.0 and the second child button has a flexibility of 2.0. The first button will receive 20 pixels of extra width and the second button will receive 40 pixels of extra width, maintaining the same ratio of extra width to flexibility values. This extra width is added to the preferred size of the element. However, if the second button had a maximum width of 150 pixels, it could only grow by 10 pixels before hitting this maximum size, so the remaining 30 pixels would instead be given to the first element, breaking the flexibility ratio. In this example there is 60 pixels of extra space available in the containing box. As both child buttons are flexible, the extra space will be divided up between them. The first child button has a flexibility of 1.0 and the second child button has a flexibility of 2.0. The first button will receive 20 pixels of extra width and the second button will receive 40 pixels of extra width, maintaining the same ratio of extra width to flexibility values. This extra width is added to the preferred size of the element. However, if the second button had a maximum width of 150 pixels, it could only grow by 10 pixels before hitting this maximum size, so the remaining 30 pixels would instead be given to the first element, breaking the flexibility ratio. More specifically, the percentage of extra space that an element may receive is calculated as follows:\' box-flex of child \' / \' total of box-flex values of child and all siblings \'If the width of all flexible children within the group has been increased to their maximum widths, the process repeats for the children within the next flex group, using any space left over from the previous flex group. Once there are no more flex groups, and there is still space remaining, the extra space is divided within the containing box according to the box-pack property. If the box would overflow after the preferred width of the children have been computed, then width is removed from flexible elements in a manner similar to that used when adding extra space. Each flex group is examined in turn and space is removed according to the ratio of the flexibility of each element. Elements do not shrink below their minimum widths. If all children have been shrunk to their minimum sizes, then the box overflows, although if the box-lines property is set to multiple, the box may be able to move elements to additional lines to prevent this. For vertically oriented boxes, the algorithm as described above is similar except using the height instead of the width. When a child box of a horizontally oriented box contains an inline element, it is likely that shrinking the width of the element due to flexibility may cause the inline element to grow in height, as the text within it may need to wrap to additional lines. Examples: #div1 { display: box; box-orient: vertical; height: 200px } <div id="div1"> <button>Cat</button> <button style="box-flex: 1">Piranha</button> <button>Antidisestablishmentarianism</button> </div> In the example above, the box is 200 pixels tall and is more than enough room for the three buttons. Because the first and third buttons are inflexible, they remain the same size, which is their intrinsic size. The second button is specified as being flexible, and because it is the only flexible element in the box, it receives all of the extra space. <div style="display: box; box-orient: vertical;"> <button style="box-flex: 1; height: 1000px;"> Cat </button> </div> In this example, if the height of the box is reduced, for instance, because the user resized the containing viewport, the height of the flexible button also shrinks with the box, despite the specification of 1000 pixels as the preferred height. It continues to shrink until the minimum required height for the button is reached, which here will likely be the height needed to display the button\'s label and border. After that, the button can shrink no further. Elements within a box can therefore have their own notions of minimum and maximum intrinsic sizes. In the above example, the button could not get any smaller than the minimum height required to draw its borders and its text. #div1 { display: box; } #iframe1 { box-flex: 1; min-width: 100px; max-width: 300px; height: 300px; } <div id="div1"> <iframe id="iframe1" src="http://www.mozilla.org/"/> </div> In this example, the iframe has a minimum width of 100 pixels and a maximum width of 300 pixels. If the containing box is less than 100 pixels wide, the iframe will overflow its containing div. If the containing box is between 100 pixels and 300 pixels inclusive, the width of the iframe would be set to that size, minus any necessary padding, borders and margins. If the width of the containing box is larger than 300 pixels, the extra space will be added inside the div. The extra space is added after the iframe inside the box. <p style="display: box;"> <button style="box-flex: 1; max-width: 50px;">Child 1</button> <button style="box-flex: 1; min-width: 50px;">Child 2</button> </p> In this example, the box has been stretched so that it is very wide. The first child has a maximum width of 50 pixels, and it divides the excess space equally with the second child until its maximum width has been reached. After that, since it is not allowed to grow any further, the remaining space all goes to the second child. 6 Packing along the box axis Name: box-pack Value: start | end | center | justify Initial: start Applies to: box elements Inherited: no Percentages: no Media: visual Computed value: specified valueExamples:In the example above, the box is 200 pixels tall and is more than enough room for the three buttons. Because the first and third buttons are inflexible, they remain the same size, which is their intrinsic size. The second button is specified as being flexible, and because it is the only flexible element in the box, it receives all of the extra space. In this example, if the height of the box is reduced, for instance, because the user resized the containing viewport, the height of the flexible button also shrinks with the box, despite the specification of 1000 pixels as the preferred height. It continues to shrink until the minimum required height for the button is reached, which here will likely be the height needed to display the button\'s label and border. After that, the button can shrink no further. Elements within a box can therefore have their own notions of minimum and maximum intrinsic sizes. In the above example, the button could not get any smaller than the minimum height required to draw its borders and its text. In this example, the iframe has a minimum width of 100 pixels and a maximum width of 300 pixels. If the containing box is less than 100 pixels wide, the iframe will overflow its containing div. If the containing box is between 100 pixels and 300 pixels inclusive, the width of the iframe would be set to that size, minus any necessary padding, borders and margins. If the width of the containing box is larger than 300 pixels, the extra space will be added inside the div. The extra space is added after the iframe inside the box. In this example, the box has been stretched so that it is very wide. The first child has a maximum width of 50 pixels, and it divides the excess space equally with the second child until its maximum width has been reached. After that, since it is not allowed to grow any further, the remaining space all goes to the second child.',
 'values': {}},

    'box-flex-group':
{'description': 'An element is flexible when the box-flex property is specified. The box-flex property is a floating point value representing the flexibility of the element. Its initial value is 0, which indicates that the element is inflexible. Elements that are flexible can shrink or grow as the box shrinks and grows. Whenever there is extra space left over in a box, the flexible elements are expanded to fill that space. All flex is relative. For example, a child with a box-flex of 2 is twice as flexible as a child with a box-flex of 1. A negative value for box-flex is not allowed. Flexible elements can be assigned to flex groups using the \'box-flex-group\' property. This property is a natural number value (the first flex group is 1 and higher values are later flex groups). The initial value is 1. In a horizontally oriented box, the preferred width of each child is computed. If the width of the margin box of each child is equal to the width of the containing block, then there is no extra space available, so the preferred widths are used for each child. If the width of the margin box adds up to a value smaller than the width of the containing block, then extra space is available. This extra space is divided up among the flexible children, as described below. If the width of the margin box adds up to a value larger than the width of the containing block, then the flexible children shrink as much as necessary to prevent overflow. Flexibility only applies to elements in normal flow. As absolute and fixed positioned elements are not in flow, any flexibility or flexgroup specified on them is ignored. In addition, as the \'float\' property does not apply to children of flexible boxes, they are considered part of normal flow and flexibility does apply. When dividing up extra space, first take all elements within the first flex group. Each element within that group should be given extra width based on the ratio of that element\'s flexibility compared to the flexibility of other elements within the same flex group. However, if the preferred width of the element plus the extra width allotted to it is larger than the maximum width of the element, then the width is set to that maximum width, and any remaining extra width beyond that is divided up among the other children. In this example there is 60 pixels of extra space available in the containing box. #div1 { display: box; width: 300px; } #button1 { box-flex: 1.0; width: 100px; } #button2 { box-flex: 2.0; width: 140px; } <div id="div1"> <button id="button1">Hello</button> <button id="button2">Goodbye</button> </div> As both child buttons are flexible, the extra space will be divided up between them. The first child button has a flexibility of 1.0 and the second child button has a flexibility of 2.0. The first button will receive 20 pixels of extra width and the second button will receive 40 pixels of extra width, maintaining the same ratio of extra width to flexibility values. This extra width is added to the preferred size of the element. However, if the second button had a maximum width of 150 pixels, it could only grow by 10 pixels before hitting this maximum size, so the remaining 30 pixels would instead be given to the first element, breaking the flexibility ratio. In this example there is 60 pixels of extra space available in the containing box. As both child buttons are flexible, the extra space will be divided up between them. The first child button has a flexibility of 1.0 and the second child button has a flexibility of 2.0. The first button will receive 20 pixels of extra width and the second button will receive 40 pixels of extra width, maintaining the same ratio of extra width to flexibility values. This extra width is added to the preferred size of the element. However, if the second button had a maximum width of 150 pixels, it could only grow by 10 pixels before hitting this maximum size, so the remaining 30 pixels would instead be given to the first element, breaking the flexibility ratio. More specifically, the percentage of extra space that an element may receive is calculated as follows:\' box-flex of child \' / \' total of box-flex values of child and all siblings \'If the width of all flexible children within the group has been increased to their maximum widths, the process repeats for the children within the next flex group, using any space left over from the previous flex group. Once there are no more flex groups, and there is still space remaining, the extra space is divided within the containing box according to the box-pack property. If the box would overflow after the preferred width of the children have been computed, then width is removed from flexible elements in a manner similar to that used when adding extra space. Each flex group is examined in turn and space is removed according to the ratio of the flexibility of each element. Elements do not shrink below their minimum widths. If all children have been shrunk to their minimum sizes, then the box overflows, although if the box-lines property is set to multiple, the box may be able to move elements to additional lines to prevent this. For vertically oriented boxes, the algorithm as described above is similar except using the height instead of the width. When a child box of a horizontally oriented box contains an inline element, it is likely that shrinking the width of the element due to flexibility may cause the inline element to grow in height, as the text within it may need to wrap to additional lines. Examples: #div1 { display: box; box-orient: vertical; height: 200px } <div id="div1"> <button>Cat</button> <button style="box-flex: 1">Piranha</button> <button>Antidisestablishmentarianism</button> </div> In the example above, the box is 200 pixels tall and is more than enough room for the three buttons. Because the first and third buttons are inflexible, they remain the same size, which is their intrinsic size. The second button is specified as being flexible, and because it is the only flexible element in the box, it receives all of the extra space. <div style="display: box; box-orient: vertical;"> <button style="box-flex: 1; height: 1000px;"> Cat </button> </div> In this example, if the height of the box is reduced, for instance, because the user resized the containing viewport, the height of the flexible button also shrinks with the box, despite the specification of 1000 pixels as the preferred height. It continues to shrink until the minimum required height for the button is reached, which here will likely be the height needed to display the button\'s label and border. After that, the button can shrink no further. Elements within a box can therefore have their own notions of minimum and maximum intrinsic sizes. In the above example, the button could not get any smaller than the minimum height required to draw its borders and its text. #div1 { display: box; } #iframe1 { box-flex: 1; min-width: 100px; max-width: 300px; height: 300px; } <div id="div1"> <iframe id="iframe1" src="http://www.mozilla.org/"/> </div> In this example, the iframe has a minimum width of 100 pixels and a maximum width of 300 pixels. If the containing box is less than 100 pixels wide, the iframe will overflow its containing div. If the containing box is between 100 pixels and 300 pixels inclusive, the width of the iframe would be set to that size, minus any necessary padding, borders and margins. If the width of the containing box is larger than 300 pixels, the extra space will be added inside the div. The extra space is added after the iframe inside the box. <p style="display: box;"> <button style="box-flex: 1; max-width: 50px;">Child 1</button> <button style="box-flex: 1; min-width: 50px;">Child 2</button> </p> In this example, the box has been stretched so that it is very wide. The first child has a maximum width of 50 pixels, and it divides the excess space equally with the second child until its maximum width has been reached. After that, since it is not allowed to grow any further, the remaining space all goes to the second child. 6 Packing along the box axis Name: box-pack Value: start | end | center | justify Initial: start Applies to: box elements Inherited: no Percentages: no Media: visual Computed value: specified valueExamples:In the example above, the box is 200 pixels tall and is more than enough room for the three buttons. Because the first and third buttons are inflexible, they remain the same size, which is their intrinsic size. The second button is specified as being flexible, and because it is the only flexible element in the box, it receives all of the extra space. In this example, if the height of the box is reduced, for instance, because the user resized the containing viewport, the height of the flexible button also shrinks with the box, despite the specification of 1000 pixels as the preferred height. It continues to shrink until the minimum required height for the button is reached, which here will likely be the height needed to display the button\'s label and border. After that, the button can shrink no further. Elements within a box can therefore have their own notions of minimum and maximum intrinsic sizes. In the above example, the button could not get any smaller than the minimum height required to draw its borders and its text. In this example, the iframe has a minimum width of 100 pixels and a maximum width of 300 pixels. If the containing box is less than 100 pixels wide, the iframe will overflow its containing div. If the containing box is between 100 pixels and 300 pixels inclusive, the width of the iframe would be set to that size, minus any necessary padding, borders and margins. If the width of the containing box is larger than 300 pixels, the extra space will be added inside the div. The extra space is added after the iframe inside the box. In this example, the box has been stretched so that it is very wide. The first child has a maximum width of 50 pixels, and it divides the excess space equally with the second child until its maximum width has been reached. After that, since it is not allowed to grow any further, the remaining space all goes to the second child.',
 'values': {}},

    'box-lines':
{'description': 'By default a horizontal box will lay out its children in a single row, and a vertical box will lay out its children in a single column. This behavior can be changed using the box-lines property. The default value is single, which means that all elements will be placed in a single row or column, and any elements that don\'t fit will simply be considered overflow. If a value of multiple is specified, however, then the box is allowed to expand to multiple lines (that is, multiple rows or columns) in order to accommodate all of its children. The box must attempt to fit its children on as few lines as possible by shrinking all elements down to their minimum widths or heights if necessary. If the children in a horizontal box still do not fit on a line after being reduced to their minimum widths, then children are moved one by one onto a new line, until the elements remaining on the previous line fit. This process can repeat to an arbitrary number of lines. If a line contains only a single element that doesn\'t fit, then the element should stay on that line and overflow out of the box. The later lines are placed below the earlier lines in normal direction boxes and above in reverse direction boxes. The height of a line is the height of the largest child in that line. No additional space appears between the lines apart from the margins on the largest elements in each line. For calculating the height of a line, margins with a computed value of auto should be treated as having a value of 0. A similar process occurs for children in a vertical box. Later lines in normal direction boxes are placed to the right of earlier lines and to the left in reverse direction boxes. Once the number of lines has been determined, elements with a computed value for box-flex other than 0 stretch as necessary in an attempt to fill the remaining space on the lines. Each line computes flexes independently, so only elements on that line are considered when evaluating flex and flex-groups. The packing of elements in a line, as specified by the box-pack property, is also computed independently for each line. This example shows four buttons that do not fit horizontally. #div1 { display: box; box-lines: multiple; width: 300px; } button { box-flex: 1.0; width: 100px; } <div id="div1"> <button id="button1">Elephant</button> <button id="button2">Tiger</button> <button id="button1">Antelope</button> <button id="button2">Wildebeest</button> </div> The buttons are shrunk to their minimum widths, in this case calculated intrinsically. Assume that the four buttons have a minimum intrinsic width of 80 pixels. This will allow the first three buttons to fit in 240 pixels with 60 pixels left over of remaining space. Because the box-lines property has a specified value of multiple, the fourth button may be moved onto a second line. Flexibility is applied to each element, separately for each line. The first line has 60 pixels of remaining space, so each of the three buttons on that line will receive 20 pixels of extra width. The remaining button on a line of its own will stretch to the entire width of the containing box, or 300 pixels. If the box was resized, the buttons may rearrange onto different lines as necessary. If the style rules in the example above were changed to the following: #div1 { display: box; box-lines: multiple; box-pack: center; width: 300px; } button { box-flex: 1.0; width: 90px; max-width: 90px; } Now, each of the buttons will only stretch to include an additional 10 pixels of width, as the maximum width of 90 pixels is only 10 pixels larger than the minimum intrinsic width of the buttons. The remaining 30 pixels of space left over is divided up and placed inside the box outside of the buttons, as the value of box-pack is center. The fourth button will also appear at 90 pixels wide, centered within the box. 7.1 Multiple Lines and alignmentThis example shows four buttons that do not fit horizontally. The buttons are shrunk to their minimum widths, in this case calculated intrinsically. Assume that the four buttons have a minimum intrinsic width of 80 pixels. This will allow the first three buttons to fit in 240 pixels with 60 pixels left over of remaining space. Because the box-lines property has a specified value of multiple, the fourth button may be moved onto a second line. Flexibility is applied to each element, separately for each line. The first line has 60 pixels of remaining space, so each of the three buttons on that line will receive 20 pixels of extra width. The remaining button on a line of its own will stretch to the entire width of the containing box, or 300 pixels. If the box was resized, the buttons may rearrange onto different lines as necessary. If the style rules in the example above were changed to the following:Now, each of the buttons will only stretch to include an additional 10 pixels of width, as the maximum width of 90 pixels is only 10 pixels larger than the minimum intrinsic width of the buttons. The remaining 30 pixels of space left over is divided up and placed inside the box outside of the buttons, as the value of box-pack is center. The fourth button will also appear at 90 pixels wide, centered within the box.',
 'values': {}},

    'box-ordinal-group':
{'description': 'The children of a box element may be assigned to ordinal groups using the \'box-ordinal-group\' property. This property is a natural number value with an initial value is 1. Ordinal groups can be used in conjunction with the \'box-direction\' property to control the order in which the direct children of a box appear. When the computed box-direction is normal, a box will display its elements starting from the lowest numbered ordinal group and ensure that those elements appear to the left (for horizontal boxes) or at the top (for vertical boxes) of the container. Elements with the same ordinal group are flowed in the order they appear in the source document tree. In the reverse direction, the ordinal groups are examined in the same order, except the elements appear reversed. This example shows how ordinal groups might be used. #div1 { display: box; } #span1 { box-ordinal-group: 2; } #span3 { box-ordinal-group: 2; } #span4 { box-ordinal-group: 1; } <div id="div1"> <span id="span1" >Sentence One</span> <span id="span2" >Sentence Two</span> <span id="span3" >Sentence Three</span> <span id="span4" >Sentence Four</span> </div> The first ordinal group, 1, contains span2 and span4. As span2 does not specify an ordinal group, it will default to 1. The elements will be displayed in document order, so span2 will be displayed before span4. The second ordinal group, 2, contains the remaining two spans. The resulting display order will be: span2 span4 span1 span3This example shows how ordinal groups might be used. The first ordinal group, 1, contains span2 and span4. As span2 does not specify an ordinal group, it will default to 1. The elements will be displayed in document order, so span2 will be displayed before span4. The second ordinal group, 2, contains the remaining two spans. The resulting display order will be:Elements within a box can use the \'visibility\' property to render themselves invisible. Boxes behave like tables in that the value collapsed can be used to specify that an element within a box should not take up any space at all. The computed width and height of a collapsed element are both 0, and the element is not considered when calculating flexibility. Other non-collapsed flexible elements may expand as needed to fill in any space left open by a collapsed element. <h2 id="boxsizing">Box sizing</h2> <table class="propdef">\n<tbody>\n<tr valign=baseline><td><em>Name:</em> <td><dfn id="propdef-box-sizing">box-sizing</dfn>\n<tr valign=baseline><td><em>Value:</em> <td>content-box | padding-box | border-box | margin-box\n<tr valign=baseline><td><em>Initial:</em> <td>1\n<tr valign=baseline><td><em>Applies to:</em> <td>box and block elements\n<tr valign=baseline><td><em>Inherited:</em> <td>no\n<tr valign=baseline><td><em>Percentages:</em> <td>no\n<tr valign=baseline><td><em>Media:</em> <td>visual</a>\n<tr valign=baseline><td><em>Computed value:</em> <td>specified value\n</tbody>\n</table> <p>The <span class="property">\'<code class=property>box-sizing</code>\'</span> property determines how the <span class="property">\'<code class=property>height</code>\'</span> and <span class="property">\'<code class=property>width</code>\'</span> properties should be interpreted. </p><dl> <dt>content-box </dt><dd>This is the behavior of width and height as specified by CSS2. The specified width and height apply to the width and height respectively of the content box of the element. The padding and border of the element are drawn outside the specified width and height. </dd><dt>padding-box </dt><dd>The specified width and height of this element determine the padding box of the element. That is, any padding specified on the element is drawn inside this specified width and height. The content width and height is computed by subtracting the padding of the respective sides from the specified width and height. The padding-box size is the dimension used for the containing block of absolutely positioned blocks. </dd><dt>border-box </dt><dd>The specified width and height of this element determine the border box of the element. That is, any padding or border specified on the element is laid out and drawn inside this specified width and height. The content width and height is computed by subtracting the border and padding of the respective sides from the specified width and height. This is the behavior of width and height as commonly implemented by legacy HTML user agents for replaced elements and input elements. </dd><dt>margin-box </dt><dd>The specified width and height of this element determine the margin box of the element. That is, any margin, padding or border specified on the element is laid out and drawn inside this specified width and height. The content width and height is computed by subtracting the margin, border and padding of the respective sides from the specified width and height. When margins collapse, the height (or width, for horizontal block layout) is calculated before applying any collapsing algorithms. </dd></dl> <p>Note that despite the name of the property, <span class="property">\'<code class=property>box-sizing</code>\'</span> applies to block and table-level elements as well as boxes. 4 Alignment Name: box-align Value: start | end | center | baseline | stretch Initial: stretch Applies to: box elements Inherited: no Percentages: no Media: visual Computed value: specified value',
        'values': {}},

    'box-orient':
{'description': 'A box may lay out its children either horizontally or vertically.',
        'values': {'block-axis': 'The box displays its children along the block axis.',
                          'horizontal': 'The box displays its children from left to right in a horizontal line.',
                          'inline-axis': 'The box displays its children along the inline axis.',
                          'vertical': 'The box displays its children from stacked from top to bottom vertically.'}},

    'box-pack':
{'description': 'When all of the elements within a box are inflexible or when all elements have grown to their maximum sizes and can stretch no further, extra space may be left over in the box. The box-pack property may be used to dictate how any additional space along the box-axis should be distributed between elements. The box-pack property does not affect the position of elements in the opposite direction. That is, box-pack affects only the horizontal position in horizontally oriented boxes and only the vertical position in vertically oriented boxes. <p style="box-align: center; box-pack: center; width: 300px; height: 300px;"> <button>centered</button> </p> In the example above, the button is centered within the box using the \'box-align\' and \'box-pack\' properties together. The former centers the button vertically, and the latter centers the button horizontally. 7 Multiple Lines Name: box-lines Value: single | multiple Initial: single Applies to: box elements Inherited: no Percentages: no Media: visual Computed value: specified value',
        'values': {'center': 'The extra space is divided evenly, with half placed before the first child and the other half placed after the last child.',
                          'end': 'For normal direction boxes, the right edge of the last child is placed at the right side, with all extra space placed before the first child. For reverse direction boxes, the left edge of the first child is placed at the left side, with all extra space placed after the last child.',
                          'justify': 'The space is divided evenly in-between each child, with none of the extra space placed before the first child or after the last child. If there is only one child, treat the pack value as if it were start.',
                          'start': 'For normal direction boxes, the left edge of the first child is placed at the left side, with all extra space placed after the last child. For reverse direction boxes, the right edge of the last child is placed at the right side, with all extra space placed before the first child.'}},

    'box-shadow':
{'description': "The 'box-shadow' property attaches one or more drop-shadows to the box. The property is a comma-separated list of shadows, each specified by 2-4 length values, an optional color, and an optional 'inset' keyword. Omitted lengths are 0; omitted colors are a UA-chosen color. Where <shadow> = inset? && [ <length> {2,4} && <color> ? ]The components of each <shadow> are interpreted as follows: The first length is the horizontal offset of the shadow. A positive value draws a shadow that is offset to the right of the box, a negative length to the left. The second length is the vertical offset. A positive value offsets the shadow down, a negative one up. The third length is a blur distance. Negative values are not allowed. If the blur value is zero, the shadow's edge is sharp. Otherwise, the larger the value, the more the shadow's edge is blurred. See below. The fourth length is a spread distance. Positive values cause the shadow shape to expand in all directions by the specified radius. Negative values cause the shadow shape to contract. See below. Note that for inner shadows, expanding the shadow (creating more shadow area) means contracting the shadow's perimeter shape. The color is the color of the shadow. The 'inset' keyword, if present, changes the drop shadow from an outer shadow (one that shadows the box onto the canvas, as if it were lifted above the canvas) to an inner shadow (one that shadows the canvas onto the box, as if the box were cut out of the canvas and shifted behind it). An outer box-shadow casts a shadow as if the border-box of the element were opaque. The shadow is drawn outside the border edge only: it is clipped inside the border-box of the element. An inner box-shadow casts a shadow as if everything outside the padding edge were opaque. The inner shadow is drawn inside the padding edge only: it is clipped outside the padding box of the element. If the box has a nonzero 'border-radius', the shadow shape is rounded in the same way. The 'border-image' does not affect the shape of the box-shadow. If a spread distance is defined, the shadow is expanded outward or contracted inward by an operation equivalent to applying twice the absolute value of the spread value to a blur operation as defined below and thresholding the result such that for a positive spread distance all non-transparent pixels are given the full shadow color and for a negative spread distance all non-opaque pixels are made transparent. The UA may approximate this operation by taking an outward outset of the specified amount normal to the original shadow perimeter. Alternatively the UA may approximate the transformed shadow perimeter shape by outsetting (insetting, for inner shadows) the shadow's straight edges by the spread distance and increasing (decreasing, for inner shadows) and flooring at zero the corner radii by the same amount. (The UA may even combine these methods, using one method for outer shadows and another for inner ones.) For corners with a zero border-radius, however, the corner must remain sharp-the operation is equivalent to scaling the shadow shape. In any case, the effective width and height of the shadow shape is floored at zero. (A zero-sized shadow shape would cause an outer shadow to disappear, and an inner shadow to cover the entire padding-box.)A non-zero blur distance indicates that the resulting shadow should be blurred, such as by a Gaussian filter. The exact algorithm is not defined; however for a long, straight shadow edge, this should create a color transition the length of the blur distance that is perpendicular to and centered on the shadow's edge, and that ranges from the full shadow color at the radius endpoint inside the shadow to fully transparent at the endpoint outside it. The example below demonstrates the effects of spread and blur on the shadow:The example below demonstrates the effects of spread and blur on the shadow:The shadow effects are applied front-to-back: the first shadow is on top and the others are layered behind. Shadows do not influence layout and may overlap other boxes or their shadows. In terms of stacking contexts and the painting order, the outer shadows of an element are drawn immediately below the background of that element, and the inner shadows of an element are drawn immediately above the background of that element (below the borders and border image, if any). If an element has multiple boxes, all of them get drop shadows, but shadows are only drawn where borders would also be drawn; see 'box-decoration-break'. Shadows do not trigger scrolling or increase the size of the scrollable area. Below are some examples of an orange box with a blue border being being given a drop shadow. border:5px solid blue; background-color:orange; width: 144px; height: 144px; border-radius: 20px; border-radius: 0; box-shadow: rgba(0,0,0,0.4) 10px 10px; box-shadow: rgba(0,0,0,0.4) 10px 10px inset box-shadow: rgba(0,0,0,0.4) 10px 10px 0 10px /* spread */ box-shadow: rgba(0,0,0,0.4) 10px 10px 0 10px /* spread */ insetBelow are some examples of an orange box with a blue border being being given a drop shadow. The 'box-shadow' property applies to the ' ::first-letter ' pseudo-element, but not the ' ::first-line ' pseudo-element. Outer shadows have no effect on internal table elements in the collapsing border model. If a shadow is defined for single border edge in the collapsing border model that has multiple border thicknesses (e.g. an outer shadow on a table where one row has thicker borders than the others, or an inner shadow on a rowspanning table cell that adjoins cells with different border thicknesses), the exact position and rendering of its shadows are undefined. 7. Definitions 7.1. Glossary",
        'values': {}},

    'box-sizing':
{'description': '',
        'values': {'border-box': "The specified width and height (and respective min/max properties) on\nthis element determine the border box of the element. That is, any padding or\nborder specified on the element is laid out and drawn inside this specified\nwidth and height. The content width and height are calculated by subtracting\nthe border and padding widths of the respective sides from the specified 'width'and'height' properties. As the content width and height cannot\nbe negative ( [CSS21], section\n10.2), this computation is floored at 0. Note. This is the behavior of width and\nheight as commonly implemented by legacy HTML user agents for replaced\nelements and input elements.",
                          'content-box': 'This is the behavior of width and height as specified by CSS2.1. The\nspecified width and height (and respective min/max properties) apply to the\nwidth and height respectively of the content box of the element. The padding\nand border of the element are laid out and drawn outside the specified width\nand height.'}},

    'break-after':
{'description': 'These properties describe page/column break behavior before/after/inside the generated box. These are normatively defined in [CSS21] {{!CSS21}} :',
        'values': {'always': 'Always force a page break before (after) the generated box.',
                          'auto': 'Neither force nor forbid a page/column break before (after, inside) the generated box.',
                          'avoid': 'Avoid a page/column break before (after, inside) the generated box.',
                          'left': 'Force one or two page breaks before (after) the generated box so that the next page is formatted as a left page.',
                          'right': 'Force one or two page breaks before (after) the generated box so that the next page is formatted as a right page.'}},

    'break-before':
{'description': 'These properties describe page/column break behavior before/after/inside the generated box. These are normatively defined in [CSS21] {{!CSS21}} :',
        'values': {'always': 'Always force a page break before (after) the generated box.',
                          'auto': 'Neither force nor forbid a page/column break before (after, inside) the generated box.',
                          'avoid': 'Avoid a page/column break before (after, inside) the generated box.',
                          'left': 'Force one or two page breaks before (after) the generated box so that the next page is formatted as a left page.',
                          'right': 'Force one or two page breaks before (after) the generated box so that the next page is formatted as a right page.'}},

    'break-inside':
{'description': 'These properties describe page/column break behavior before/after/inside the generated box. These are normatively defined in [CSS21] {{!CSS21}} :',
        'values': {'always': 'Always force a page break before (after) the generated box.',
                          'auto': 'Neither force nor forbid a page/column break before (after, inside) the generated box.',
                          'avoid': 'Avoid a page/column break before (after, inside) the generated box.',
                          'left': 'Force one or two page breaks before (after) the generated box so that the next page is formatted as a left page.',
                          'right': 'Force one or two page breaks before (after) the generated box so that the next page is formatted as a right page.'}},

    'color-profile':
{'description': 'This property permits the specification of a source color profile other\nthan the default. <dt><strong>none</strong>\n<dd>Any profile information embedded within image data should be ignored.\nThe image should be rendered as if it is already in the destination color space. <i>This value is most useful for demonstration purposes.</i> Example(s): /* use the specified profile, even if the image contains an embedded profile */\nIMG { color-profile: url("http://example.com/profiles/eg.icm") } 3.4. The \'rendering-intent\'\nproperty Name: rendering-intent Value: auto | perceptual | relative-colorimetric | saturation |\nabsolute-colorimetric | inherit Initial: auto Applies to: all elements Inherited: yes Percentages: N/A Media: visual Computed value: specified value',
        'values': {'<name>': "A name corresponding to a defined color profile that is in the user\nagent's color profile description database. The user agent searches the color\nprofile description database for a color profile\ndescription entry whose name descriptor matches <name> and uses the\nlast matching entry that is found. If a match is found, the corresponding\nprofile overrides an embedded profile inside an image. If no match is found,\nthen the embedded profile inside the image is used.",
                          'url(': 'The location of a standard ICC profile resource. Just like specifying sRGB, it overrides an embedded profile.',
                          'auto': 'This is the default behavior. All colors are presumed to be defined in\nthe sRGB color space unless a more precise embedded profile is specified\nwithin content data. For images that do have a profile built into their data,\nthat profile is used. For images that do not have a profile, the sRGB profile\nis used so that the colors in these images can be kept "in synch" with the\ncolors specified in CSS and HTML.',
                          'sRGB': 'The source profile is assumed to be sRGB. This differs from auto in that it overrides an embedded profile inside an\nimage. For consistency with CSS lexical scanning and parsing rules, the\nkeyword "sRGB" is case-insensitive; however, it is recommended that the mixed\ncapitalization "sRGB" be used for consistency with common industry practice.'}},

    'column-count':
{'description': "This property describes the number of columns of a multicol element. Example: body { column-count: 3 } 3.3. 'columns' Name: columns Value: <'column-width'> || <'column-count'> Initial: see individual properties Applies to: non-replaced block-level elements (except table elements), table cells, and inline-block elements Inherited: no Percentages: N/A Media: visual Computed value: see individual properties",
        'values': {'<integer>': "describes the optimal number of columns into which the content of the element will be flowed. Values must be greater than 0. If both 'column-width'and'column-count' have non-auto values, the integer value describes the maximum number of columns.",
                          'auto': "means that the number of columns will be determined by other properties (e.g., 'column-width', if it has a non-auto value)."}},

    'column-fill':
{'description': 'The values are:',
        'values': {'auto': 'Fills columns sequentially.',
                          'balance': 'Balance content equally between columns, if possible.'}},

    'column-gap':
{'description': "The 'column-gap' property sets the gap between columns. If there is a column rule between columns, it will appear in the middle of the gap. The 'normal' value is UA-specific. A value of '1em' is suggested. Column gaps cannot be negative. 4.2. 'column-rule-color' Name: column-rule-color Value: <color> Initial: same as for 'color' property [CSS21] {{!CSS21}} Applies to: multicol elements Inherited: no Percentages: N/A Media: visual Computed value: the same as the computed value for the 'color' property [CSS21] {{!CSS21}}",
        'values': {}},

    'column-rule':
{'description': "This property is a shorthand for setting 'column-rule-width', 'column-rule-style', and 'column-rule-color' at the same place in the style sheet. Omitted values are set to their initial values. In this example, the column rule and the column gap have the same width. Therefore, they will occupy exactly the same space. body { column-gap: 1em; column-rule-width: 1em; column-rule-style: solid; column-rule-color: black;\n} If a tall image is moved to a column on the next page to find room for it, its natural column may be left empty. If so, the column is is still considered to have content for the purpose of deciding if the column rule should be drawn. 5. Column breaksIn this example, the column rule and the column gap have the same width. Therefore, they will occupy exactly the same space. body { column-gap: 1em; column-rule-width: 1em; column-rule-style: solid; column-rule-color: black;\n}If a tall image is moved to a column on the next page to find room for it, its natural column may be left empty. If so, the column is is still considered to have content for the purpose of deciding if the column rule should be drawn.",
        'values': {}},

    'column-rule-color':
{'description': "This property sets the color of the column rule. The <color> values are defined in [CSS21] {{!CSS21}}. 4.3. 'column-rule-style' Name: column-rule-style Value: <'border-style'> Initial: none Applies to: multicol elements Inherited: no Percentages: N/A Media: visual Computed value: specified value",
        'values': {}},

    'column-rule-style':
{'description': "The 'column-rule-style' property sets the style of the rule between columns of an element. The <border-style> values are defined in [CSS21] {{!CSS21}}. The 'inset' keyword value is shown like the 'ridge' value. The 'outset' value is shown like 'groove'. The 'none' value forces the computed value of 'column-rule-width' to be '0'. 4.4. 'column-rule-width' Name: column-rule-width Value: <'border-width'> Initial: medium Applies to: multicol elements Inherited: no Percentages: N/A Media: visual Computed value: absolute length; '0' if the column rule style is 'none'or'hidden'",
        'values': {}},

    'column-rule-width':
{'description': "This property sets the width of the rule between columns. Negative values are not allowed. 4.5. 'column-rule' Name: column-rule Value: <column-rule-width> || <border-style> || [ <color> | transparent ] Initial: see individual properties Applies to: multicol elements Inherited: no Percentages: N/A Media: visual Computed value: see individual properties",
        'values': {}},

    'column-span':
{'description': 'This property describes how many columns an element spans across. Values are:',
        'values': {'1': 'The element does not span multiple columns.',
                          'all': 'The element spans across all columns. Content in the normal flow that appears before the element is automatically balanced across all columns before the element appears.'}},

    'column-width':
{'description': 'This property describes the width of columns in multicol elements. For example, consider this style sheet: div { width: 100px; column-width: 45px; column-gap: 0; column-rule: none;\n} There is room for two 45px wide columns inside the 100px wide element. In order to fill the available space the actual column width will be increased to 50px. Also, consider this style sheet: div { width: 40px; column-width: 45px; column-gap: 0; column-rule: none;\n} The available space is smaller than the specified column width and the actual column width will therefore be decreased.',
        'values': {'<length>': 'describes the optimal column width. The actual column width may be wider (to fill the available space), or narrower (only if the available space is smaller than the specified column width). Values must be greater than 0.',
                          'auto': "means that the column width will be determined by other properties (e.g., 'column-count', if it has a non-auto value)."}},

    'columns':
{'description': "This is a shorthand property for setting 'column-width'and'column-count'. Omitted values are set to their initial values. Here are some valid declarations using the 'columns' property: columns: 12em; /* column-width: 12em; column-count: auto */\ncolumns: auto 12em; /* column-width: 12em; column-count: auto */\ncolumns: 2; /* column-width: auto; column-count: 2 */\ncolumns: 2 auto; /* column-width: auto; column-count: 2 */\ncolumns: auto; /* column-width: auto; column-count: auto */\ncolumns: auto auto; /* column-width: auto; column-count: auto */ 3.4. Pseudo-algorithmHere are some valid declarations using the 'columns' property: columns: 12em; /* column-width: 12em; column-count: auto */\ncolumns: auto 12em; /* column-width: 12em; column-count: auto */\ncolumns: 2; /* column-width: auto; column-count: 2 */\ncolumns: 2 auto; /* column-width: auto; column-count: 2 */\ncolumns: auto; /* column-width: auto; column-count: auto */\ncolumns: auto auto; /* column-width: auto; column-count: auto */",
        'values': {}},

    'crop':
{'description': 'This property allows a replaced element to be just a rectangular area of\nan object, instead of the whole object. The \'crop\' property adds a step when determining the intrinsic dimensions\nof an element. With \'crop\', the notion of computed intrinsic width\nand height are introduced. When the layout algorithms reference the\n"intrinsic width" (and/or height), they are referring to the computed\nintrinsic width and height. The computed intrinsic width and height of an element are the result of\napplying the crop to the actual intrinsic width and height of the element.',
        'values': {'auto': "The element's computed intrinsic width and height are the same as its\nactual intrinsic width and height.",
                          'inset-rect': 'inset-rect( top, right, bottom, left ). Like rect(), except that the values are offsets relative to the\nrespective edges of the element.',
                          'rect': 'rect( top, right, bottom, left ). Each of the four arguments can be a <length> or a <percentage>. All percentage values are computed relative to\nthe intrinsic dimensions of the element, if there is one. Values are offsets\nrelative to the top left of the element. The computed intrinsic width and\nheight of the element are determined by subtracting the left from the right\nfor the width, and similarly top from bottom for the height. However, if this\ncomputation results in a negative value, it is considered to be zero.'}},

    'dominant-baseline':
{'description': "The 'dominant-baseline' property is used to\ndetermine or re-determine a scaled-baseline-table. A scaled-baseline-table is\na compound value with three components: a baseline-identifier for the dominant baseline; it can be qualified as\nthe 'dominant' baseline-identifier (or 'dominant baseline' in short); the\nbaseline-identifier is basically an 'alignment-baseline' value. a derived baseline-table which contains definition for additional\nbaseline-identifiers related to various scripts, and a baseline-table font-size. Some values of the property re-determine all three values; other only\nreestablish the baseline-table font-size. Values for the property have the\nfollowing meaning:",
        'values': {'alphabetic': "The dominant baseline-identifier is set to the 'alphabetic' baseline, the\nderived baseline-table is constructed using the 'alphabetic' baseline-table\nin the nominal font, and the baseline-table font-size is changed to the value\nof the 'font-size' property on this element. (The 'alphabetic' baseline is\nthe standard baseline for Roman scripts.)",
                          'auto': "If this property occurs on a block or inline-block element, then the user\nagent behavior depends on the value of the 'script' property. If the value of the script\nproperty is 'auto, the 'auto' value is equivalent to 'alphabetic' for\nhorizontal 'writing-mode' values and 'central' for\nvertical 'writing-mode' values. If the value of the\nscript property is other than 'auto', the 'auto' value is equivalent to\n'use-script'",
                          'central': "The dominant baseline-identifier is set to be 'central'. The derived\nbaseline-table is constructed from the defined baselines in a baseline-table\nin the nominal font. That font baseline-table is chosen using the following\npriority order of baseline-table names: 'ideographic', 'alphabetic',\n'hanging'and'mathematical'. The baseline-table is changed to the value of\nthe 'font-size' property on this element.",
                          'hanging': "The dominant baseline-identifier is set to the 'hanging' baseline, the\nderived baseline- table is constructed using the 'hanging' baseline-table in\nthe nominal font, and the baseline-table font-size is changed to the value of\nthe 'font-size' property on this element.",
                          'ideographic': "The dominant baseline-identifier is set to the 'ideographic' baseline,\nthe derived baseline- table is constructed using the 'ideographic'\nbaseline-table in the nominal font, and the baseline-table font-size is\nchanged to the value of the 'font-size' property on this element.",
                          'mathematical': "The dominant baseline-identifier is set to the 'mathematical' baseline,\nthe derived baseline- table is constructed using the 'mathematical'\nbaseline-table in the nominal font, and the baseline-table font-size is\nchanged to the value of the 'font-size' property on this element.",
                          'middle': "The dominant baseline-identifier is set to be 'middle'. The derived\nbaseline-table is constructed from the defined baselines in a baseline-table\nin the nominal font. That font baseline-table is chosen using the following\npriority order of baseline-table names: 'alphabetic', 'ideographic',\n'hanging'and'mathematical'. The baseline-table is changed to the value of\nthe 'font-size' property on this element.",
                          'no-change': 'The dominant baseline-identifier, the baseline-table and the\nbaseline-table font-size remain the same as that of the parent.',
                          'reset-size': "The dominant baseline-identifier and the baseline table remain the same,\nbut the baseline-table font-size is changed to the value of the 'font-size' property on this element. This\nre-scales the baseline table for the current 'font-size'.",
                          'text-after-edge': "The dominant baseline-identifier is set to be 'text-after-edge'. The\nderived baseline-table is constructed from the defined baselines in a\nbaseline-table in the nominal font. That font baseline-table is chosen using\nthe following priority order of baseline-table names: 'alphabetic',\n'ideographic', 'hanging'and'mathematical'. The baseline-table is changed to\nthe value of the 'font-size' property on this element.",
                          'text-before-edge': "The dominant baseline-identifier is set to be 'text-before-edge'. The\nderived baseline-table is constructed from the defined baselines in a\nbaseline-table in the nominal font. That font baseline-table is chosen using\nthe following priority order of baseline-table names: 'alphabetic',\n'ideographic', 'hanging'and'mathematical'. The baseline-table is changed to\nthe value of the 'font-size' property on this element.",
                          'use-script': "The dominant baseline-identifier is set using the computed value of the 'script' property. The 'writing-mode' value, whether horizontal or vertical is used to select the baseline-table\nthat correspond to that baseline-identifier. The baseline-table font-size\ncomponent is set to the value of the 'font-size' property on this element."}},

    'drop-initial-after-adjust':
{'description': "The 'drop-initial-after-adjust' property sets\nthe alignment point of the drop initial for the primary connection point.\nPossible values: Name: drop-initial-before-align Value: caps-height | <'alignment-baseline'> Initial: caps-height Applies to: ::first-letter pseudo element Inherited: no Percentages: N/A Media: visual Computed value: specified values (except for initial and inherit)",
        'values': {'<length>': "The alignment-point is on the end-edge of the inline box. Its position\nalong the end-edge is offset from the after-edge by the <length> value.\nA value of '0cm' makes the text-after-edge the alignment point.",
                          '<percentage>': "The computed value of the property is this percentage multiplied by the\ncomputed 'line-height' of the element. The alignment point is on the end-edge\nof the inline box and is offset from the after-edge by the computed value. A\nvalue of '0%' makes the text-after-edge the alignment point.",
                          'after-edge': "The alignment point is at the intersection of the end-edge of the element\nand the 'after-edge' of the extended inline box of the element. This may include or not the line-height of the element, depending on the line-stacking-strategy.",
                          'alphabetic': "The alignment point is at the intersection of the end-edge of the element\nand the 'alphabetic' baseline of the element.",
                          'central': "The alignment point is at the intersection of the end-edge of the element\nand the 'central' baseline of the element.",
                          'hanging': "The alignment point is at the intersection of the end-edge of the element\nand the 'hanging' baseline of the element.",
                          'ideographic': "The alignment point is at the intersection of the end-edge of the element\nand the 'ideographic' baseline of the element.",
                          'mathematical': "The alignment point is at the intersection of the end-edge of the element\nand the 'mathematical' baseline of the element.",
                          'middle': "The alignment point is at the intersection of the end-edge of the element\nand the 'middle' baseline of the element.",
                          'text-after-edge': "The alignment point is at the intersection of the end-edge of the element\nand the 'text-after-edge' baseline of the element."}},

    'drop-initial-after-align':
{'description': "The 'drop-initial-after-align' property\ndetermines which alignment line within the nth line box (n being defined by\nthe 'drop-initial-value' property) is used at the\nprimary connection point with the initial letter box. The values are the same\nas the 'alignment-baseline' property values. Name: drop-initial-after-adjust Value: central | middle | after-edge | text-after-edge | ideographic |\nalphabetic | mathematical | <percentage> | <length> Initial: text-after-edge Applies to: ::first-letter pseudo element Inherited: no Percentages: refer to combined line height size as provided by drop-initial-value Media: visual Computed value: specified values (except for initial and inherit)The 'drop-initial-after-adjust' property sets\nthe alignment point of the drop initial for the primary connection point.\nPossible values: Name: drop-initial-before-align Value: caps-height | <'alignment-baseline'> Initial: caps-height Applies to: ::first-letter pseudo element Inherited: no Percentages: N/A Media: visual Computed value: specified values (except for initial and inherit)",
        'values': {'<length>': "The alignment-point is on the end-edge of the inline box. Its position\nalong the end-edge is offset from the after-edge by the <length> value.\nA value of '0cm' makes the text-after-edge the alignment point.",
                          '<percentage>': "The computed value of the property is this percentage multiplied by the\ncomputed 'line-height' of the element. The alignment point is on the end-edge\nof the inline box and is offset from the after-edge by the computed value. A\nvalue of '0%' makes the text-after-edge the alignment point.",
                          'after-edge': "The alignment point is at the intersection of the end-edge of the element\nand the 'after-edge' of the extended inline box of the element. This may include or not the line-height of the element, depending on the line-stacking-strategy.",
                          'alphabetic': "The alignment point is at the intersection of the end-edge of the element\nand the 'alphabetic' baseline of the element.",
                          'central': "The alignment point is at the intersection of the end-edge of the element\nand the 'central' baseline of the element.",
                          'hanging': "The alignment point is at the intersection of the end-edge of the element\nand the 'hanging' baseline of the element.",
                          'ideographic': "The alignment point is at the intersection of the end-edge of the element\nand the 'ideographic' baseline of the element.",
                          'mathematical': "The alignment point is at the intersection of the end-edge of the element\nand the 'mathematical' baseline of the element.",
                          'middle': "The alignment point is at the intersection of the end-edge of the element\nand the 'middle' baseline of the element.",
                          'text-after-edge': "The alignment point is at the intersection of the end-edge of the element\nand the 'text-after-edge' baseline of the element."}},

    'drop-initial-before-adjust':
{'description': "The 'drop-initial-before-adjust' property\nsets the alignment point of the drop initial for the secondary connection point.\nThis property is only effective is the value of the 'drop-initial-size' property is 'auto'. Possible\nvalues: 6. Properties index",
        'values': {'<length>': "The alignment-point is on the end-edge of the inline box. Its position\nalong the end-edge is offset from the text-before-edge by the <length>\nvalue. A value of '0cm' makes the text-before-edge the alignment point.",
                          '<percentage>': "The computed value of the property is this percentage multiplied by the\ncomputed 'line-height' of the element. The alignment point is on the end-edge\nof the inline box and is offset from the text-before-edge by the computed\nvalue. A value of '0%' makes the text-before-edge the alignment point.",
                          'before-edge': "The alignment point is at the intersection of the end-edge of the element\nand the 'before-edge' of the extended inline box of the element. This may include or not the line-height of the element, depending on the line-stacking-strategy.",
                          'central': "The alignment point is at the intersection of the end-edge of the element\nand the 'central' baseline of the element.",
                          'hanging': "The alignment point is at the intersection of the end-edge of the element\nand the 'hanging' baseline of the element.",
                          'mathematical': "The alignment point is at the intersection of the end-edge of the element\nand the 'mathematical' baseline of the element.",
                          'middle': "The alignment point is at the intersection of the end-edge of the element\nand the 'middle' baseline of the element.",
                          'text-before-edge': "The alignment point is at the intersection of the end-edge of the element\nand the 'text-before-edge' baseline of the element."}},

    'drop-initial-before-align':
{'description': "The 'drop-initial-before-align' property\ndetermines which alignment line within the initial line box is used at\nthe secondary connection point with the initial letter box. This property is\nonly effective is the value of the 'drop-initial-size' property is 'auto'. Possible\nvalues: Name: drop-initial-before-adjust Value: before-edge | text-before-edge | central | middle | hanging |\nmathematical | <percentage> | <length> Initial: text-before-edge Applies to: ::first-letter pseudo element Inherited: no Percentages: refer to combined line height size as provided by drop-initial-value Media: visual Computed value: specified values (except for initial and inherit)",
        'values': {'<alignment-baseline>': "The values are the same as the 'alignment-baseline' property values.",
                          'caps-height': 'The caps-height alignment line is used.'}},

    'drop-initial-size':
{'description': "The 'drop-initial-size' property controls the partial\nsinking of the initial letter. Using any other value than 'auto' removes the\nsecondary connection line constraint. Possible values: 5.4. Aligning drop initial: the 'drop-initial-before-align', 'drop-initial-before-adjust', 'drop-initial-after-align'and'drop-initial-after-adjust' properties Name: drop-initial-after-align Value: <'alignment-baseline'> Initial: baseline Applies to: ::first-letter pseudo element Inherited: no Percentages: N/A Media: visual Computed value: specified values (except for initial and inherit)",
        'values': {'<length>': 'The drop initial letter is sized using the length value.',
                          '<line>': 'The drop initial letter is sized using the combined line height of the nth\nlines (as determined by the line value). The letter may be stretched on one\ndimension if the line height of each line is variable to avoid circular\nissues.',
                          '<percentage>': "The drop initial letter is sized relatively to the combined line height of\nthe n lines determined by the 'drop-initial-value' property value.",
                          'auto': 'The drop initial letter is sized according to the constraints created by the\nthe ink filling strategy and the two connection lines.'}},

    'drop-initial-value':
{'description': "The 'drop-initial-value' property is the basic\nproperty that activates a drop-initial effect. By providing a value different than\n'initial or '1', the primary connection point is moved after the initial line.\nPossible values: Name: drop-initial-size Value: auto | <line> | <length> | <percentage> Initial: auto Applies to: ::first-letter pseudo element Inherited: no Percentages: refer to combined line height size as provided by drop-initial-value Media: visual Computed value: specified values (except for initial and inherit)",
        'values': {'<integer>': 'The drop initial letter is sunken to the nth line (as determined by the\ninteger value).',
                          'initial': 'The drop initial letter is aligned on the initial line'}},

    'fit':
{'description': "The 'fit' property gives a hint for how to scale a replaced element if neither its 'width' nor its 'height' property is 'auto'. Not all replaced objects can be scaled, but images typically can.",
        'values': {'fill': "Scale the object's height and width independently so that the content just touches all edges of the containing box.",
                          'hidden': 'Do not scale the object.',
                          'meet': "Make the object as large as possible with its width <= 'width' and height <= 'height', while preserving its aspect ratio. Position the object as for the 'hidden' value.",
                          'slice': "Make the object as small as possible with its width >= 'width' and height >= 'height', while preserving its aspect ratio. Position the object as for the 'hidden' value."}},

    'fit-position':
{'description': "The 'fit' property gives a hint for how to scale a replaced element if neither its 'width' nor its 'height' property is 'auto'. Not all replaced objects can be scaled, but images typically can.",
        'values': {'fill': "Scale the object's height and width independently so that the content just touches all edges of the containing box.",
                          'hidden': 'Do not scale the object.',
                          'meet': "Make the object as large as possible with its width <= 'width' and height <= 'height', while preserving its aspect ratio. Position the object as for the 'hidden' value.",
                          'slice': "Make the object as small as possible with its width >= 'width' and height >= 'height', while preserving its aspect ratio. Position the object as for the 'hidden' value."}},

    'float-offset':
{'description': 'This property pushes floated elements in the opposite direction of the where they have been floated with \'float\'. If one value is specified, it is the horizontal offset. If two values are specified, the first is the horizontal and the second is the vertical offset. If an element has only been floated horizontally (e.g., by setting \' float: right \'), this property will only offset the float horizontally, even if a vertical value also has been specified. Likewise, if an element has only been floated vertically, this property will only offset the float vertically. If an element has been floated both horizontally and vertically, this property will offset both horizontally and vertically. If no vertical value has been specified, the vertical offset is set to zero. If the \'gr\' unit or percentage unit is used, it means that the middle of the float should be aligned with the specified grid line (or portion thereof). If another unit is used, it means that the float is pushed a distance equal to the specified length.\'float-offset\' is a good concept for moving a float into the right position. For completeness it should apply to absolute positioning as well. We should reuse existing naming conventions already in place for abspos elements (e.g., \'offset-left, \'right\', or call it \' shift left, \'shift right\' etc.). This code serves as the base document for the examples of this section: <html>\n<style>\ndiv { column-width: 15em; column-gap: 2em; /* shown in red below */ column-rule: thin solid black; /* shown in black below */ padding: 1em; /* shown in blue below */\n}\nimg { display: block; /* shown in dark gray below */\n}\n</style>\n<body>\n<div>\nLorem ipsum dolor sit amet. Nam at jus.\n<img src="foo"/>\nSed imp er di et ris. Cur abi tur et sapen.\n...\n</div>\n</body>\n</html> This code can be rendered as: Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Vivamus a metus. Aenean at risus pharetra ante luctu feugiat quis enim. Cum sociis natoque penatibus et magni. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Vivamus a metus. Aenean at risus pharetra ante luctu feugiat quis enim. Cum sociis natoque penatibus et magni. If this code is added to the base document: img { float: right } it may be rendered as: Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Fusce sed ligula a turpis. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Vivamus a metus. Aenean at risus pharetra ante luctu feugiat quis enim. Cum sociis natoque penatibus et magni. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Vivamus a metus. Aenean at risus pharetra ante luctu feugiat quis enim. Cum sociis natoque penatibus et magni. This code floats images to the bottom of their containing block and sets the width to be that of the column: img { float: bottom; width: 1gr;\n} The column box is the containing block for floats, so if an image naturally appears in the first column it will float to its bottom: Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Vivamus a metus. Aenean at risus pharetra ante luctu feugiat quis enim. Cum sociis natoque penatibus et magni. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Vivamus a metus. Aenean at risus pharetra ante luctu feugiat quis enim. Cum sociis natoque penatibus et magni. This code floats figures to the top of the multi-column element. div.figure { float: top right multicol; width: 1gr } The \'1gr\' value on \'width\' is equal to the width of the containing block. Here is a possible rendering: Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Vivamus a metus. Aenean at risus pharetra ante luctu feugiat quis enim. Cum sociis natoque penatibus et magni. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Vivamus a metus. Aenean at risus pharetra ante luctu feugiat quis enim. Cum sociis natoque penatibus et magni. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. In this code, the \'float\' property floats the element to the top left of the multi-column element, while the \'float-offset\' property pushes it to the right so that it ends up in the column next to it: div.quote { float: top left multicol; float-offset: 2.5gr; width: 1gr } Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Vivamus a metus. Aenean at risus pharetra ante luctu feugiat quis enim. Cum sociis natoque penatibus et magni. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Vivamus a metus. Aenean at risus pharetra ante luctu feugiat quis enim. Cum sociis natoque penatibus et magni. Assuming a three-column layout, the same rendering can be achieved by floating the element to the right instead: div.quote { float: top right multicol; float-offset: 2gr; width: 1gr }This code serves as the base document for the examples of this section: <html>\n<style>\ndiv { column-width: 15em; column-gap: 2em; /* shown in red below */ column-rule: thin solid black; /* shown in black below */ padding: 1em; /* shown in blue below */\n}\nimg { display: block; /* shown in dark gray below */\n}\n</style>\n<body>\n<div>\nLorem ipsum dolor sit amet. Nam at jus.\n<img src="foo"/>\nSed imp er di et ris. Cur abi tur et sapen.\n...\n</div>\n</body>\n</html>This code can be rendered as: Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Vivamus a metus. Aenean at risus pharetra ante luctu feugiat quis enim. Cum sociis natoque penatibus et magni. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Vivamus a metus. Aenean at risus pharetra ante luctu feugiat quis enim. Cum sociis natoque penatibus et magni. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Vivamus a metus. Aenean at risus pharetra ante luctu feugiat quis enim. Cum sociis natoque penatibus et magni. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Vivamus a metus. Aenean at risus pharetra ante luctu feugiat quis enim. Cum sociis natoque penatibus et magni. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Vivamus a metus. Aenean at risus pharetra ante luctu feugiat quis enim. Cum sociis natoque penatibus et magni. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Vivamus a metus. Aenean at risus pharetra ante luctu feugiat quis enim. Cum sociis natoque penatibus et magni. If this code is added to the base document: img { float: right }it may be rendered as: Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Fusce sed ligula a turpis. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Vivamus a metus. Aenean at risus pharetra ante luctu feugiat quis enim. Cum sociis natoque penatibus et magni. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Vivamus a metus. Aenean at risus pharetra ante luctu feugiat quis enim. Cum sociis natoque penatibus et magni. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Fusce sed ligula a turpis. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Vivamus a metus. Aenean at risus pharetra ante luctu feugiat quis enim. Cum sociis natoque penatibus et magni. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Vivamus a metus. Aenean at risus pharetra ante luctu feugiat quis enim. Cum sociis natoque penatibus et magni. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Vivamus a metus. Aenean at risus pharetra ante luctu feugiat quis enim. Cum sociis natoque penatibus et magni. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Vivamus a metus. Aenean at risus pharetra ante luctu feugiat quis enim. Cum sociis natoque penatibus et magni. This code floats images to the bottom of their containing block and sets the width to be that of the column: img { float: bottom; width: 1gr;\n}The column box is the containing block for floats, so if an image naturally appears in the first column it will float to its bottom: Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Vivamus a metus. Aenean at risus pharetra ante luctu feugiat quis enim. Cum sociis natoque penatibus et magni. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Vivamus a metus. Aenean at risus pharetra ante luctu feugiat quis enim. Cum sociis natoque penatibus et magni. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Vivamus a metus. Aenean at risus pharetra ante luctu feugiat quis enim. Cum sociis natoque penatibus et magni. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Vivamus a metus. Aenean at risus pharetra ante luctu feugiat quis enim. Cum sociis natoque penatibus et magni. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Vivamus a metus. Aenean at risus pharetra ante luctu feugiat quis enim. Cum sociis natoque penatibus et magni. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Vivamus a metus. Aenean at risus pharetra ante luctu feugiat quis enim. Cum sociis natoque penatibus et magni. This code floats figures to the top of the multi-column element. div.figure { float: top right multicol; width: 1gr }The \'1gr\' value on \'width\' is equal to the width of the containing block. Here is a possible rendering: Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Vivamus a metus. Aenean at risus pharetra ante luctu feugiat quis enim. Cum sociis natoque penatibus et magni. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Vivamus a metus. Aenean at risus pharetra ante luctu feugiat quis enim. Cum sociis natoque penatibus et magni. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Vivamus a metus. Aenean at risus pharetra ante luctu feugiat quis enim. Cum sociis natoque penatibus et magni. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Vivamus a metus. Aenean at risus pharetra ante luctu feugiat quis enim. Cum sociis natoque penatibus et magni. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Vivamus a metus. Aenean at risus pharetra ante luctu feugiat quis enim. Cum sociis natoque penatibus et magni. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. In this code, the \'float\' property floats the element to the top left of the multi-column element, while the \'float-offset\' property pushes it to the right so that it ends up in the column next to it: div.quote { float: top left multicol; float-offset: 2.5gr; width: 1gr } Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Vivamus a metus. Aenean at risus pharetra ante luctu feugiat quis enim. Cum sociis natoque penatibus et magni. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Vivamus a metus. Aenean at risus pharetra ante luctu feugiat quis enim. Cum sociis natoque penatibus et magni. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Vivamus a metus. Aenean at risus pharetra ante luctu feugiat quis enim. Cum sociis natoque penatibus et magni. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Vivamus a metus. Aenean at risus pharetra ante luctu feugiat quis enim. Cum sociis natoque penatibus et magni. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Vivamus a metus. Aenean at risus pharetra ante luctu feugiat quis enim. Cum sociis natoque penatibus et magni. Assuming a three-column layout, the same rendering can be achieved by floating the element to the right instead: div.quote { float: top right multicol; float-offset: 2gr; width: 1gr }The floated element will never be pushed outside the content edges of the multicol element due to \'float-offset\'. img { float: top right multicol; width: 3gr;\n} The code above floats the element to the top right of the multi-column element. Further, it sets the width of images to the width of two columns plus the gap between them. Here is a possible rendering. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Vivamus a metus. Aenean at risus pharetra ante luctu feugiat quis enim. Cum sociis natoque penatibus et magni. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. img { float: top right multicol; width: 2gr;\n} The code above floats the element to the top right of the multi-column element. Further, it sets the width of the image to the width of one column plus one column gap. Here is a possible rendering. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Vivamus a metus. Aenean at risus pharetra ante luctu feugiat quis enim. Cum sociis natoque penatibus et magni. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Vivamus a metus. Aenean at risus pharetra ante luctu feugiat quis enim. Cum sociis natoque penatibus et magni. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. img { float: top right multicol; width: 1.5gr;\n} The code above floats the element to the top right of the multi-column element. Further, it sets the width of the image to the width of one column plus half the column gap. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Vivamus a metus. Aenean at risus pharetra ante luctu feugiat quis enim. Cum sociis natoque penatibus et magni. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Vivamus a metus. Aenean at risus pharetra ante luctu feugiat quis enim. Cum sociis natoque penatibus et magni. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. img { float: top left multicol; float-offset: 1.5gr 50%; width: 8em;\n} The first rule in the code above floats images to the top left of the multi-column element. The second rule pushes the float in the opposite directions: to the right and downwards. The horizontal component (\' 1.5gr \') means that the horizontal middle of the element should be in the middle of the gap between the left-most column and the one next to it. Vertically, element should be in the middle of the column. Here is a possible rendering: Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Fusce sed ligula a turpis. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Fusce sed ligula a turpis. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Vivamus a metus. Aenean at risus pharetra ante luctu feugiat quis enim. Cum sociis natoque penatibus et magni. Consider this code: img { float: top left multicol; float-offset: 1.25gr 50%; width: 6em;\n} The only difference between this and the previous example is the horizontal value on \'float-offset\'. The value \' 1.25gr \' means that a point 25% into the image in the inline direction will be aligned with a point 25% into the column gap. Here is a possible rendering: Lorem ipsum dolor sit amet. Nam at jus. Sed imper di et ris. Cur abi tur et sapen. Fusce sed ligula a sic turpis. Lorem ipsum dolor sit amet. Namat jus. Sed imper di et ris curit. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Fusce sed ligula a turpis. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Vivamus a metus. Aenean at risus pharetra ante luctu feugiat quis enim. Cum sociis natoque penatibus et magni. 15. Conformance User agents that support hyphenation and support this specification must a 16. Appendix A: Default style sheetThe code above floats the element to the top right of the multi-column element. Further, it sets the width of images to the width of two columns plus the gap between them. Here is a possible rendering. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Vivamus a metus. Aenean at risus pharetra ante luctu feugiat quis enim. Cum sociis natoque penatibus et magni. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Vivamus a metus. Aenean at risus pharetra ante luctu feugiat quis enim. Cum sociis natoque penatibus et magni. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. The code above floats the element to the top right of the multi-column element. Further, it sets the width of the image to the width of one column plus one column gap. Here is a possible rendering. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Vivamus a metus. Aenean at risus pharetra ante luctu feugiat quis enim. Cum sociis natoque penatibus et magni. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Vivamus a metus. Aenean at risus pharetra ante luctu feugiat quis enim. Cum sociis natoque penatibus et magni. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Vivamus a metus. Aenean at risus pharetra ante luctu feugiat quis enim. Cum sociis natoque penatibus et magni. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Vivamus a metus. Aenean at risus pharetra ante luctu feugiat quis enim. Cum sociis natoque penatibus et magni. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Vivamus a metus. Aenean at risus pharetra ante luctu feugiat quis enim. Cum sociis natoque penatibus et magni. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. The code above floats the element to the top right of the multi-column element. Further, it sets the width of the image to the width of one column plus half the column gap. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Vivamus a metus. Aenean at risus pharetra ante luctu feugiat quis enim. Cum sociis natoque penatibus et magni. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Vivamus a metus. Aenean at risus pharetra ante luctu feugiat quis enim. Cum sociis natoque penatibus et magni. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Vivamus a metus. Aenean at risus pharetra ante luctu feugiat quis enim. Cum sociis natoque penatibus et magni. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Vivamus a metus. Aenean at risus pharetra ante luctu feugiat quis enim. Cum sociis natoque penatibus et magni. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Vivamus a metus. Aenean at risus pharetra ante luctu feugiat quis enim. Cum sociis natoque penatibus et magni. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. The first rule in the code above floats images to the top left of the multi-column element. The second rule pushes the float in the opposite directions: to the right and downwards. The horizontal component (\' 1.5gr \') means that the horizontal middle of the element should be in the middle of the gap between the left-most column and the one next to it. Vertically, element should be in the middle of the column. Here is a possible rendering: Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Fusce sed ligula a turpis. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Fusce sed ligula a turpis. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Vivamus a metus. Aenean at risus pharetra ante luctu feugiat quis enim. Cum sociis natoque penatibus et magni. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Fusce sed ligula a turpis. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Fusce sed ligula a turpis. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Vivamus a metus. Aenean at risus pharetra ante luctu feugiat quis enim. Cum sociis natoque penatibus et magni. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Fusce sed ligula a turpis. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Vivamus a metus. Aenean at risus pharetra ante luctu feugiat quis enim. Cum sociis natoque penatibus et magni. Consider this code: img { float: top left multicol; float-offset: 1.25gr 50%; width: 6em;\n}The only difference between this and the previous example is the horizontal value on \'float-offset\'. The value \' 1.25gr \' means that a point 25% into the image in the inline direction will be aligned with a point 25% into the column gap. Here is a possible rendering: Lorem ipsum dolor sit amet. Nam at jus. Sed imper di et ris. Cur abi tur et sapen. Fusce sed ligula a sic turpis. Lorem ipsum dolor sit amet. Namat jus. Sed imper di et ris curit. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Fusce sed ligula a turpis. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Vivamus a metus. Aenean at risus pharetra ante luctu feugiat quis enim. Cum sociis natoque penatibus et magni. Lorem ipsum dolor sit amet. Nam at jus. Sed imper di et ris. Cur abi tur et sapen. Fusce sed ligula a sic turpis. Lorem ipsum dolor sit amet. Namat jus. Sed imper di et ris curit. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Fusce sed ligula a turpis. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Vivamus a metus. Aenean at risus pharetra ante luctu feugiat quis enim. Cum sociis natoque penatibus et magni. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Fusce sed ligula a turpis. Lorem ipsum dolor sit amet. Nam at jus. Sed imp er di et ris. Cur abi tur et sapen. Vivamus a metus. Aenean at risus pharetra ante luctu feugiat quis enim. Cum sociis natoque penatibus et magni.',
        'values': {}},

    'font-size-adjust':
{'description': 'For any given font size, the apparent size and legibility of text varies across fonts. For scripts such as Latin or Cyrillic that distinguish between upper and lowercase letters, the relative height of lowercase letters compared to their uppercase counterparts is a determining factor of legibility. This is commonly referred to as the aspect value. Precisely defined, it is equal to the x-height of a font divided by the font size. In situations where font fallback occurs, fallback fonts may not share the same aspect ratio as the desired font family and will thus appear less readable. The font-size-adjust property is a way to preserve the readability of text when font fallback occurs. It does this by adjusting the font-size so that the x-height is the same irregardless of the font used. The style defined below defines Verdana as the desired font family, but if Verdana is not available Futura or Times will be used. p { font-family: Verdana, Futura, Times; } <p>Lorem ipsum dolor sit amet,...</p> Verdana has a relatively high aspect ratio, lowercase letters are relatively tall compared to uppercase letters, so at small sizes text appears legible. Times has a lower aspect ratio and so if fallback occurs, the text will be less legible at small sizes than Verdana. The style defined below defines Verdana as the desired font family, but if Verdana is not available Futura or Times will be used. Verdana has a relatively high aspect ratio, lowercase letters are relatively tall compared to uppercase letters, so at small sizes text appears legible. Times has a lower aspect ratio and so if fallback occurs, the text will be less legible at small sizes than Verdana. How text rendered in each of these fonts compares is shown below, the columns show text rendered in Verdana, Futura and Times. The same font-size value is used across cells within each row and red lines are included to show the differences in x-height. In the upper half each row is rendered in the same font-size value. The same is true for the lower half but in this half the font-size-adjust property is also set so that the actual font size is adjusted to perserve the x-height across each row. Note how small text remains relatively legible across each row in the lower half. Text with and without the use of font-size-adjustText with and without the use of font-size-adjustThis property allows authors to specify an aspect value for an element that will effectively preserve the x-height of the first choice font, whether it is substituted or not. Values have the following meanings:',
        'values': {'<number>': "Specifies the aspect value used in the calculation below to calculate the adjusted font size: c = ( a / a' ) s where: s = font-size value\na = aspect value as specified by the font-size-adjust property\na' = aspect value of actual font\nc = adjusted font-size to use This value applies to any font that is selected but in typical usage it should be based on the aspect value of the first font in the font-family list. If this is specified accurately, the (a/a') term in the formula above is effectively 1 for the first font and no adjustment occurs. If the value is specified inaccurately, text rendered using the first font in the family list will display differently in older user agents that don't support font-size-adjust.",
                          'none': "Do not preserve the font's x-height."}},

    'font-stretch':
{'description': "Sets a normal, condensed, or expanded face from a font family. When a face does not exist for a given width, normal or condensed values map to a narrower face, otherwise a wider face. Conversely, expanded values map to a wider face, otherwise a narrower face.",
        'values': {'ultra-condensed': 'Specifies a font face that is the most condensed from normal.',
                          'extra-condensed': 'Specifies a font face that is very condensed from normal.',
                          'condensed': 'Specifies a font face that is the condensed from normal.',
                          'semi-condensed': 'Specifies a font face that is slighly more condensed from normal.',
                          'semi-expanded': 'Specifies a font face that is slighly more expanded from normal.',
                          'expanded': 'Specifies a font face that is the expanded from normal.',
                          'extra-expanded': 'Specifies a font face that is very expanded from normal.',
                          'ultra-expanded': 'Specifies a font face that is the most expanded from normal.',
                          'narrower': 'Specifies a font face that is more condensed than normal.',
                          'wider': 'Specifies a font face that is more expanded than normal.'}},

    'grid-columns':
{'description': 'Space for each column or row of the grid can be defined as Length. Note that gr unit can also be used here (it refers to grid of the containing block) Percentage of containing block height and width Relative length (as defined in multi-length type in [HTML401] {{!HTML401}} ): A relative length has the form "i*", where "i" is an integer. When allotting space among elements competing for that space, user agents allot pixel and percentage lengths first, then divide up remaining available space among relative lengths. Each relative length receives a portion of the available space that is proportional to the integer preceding the "*". The value "*" is equivalent to "1*". Thus, if 60 pixels of space are available after the user agent allots pixel and percentage space, and the competing relative lengths are 1*, 2*, and 3*, the 1* will be allotted 10 pixels, the 2* will be allotted 20 pixels, and the 3* will be allotted 30 pixels. This definition is taken directly from HTML4.01. But it doesn\'t have to be exactly same. The number doesn\'t have to be integer. And maybe the number should be required for consistency with other units. A relative length has the form "i*", where "i" is an integer. When allotting space among elements competing for that space, user agents allot pixel and percentage lengths first, then divide up remaining available space among relative lengths. Each relative length receives a portion of the available space that is proportional to the integer preceding the "*". The value "*" is equivalent to "1*". Thus, if 60 pixels of space are available after the user agent allots pixel and percentage space, and the competing relative lengths are 1*, 2*, and 3*, the 1* will be allotted 10 pixels, the 2* will be allotted 20 pixels, and the 3* will be allotted 30 pixels. This definition is taken directly from HTML4.01. But it doesn\'t have to be exactly same. The number doesn\'t have to be integer. And maybe the number should be required for consistency with other units. For example this rule div { grid-columns: 50% * * 4em } adds one grid line in the middle of containing block, another one 4em from the right another one in the middle of remaining spaceAlso, grid lines can be defined in repeating groups. A group is enclosed in parentheses and optionally specifies a maximum number of repetitions in square brackets. Nested repeating groups are not allowed. For example this rule div { grid-rows: 4em (0.25em 1em); } defines a header row of 4em adds as many additional rows as necessary, alternating heights of 0.25em and 1em. For another example this rule div { grid-columns: * (1em *)[2]; }defines 3 columns of equal widths with 1em gaps, which matches a multi-column layout defined as div { column-count: 3; }(assuming 1em is the default value of column gap). 4.2. Natural grid',
        'values': {}},

    'grid-rows':
{'description': 'Space for each column or row of the grid can be defined as Length. Note that gr unit can also be used here (it refers to grid of the containing block) Percentage of containing block height and width Relative length (as defined in multi-length type in [HTML401] {{!HTML401}} ): A relative length has the form "i*", where "i" is an integer. When allotting space among elements competing for that space, user agents allot pixel and percentage lengths first, then divide up remaining available space among relative lengths. Each relative length receives a portion of the available space that is proportional to the integer preceding the "*". The value "*" is equivalent to "1*". Thus, if 60 pixels of space are available after the user agent allots pixel and percentage space, and the competing relative lengths are 1*, 2*, and 3*, the 1* will be allotted 10 pixels, the 2* will be allotted 20 pixels, and the 3* will be allotted 30 pixels. This definition is taken directly from HTML4.01. But it doesn\'t have to be exactly same. The number doesn\'t have to be integer. And maybe the number should be required for consistency with other units. A relative length has the form "i*", where "i" is an integer. When allotting space among elements competing for that space, user agents allot pixel and percentage lengths first, then divide up remaining available space among relative lengths. Each relative length receives a portion of the available space that is proportional to the integer preceding the "*". The value "*" is equivalent to "1*". Thus, if 60 pixels of space are available after the user agent allots pixel and percentage space, and the competing relative lengths are 1*, 2*, and 3*, the 1* will be allotted 10 pixels, the 2* will be allotted 20 pixels, and the 3* will be allotted 30 pixels. This definition is taken directly from HTML4.01. But it doesn\'t have to be exactly same. The number doesn\'t have to be integer. And maybe the number should be required for consistency with other units. For example this rule div { grid-columns: 50% * * 4em } adds one grid line in the middle of containing block, another one 4em from the right another one in the middle of remaining spaceAlso, grid lines can be defined in repeating groups. A group is enclosed in parentheses and optionally specifies a maximum number of repetitions in square brackets. Nested repeating groups are not allowed. For example this rule div { grid-rows: 4em (0.25em 1em); } defines a header row of 4em adds as many additional rows as necessary, alternating heights of 0.25em and 1em. For another example this rule div { grid-columns: * (1em *)[2]; }defines 3 columns of equal widths with 1em gaps, which matches a multi-column layout defined as div { column-count: 3; }(assuming 1em is the default value of column gap). 4.2. Natural grid',
        'values': {}},

    'hanging-punctuation':
{'description': 'This property determines whether a punctuation mark, if one is present, may be placed outside the line box at the start or at the end of a full line of text. If a justified line can fit the punctuation will it expand to push it outside the content area? No. What if the line ends in multiple punctuation marks? Which punctuation marks are affected? Values have the following meanings:',
        'values': {'end': 'Punctuation may hang outside the end edge of the last line.',
                          'end-edge': 'Punctuation may hang outside the end edge of all lines.',
                          'start': 'Punctuation may hang outside the start edge of the first line.'}},

    'hyphenate-after':
{'description': 'This property specifies the minimum number of characters in a hyphenated word after the hyphenation character. The \'auto\' value means that the UA chooses a value that adapts to the current layout. Unless the UA is able to calculate a better value, it is suggested that \'auto\' means 2. Name: hyphenate-lines Value: no-limit | <integer> Initial: no-limit Applies to: all elements Inherited: yes Percentages: N/A Media: visual Computed value: specified valueThis property indicates the maximum number of successive hyphenated lines in an element. In some cases, user agents may not be able to honor the specified value. The \'no-limit\' value means that there is no limit. Name: hyphenate-character Value: auto | <string> Initial: auto Applies to: all elements Inherited: yes Percentages: N/A Media: visual Computed value: specified valueThis property specifies a string that is shown when a hyphenate-break occurs. The \'auto\' value means that the user agent should find an appropriate value. <p class=issue>Which character is it, "minus hyphen" or U+2010? In Latin scripts, the hyphen character (U+2010) is often used to indicate that a word has been split. Normally, it will not be necessary to set it explicitly. However, this can easily be done: article { hyphenate-character: "\\2010" } <p class=issue>XSL uses a different list of <a href="http://www.w3.org/TR/2006/CR-xsl11-20060220/#common-hyphenation-properties">properties</a>. Reuse of these properties has been considered. 7. New counter styles 7.1. The \'super-decimal\' list-style-typeIn Latin scripts, the hyphen character (U+2010) is often used to indicate that a word has been split. Normally, it will not be necessary to set it explicitly. However, this can easily be done: article { hyphenate-character: "\\2010" }',
        'values': {}},

    'hyphenate-before':
{'description': 'This property specifies the minimum number of characters in a hyphenated word before the hyphenation character. The \'auto\' value means that the UA chooses a value that adapts to the current layout. Unless the UA is able to calculate a better value, it is suggested that \'auto\' means 2. Name: hyphenate-after Value: <integer> | auto Initial: auto Applies to: all elements Inherited: yes Percentages: N/A Media: visual Computed value: specified valueThis property specifies the minimum number of characters in a hyphenated word after the hyphenation character. The \'auto\' value means that the UA chooses a value that adapts to the current layout. Unless the UA is able to calculate a better value, it is suggested that \'auto\' means 2. Name: hyphenate-lines Value: no-limit | <integer> Initial: no-limit Applies to: all elements Inherited: yes Percentages: N/A Media: visual Computed value: specified valueThis property indicates the maximum number of successive hyphenated lines in an element. In some cases, user agents may not be able to honor the specified value. The \'no-limit\' value means that there is no limit. Name: hyphenate-character Value: auto | <string> Initial: auto Applies to: all elements Inherited: yes Percentages: N/A Media: visual Computed value: specified valueThis property specifies a string that is shown when a hyphenate-break occurs. The \'auto\' value means that the user agent should find an appropriate value. <p class=issue>Which character is it, "minus hyphen" or U+2010? In Latin scripts, the hyphen character (U+2010) is often used to indicate that a word has been split. Normally, it will not be necessary to set it explicitly. However, this can easily be done: article { hyphenate-character: "\\2010" } <p class=issue>XSL uses a different list of <a href="http://www.w3.org/TR/2006/CR-xsl11-20060220/#common-hyphenation-properties">properties</a>. Reuse of these properties has been considered. 7. New counter styles 7.1. The \'super-decimal\' list-style-typeIn Latin scripts, the hyphen character (U+2010) is often used to indicate that a word has been split. Normally, it will not be necessary to set it explicitly. However, this can easily be done: article { hyphenate-character: "\\2010" }',
        'values': {}},

    'hyphenate-character':
{'description': 'This property specifies a string that is shown when a hyphenate-break occurs. The \'auto\' value means that the user agent should find an appropriate value. <p class=issue>Which character is it, "minus hyphen" or U+2010? In Latin scripts, the hyphen character (U+2010) is often used to indicate that a word has been split. Normally, it will not be necessary to set it explicitly. However, this can easily be done: article { hyphenate-character: "\\2010" } <p class=issue>XSL uses a different list of <a href="http://www.w3.org/TR/2006/CR-xsl11-20060220/#common-hyphenation-properties">properties</a>. Reuse of these properties has been considered. 7. New counter styles 7.1. The \'super-decimal\' list-style-typeIn Latin scripts, the hyphen character (U+2010) is often used to indicate that a word has been split. Normally, it will not be necessary to set it explicitly. However, this can easily be done: article { hyphenate-character: "\\2010" }',
        'values': {}},

    'hyphenate-lines':
{'description': 'This property indicates the maximum number of successive hyphenated lines in an element. In some cases, user agents may not be able to honor the specified value. The \'no-limit\' value means that there is no limit. Name: hyphenate-character Value: auto | <string> Initial: auto Applies to: all elements Inherited: yes Percentages: N/A Media: visual Computed value: specified valueThis property specifies a string that is shown when a hyphenate-break occurs. The \'auto\' value means that the user agent should find an appropriate value. <p class=issue>Which character is it, "minus hyphen" or U+2010? In Latin scripts, the hyphen character (U+2010) is often used to indicate that a word has been split. Normally, it will not be necessary to set it explicitly. However, this can easily be done: article { hyphenate-character: "\\2010" } <p class=issue>XSL uses a different list of <a href="http://www.w3.org/TR/2006/CR-xsl11-20060220/#common-hyphenation-properties">properties</a>. Reuse of these properties has been considered. 7. New counter styles 7.1. The \'super-decimal\' list-style-typeIn Latin scripts, the hyphen character (U+2010) is often used to indicate that a word has been split. Normally, it will not be necessary to set it explicitly. However, this can easily be done: article { hyphenate-character: "\\2010" }',
        'values': {}},

    'hyphenate-resource':
{'description': 'This property specifies a comma-separated list of external resources that can help the UA determine hyphenation points. If more than one resource is specified, the UA should consult each resource until it finds one that is able to determine hyphenation points in a word. The \'none\' value indicates that no external resources are available. In any case, the UA can also use local resources not listed on this property. Often, finding the right hyphenate resource is based on knowing the language of the text. The lang attribute is recommended for encoding the language, and the corresponding selector is used in this example: :lang(dk) { hyphenate-resource: url("hyph_da_DK.dic"), url("hyph_da_NO.dic") } Name: hyphenate-before Value: <integer> | auto Initial: auto Applies to: all elements Inherited: yes Percentages: N/A Media: visual Computed value: specified valueOften, finding the right hyphenate resource is based on knowing the language of the text. The lang attribute is recommended for encoding the language, and the corresponding selector is used in this example: :lang(dk) { hyphenate-resource: url("hyph_da_DK.dic"), url("hyph_da_NO.dic") }This property specifies the minimum number of characters in a hyphenated word before the hyphenation character. The \'auto\' value means that the UA chooses a value that adapts to the current layout. Unless the UA is able to calculate a better value, it is suggested that \'auto\' means 2. Name: hyphenate-after Value: <integer> | auto Initial: auto Applies to: all elements Inherited: yes Percentages: N/A Media: visual Computed value: specified valueThis property specifies the minimum number of characters in a hyphenated word after the hyphenation character. The \'auto\' value means that the UA chooses a value that adapts to the current layout. Unless the UA is able to calculate a better value, it is suggested that \'auto\' means 2. Name: hyphenate-lines Value: no-limit | <integer> Initial: no-limit Applies to: all elements Inherited: yes Percentages: N/A Media: visual Computed value: specified valueThis property indicates the maximum number of successive hyphenated lines in an element. In some cases, user agents may not be able to honor the specified value. The \'no-limit\' value means that there is no limit. Name: hyphenate-character Value: auto | <string> Initial: auto Applies to: all elements Inherited: yes Percentages: N/A Media: visual Computed value: specified valueThis property specifies a string that is shown when a hyphenate-break occurs. The \'auto\' value means that the user agent should find an appropriate value. <p class=issue>Which character is it, "minus hyphen" or U+2010? In Latin scripts, the hyphen character (U+2010) is often used to indicate that a word has been split. Normally, it will not be necessary to set it explicitly. However, this can easily be done: article { hyphenate-character: "\\2010" } <p class=issue>XSL uses a different list of <a href="http://www.w3.org/TR/2006/CR-xsl11-20060220/#common-hyphenation-properties">properties</a>. Reuse of these properties has been considered. 7. New counter styles 7.1. The \'super-decimal\' list-style-typeIn Latin scripts, the hyphen character (U+2010) is often used to indicate that a word has been split. Normally, it will not be necessary to set it explicitly. However, this can easily be done: article { hyphenate-character: "\\2010" }',
        'values': {}},

    'hyphens':
{'description': 'Values are: Name: hyphenate-resource Value: none | <uri> [, <uri> ]* Initial: none Applies to: all elements Inherited: yes Percentages: N/A Media: visual Computed value: specified value',
        'values': {'auto': "Words can be broken at appropriate hyphenation points, as determined by characters inside the word, resources listed in 'hyphenate-resource', or other UA-dependent resources. Characters inside the word take priority over hyphenation points determined by other resources.",
                          'manual': 'Words are only broken at line breaks where there are characters inside the word that suggest line break opportunities. Characters can be explicit or conditional. In Unicode, U+00AD is a conditional "soft hyphen" and U+2010 is an explicit hyphen. Unicode Standard Annex #14 describes the role of soft hyphens in the Unicode Line breaking algorithm. In HTML, represents the soft hyphen character which suggests a line break opportunity. example.',
                          'none': 'Words are not broken at line breaks, even if characters inside the word suggest line break points.'}},

    'icon':
{'description': '',
        'values': {'url(': 'URIs (see [URI], [RFC1738] and [RFC1808] ) provide a way of identifying resources. The\n<uri> value(s) in this property refer to one or more icons in a comma\ndelimited list. The user agent loads the referenced icons one by one until it\nfinds one that it is able to render. This permits the usage of multiple\ndifferent icon formats for various platforms, and various media for that\nmatter.',
                          'auto': 'Use a default generic icon provided by the user agent.'}},

    'image-orientation':
{'description': "'image-orientation' specifies a rotation in the right or clockwise direction that a user agent applies to an image. In terms of the order of transformations, the image is first rotated, then sized, then positioned. Thus height and width properties apply to the rotated rather than the original image dimensions. Two values for the 'image-orientation' property apply to an image:",
        'values': {'<angle>': 'A positive value rotates the image to the right (in a clockwise direction) by the given number of degrees. Negative values rotate to the left or in a counter-clockwise direction. Specified values outside the range of ]-360, 360[ degrees are moduloed by 360 to produce a computed value within that range. User agents MUST support values which compute to 0, 90, 180, and 270 degrees. Support for other values is optional.',
                          'auto': 'The image will be set to the orientation of the page. That is, for a pixelated image consisting of rows and columns of pixels, a row is displayed across the width of the display surface and a column along the height.'}},

    'image-resolution':
{'description': 'Image resolution, as the term is used in this document, means pixels per physical length, e.g., pixels per inch. Some image formats can record information about the resolution of images. This information can be helpful when determining the actual size of the image in the formatting process. However, the information can also be wrong, in which case it should be ignored. The \'image-resolution\' and \'background-image-resolution\' properties are introduced to determine the correct resolution of images. Name: image-resolution Value: normal | [ from-image || <dpi> ] Initial: normal Applies to: replaced elements and background images? Inherited: yes Percentages: N/A Media: visual Computed value: as specified value (or, should it be only one value?)The values are: This rule specifies that the UA should use the image resolution found in the image itself. img { image-resolution: from-image } Using this rule, the image resolution is set to 300dpi and the resolution in the image, if any, is ignored. img { image-resolution: 300dpi } These rules both specify that the UA should use the image resolution found in the image itself. If the image has no resolution, the resolution is set to 300dpi. img { image-resolution: from-image 300dpi }\nimg { image-resolution: 300dpi from-image } <table class=propdef> <tr> <td><em>Name:</em> <td><dfn>image-resolution</dfn> <tr> <td><em>Value:</em> <td>normal | auto | <dpi> [, normal | <dpi> ]? <tr> <td><em>Initial:</em> <td>normal <tr> <td><em>Applies to:</em> <td>replaced elements <tr> <td><em>Inherited:</em> <td>yes <tr> <td><em>Percentages:</em> <td>N/A <tr> <td><em>Media:</em> <td>visual <tr> <td><em>Computed value:</em> <td>as specified value <span class=issue>(or, should it be only one value?)</span>\n</table> <p>This property accepts either a single value, or a comma-separated\nlist of two values. The values are: <dl>\n<dt>normal <dd>The resolution of the image is unknown, and UAs should not use the\nresolution found in the image. Instead, the image resolution will be\nfound by making image pixels equivalent to CSS pixels. <dt>auto <dd>The UA must look for the resolution in the image itself. If the image has no image resolution, the next value in the comma-separated list is evaluated. <dt><dpi> <dd>The value consists of a number with a \'<code class=property>dpi</code>\' unit identifier. The\nUA should use the specified resolution. </dl> <p>If, after evaluating the specified values, no image resolution has been determined, the UA should behave as if \'<code class=css>normal</code>\' had been specified. <div class="example">\n<p>This rule specifies that the UA should use the image resolution found in the image itself.\n<pre>\nimg { image-resolution: auto }\n</pre>\n</div> <div class="example">\n<p>This rule specifies that the UA should use the image resolution found in the image itself. If the image has no resolution, the resolution is set to 300dpi.\n<pre>\nimg { image-resolution: auto, 300dpi }\n</pre>\n</div> <div class="example">\n<p>Using this rule, the image resolution is set to 300dpi and the resolution in the image, if any, is ignored. <pre>\nimg { image-resolution: 300dpi }\n</pre>\n</div> <div class="issue">\n<p>Should there be a way of setting width, height, resolution on images that are referenced by a URL in the style sheet? E.g., <pre>\nbackground-image: url(image.png, width, height, resolution);\nbackground-image: image-url(image.png, width, height, resolution);\nbackground-image: image(url(image.png), width, height, resolution);\n</pre>\n</div> <table class=propdef> <tr> <td><em>Name:</em> <td><dfn>background-image-resolution</dfn> <tr> <td><em>Value:</em> <td>normal | auto | <dpi> [, normal | <dpi> ]? <tr> <td><em>Initial:</em> <td>normal <tr> <td><em>Applies to:</em> <td>replaced elements <tr> <td><em>Inherited:</em> <td>yes <tr> <td><em>Percentages:</em> <td>N/A <tr> <td><em>Media:</em> <td>visual <tr> <td><em>Computed value:</em> <td>as specified value <span class=issue>(or, should it be only one value?)</span>\n</table> <p class=issue>Introducing one new property in all places where an image can be loaded may not be a scalable solution. Therefore this property is at risk. <p>As \'<code class=property>image-resolution</code>\', except that it describes the resolution of the element\'s background image. 9. Page marks and bleed area',
        'values': {'<dpi>': "The value consists of a number with a 'dpi' unit identifier. The <dpi> value sets the resolution of the image. In combination with 'from-image', the specified dpi is only used if the image does not have a resolution.",
                          'from-image': "The UA must look for the resolution in the image itself. If the image does not have a resolution, the specified <dpi> value is used. If no <dpi> value is specified, the behavior is as if 'normal' had been specified.",
                          'normal': 'The resolution of the image is unknown, and UAs should not use the resolution found in the image. Instead, the image resolution will be found by converting the dimension of the image into CSS pixels.'}},

    'inline-box-align':
{'description': "The 'inline-box-align' property determines\nwhich line of a multi-line inline block align with the previous and next\ninline elements within a line. The alignment strategy for the inline lock\nitself (i.e. the definition of it alignment point and which parent baseline\nshould be used for the alignment) is determined by the inline block element\nbaseline alignment properties applicable to the line being used for the\nalignment. This property has no effect for single line inline block. Possible\nvalues: 5. Initial line and Drop initial 5.1. Initial line",
        'values': {'<integer>': 'Use nth line (as determined by the integer value) of the inline block\nelement for alignment purpose.',
                          'initial': 'Use the initial line of the inline block element for alignment purpose.',
                          'last': 'Use the last line of the inline block element for alignment purpose.'}},

    'line-stacking':
{'description': '', 'values': {}},

    'line-stacking-ruby':
{'description': "This property determines the line stacking method for block elements containing ruby annotation elements (element with 'display: ruby-text'or'display: ruby-text-container'). In all cases the ruby base elements (elements with 'display: ruby-base' or display: ruby-base-container') are considered for line stacking. Possible values:",
        'values': {'exclude-ruby': 'The ruby annotation elements are ignored for line stacking.',
                          'include-ruby': 'The ruby annotation elements are considered for line stacking.'}},

    'line-stacking-shift':
{'description': 'This property determines the line stacking method for block elements containing elements with base-shift. Possible values:',
        'values': {'consider-shifts': 'In determining the stack-height, include the adjusted top-edge and bottom-edge of any characters that have a baseline-shift.',
                          'disregard-shifts': 'In determining the stack-height, include the unshifted top-edge and bottom-edge of any characters that have a baseline-shift.'}},

    'line-stacking-strategy':
{'description': "This property determines the line stacking strategy for stacked line boxes within a containing block element. The term 'stack-height' is used in the context of this property description to indicate the block-progression advance for the line boxes. Possible values:",
        'values': {'block-line-height': "The stack-height is determined by the block element 'line-height' property value. The 'line-height' property value is ignored for inline elements. For alignment purpose, this case is similar to the minimum extended block progression dimension case (strut model). This is the only line-stacking strategy that may cause inline boxes within the line to bleed before and after the line box because the line box is not constrained by its inline boxes.",
                          'grid-height': "The stack-height is the smallest multiple of the block element 'line-height' computed value that can contain the block progression of all the inline elements on that line when those elements are properly aligned. The 'line-height' property value is ignored for inline elements.",
                          'inline-line-height': "The stack-height is the smallest value that contains the extended block progression dimension of all the inline elements on that line when those elements are properly aligned. Since the line spacing information is already included in the computation of the line box, these line boxes are simply stacked adjacent to one another in the formatted block to which they belong. The 'line-height' property value is taken into account for both the inline elements and the block elements. For inline elements, it defines the extended block progression dimension. For block elements, it defines the minimum extended block progression dimension.",
                          'max-height': "The stack-height is the smallest value that contains the block progression dimension of all the inline elements on that line when those elements are properly aligned. The 'line-height' property value is taken into account only for the block elements."}},

    'mark':
{'description': "The 'mark' property is a shorthand for setting 'mark-before'\nand 'mark-after'. If two values are given the first value is\n'mark-before' and the second is 'mark-after'. If only one value\nis given, it applies to both properties. The following two rules are equivalent:",
        'values': {}},

    'mark-after':
{'description': 'The mark properties allow named markers to be attached to the\naudio stream. For compatibility with SSML, this must conform to the xsd:token datatype as defined in XML Schema. Synthesis processors must do one\nor both of the following when encountering a mark:The mark properties have no audible effect on the speech\nand instead just serve to mark points in the stream. Values have the following meanings:',
        'values': {'<string>': 'A string to be used as the name of the mark.'}},

    'mark-before':
{'description': 'The mark properties allow named markers to be attached to the\naudio stream. For compatibility with SSML, this must conform to the xsd:token datatype as defined in XML Schema. Synthesis processors must do one\nor both of the following when encountering a mark:The mark properties have no audible effect on the speech\nand instead just serve to mark points in the stream. Values have the following meanings:',
        'values': {'<string>': 'A string to be used as the name of the mark.'}},

    'marquee-direction':
{'description': 'This property determines the initial direction in which the content moves if the marquee effect is used. \'Forward\' moves the text so that hidden text appears in the normal reading order, \'reverse\' does the opposite. The actual direction therefore depends on \'direction\' and \'overflow-style\' of the element, as follows: \'overflow-style\' \'direction\' \'forward\' \'reverse\' \'marquee-line\' \'ltr\' left right \'rtl\' right left \'marquee-block\' up downNote that \' marquee-style: alternate \' moves content in the opposite direction from this table on every other loop. Note that the \'direction\' property is often set by rules in the UA style sheet based on mark-up in the document, as recommended in CSS 2.1 [CSS21] {{!CSS21}} section 9.10 ("Text direction: the direction and unicode-bidi properties"). 9. The \'marquee-speed\' property Name: marquee-speed Value: slow | normal | fast Initial: normal Applies to: same as \'overflow\' Inherited: no Percentages: N/A Media: visual Computed value: as specified',
        'values': {}},

    'marquee-play-count':
{'description': "This property specifies how many times the content moves. UAs should restart the loop count every time the element turns from completely invisible into (fully or partially) visible. E.g., an element that is outside the viewport starts moving when it is scrolled into view. A UA may also take the visibility of the UA viewport itself into account, e.g., if the element is hidden behind a pop-up window or if the UA is iconified. If 'marquee-play-count' is different for different states of the element, e.g., ' p {marquee-play-count: 0} p:hover {marquee-play-count: infinite} ', the loop counter must be reset each time the element enters a state with a different computed value. For example, if the content of an li overflows under the following style rules, the content moves once when the li gets the focus or is hovered over. But, when it already has the focus when it is hovered over, the 'marquee-play-count' property doesn't change and thus the content doesn't move again: li {overflow: auto; overflow-style: marquee; marquee-play-count: 0}\nli:focus, li:hover {marquee-play-count: 1}For example, if the content of an li overflows under the following style rules, the content moves once when the li gets the focus or is hovered over. But, when it already has the focus when it is hovered over, the 'marquee-play-count' property doesn't change and thus the content doesn't move again: li {overflow: auto; overflow-style: marquee; marquee-play-count: 0}\nli:focus, li:hover {marquee-play-count: 1}If the specified value is 'infinite' or greater than 16, the UA may stop after 16 loops. 8. The 'marquee-direction' property Name: marquee-direction Value: forward | reverse Initial: forward Applies to: same as 'overflow' Inherited: yes Percentages: N/A Media: visual Computed value: as specified",
        'values': {}},

    'marquee-speed':
{'description': 'This property determines how fast the content scrolls. The actual speed depends on the UA and the type of content. But, for a given UA and a given element, the following must always be true: slow < normal < fast. 10. Conformance',
        'values': {}},

    'marquee-style':
{'description': "The values are: This figure shows one loop of ' marquee-style: scroll '. The initial state (1) has all content outside the box to the right. (2) shows an intermediate state. And the final state (3) has all content outside the box on the left. This figure shows one loop of ' marquee-style: slide '. The initial state (1) has all content outside the box to the right. (2) shows an intermediate state. And the final state (3) has the right edge of the content just inside the right edge of the box and some content overflowing to the left of the box. This figure show two loops of ' marquee-style: alternate '. The initial state (1) has the left edge of the content aligned to the left edge of the box and content overflowing on the right. (2) shows an intermediate state, while the content moves to the left. The end of the first loop is state (3). (4) is an intermediate state of the second loop. (5) is the end of the second loop and is equal to state (1).",
        'values': {'alternate': "Bounce back and forth. The following pseudo-code defines the behavior when the initial marquee direction is to the left (see 'marquee-direction'). The other directions are analogous. Set the element to clip the overflow to the left and to the right Create an anonymous box B around the content; set its 'width' so as to include all content and all overflow exactly Set r to false Set n to the value of 'marquee-play-count' While n != 0: If r, set 'margin-right' of B to 0 and 'margin-left'to'auto'; else, set 'margin-left' of B to 0 and 'margin-right'to'auto' If r, decrease 'margin-right' at constant speed (see 'marquee-speed') until 'margin-left' is 0; else, decrease 'margin-left' at constant speed until 'margin-right' is 0 Set r to !r (i.e., the next loop will move in the opposite direction) Decrease n by one",
                          'scroll': "Start completely off one side, scroll all the way across and completely off. The following pseudo-code defines the behavior when the marquee direction is to the left (see 'marquee-direction'). The other directions are analogous. Set the element to clip the overflow to the left and to the right Create an anonymous box B around the content; set its 'width' so as to include all content and all overflow exactly; set its 'margin-right'to'auto' Set n to the value of 'marquee-play-count' While n != 0: Set 'margin-left' of B to 100% (i.e., all contents is off to the right and thus invisible) Decrease 'margin-left' at constant speed (see 'marquee-speed') until 'margin-right' is 100% (i.e., all content is off to the left and thus invisible) Decrease n by one",
                          'slide': "Start completely off one side, scroll in, and stop as soon as no more content is off that side. The following pseudo-code defines the behavior when the marquee direction is to the left (see 'marquee-direction'). The other directions are analogous. Set the element to clip the overflow to the left and to the right Create an anonymous box B around the content; set its 'width' so as to include all content and all overflow exactly; set its 'margin-right'to'auto' Set n to the value of 'marquee-play-count' While n != 0: Set 'margin-left' of B to 100% (i.e., all contents is off to the right and thus invisible) Decrease 'margin-left' at constant speed (see 'marquee-speed') until 'margin-right' is 0 Decrease n by one"}},

    'move-to':
{'description': "The 'move-to' property causes the element or pseudo-element to be removed\nfrom the flow and reinserted at a later point in the document. The content is\nreinserted using the 'pending()' XXX link value of the 'content'\nproperty. This property applies to all elements as well as the '::before',\n'::after', and '::alternate' pseudo-elements. The '::alternate'\npseudo-element in fact exists exclusively for the purpose of being moved by\nthis property, e.g. in the creation of footnotes.",
        'values': {'<identifier>': "The element is not displayed at the current location, but at the next\noccurrence of 'pending(<identifier>)' (where the identifiers match),\nwith all other elements moved to that point, in document order. If at the end\naf the document (after the '::after' pseudo-elements of the root element)\nthere are outstanding elements, then they are all inserted in document order\nat that point.",
                          'here': "The element or pseudo-element is not moved. This value inhibits the\ncreation of '::alternate' pseudo-elements and any pseudo-elements that have\nsuch a pseudo-element as a superior.",
                          'normal': "For '::alternate' pseudo-elements, if the superior parent uses the\n'footnote' counter in its 'content' property then the computed value of\n'move-to'is'footnotes'. For '::alternate' pseudo-elements, if the superior parent uses the\n'endnote' counter in its 'content' property then the computed value of\n'move-to'is'endnotes'. For '::alternate' pseudo-elements, if the superior parent uses the\n'section-note' counter in its 'content' property then the computed value of\n'move-to'is'section-notes'. Otherwise the computed value of the move-to property is 'here'."}},

    'nav-down':
{'description': '',
        'values': {'<id>': "The <id> value consists of a ' # ' character followed by\nan identifier, similar to a fragment identifier in a URL. It indicates the\nelement to which the focus is navigated to in response to directional\nnavigation input respective to the specific property. If the <id> refers to the currently focused element, the\ndirectional navigation input respective to the nav- property is ignored\n- there is no need to refocus the same element.",
                          '<target-name>': 'The <target-name> parameter indicates the target frame for the\nfocus navigation. It is a string and it cannot start with the underscore "_"\ncharacter. If the specified target frame does not exist, the parameter will\nbe treated as the keyword \'current\', which means\nto simply use the frame that the element is in. The keyword \'root\' indicates that the user agent should target the\nfull window.',
                          'auto': 'The user agent automatically determines which element to navigate the\nfocus to in response to directional navigational input.'}},

    'nav-index':
{'description': 'The \'nav-index\' property is an input-method-neutral way of specifying the sequential\nnavigation order (also known as "tabbing order"). Name: nav-index Value: auto | <number> | inherit Initial: auto Applies to: all enabled elements Inherited: no Percentages: n/a Media: interactive Computed value: specified value.',
        'values': {'<number>': "The number (which is non-zero and positive) indicates the sequential\nnavigation order for the element. '1' means first.\nElements with the same nav-index value are navigated in document order when\nthat nav-index value is being navigated.",
                          'auto': "The element's sequential navigation order is assigned automatically by\nthe user agent."}},

    'nav-left':
{'description': '',
        'values': {'<id>': "The <id> value consists of a ' # ' character followed by\nan identifier, similar to a fragment identifier in a URL. It indicates the\nelement to which the focus is navigated to in response to directional\nnavigation input respective to the specific property. If the <id> refers to the currently focused element, the\ndirectional navigation input respective to the nav- property is ignored\n- there is no need to refocus the same element.",
                          '<target-name>': 'The <target-name> parameter indicates the target frame for the\nfocus navigation. It is a string and it cannot start with the underscore "_"\ncharacter. If the specified target frame does not exist, the parameter will\nbe treated as the keyword \'current\', which means\nto simply use the frame that the element is in. The keyword \'root\' indicates that the user agent should target the\nfull window.',
                          'auto': 'The user agent automatically determines which element to navigate the\nfocus to in response to directional navigational input.'}},

    'nav-right':
{'description': '',
        'values': {'<id>': "The <id> value consists of a ' # ' character followed by\nan identifier, similar to a fragment identifier in a URL. It indicates the\nelement to which the focus is navigated to in response to directional\nnavigation input respective to the specific property. If the <id> refers to the currently focused element, the\ndirectional navigation input respective to the nav- property is ignored\n- there is no need to refocus the same element.",
                          '<target-name>': 'The <target-name> parameter indicates the target frame for the\nfocus navigation. It is a string and it cannot start with the underscore "_"\ncharacter. If the specified target frame does not exist, the parameter will\nbe treated as the keyword \'current\', which means\nto simply use the frame that the element is in. The keyword \'root\' indicates that the user agent should target the\nfull window.',
                          'auto': 'The user agent automatically determines which element to navigate the\nfocus to in response to directional navigational input.'}},

    'nav-up':
{'description': '',
        'values': {'<id>': "The <id> value consists of a ' # ' character followed by\nan identifier, similar to a fragment identifier in a URL. It indicates the\nelement to which the focus is navigated to in response to directional\nnavigation input respective to the specific property. If the <id> refers to the currently focused element, the\ndirectional navigation input respective to the nav- property is ignored\n- there is no need to refocus the same element.",
                          '<target-name>': 'The <target-name> parameter indicates the target frame for the\nfocus navigation. It is a string and it cannot start with the underscore "_"\ncharacter. If the specified target frame does not exist, the parameter will\nbe treated as the keyword \'current\', which means\nto simply use the frame that the element is in. The keyword \'root\' indicates that the user agent should target the\nfull window.',
                          'auto': 'The user agent automatically determines which element to navigate the\nfocus to in response to directional navigational input.'}},

    'opacity':
{'description': '',
        'values': {'<alphavalue>': 'Syntactically a <number>. The uniform opacity setting to be applied across an entire object. Any values outside the range 0.0 (fully transparent) to 1.0 (fully opaque) will be clamped to this range. If the object is a container element, then the effect is as if the contents of the container element were blended against the current background using a mask where the value of each pixel of the mask is <alphavalue>.'}},

    'outline-offset':
{'description': "If the computed value of 'outline-offset' is anything other than 0,\nthen the outline is outset from the border edge by that amount. Example(s): For example, to leave 2 pixels of space between a focus outline and the\nelement that has the focus, or is active, the following rule can be used: :focus,:active { outline-offset: 2px } 9. ResizingExample(s):For example, to leave 2 pixels of space between a focus outline and the\nelement that has the focus, or is active, the following rule can be used:",
        'values': {}},

    'overflow-style':
{'description': "This property specifies the preferred scrolling method for elements that overflow (see the 'overflow' property.) If the UA does not support the specified value, it must act as if the value was 'auto'. 6. The 'marquee-style' property Name: marquee-style Value: scroll | slide | alternate Initial: scroll Applies to: same as 'overflow' Inherited: no Percentages: N/A Media: visual Computed value: as specified",
        'values': {'auto': 'The UA chooses the scrolling mechanism. Marquees and scrollbars are common mechanisms, but the UA may also use others.',
                          'marquee-block': 'This selects marquee as the vertical scrolling mechanism (i.e., for content that overflows above or below the box). The scrolling mechanism in the perpendicular direction is left to the UA, but should not be marquee.',
                          'marquee-line': 'This selects marquee as the horizontal scrolling mechanism (i.e., for content that overflows to the left or right). The scrolling mechanism in the perpendicular direction is left to the UA, but should not be marquee.'}},

    'overflow-x':
{'description': "These properties specify whether content is clipped when it overflows the element's content area. It affects the clipping of all of the element's content except any descendant elements (and their respective content and descendants) whose containing block is the viewport or an ancestor of the element. 'Overflow-x' determines clipping at the left and right edges, 'overflow-y' at the top and bottom edges.'Overflow' is a shorthand. If it has one keyword, it sets both 'overflow-x'and'overflow-y' to that keyword; if it has two, it sets 'overflow-x' to the first and 'overflow-y' to the second. Keywords have the following meanings:",
        'values': {'auto': "The behavior of the 'auto' value is UA-dependent, but should cause a scrolling mechanism to be provided for overflowing boxes.",
                          'hidden': 'This value indicates that the content is clipped and that no scrolling mechanism should be provided to view the content outside the clipping region.',
                          'no-content': "When the content doesn't fit in the content box, the whole content is hidden, as if ' visibility: hidden ' were specified. [This idea is due to Till Halbach <tillh@opera.com>, July 21, 2005]",
                          'no-display': "When the content doesn't fit in the content box, the whole box is removed, as if ' display: none ' were specified. [This idea is due to Till Halbach <tillh@opera.com>, July 21, 2005]",
                          'scroll': "This value indicates that the content is clipped and that if the user agent uses a scrolling mechanism that is visible on the screen (such as a scroll bar or a panner), that mechanism should be displayed for a box whether or not any of its content is clipped. This avoids any problem with scrollbars appearing and disappearing in a dynamic environment. When this value is specified and the target medium is 'print', overflowing content may be printed.",
                          'visible': 'This value indicates that content is not clipped, i.e., it may be rendered outside the content box.'}},

    'overflow-y':
{'description': "These properties specify whether content is clipped when it overflows the element's content area. It affects the clipping of all of the element's content except any descendant elements (and their respective content and descendants) whose containing block is the viewport or an ancestor of the element. 'Overflow-x' determines clipping at the left and right edges, 'overflow-y' at the top and bottom edges.'Overflow' is a shorthand. If it has one keyword, it sets both 'overflow-x'and'overflow-y' to that keyword; if it has two, it sets 'overflow-x' to the first and 'overflow-y' to the second. Keywords have the following meanings:",
        'values': {'auto': "The behavior of the 'auto' value is UA-dependent, but should cause a scrolling mechanism to be provided for overflowing boxes.",
                          'hidden': 'This value indicates that the content is clipped and that no scrolling mechanism should be provided to view the content outside the clipping region.',
                          'no-content': "When the content doesn't fit in the content box, the whole content is hidden, as if ' visibility: hidden ' were specified. [This idea is due to Till Halbach <tillh@opera.com>, July 21, 2005]",
                          'no-display': "When the content doesn't fit in the content box, the whole box is removed, as if ' display: none ' were specified. [This idea is due to Till Halbach <tillh@opera.com>, July 21, 2005]",
                          'scroll': "This value indicates that the content is clipped and that if the user agent uses a scrolling mechanism that is visible on the screen (such as a scroll bar or a panner), that mechanism should be displayed for a box whether or not any of its content is clipped. This avoids any problem with scrollbars appearing and disappearing in a dynamic environment. When this value is specified and the target medium is 'print', overflowing content may be printed.",
                          'visible': 'This value indicates that content is not clipped, i.e., it may be rendered outside the content box.'}},

    'page-policy':
{'description': "'page-policy' determines which page-based occurance of a given element is\napplied to a counter or string value: The following example places the chapter name in the header, specifying\nthat it is the value of the string at the end of the page. Example: @string chapter { page-policy: last; }\n@page { size: 21.0cm 29.7cm; /* A4 */ @top { text-align: right; vertical-align: center; content: string (chapter); }\n}",
        'values': {'first': 'Takes the value after the first state change in the counter or string\nduring processing of the page.',
                          'last': 'Takes the value following the final state change on the page.',
                          'start': 'Takes the value of the counter or string at the beginning of the page\n(before applying style to the elements of the page, but after applying it to\nthe @page context itself).'}},

    'phonemes':
{'description': 'This allows authors to specify a phonetic pronunciation for the\ntext contained by the corresponding element.',
        'values': {}},

    'presentation-level':
{'description': "This property sets the element's presentation level (EPL). The values have\nthe following meanings:",
        'values': {}},

    'punctuation-trim':
{'description': 'This property determines whether or not a fullwidth punctuation character should be trimmed (kerned) if it appears at the start or end of a line, or adjacent to another fullwidth punctuation character. Values are defined as follows:',
        'values': {'adjacent': 'Trim (kern) the blank half of fullwidth opening punctuation if its previous adjacent character is a fullwidth opening punctuation, fullwidth middle dot punctuation, fullwidth closing punctuation, or ideographic space (U+3000). Trim (kern) the blank half of fullwidth closing punctuation if its next adjacent character is a fullwidth closing punctuation, fullwidth middle dot punctuation, or ideographic space (U+3000).',
                          'end': 'Trim (kern) the blank half of fullwidth closing punctuation at the end of each line.',
                          'none': 'Do not trim or kern the blank half of fullwidth opening or closing punctuation glyphs.',
                          'start': 'Trim (kern) the blank half of fullwidth opening punctuation at the beginning of each line.'}},

    'rendering-intent':
{'description': "This property permits the specification of a color profile rendering\nintent other than the default. The behavior of values other than auto and inherit are defined by the International Color\nConsortium standard [ICC32]. 3.5. The '@color-profile'\nat-rule",
        'values': {'auto': 'This is the default behavior. The user agent determines the best intent\nbased on the content. For image content containing an embedded profile, it\nshould be assumed that the intent specified within the profile is the desired\nintent. Otherwise, the user agent should use the current profile (based on\nthe color-profile style) and force the\nintent, overriding any intent that may be stored in the profile itself.'}},

    'resize':
{'description': '',
        'values': {'both': 'The UA presents a bidirectional resizing mechanism to allow the user to\nadjust both the height and the width of the element.',
                          'horizontal': 'The UA presents a unidirectional horizontal resizing mechanism to allow\nthe user to adjust only the width of the element.',
                          'none': 'The UA does not present a resizing mechanism on the element, and the user\nis given no direct manipulation mechanism to resize the element.',
                          'vertical': 'The UA presents a unidirectional vertical resizing mechanism to allow the\nuser to adjust only the height of the element.'}},

    'rest':
{'description': "The 'rest' property is a shorthand for setting 'rest-before' and\n'rest-after'. If two values are given, the first value is 'rest-before'\nand the second is 'rest-after'. If only one value is given, it applies\nto both properties.",
        'values': {}},

    'rest-after':
{'description': "These properties specify a rest or prosodic boundary to be observed\nbefore (or after) speaking an element's content. Values have the following\nmeanings:",
        'values': {'<time>': 'Expresses the rest in absolute time units (seconds and milliseconds,\ne.g. "3s", "250ms"). Only positive values are allowed.',
                          'none': 'none, x-weak, weak, medium, strong, and x-strong. These values may be used to indicate the prosodic strength of\nthe break in speech output. The synthesis processor may insert a\nrest as part of its implementation of the prosodic break. The value\n"none" indicates that no prosodic break boundary should be output,\nand can be used to inhibit a prosodic break which the processor\nwould otherwise produce. The other values indicate monotonically\nnon-decreasing (conceptually increasing) break strength between words.\nThe stronger boundaries are typically accompanied by rests. "x-weak"\nand "x-strong" are mnemonics for "extra weak" and "extra strong",\nrespectively.'}},

    'rest-before':
{'description': "These properties specify a rest or prosodic boundary to be observed\nbefore (or after) speaking an element's content. Values have the following\nmeanings:",
        'values': {'<time>': 'Expresses the rest in absolute time units (seconds and milliseconds,\ne.g. "3s", "250ms"). Only positive values are allowed.',
                          'none': 'none, x-weak, weak, medium, strong, and x-strong. These values may be used to indicate the prosodic strength of\nthe break in speech output. The synthesis processor may insert a\nrest as part of its implementation of the prosodic break. The value\n"none" indicates that no prosodic break boundary should be output,\nand can be used to inhibit a prosodic break which the processor\nwould otherwise produce. The other values indicate monotonically\nnon-decreasing (conceptually increasing) break strength between words.\nThe stronger boundaries are typically accompanied by rests. "x-weak"\nand "x-strong" are mnemonics for "extra weak" and "extra strong",\nrespectively.'}},

    'rotation':
{'description': 'Should probably be in the extended Box module instead of here... Name: rotation Value: <angle> Initial: 0 Applies to: block-level elements, inline-table and inline-block Inherited: no Percentages: N/A Media: visual Computed value: 0deg <= angle < 360deg Name: rotation-point Value: <bg-position> Initial: 50% 50% Applies to: block-level elements Inherited: no Percentages: Width and height of border box Media: visual Computed value: for <length> the absolute value, otherwise a percentageThe value of \'rotation-point\' is a pair of values that defines a point as an offset from the top left border edge. Percentages refer to the width and height of the border box. Values may be negative.\'Rotation\' rotates a block-level element counterclockwise around the point given by \'rotation-point\'. The border, padding and content are rotated, and also any background that is not \'fixed\'. All static or relatively positioned child elements (and their static and relatively positioned children, recursively) are rotated along. But absolutely positioned and fixed descendant elements are not. Note that this means that rotation is relative. A child of a box that is rotated 45deg and that has a rotation of -45deg itself, actually ends up horizontal (but probably in a different location than when both rotations had been 0). Rotation doesn\'t affect parent or sibling elements, they are laid out as if the element\'s rotation was 0. Conceptually, the element is first laid out without any rotation, then any relative positioning is applied to it (see [CSS3POS] {{CSS3POS}} ) and finally any rotation. The rotation point is relative to the box after relative positioning. Note that, like relative positioning, rotation can thus cause an element\'s box to overlap other boxes. It is the author\'s responsibility to give the element wide enough margins if such overlapping is not desired. When a box is broken over several columns or pages, each of the boxes is rotated separately around its own rotation point. The computed value of \'rotation\' is the angle normalized to fall in 0deg <= angle < 360deg. The computed value or \'rotation-point\' is a pair in which any <length> is made absolute, keywords are replaced by percentages and percentages are left as specified. This example puts H1 elements upside down. It relies on the \'rotation-point\' having its default value of \' 50% 50% \'. H1 {rotation: 180deg} This example displays column headers in a table diagonally. It uses \'block-progression\' (see [CSS3TEXTLAYOUT] {{!CSS3TEXTLAYOUT}} ) to write the column headers vertically and applies \'rotation\' to rotate the headers 45 degrees to the left. A fairly wide padding is applied, to make sure the text of the headings doesn\'t overlap. thead th { block-progression: rl; padding: 0.5em 1em; rotation: 45deg; rotation-point: bottom left } Example of a table with rotated column headings. This example puts H1 elements upside down. It relies on the \'rotation-point\' having its default value of \' 50% 50% \'. This example displays column headers in a table diagonally. It uses \'block-progression\' (see [CSS3TEXTLAYOUT] {{!CSS3TEXTLAYOUT}} ) to write the column headers vertically and applies \'rotation\' to rotate the headers 45 degrees to the left. A fairly wide padding is applied, to make sure the text of the headings doesn\'t overlap. Example of a table with rotated column headings. In the table example, how are the borders rotated? Because the borders belong to two elements that are rotated individually. Dave Hyatt proposes to generalize the property and call it "transform" with a syntax and functionality like in SVG, i.e., a property that accepts a series of transformations (rotations, translations, arbitrary affine transformations). 14. Stacking contexts',
        'values': {}},

    'rotation-point':
{'description': 'Should probably be in the extended Box module instead of here... Name: rotation Value: <angle> Initial: 0 Applies to: block-level elements, inline-table and inline-block Inherited: no Percentages: N/A Media: visual Computed value: 0deg <= angle < 360deg Name: rotation-point Value: <bg-position> Initial: 50% 50% Applies to: block-level elements Inherited: no Percentages: Width and height of border box Media: visual Computed value: for <length> the absolute value, otherwise a percentageThe value of \'rotation-point\' is a pair of values that defines a point as an offset from the top left border edge. Percentages refer to the width and height of the border box. Values may be negative.\'Rotation\' rotates a block-level element counterclockwise around the point given by \'rotation-point\'. The border, padding and content are rotated, and also any background that is not \'fixed\'. All static or relatively positioned child elements (and their static and relatively positioned children, recursively) are rotated along. But absolutely positioned and fixed descendant elements are not. Note that this means that rotation is relative. A child of a box that is rotated 45deg and that has a rotation of -45deg itself, actually ends up horizontal (but probably in a different location than when both rotations had been 0). Rotation doesn\'t affect parent or sibling elements, they are laid out as if the element\'s rotation was 0. Conceptually, the element is first laid out without any rotation, then any relative positioning is applied to it (see [CSS3POS] {{CSS3POS}} ) and finally any rotation. The rotation point is relative to the box after relative positioning. Note that, like relative positioning, rotation can thus cause an element\'s box to overlap other boxes. It is the author\'s responsibility to give the element wide enough margins if such overlapping is not desired. When a box is broken over several columns or pages, each of the boxes is rotated separately around its own rotation point. The computed value of \'rotation\' is the angle normalized to fall in 0deg <= angle < 360deg. The computed value or \'rotation-point\' is a pair in which any <length> is made absolute, keywords are replaced by percentages and percentages are left as specified. This example puts H1 elements upside down. It relies on the \'rotation-point\' having its default value of \' 50% 50% \'. H1 {rotation: 180deg} This example displays column headers in a table diagonally. It uses \'block-progression\' (see [CSS3TEXTLAYOUT] {{!CSS3TEXTLAYOUT}} ) to write the column headers vertically and applies \'rotation\' to rotate the headers 45 degrees to the left. A fairly wide padding is applied, to make sure the text of the headings doesn\'t overlap. thead th { block-progression: rl; padding: 0.5em 1em; rotation: 45deg; rotation-point: bottom left } Example of a table with rotated column headings. This example puts H1 elements upside down. It relies on the \'rotation-point\' having its default value of \' 50% 50% \'. This example displays column headers in a table diagonally. It uses \'block-progression\' (see [CSS3TEXTLAYOUT] {{!CSS3TEXTLAYOUT}} ) to write the column headers vertically and applies \'rotation\' to rotate the headers 45 degrees to the left. A fairly wide padding is applied, to make sure the text of the headings doesn\'t overlap. Example of a table with rotated column headings. In the table example, how are the borders rotated? Because the borders belong to two elements that are rotated individually. Dave Hyatt proposes to generalize the property and call it "transform" with a syntax and functionality like in SVG, i.e., a property that accepts a series of transformations (rotations, translations, arbitrary affine transformations). 14. Stacking contexts',
        'values': {}},

    'ruby-align':
{'description': "This property can be used on any element to control the text alignment of\nthe ruby text and ruby base contents relative to each other. It applies to all\nthe ruby's in the element. For simple ruby, the alignment is applied to the\nruby child element whose content is shorter: either the rb element or the rt element [ RUBY ]. For complex ruby, the alignment is also applied to the\nruby child elements whose content is shorter: either the rb element and/or one or two rt elements for each related ruby text\nand ruby base element within the rtc and rbc element. Possible values:",
        'values': {'auto': "The user agent determines how the ruby contents are aligned. This is the initial value. The behavior recommended by [ JIS4051 ] is for a wide-cell ruby is to be aligned in the 'distribute-space' mode: Figure 4.2.1 : Wide-cell text in 'auto' ruby alignment is 'distribute-space' justified The recommended behavior for a narrow-cell glyph ruby is to be aligned in the 'center' mode. Figure 4.2.2 : Narrow-width ruby text in 'auto' ruby alignment is centered",
                          'center': 'The ruby text content is centered within the width of the base. If the length of the base is smaller than the length of the ruby text, then the base is centered within the width of the ruby text. Figure 4.2.4 : Center ruby alignment',
                          'distribute-letter': 'If the width of the ruby text is smaller than that of the base, then the ruby text contents are evenly distributed across the width of the base, with the first and last ruby text glyphs lining up with the corresponding first and last base glyphs. If the width of the ruby text is at least the width of the base, then the letters of the base are evenly distributed across the width of the ruby text. Figure 4.2.6 : Distribute-letter ruby alignment',
                          'distribute-space': 'If the width of the ruby text is smaller than that of the base, then the ruby text contents are evenly distributed across the width of the base, with a certain amount of white space preceding the first and following the last character in the ruby text. That amount of white space is normally equal to half the amount of inter-character space of the ruby text. If the width of the ruby text is at least the width of the base, then the same type of space distribution applies to the base. In other words, if the base is shorter than the ruby text, the base is distribute-space aligned. This type of alignment is sometimes referred to as the "1:2:1" alignment [ JIS4051 ]. Figure 4.2.7 : Distribute-space ruby alignment',
                          'left': 'The ruby text content is aligned with the start edge of the base. Figure 4.2.3 : Start ruby alignment',
                          'line-edge': "If the ruby text is not adjacent to a line edge, it is aligned as in 'auto'. If it is adjacent to a line edge, then it is still aligned as in auto, but the side of the ruby text that touches the end of the line is lined up with the corresponding edge of the base. This type of alignment is specified by [ JIS4051 ]. This type of alignment is relevant only to the scenario where the ruby text is longer than the ruby base. In the other scenarios, this is just 'auto'. Figure 4.2.8 : Line edge ruby alignment",
                          'right': 'The ruby text content is aligned with the end edge of the base. Figure 4.2.5 : End ruby alignment'}},

    'ruby-overhang':
{'description': 'This property determines whether, and on which side, ruby text is allowed\nto partially overhang any adjacent text in addition to its own base, when the\nruby text is wider than the ruby base. Note that ruby text is never allowed to\noverhang glyphs belonging to another ruby base. Also the user agent is free to assume\na maximum amount by which ruby text may overhang adjacent text. The user agent may use\nthe [ JIS4051 ] recommendation of using one ruby text character\nlength as the maximum overhang length. Possible values:',
        'values': {'auto': 'The ruby text can overhang text adjacent to the base on either side. [ JIS4051 ] specifies the categories of characters that ruby text can overhang. The user agent is free to follow the [ JIS4051 ] recommendation or specify its own classes of characters to overhang. This is the initial value. Figure 4.3.1 : Ruby overhanging adjacent text',
                          'end': 'The ruby text can overhang the text that follows it. That means, for example, that ruby can overhang text that is to the right of it in horizontal LTR layout, or it can overhang text that is below it in vertical-ideographic layout. Figure 4.3.3 : Ruby overhanging following text only',
                          'none': 'The ruby text cannot overhang any text adjacent to its base, only its own base. Figure 4.3.4 : Ruby not allowed to overhang adjacent text',
                          'start': 'The ruby text can overhang the text that precedes it. That means, for example, that ruby can overhang text that is to the left of it in horizontal LTR layout, or it can overhang text that is above it in vertical-ideographic layout. Figure 4.3.2 : Ruby overhanging preceding text only'}},

    'ruby-position':
{'description': 'This property is used by the parent of elements with display: ruby-text to\ncontrol the position of the ruby text with respect to its base. Such parents\nare typically either the ruby element itself (simple ruby) or the rtc element (complex ruby). This assures that all part of a rtc element will be displayed in the same position. Possible values:',
        'values': {'after': 'The ruby text appears after the base. This is a relatively rare setting used in ideographic East Asian writing systems, most easily found in educational text. Figure 4.1.4 : Bottom ruby in horizontal layout applied to Japanese text If the base appears in a vertical ideographic mode, the bottom ruby appears on the left side of the base and is rendered in the same layout mode as the base (i.e. vertical). Figure 4.1.5 : Bottom ruby in vertical ideographic layout applied to Japanese text',
                          'before': 'The ruby text appears before the base. This is the most common setting used in ideographic East Asian writing systems. This is the initial value. Figure 4.1.1 : Top ruby in horizontal layout applied to Japanese text If the base appears in a vertical-ideographic layout mode, the ruby appears on the right side of the base and is rendered in the same layout mode as the base (i.e. vertical-ideographic). Figure 4.1.2 : Top ruby in vertical ideographic layout applied to Japanese text Note the special case of traditional Chinese as used especially in Taiwan: ruby (made of Bopomofo glyphs) in that context can appear along the right side of the base glyph, as if the text were in vertical layout, but the bases themselves are rendered on a horizontal line, since the actual layout is horizontal: Figure 4.1.3 : " Bopomofo " ruby in traditional Chinese (ruby text shown in blue for clarity) in horizontal layout In order to achieve that effect, vertical-ideographic layout should be set on each individual ruby. That can be accomplished with the following simple CSS rule: ruby.bopomofo { writing-mode: tb-rl } Note: The Bopomofo transcription is written in the normal way as part of the ruby text. The user agent is responsible for ensuring the correct relative alignment and positioning of the glyphs, including those corresponding to the tone marks, when displaying as vertical ruby.',
                          'right': "The ruby text appears on the right of the base. Unlike 'before'and'after', this value is not relative to the text flow direction."}},

    'ruby-span':
{'description': 'This property controls the spanning behavior of annotation elements. Note: A XHTML user agent may also use the rbspan attribute to get the same effect. Possible values:',
        'values': {'attr': "attr(x). The value of attribute 'x' as a string value. The string value is evaluated as a <number> to determine the number of ruby base elements to be spanned by the annotation element. If the <number> is '0', it is replaced by '1'. The <number> is the computed value.",
                          'none': "No spanning. The computed value is '1'."}},

    'string-set':
{'description': 'The \'string-set\' property accepts a comma-separated list of named strings. Each named string is followed by a content list that specifies which text to copy into the named string. Whenever an element with value of \'string-set\' different from \'none\' is encountered, the named strings are assigned their respective value. For the \'string-set\' property, <content-list> expands to one or more of these values, in any order: <p class="issue">Should target-counter() and leader() also be allowed?</p>',
        'values': {'<content>': 'the \' content() \' function returns the content of elements and pseudo-elements. The functional notation accepts an optional argument: \' content() \' Without any arguments, the function returns the textual content of the element, not including the content of its ::before and ::after pseudo-element. The content of the element\'s descendants, including their respective ::before and ::after pseudo-elements, are included in the returned content. \' content(before) \' The function returns the textual content of the ::before pseudo-element the content of the element. \' content(after) \' The function returns the textual content of the ::after pseudo-element the content of the element. \' content(first-letter) \' The function returns the first letter of the content of the element. The definition of a letter is the same as for :first-letter pseudo-elements. The expected use for \' content(first-letter) \' is to create one-letter headers, e.g., in dictionaries. \' env() \' This function returns data from the local environment of the user at the time of formatting. The function accepts one of these keywords: env(url): returns the URL of the document env(date): returns the date on the user\'s system at the time of formatting env(time): returns the time on the user\'s system at the time of formatting env(date-time): returns the date and time on the user\'s system at the time of formatting Information about date and time is formatted according to the locale of the user\'s system. Or, should there be a way to specify the locale? Or should we simply format all in ISO format (e.g., 2010-03-30)? On many systems, preformatted strings in the user\'s locale can be found through the strftime function. The date, time and date-time strings can be found by using the "%x", "%X" and "%c" conversion strings, respectively. @page { @top-right { content: env(url) } @bottom-right { content: env(date-time) }\n}',
                          '<counter>': 'the counter() or counters() function, as per CSS 2.1 section 4.3.5',
                          '<string>': 'a string, e.g. "foo"'}},

    'target':
{'description': 'The \'target\' property is a shorthand property for setting the individual\ntarget properties (i.e., \'target-name\', \'target-new\'and\'target-position\')\nat the same place in the style sheet. Given a valid declaration, the \'target\' property first sets all the\nindividual target properties to their initial values, then assigns explicit\nvalues given in the declaration. <h2>The :link and :visited pseudo-classes</h2> == These are already described in CSS3 Selectors == <h2>The ??? property</h2> <p>An element may represent several links. The ??? property specifies which\nlink to use.</p>\n<pre>p[href] { link: attr(href) }</pre> == Editor thinks this is not developed enough of an idea to include here == <p>Primary and secondary links?</p> == perhaps an issue == <h2 id="profiles">Profiles</h2> <p>[This section explains what parts of this module belong in which\nprofiles.]</p> <p>We have at least 4 profiles: level 1, level 2, level 3 and full</p> == CSS3 Hyperlinks should not have any profiles. This should be all or nothing. == 4. Conformance',
        'values': {}},

    'target-name':
{'description': "The 'target-name' property defines the name of the target destination,\nincluding a few keywords for well known destinations. Name: target-name Value: current | root | parent | new | modal | <string> Initial: current Applies to: hyperlinks Inherited: no Percentages: N/A Media Group(s): interactive visual Computed value: specified value does not apply if 'target-style'is'auto'. In other cases theThe values mean the following: 3.3. The 'target-new'\nproperty",
        'values': {'<string>': "The target is displayed in the existing frame, window or tab of that\nname. If no such named destination exists, a new destination (see\n'target-new') is created with that name.",
                          'current': 'The name of the current frame, tab or window where the link resides. This\nvalue never causes a new destination to be created.',
                          'modal': "If 'target-style'is'frame', this value is treated as 'current'. Otherwise a A new modal window is temporarily created.",
                          'new': "If 'target-style'is'frame', this value is treated as 'current'. Otherwise a A new destination (see 'target-new') is always created.",
                          'parent': "The name of the parent of the current frame. If the current frame has no\nparent this value is treated as 'root'. This value never causes a new\ndestination to be created.",
                          'root': 'The name of the current tab (if there is one) or window. This value never\ncauses a new destination to be created.'}},

    'target-new':
{'description': "The 'target-new' property determines what new target destination (if any)\nis created. Name: target-new Value: window | tab | none Initial: window Applies to: hyperlinks Inherited: no Percentages: N/A Media Group(s): interactive visual Computed value: specified value If a user wanted to have new windows open in new tabs instead, she could\nuse the following user style sheet to do so: * { target-new: tab ! important } 3.4. The\n'target-position' property",
        'values': {'none': 'No new destination is created. The target is not displayed.',
                          'tab': 'The target is displayed in a new tab of an existing window.',
                          'window': 'The target is displayed in a new window.'}},

    'target-position':
{'description': "The 'target-position' property indicates where a new destination (if any)\nis created. Name: target-position Value: above | behind | front | back Initial: above Applies to: hyperlinks Inherited: no Percentages: N/A Media Group(s): interactive visual Computed value: specified value",
        'values': {'above': 'The new destination tab (window) is placed above the current tab (window)\nrespectively.',
                          'back': 'The new destination tab (window) is placed behind all other tabs\n(windows) respectively.',
                          'behind': 'The new destination tab (window) is placed behind the current tab\n(window) respectively.',
                          'front': 'The new destination tab (window) is placed above all other tabs (windows)\nrespectively.'}},

    'text-align-last':
{'description': "This property describes how the last line of a block or a line right before a forced line break is aligned when 'text-align' is set to 'justify'. Values have the same meaning as for 'text-align'.",
        'values': {}},

    'text-emphasis':
{'description': "East Asian documents use small symbols on top of each glyph to emphasize a run of text. For example:Accent emphasis (shown in blue for clarity) applied to Japanese textThis property applies emphasis formatting applied to text. Unlike 'text-decoration', emphasis marks can affect the line height. Values have the following meanings:",
        'values': {'accent': 'Draw calligraphic accent strokes as marks.',
                          'after': 'Draw marks below the text in horizontal layout, to the left in vertical layout.',
                          'before': 'Draw marks above the text in horizontal layout, to the right in vertical layout. This is the default position.',
                          'circle': 'Draw hollow circles as marks.',
                          'disc': 'Draw filled circles as marks.',
                          'dot': 'Draw calligraphic dots as marks.',
                          'none': 'No emphasis marks.'}},

    'text-height':
{'description': "The 'text-height' property determine the block-progression dimension of the text content area of an inline box. Possible values:",
        'values': {'auto': 'The block-progression dimension is based either on the em square determined by the element font-size property value or the cell-height (ascender + descender) related to the element font-size as chosen by the user agent.',
                          'font-size': 'The block-progression dimension is based on the em square as determined by the element font-size.',
                          'max-size': "The block-progression dimension is based on the maximum extents toward the before-edge and after-edge of the box obtained by considering all children elements located on the same line, ruby annotations (elements with 'display:ruby-text') and baseline shifted elements.",
                          'text-size': 'The block-progression dimension is based on the cell-height (ascender + descender) related to the element font-size.'}},

    'text-justify':
{'description': "This property selects the justification method used when 'text-align' is set to 'justify'. It takes the following values:",
        'values': {'auto': 'The UA determines the justification algorithm to follow, based on a balance between performance and adequate presentation quality.',
                          'distribute': 'Justification primarily changes spacing both at word separators and at grapheme cluster boundaries in all scripts except those in the connected and cursive groups.',
                          'inter-cluster': 'Justification primarily changes spacing at word separators and at grapheme cluster boundaries in cluster scripts.',
                          'inter-ideograph': 'Justification primarily changes spacing at word separators and at inter-graphemic boundaries in scripts that use no word spaces',
                          'inter-word': 'Justification primarily changes spacing at word separators',
                          'kashida': 'Justification primarily stretches Arabic and related scripts through the use of kashida or other calligraphic elongation.',
                          'tibetan': 'Justification primarily stretches spaces after shad if the line contains any and/or pads the end of the line with tsek marks if the line already ends in one.'}},

    'text-outline':
{'description': "This property specifies a text outline where the first length represents the outline's thickness and the second represents an optional blur radius. The outline never overlays the text itself. Its effect is the same as that obtained by applying text shadows in every radial direction, i.e. all text shadows whose offsets satisfy the equation x 2 + y 2 = thickness 2. The Timed-Text WG had suggestions for some keywords (text-outline: normal|heavy|light;) as well as a <length> thickness. Should these be added? How would they be defined? (Maybe use (thin|medium|thick) as in border-width ?)The blur radius is a length value that indicates the boundaries of the blur effect. The exact algorithm for computing the blur effect is not specified, but it is only applied to the outer edge of the outline. If the blur radius is not specified, it is equal to zero. Is a second blur radius needed for the inner edge? Or should the blur apply to both edges? Implementations may choose to ignore the blur radius when text outline is combined with a text shadow. A color value must be specified before or after the length values of the outline effect. The color value will be used as the color of the outline.",
        'values': {}},

    'text-wrap':
{'description': 'This property specifies the mode for text wrapping. Possible values:',
        'values': {'none': 'Lines may not break; text that does not fit within the block box overflows it.',
                          'normal': 'Lines may break at allowed break points, as determined by the line-breaking rules in effect. Line breaking behavior defined for the WJ, ZW, and GL line-breaking classes in [ UAX14 ] must be honored.',
                          'suppress': "Line breaking is suppressed within the element: the UA may only break within the element if there are no other valid break points in the line. If the text breaks, line-breaking restrictions are honored as for 'normal'.",
                          'unrestricted': 'Lines may break between any two grapheme clusters. Line-breaking restrictions have no effect and hyphenation does not take place. Character shaping is performed on each side of the break as if the break had not occurred.'}},

    'transition':
{'description': '', 'values': {}},

    'transition-delay':
{'description': '', 'values': {}},

    'transition-duration':
{'description': "This property specifies how long the transition from the old value to the new value should take. By default the value is '0', meaning that the transition is immediate (i.e. there will be no animation). A negative value for transition-duration is treated as '0'.",
        'values': {}},

    'transition-property':
{'description': 'A value of \'none\' means that no property will transition. A value of \'all\' means that every property that is able to undergo a transition will do so. Otherwise, a list of properties to be transitioned is given. We need to generate a list of properties that can be transitioned. Is "none" even a useful value if the initial value is "all"? The syntax is more elegant if transition-duration defaults to 0 and this property defaults to "all", but another option is to default this property to "none" and duration to something reasonable, e.g., 250ms. This would force an author to specify transition-property in the shorthand all the time though. If one of the identifiers listed is not a recognized property name or is not an animatable property, the implementation must still start transitions on the animatable properties in the list using the duration, delay, and timing function at their respective indices in the lists for \'transition-duration\', \'transition-delay\', and \'transition-timing-function\'. In other words, unrecognized or non-animatable properties must be kept in the list to preserve the matching of indices. Are \'all\', \'none\', \'inherit\', and \'initial\' allowed as items in a list of identifiers (of length greater than one)?If one of the identifiers listed is a shorthand property, implementations must start transitions for any of its longhand sub-properties that are animatable, using the duration, delay, and timing function at the index corresponding to the shorthand. If a property is specified multiple times in the value of \'transition-property\' (either on its own or via a shorthand that contains it), then the transition that starts uses the duration, delay, and timing function at the index corresponding to the last occurrence of the property.',
        'values': {}},

    'transition-timing-function':
{'description': "The timing functions have the following definitions. ======================================================================================================= 2.4. The 'transition-delay' Property",
        'values': {'cubic-bezier': 'Specifies a cubic-bezier curve. The four values specify points P 1 and P 2 of the curve as (x1, y1, x2, y2). All values must be in the range [0, 1] or the definition is invalid.',
                          'ease': 'The ease function is equivalent to cubic-bezier(0.25, 0.1, 0.25, 1.0).',
                          'ease-in': 'The ease-in function is equivalent to cubic-bezier(0.42, 0, 1.0, 1.0).',
                          'ease-in-out': 'The ease-in-out function is equivalent to cubic-bezier(0.42, 0, 0.58, 1.0)',
                          'ease-out': 'The ease-out function is equivalent to cubic-bezier(0, 0, 0.58, 1.0).',
                          'linear': 'The linear function is equivalent to cubic-bezier(0.0, 0.0, 1.0, 1.0).'}},

    'voice-balance':
{'description': "The 'voice-balance' property refers to the balance between left and right channels, and presumes a two channel (stereo) model that is widely supported on consumer audio equipment. Values have the following meanings:",
        'values': {'<number>': "An integer or floating point number between '-100'and'100'. For '-100' only the left channel is audible. Simarly for '100' or '+100' only the right channel is audible. For '0' both channels have the same level, so that the speech appears to be coming from the center.",
                          'center': "Same as '0'.",
                          'left': "Same as '-100'.",
                          'leftwards': "Moves the sound to the left, relative to the inherited voice balance. More precisely, subtract 20 from the inherited value and clip the resulting value to the range '-100'and'100'.",
                          'right': "Same as '100'or'+100'.",
                          'rightwards': "Moves the sound to the right, relative to the inherited voice balance. More precisely, add 20 to the inherited value and clip the resulting value to the range '-100'and'100'."}},

    'voice-duration':
{'description': "Allows authors to specify how long it should take to render the selected element's content. This property overrides the 'voice-rate' property. Values have the following meanings:",
        'values': {'<time>': 'Specifies a value in seconds or milliseconds for the desired time to take to speak the element contents, for instance, "250ms", or "3s". Only positive numbers are allowed.'}},

    'voice-pitch':
{'description': "Specifies the average pitch (a frequency) of the speaking voice. The average pitch of a voice depends on the voice family. For example, the average pitch for a standard male voice is around 120Hz, but for a female voice, it's around 210Hz. Values have the following meanings:",
        'values': {'<number>': 'A positive integer or floating point number that specifies the average pitch of the speaking voice in Hertz.',
                          '<percentage>': 'Specifies a relative change to the inherited value.',
                          'x-low': 'Extra low pitch level.',
                          'low': 'Low pitch level.',
                          'medium': 'Medium pitch level.',
                          'high': 'High pitch level.',
                          'x-high': 'Extra high pitch level.'}},

    'voice-pitch-range':
{'description': 'Specifies variation in average pitch. The perceived pitch of a human voice is determined by the fundamental frequency and typically has a value of 120Hz for a male voice and 210Hz for a female voice. Human languages are spoken with varying inflection and pitch; these variations convey additional meaning and emphasis. Thus, a highly animated voice, i.e., one that is heavily inflected, displays a high pitch range. This property specifies the range over which these variations occur, i.e., how much the fundamental frequency may deviate from the average pitch. Values have the following meanings:',
        'values': {'<number>': 'An non-negative integer or floating point number indicating pitch range in Hertz. Low ranges produce a flat, monotonic voice. A high range produces animated voices.',
                          '<percentage>': 'Specifies a relative change to the inherited value.',
                          'x-low': 'Extra low pitch range.',
                          'low': 'Low pitch range.',
                          'medium': 'Medium pitch range.',
                          'high': 'High pitch range.',
                          'x-high': 'Extra high pitch range.'}},

    'voice-rate':
{'description': 'This property controls the speaking rate. The default rate for a voice depends on the language and dialect and on the personality of the voice. The default rate for a voice should be such that it is experienced as a normal speaking rate for the voice when reading aloud text. Since voices are processor-specific, the default rate will be as well.',
        'values': {'<percentage>': 'Applies to the default speaking rate for each voice. Thus 50% means half the normal rate for this voice.',
                          'x-slow': 'Extra slow voice speed.',
                          'slow': 'Slow voice speed.',
                          'medium': 'Medium voice speed.',
                          'fast': 'Fast voice speed.',
                          'x-fast': 'Extra fast voice speed.'}},

    'voice-stress':
{'description': 'Indicates the strength of emphasis to be applied. Emphasis is indicated using a combination of pitch change, timing changes, loudness and other acoustic differences) that varies from one language to the next. Values have the following meanings:',
        'values': {'none': "Inhibits the synthesizer from emphasizing words it would normally emphasize.",
                          'moderate': 'Gives a moderare emphasis of a word.',
                          'strong': 'Gives a strong emphasis on a word.',
                          'reduced': 'Effectively the opposite of emphasizing a word. For example, when the phrase "going to" is reduced it may be spoken as "gonna".'}},

    'voice-volume':
{'description': "The 'voice-volume' refers to the amplitude of the waveform output by the speech synthesiser. This may be mixed with other audio sources, influencing the perceived loudness of synthetic speech relative to these sources. Note that voice-volume does not apply to audio cues for which there is a separate means to set the relative loudness. Values have the following meanings:",
        'values': {'<number>': "An integer or floating point number in the range '0'to'100'. '0' represents silence (the minimum level), and 100 corresponds to the maximum level. The volume scale is linear amplitude.",
                          '<percentage>': "Percentage values are calculated relative to the inherited value, and are then clipped to the range '0'to'100'.",
                          'silent': 'Zero volume (0).',
                          'x-soft': 'Extra soft volume.',
                          'soft': 'Low volume.',
                          'medium': 'Medium volume.',
                          'loud': 'High volume.',
                          'x-loud': 'Highest volume (100).'}},

    'white-space-collapse':
{'description': 'This section is still under discussion and may change in future drafts. This property declares whether and how white space inside the element is collapsed. Values have the following meanings, which must be interpreted according to the white space processing rules :',
        'values': {'collapse': 'This value directs user agents to collapse sequences of white space into a single character (or in some cases, no character).',
                          'discard': 'This value directs user agents to "discard" all white space in the element.',
                          'preserve': 'This value prevents user agents from collapsing sequences of white space. Line breaks are preserved.',
                          'preserve-breaks': "This value collapses white space as for 'collapse', but preserves line breaks."}},

    'word-break':
{'description': "CSS distinguishes between two levels of strictness in the rules for implicit line breaking in CJK text. The precise set of rules in effect for the strict and loose levels is up to the UA and should follow language conventions. However, this specification does recommend that the following breaks be forbidden in strict line breaking and allowed in loose:Breaks between Hangul syllable blocks are allowed in both strict and loose rules: to restrict breaks in Korean to spaces, the 'keep-all' value of 'word-break' can be specified. Information on line breaking conventions can be found in [ JIS4051 ] for Japanese, [ ???? ] for Chinese, and [?] for Korean, and in [ UAX14 ] for all scripts in Unicode. The CSS Working Group notes that although UAX 14 contains a wealth of information about line breaking conventions, a literal implementation of its algorithm has been found to be inadequate in multiple situations. Any guidance for appropriate references here would be much appreciated. This property specifies what set of line breaking restrictions are in effect within the element. Values have the following meanings:",
        'values': {'break-all': "As for 'break-strict', except CJK scripts break according to the rules for 'loose'.",
                          'break-strict': "Same as 'normal' for CJK scripts, but non-CJK scripts can break anywhere. This option is used mostly when the text is predominantly CJK characters with few non-CJK excerpts and it is desired that the text be more evenly distributed on each line.",
                          'keep-all': "Same as 'normal' for all non-CJK scripts. However, sequences of CJK characters can no longer break on implied break points. This option should only be used where the presence of white space characters still creates line-breaking opportunities, as in Korean.",
                          'loose': "As for 'normal', but CJK scripts use a less restrictive set of line-breaking restrictions.",
                          'normal': 'Breaks non-CJK scripts according to their own rules while using a strict set of line breaking restrictions for CJK scripts (Hangul, Japanese Kana, and CJK ideographs).'}},

    'word-wrap':
{'description': "This property specifies whether the UA may break within a word to prevent overflow when an otherwise-unbreakable string is too long to fit within the line box. It only has an effect when 'text-wrap' is either 'normal'or'suppress'. Possible values:",
        'values': {'break-word': 'An unbreakable "word" may be broken at an arbitrary point if there are no otherwise-acceptable break points in the line. Shaping characters are still shaped as if the word were not broken, and grapheme clusters must together stay as one unit.',
                          'normal': 'Lines may break only at allowed break points.'}},
}

### END: Auto generated


CSS3_SPECIFIC_ATTRS_DICT = {}
CSS3_SPECIFIC_CALLTIP_DICT = {}
for attr, details in list(CSS3_DATA.items()):
    values = details.get("values", {})
    attr_completions = sorted(values.keys())
    if attr_completions:
        CSS3_SPECIFIC_ATTRS_DICT[attr] = attr_completions
    else:
        CSS3_SPECIFIC_ATTRS_DICT[attr] = []
    description = details.get("description")
    if description:
        desc_lines = textwrap.wrap(description, width=60)
        if values:
            desc_lines.append("")
            for value, attr_desc in list(values.items()):
                attr_desc = "  %r: %s" % (value, attr_desc)
                attr_desc_lines = textwrap.wrap(attr_desc, width=50)
                for i in range(len(attr_desc_lines)):
                    attr_line = attr_desc_lines[i]
                    if i > 0:
                        attr_line = "        " + attr_line
                    desc_lines.append(attr_line)
        CSS3_SPECIFIC_CALLTIP_DICT[attr] = "\n".join(
            desc_lines)

removed_css2_items = ["azimuth", "clip", "pointer-events"]

maybe_removed_css2_items = [
    "border-collapse", "border-spacing", "bottom",
    "direction", "elevation", "empty-cells", "left", "marker-offset",
    "pitch", "pitch-range", "play-during", "position",
    "richness", "right", "speak-header", "speak-numeral",
    "speak-punctuation", "speech-rate", "stress",
    "table-layout", "text-transform", "top",
    "unicode-bidi", "volume", "z-index",
]

CSS_ATTR_DICT = CSS1_SPECIFIC_ATTRS_DICT.copy()
CSS_ATTR_DICT.update(CSS2_SPECIFIC_ATTRS_DICT)
CSS_ATTR_DICT.update(CSS3_SPECIFIC_ATTRS_DICT)

CSS_PROPERTY_ATTRIBUTE_CALLTIPS_DICT = CSS1_SPECIFIC_CALLTIP_DICT.copy()
CSS_PROPERTY_ATTRIBUTE_CALLTIPS_DICT.update(CSS2_SPECIFIC_CALLTIP_DICT)
CSS_PROPERTY_ATTRIBUTE_CALLTIPS_DICT.update(CSS3_SPECIFIC_CALLTIP_DICT)

# Remove the css 2 properties that are no longer in css 3.
for name in removed_css2_items:
    CSS_ATTR_DICT.pop(name, None)
    CSS_PROPERTY_ATTRIBUTE_CALLTIPS_DICT.pop(name, None)

for property, calltip in list(CSS_PROPERTY_ATTRIBUTE_CALLTIPS_DICT.items()):
    if property not in CSS3_SPECIFIC_CALLTIP_DICT:
        if property in CSS2_SPECIFIC_CALLTIP_DICT:
            calltip += "\n(CSS2, CSS3)"
        else:
            calltip += "\n(CSS1, CSS2, CSS3)"
    else:
        calltip += "\n(CSS3)"
    CSS_PROPERTY_ATTRIBUTE_CALLTIPS_DICT[property] = calltip


# Note: The CSS3 color names below are not used yet.
css3_color_names = [
    'aliceblue',
    'antiquewhite',
    'aqua',
    'aquamarine',
    'azure',
    'beige',
    'bisque',
    'black',
    'blanchedalmond',
    'blue',
    'blueviolet',
    'brown',
    'burlywood',
    'cadetblue',
    'chartreuse',
    'chocolate',
    'coral',
    'cornflowerblue',
    'cornsilk',
    'crimson',
    'cyan',
    'darkblue',
    'darkcyan',
    'darkgoldenrod',
    'darkgray',
    'darkgreen',
    'darkgrey',
    'darkkhaki',
    'darkmagenta',
    'darkolivegreen',
    'darkorange',
    'darkorchid',
    'darkred',
    'darksalmon',
    'darkseagreen',
    'darkslateblue',
    'darkslategray',
    'darkslategrey',
    'darkturquoise',
    'darkviolet',
    'deeppink',
    'deepskyblue',
    'dimgray',
    'dimgrey',
    'dodgerblue',
    'firebrick',
    'floralwhite',
    'forestgreen',
    'fuchsia',
    'gainsboro',
    'ghostwhite',
    'gold',
    'goldenrod',
    'gray',
    'green',
    'greenyellow',
    'grey',
    'honeydew',
    'hotpink',
    'indianred',
    'indigo',
    'ivory',
    'khaki',
    'lavender',
    'lavenderblush',
    'lawngreen',
    'lemonchiffon',
    'lightblue',
    'lightcoral',
    'lightcyan',
    'lightgoldenrodyellow',
    'lightgray',
    'lightgreen',
    'lightgrey',
    'lightpink',
    'lightsalmon',
    'lightseagreen',
    'lightskyblue',
    'lightslategray',
    'lightslategrey',
    'lightsteelblue',
    'lightyellow',
    'lime',
    'limegreen',
    'linen',
    'magenta',
    'maroon',
    'mediumaquamarine',
    'mediumblue',
    'mediumorchid',
    'mediumpurple',
    'mediumseagreen',
    'mediumslateblue',
    'mediumspringgreen',
    'mediumturquoise',
    'mediumvioletred',
    'midnightblue',
    'mintcream',
    'mistyrose',
    'moccasin',
    'navajowhite',
    'navy',
    'oldlace',
    'olive',
    'olivedrab',
    'orange',
    'orangered',
    'orchid',
    'palegoldenrod',
    'palegreen',
    'paleturquoise',
    'palevioletred',
    'papayawhip',
    'peachpuff',
    'per',
    'pink',
    'plum',
    'powderblue',
    'purple',
    'red',
    'rosybrown',
    'royalblue',
    'saddlebrown',
    'salmon',
    'sandybrown',
    'seagreen',
    'seashell',
    'sienna',
    'silver',
    'skyblue',
    'slateblue',
    'slategray',
    'slategrey',
    'snow',
    'springgreen',
    'steelblue',
    'tan',
    'teal',
    'thistle',
    'tomato',
    'turquoise',
    'violet',
    'wheat',
    'white',
    'whitesmoke',
    'yellow',
    'yellowgreen',
]

# Add the css3 named colors.
# from codeintel2.util import CompareNPunctLast
# for attr, values in CSS_ATTR_DICT.items():
#    if '#' in values or 'rbg(' in values:
#        CSS_ATTR_DICT[attr] = sorted(values + css3_color_names,
#                                     cmp=CompareNPunctLast)
