SSH-Panel
=========
这个Sublime Text插件可用于浏览和编辑远程服务器上的文件

支持可使用openssh的Windows、Linux服务器

![Screenshot](https://github.com/Haiquan-27/SSH-Panel-doc-annex/blob/main/recording.gif?raw=true)

# Install

## 1. 检查依赖库 (**非常重要**)
### 在Windows上你需要:
* python3.dll
> 你可以从[这个仓库](https://github.com/Haiquan-27/SSH-Panel-doc-annex)下载并复制到sublime text的**安装目录**下

### 在Windows上你需要:
* 安装 **libffi**
```bash
# if Debian / Ubuntu
apt-get install libffi-dev
# if Fedora / CentOS / RHEL
sudo yum install libffi-devel
```

### 以下python3.8依赖库
* bcrypt
* cffi
* cryptography
* nacl
* six
> 你可以从[这个仓库](https://github.com/Haiquan-27/SSH-Panel-doc-annex)下载并复制到sublime text 的**Lib\python38**路径下

## 2. 安装此包
### 你可以使用*Package Control*安装或*手动安装*
* 使用 Package Control
> 打开 `Package Control: install` 菜单并键入 **"SSH-Panel"** 即可安装

* 手动安装
> 下载项目zip文件并解压到**"{你的插件包路径}/SSH-Panel"**

## 3. 重启sublime text


# Settings

设置服务器连接参数

打开命令面板菜单，选择`SSH-Panel: Edit Settings`命令，编辑配置文件

## 参数注解:

### 根下:
* `default_connect_settings` 所有连接使用的默认参数
* `server_settings` 配置连接的首选项
* `debug_mode` 是否启用Debug模式
* `style_css` 自定义css样式，类型是sublime resource，默认*Packages/SSH-Panel/style.css* [详见此处](#style-coustom)
* `new_window` 当连接时打开一个新的窗口
* `quiet_log` 当有消息时不会立即弹出消息面板
* `reconnect_on_start` 是否在启动sublime text时自动打开上次关闭的连接
* `nav_bar_color_change` 更改目录面板的颜色，值为-16777215~+16777215(-0xffffff~+0xffffff) 字符串，此值将与当前视图背景的rgb色进行加运算得到一个新的rgb色
> 如果想使用原视图的背景色则可设置为 "0"
### 路径:
* `remote_path` 远程主机上的路径，你可以使用远程主机上的环境变量，例如"$HOME"、"%userprofile%"，值是一个路径或路径列表
> 每个远程根路径将会被分别映射到`local_path`的子目录下，子目录名称是由路径名生成的摘要字符串
* `local_path` 用于同步的本地目录路径，如果为空将会在当前用户家目录下自动生成，可以使用本地环境变量
> "{auto_generate}"会被替换为由配置与时间戳生成的uuid字符串,用于生成唯一的uuid路径
> 在第一次连接后此路径将会写入到用户配置中，用于下次连接使用
### 连接和认证:
* `network_timeout` 用于认证和连接到远程主机的超时秒数
* `port` 服务器上的SSH服务端口，默认22
* `known_hosts_file` 本地know_hosts文件路径，如果设置此项则
> 连接时使用known_hosts_file中记录的主机密钥算法
> 如主机未在know_hosts_file中记录，则会提示是否添加主机公钥
> 当在连接成功后得到的主机公钥与known_host_file中记录的公钥不匹配时将会警告并强制关闭当前连接
* `username` 远程主机上的用户名
* `hostname` 远程主机IP或域名
* `always_fingerprint_confirm` 每次连接要求确认主机指纹，如果设置了`known_hosts_file`则直接通过known_hosts_file验证主机指纹
#### 如果服务器使用账户密码进行认证，应使用如下选项:
* `password` 密码明文
* `save_password` 是否在配置文件中保存密码明文，如果设为false密码将在连接操作后被删除，值为bool
#### 如果服务器使用公私密钥对进行认证，应使用如下选项:
* `private_key` 用于设置加密算法和私钥文件路径，此项只在服务器要求使用公私密钥对进行认证时有效
> 密钥算法支持"RSAKey"、"DSSKey"、"ECDSAKey"、"Ed25519Key"
> 此项的值是一个2元素的列表，格式为[{RSAKey/DSSKey/ECDSAKey/Ed25519Key},{私钥文件路径}]
> !! 对于密钥文件，如果你使用的sublime版本<4000 生成密钥的命令必须包括[-m PEM]参数，或对已有的私钥文件转换格式
* `"need_passphrase"` 告知插件此密钥生成时是否使用了passphrase，值为bool
#### 如果服务器使用GSSAPI进行认证，应使用如下选项:
* `gss_host` 远程主机IP或域名，如果使用此项`hostname`将不被使用
* `gss_auth` 启用gss认证，值为bool
* `gss_kex` 使用gss kex，值为bool
* `gss_deleg_creds` gss deleg creds
* `gss_trust_dns` gss trust dns

## 例子
```js
"server_settings":{
		// 使用账户名和密码进行连接
		"MyServer0":{
			"username":"",
			"hostname":"", // ip或域名
			"password":"", // 如果为空将会在连接时提示输入
			"save_password":false, // (可选) 默认为true
			// 路径
			"remote_path":"/", // 指定绝对路径
			// "remote_path":"%HOME/", // 带变量的路径
			// "remote_path":["/var","/etc"], // 使用列表
			"local_path":"~/SFTP-Local/{auto_generate}" // 自动生成
			// ...
		},
		// 使用用户名和私钥进行连接
		"MyServer1":{
			"username":"",
			"hostname":"",
			"private_key":["RSAKey","~/.ssh/id_rsa"],			// ssh-keygen -t rsa [-m PEM]
			// "private_key":["DSSKey","~/.ssh/id_dsa"]			// ssh-keygen -t dsa [-m PEM]
			// "private_key":["ECDSAKey","~/.ssh/id_ecdsa"]		// ssh-keygen -t ecdsa [-m PEM]
			// "private_key":["Ed25519Key","~/.ssh/id_ed25519"] // ssh-keygen -t ed25519 [-m PEM]
			"need_passphrase":false								// (可选) 默认为false，如果为true将在连接时提示输入passphrase
			// ...
		},
		// 使用gssapi进行连接
		"MyServer2":{
			"username":"",
			"gss_host":"",
			"gss_auth":true,
			"gss_kex":true,
			"gss_deleg_creds":true,
			"gss_trust_dns":true
			// ...
		},
		// ...
	},
```

# Using
打开命令选择面板并选择`SSH-Panel: Connect Server`命令

然后选择你的服务器名称进行连接

你可以在弹出的目录面板上查看和编辑服务器信息

## 快速命令按钮:
* `[?]` :帮助
* `[I]` :显示服务器信息
* `[R]` :刷新与同步文件列表
* `[E]` :编辑设置
* `[T]` :伪终端
* `[+]` :添加路径
* `[-]` :从目录视图中删除路径
你可以点击文件或目录右侧的`[...]`按钮查看其属性或在下方创建新的对象

# Style coustom

你可以通过自定义*style_css*项控制显示在output_panel和navication_view中的html样式

在sublime package路径下创建文件*"Packages\User\SSH-Panel\style.css"*，并设置*"style_css":"Packages\User\SSH-Panel\style.css"*

## css 类
```css
<!-- the following class will be load -->
<!-- The available syntax rules follow https://www.sublimetext.com/docs/minihtml.html -->
.keyword{}
.keyword_error{}
.symbol{}
.title_bar{}
.res_dir{}
.res{}
.res_focus{}
.operation_menu{}
.warning{}
.error{}
.info{}
.debug{}
.no_accessible{}
```

# Feedback
欢迎提供建议或提供代码

如果你喜欢这个项目可以给我点个star :)
