# 5.0.0

This is a large syntax change with substantial modification
to where some keywords are able to be used.

If you find bugs, especially egregious ones that break code
highlighting further down in the file, please mention them at
https://github.com/SublimeText/PowerShell/issues and include
"v5" in the title.


## Standout improvements

- Commands are recognized without Verb-Noun format.

- Command arguments are more conscientiously marked,
  including unquoted strings.

- String contents are sometimes interpreted specially,
  though not in all cases. Some examples:

    * Here-strings beginning with `using System` are
      highlighted with C#.

    * Command argument strings recognize wildcards and
      path separators.

    * Single-quoted strings in certain cases are
      highlighted with Regular Expressions.

    * Other strings recognize some format placeholders.

- `using` imports can only come at the beginning of a file.

- `meta` scopes are used in more places, which doesn't
  typically affect highlighting, but sometimes has an
  effect on ST commands.
