# Prelease invitation

Hello PowerShell user. There are improvements underway to parse PS
more consistently in Sublime Test. Some of these changes have the
potential for regressions. A summary of changes is below.

It is not perfect. And as such, I'm inviting adventurous ST users to
try it out ahead of time. If that sounds like you, open your Package
Control Settings (usually `Cmd/Ctrl`+`Shift`+`P`, "Preferences: Package
Control Settings") and add `"PowerShell"` to the array for
`install_prereleases` in the right-hand pane.

If you find bugs, especially egregious ones that break code
highlighting further down in the file, please mention them at
https://github.com/SublimeText/PowerShell/issues and include "v5" in
the title.

Thank you.


## Standout Improvements

- Commands not in Verb-Noun format are now recognized.

- Command arguments are more conscientiously marked,
  including unquoted strings.

- String contents are sometimes interpreted specially,
  though not in all cases. Some examples:

    * Here-strings beginning with `using System` are
      highlighted with C#.

    * Command argument strings recognize wildcards and
      path separators.

    * Single-quoted strings in certain cases are
      highlighted with Regular Expressions.

    * Other strings recognize formatting placeholders.

- `using` imports can only come at the beginning of a file.

- `meta` scopes are used in more places, which doesn't
  typically affect highlighting, but sometimes has an
  effect on ST commands.
