# 5.0.0 Beta

Hello PowerShell user. Welcome to the 5.0 preview!

If you find bugs, especially egregious ones that break code
highlighting further down in the file, please mention them at
https://github.com/SublimeText/PowerShell/issues and include "v5"
in the title.

Thank you.


## Standout Improvements

- Commands are recognized without Verb-Noun format.

- Command arguments are more conscientiously marked,
  including unquoted strings.

- String contents are sometimes interpreted specially,
  though not in all cases. Some examples:

    * Here-strings beginning with `using System` are
      highlighted with C#.

    * Command argument strings recognize wildcards and
      path separators.

    * Single-quoted strings in certain cases are
      highlighted with Regular Expressions.

    * Other strings recognize simple format placeholders.

- `using` imports can only come at the beginning of a file.

- `meta` scopes are used in more places, which doesn't
  typically affect highlighting, but sometimes has an
  effect on ST commands.


## Regression tracking

- [X] #213 The Containerfile package exceeds the context sanity check.
