# MarkdownEditing 2.2.1 Changelog

Your _MarkdownEditing_ plugin is updated. Enjoy new version. For any type of
feedback you can use [GitHub issues][issues].

Just FYI, you can change the color theme of MarkdownEditing. If you are willing to do so, there are [Dark][github 2] and [yellow][github 3] theme available, plus [thirdparty themes](additional-color-themes). See [configuration](configuration) section to learn **how to change the theme**.

## Bug Fixes

## New Features

* `Shift+Tab` is now default key binding to toggle folding in current sections.
* `Ctrl/Command+Shift+Tab` now toggle folding in all sections under headings of same level. FYI, `Ctrl+k,Ctrl+j/0` is a default key binding that unfolds everything. If you use this feature __a lot__ maybe you would want to add your custom key bindings like this:

```json
{ "keys": ["shift+f12"], "command": "fold_all_sections", "context":
    [
        { "key": "selector", "operator": "equal", "operand": "text.html.markdown", "match_all": true }
    ]
},
{ "keys": ["shift+f1"], "command": "fold_all_sections", "args": {"target_level": 1}, "context":
    [
        { "key": "selector", "operator": "equal", "operand": "text.html.markdown", "match_all": true }
    ]
},
{ "keys": ["shift+f2"], "command": "fold_all_sections", "args": {"target_level": 2}, "context":
    [
        { "key": "selector", "operator": "equal", "operand": "text.html.markdown", "match_all": true }
    ]
},
{ "keys": ["shift+f3"], "command": "fold_all_sections", "args": {"target_level": 3}, "context":
    [
        { "key": "selector", "operator": "equal", "operand": "text.html.markdown", "match_all": true }
    ]
},
{ "keys": ["shift+f4"], "command": "fold_all_sections", "args": {"target_level": 4}, "context":
    [
        { "key": "selector", "operator": "equal", "operand": "text.html.markdown", "match_all": true }
    ]
}
```

* `Ctrl+Shift+PageUp/Down`, `Command+Shift+PageUp/Down`(Mac) help you navigate to the next or previous heading of the any level.
* `Ctrl+Shift+Alt+PageUp/Down;`, `Command+Ctrl+PageUp/Down`(Mac) help you navigate to the next or previous heading of the same level.

## Changes

[issues]: https://github.com/SublimeText-Markdown/MarkdownEditing/issues
[github 2]: https://raw.github.com/SublimeText-Markdown/MarkdownEditing/master/screenshots/dark.png
[github 3]: https://raw.github.com/SublimeText-Markdown/MarkdownEditing/master/screenshots/yellow.png
[additional-color-themes]: https://github.com/SublimeText-Markdown/MarkdownEditing/tree/master#additional-color-themes
[configuration]: https://github.com/SublimeText-Markdown/MarkdownEditing/tree/master#configuration