# MarkdownEditing 2.1.2 Changelog

Your _MarkdownEditing_ plugin is updated. Enjoy new version. For any type of
feedback you can use [GitHub issues][issues].

## Bug Fixes

* Many fixes in linter.
* Fixed keep centered feature unintentionally switching on (thanks to @suor).
* Fixed a syntax bug with block level HTML tags.
* HTML ID attributes were appearing in the symbol list, fixed.

## New Features

* New markdown files will be automatically renamed to the first title.
* Added a command palette command for switching list bullet types (actually
added in v2.1.1 but didn't get into the changelog).

## Changes

* Lint command is renamed to `markdown_lint` (was `lint` before). If you set
custom keybinding for that, you need to update it with the new command name.

* Hotkey for linting is now removed. The command name for linting is "lint".
You can always add the following configuration to your user keymap file to
enable it.

    ```json
    { "keys": ["ctrl+shift+m"], "command": "markdown_lint", "context":
        [
            { "key": "selector", "operator": "equal", "operand": "text.html.markdown", "match_all": true }
        ]
     }
    ```

* Renamed settings key for lint feature to `mde.lint`. If you customized
one of those settings in you user settings file, you have to update `lint`
to `mde.lint`.

[issues]: https://github.com/SublimeText-Markdown/MarkdownEditing/issues
