# MarkdownEditing 3.0.0 Changelog

Your _MarkdownEditing_ plugin is updated. Enjoy new version. For any type of
feedback you can use [GitHub issues][issues].

This is a major release with several breaking changes, which are required to
fix issues, avoid possible confilcts with other packages and enhance overall
handling of user settings.

Please visit [User Guide][UserGuide] to learn more about the full set of features
and how to use them.

If you defined custom key bindings or settings you might need to check and
adjust those as commands have been renamed and all preferencesare moved to
Preferences.sublime-settings.

A set of tips is listed in the [Troubleshooting][] section of the [User Guide][UserGuide].


## Bug Fixes

### Behavior Fixes

* changing heading levels no longer requires text to be selected (fixes #78)
* changing heading levels works within block quotes
* changing heading levels no longer adds hashmarkers in the middle of a line
* auto matching heading hash tags on `enter` now works in blockquotes
* `mde_complete_underlined_headings` no longer prevents tab after `-` in new lists (fixes #177)
* `ctrl+alt+s` is disabled by default to avoid confilcts (fixes #178)
* automatic centering is enabled only if `mde.keep_centered` is `True` (fixes #259)
* reassign syntax of open markdown files after install or before uninstall (fixes #216,fixes #485)
* reset syntax specific `color_scheme` before plugin is uninstalled (fixes #493)
* internal linter now ignores front-matter (fixes #498)
* improve strikethrough color scheme rules with regards to punctuation (fixes #534)
* fix `shift+tab` not unindenting list items in some situations (fixes #545)
* fix `shift+tab` folding instead of unindenting list (fixes #552)
* fix bold/italic via `alt+b`/`alt+i` if both marker types are set to `*` (fixes #562)
* linter rule md028 correctly detects empty lines between blockquotes (fixes #564)
* linter rule md027 no longer triggers for indented lists in blockquotes (fixes #565)
* adding footnotes no longer fails if textual footnotes exist (fixes #586)
* global color scheme is the default and can optionally be replaced (fixes #436,fixes #567, fixes #595)
* avoid possible command naming conflicts with other packages (fixes #606)
* hitting `enter` after heading adds correct number of trailing hashes
  if `mde.match_heading_hashes` is `true` even if some exist already.
* hitting `enter` after heading removes trailing hashes
  if `mde.match_heading_hashes` is `false`.
* hitting `enter` in block quotes correctly adds list and task items
* hitting `enter` adds new lists/tasks/quotes if auto completion is visisble and
  `"setting.auto_complete_commit_on_tab": true`
* hitting `enter` after reference definitions no longer adds duplicates
* hitting `enter` after empty list or GFM task items removes them without terminating blockquotes
* hitting `enter` after empty blockquotes removes the blockquote markers
* disables auto-pairing of `*`, `_`, `` ` ``, `<`, ... within `<kbd></kbd>` tags
* indent/unindent list items now works within blockquotes
* `tab` and `shift+tab` correctly select next/previous field of snippets
  instead of indenting/undindenting lists or folding sections

### Syntax Fixes

Markdown syntax is backported from ST4114 to a ST3 compatible version, which provides a lot of
fixes and improvements for ST3176+.

* highlight multiline bold/italics (fixes #103)
* highlight code blocks in lists (fixes #122)
* highlight blockquote in lists (fixes #123)
* add table syntax (fixes #124)
* add critic markup (fixes #144)
* text and urls inside itallic (bold) markup work correctly (fixes #246)
* striked urls no longer break highlighting (fixes #263)
* highlight inline bold, italic and raw code blocks in link and image descriptions (fixes #404)
* line-breaks within Markdown comments no longer break highlighting (fixes #409)
* scope hard line breaks and update color schemes (fixes #470)
* prevent "Apparent recursion" error by embedding syntaxes in fenced code blocks (fixes #533)
* strikethrough followed by no space no longer disables highlighting (fixes #537)
* correctly scope bold parts of a word (fixes #553)
* don't highlight words starting with hashtag as heading (fixes #572)
* ignore info string after language identifier of code fences (fixes #577)
* scope punctuation of fenced code blocks (fixes #612)

## New Features

* heading levels can be changed incrementally via <kbd>ctrl+alt+,</kbd> 
  and <kbd>ctrl+alt+.</kbd> (fixes #78)
* _Toggle Centered Line_ added to Command Palette (fixes #118)
* a new setting `mde.list_align_text` controls whether list item text is alignt to indention levels
* key binding (`alt+t`) to create new or convert empty list item to gfm task
* key binding (`alt+x`) to toggle task lists (fixes #589)
* Color scheme quick panel lists all _MarkdownEditor-<name>.sublime-color-scheme_ files (fixes #563)
* fenced codeblocks learned to highlight DOS Batch syntax
  - Ada syntax
  - DOS batch syntax
  - Dart syntax
  - Docker syntax
  - Elixir syntax
  - GraphQL syntax
  - INI syntax
  - Jade syntax
  - JSX syntax
  - Julia syntax
  - Kotlin syntax
  - Matlab syntax
  - Mermaid syntax
  - NIM/NIX syntax
  - PowerShell syntax
  - R syntax (fixes #569)
  - STATA syntax (fixes #560)
  - TOML syntax
  - TSX syntax
* key bindings and snippets to easily insert, accept or reject critic markup
  - press `alt+c, alt+a` to insert addition
  - press `alt+c, alt+d` to insert deletion
  - press `alt+c, alt+h` to insert highlight
  - press `alt+c, alt+s` to insert substitution
  - press `alt+c, alt+c` to insert comment
  - press `alt+enter` to accept critic
  - press `alt+backspace` to reject critic

## Changes

* All syntaxes use sublime-syntax format (fixes #324)
* Requires ST 3176+ (closes #463)
* Opt-in to ST4's python3.8 plugin host
* Reorganize all python modules in a _plugins_ sub directory
* Merge several python modules to group functions logically
* Removed most syntax specific settings (fixes #209, fixes #501, fixes #509)
* Settings are displayed side-by-side (fixes #609)
* Settings are now placed in Preferences.sublime-settings
* Reorganize key bindings to group them by logical function
* MultiMarkdown is converted to sublime-syntax format
* Bold/Italics style is now configured via Preferences
  (removed _Bold and Italic Markers.tmPreferences_)
* The `mde_fold_section` command now respects previously set folding level
  (Results in more consistend and logical behavior when combined wth `mde_fold_all_sections`)
* new commands:
  - `mde_change_headings_level`
  - `mde_fold_links`
  - `mde_match_heading_hashes`
  - `mde_toggle_centered_line`
  - `mde_toggle_task_list_item`
  - `unindent_list_item` replaces `indent_list_item(reverse=True)` 
    and `indent_list_multiitem(reverse=True)`
* removed commands:
  - `indent_list_multiitem`
* renamed commands (all commands are prefixed with `mde_`):
  - `complete_underlined_header` -> `mde_complete_underlined_headings`
  - `convert_inline_link_to_reference` -> `mde_convert_inline_link_to_reference`
  - `convert_inline_links_to_references` -> `mde_convert_inline_links_to_references`
  - `convert_to_atx` -> `mde_convert_underlined_headings_to_atx`
  - `deindent_quote` -> `mde_unindent_quote`
  - `fix_all_underlined_headers` -> `mde_fix_underlined_headings`
  - `fold_all_sections` -> `mde_fold_all_sections`
  - `fold_section` -> `mde_fold_section`
  - `gather_missing_footnotes` -> `mde_gather_missing_footnotes`
  - `gather_missing_link_markers` -> `mde_gather_missing_link_markers`
  - `goto_next_heading` -> `mde_goto_next_heading`
  - `goto_previous_heading` -> `mde_goto_previous_heading`
  - `indent_list_item` -> `mde_indent_list_item` (is used for all items/situations) (fixes #530)
  - `indent_quote` -> `mde_indent_quote`
  - `list_back_links` -> `mde_list_back_links`
  - `magic_footnotes` -> `mde_magic_footnotes`
  - `make_page_reference` -> `mde_make_page_reference`
  - `markdown_lint` -> `mde_markdown_lint`
  - `markdown_lint_mdl` -> `mde_markdown_lint_mdl`
  - `mde_color_activate` -> `mde_select_color_scheme`
  - `number_list` -> `mde_number_list`
  - `number_list_reference` -> `mde_add_numbered_reference_definition`
  - `open_home_page` -> `mde_open_home_page`
  - `open_journal` -> `mde_open_journal`
  - `open_page` -> `mde_open_page`
  - `reference_delete_reference` -> `mde_reference_delete_reference`
  - `reference_jump` -> `mde_reference_jump`
  - `reference_new_footnote` -> `mde_reference_new_footnote`
  - `reference_new_image` -> `mde_reference_new_image`
  - `reference_new_inline_image` -> `mde_reference_new_inline_image`
  - `reference_new_inline_link` -> `mde_reference_new_inline_link`
  - `reference_new_reference` -> `mde_reference_new_reference`
  - `reference_organize` -> `mde_reference_organize`
  - `show_fold_all_sections` -> `mde_show_fold_all_sections`
  - `switch_list_bullet_type` -> `mde_switch_list_bullet_type`
  - `unfold_all_sections` -> `mde_unfold_all_sections`
* renamed settings:
  - `mde.match_haeder_hash` -> `mde.match_heading_hashes`

[issues]: https://github.com/SublimeText-Markdown/MarkdownEditing/issues
[UserGuide]: https://sublimetext-markdown.github.io/MarkdownEditing
[Troubleshooting]: https://sublimetext-markdown.github.io/MarkdownEditing/troubleshooting
