# MarkdownEditing 2.2.7 Changelog

Your _MarkdownEditing_ plugin is updated. Enjoy new version. For any type of
feedback you can use [GitHub issues][issues].

## Bug Fixes

* Fixed an issue in setting files that caused failure on ST2.
* Fixes many issues regarding to "unclosed code block" like this (notice `<?php` tag never gets closed):
    ```php
    <?php
    namespace My\Name\Space;

    class MyClass extends \Original\ClassName {

    public function myFunction() {
        # Do something...
    }

    }# Notice no closing PHP tags
    ```
    This fix only works on the newest Sublime Text 3 stable build (3170), and ***it may cause regression on prior builds***. If you have to stick to a previous ST3 release, consider manually downloading [MDE 2.2.6](mde226).

## New Features

* To surround an URL with '<>', select the whole URL, then press '<'.
* Support highlight with Rust language.
* Enables styling of ">" quotes when inside either numbered and un-numbered lists.

## Changes

* As stated previously, you need to upgrade to newest Sublime Text 3 stable build (3170) for code blocks to work.
* **Wiki**: when creating a new wiki page, a template file configured by "mde.wikilinks.templates" setting will be used if possible. The template file currently supports "$title" placeholder.

## Note

There is a known issue with Sublime Text Dev Build that causes highlight in some code blocks (notably JavaScript and JSON) not closing as intended. I recommend using stable version for now.

[issues]: https://github.com/SublimeText-Markdown/MarkdownEditing/issues
[mde226]: https://github.com/SublimeText-Markdown/MarkdownEditing/releases/tag/2.2.6