# MarkdownEditing 2.2.6 Changelog

Your _MarkdownEditing_ plugin is updated. Enjoy new version. For any type of
feedback you can use [GitHub issues][issues].

## Call for Maintainers!

MarkdownEditing is an open-sourced and free project aiming to improve markdown experience on Sublime Text 3. If you like this package and want to help it move forward, please check below [Call for Maintainers](#call-for-maintainers) section.

## Bug Fixes

* Save dialog now uses proper file extensions on Markdown (Standard) and MultiMarkdown.

## New Features

* Haskell syntax is supported in code blocks.
* Wiki features are added (see below _Wiki features_), credits to [Dave Ellis](https://github.com/dave-ellis).
* MDE now supports [markdownlint](https://github.com/markdownlint/markdownlint) package for linting. To use this, you need to install markdownlint first (it requires Ruby). Then use `MarkdownEditing: Run markdownlint`. markdownlint is highly configurable, check [its document](https://github.com/markdownlint/markdownlint/blob/master/docs/configuration.md) for configuration options. It is also always possible to use [ST Build System](http://docs.sublimetext.info/en/latest/file_processing/build_systems.html) to automate linting, rendering to HTML or PDF etc for advanced users.
* Github style comment `<!--- comment --->` is now supported in Markdown GFM.

## Changes

* (Windows/Linux) Keybindings for `New Inline Link` and `New Reference` are changed to `Ctrl+Alt+v` and `Ctrl+Alt+r`, from `Ctrl+Super+v` and `Ctrl+Super+r`, due to the conflict with Win10 `Open Shoulder Tap` shortcut. Keybindings on Mac are not affected.
* Background color of http links in the default color is disabled, due to being distracting.

## (New) Wiki Features

Wiki features are intended for wiki writers.

Wiki links are defined by surrounding a (wiki) word with double square brackets, for example:

    [[SampleWikiPage]]

The user can `open` wiki page using a sublime command.  This will search the current open file's directory (and sub-directories) for a file with a matching name and a markdown extension.  For example, opening the previous wiki link
will look for and open a file named:

    SampleWikiPage.md

Note that, if the wiki page does *not* yet exist, if will be created with a header matching the page name.  However the file will only actually be created on the file system, when it is saved by the user.  

The user can `list back links` and of course to open them.  Back links are pages that reference the current page.  This allows pages to be tied together into a personal wiki.   A common technique is to define *tag* wiki pages and to list any tags for a page as references to the tag pages at the bottom of the page, for example:
    
    [[TagSyntax]] [[TagDev]] [[TagPython]]

This allows the user to list all pages with a specific tag, by opening the tag page and list all back links.

Journal wiki pages are also supported.  A journal page is just a wiki page with a name matching the current date.

Lastly the command to open the *home* page is provided, where the home page is just a wiki page named `HomePage`.

For more info on wiki features, please refer to this pull request: https://github.com/SublimeText-Markdown/MarkdownEditing/pull/486

## Call for Maintainers

This project was created by Brett Terpstra back in 2012. After a few transfers and now the maintainance is majorly headed by Felix Hao (me). However given the recent changes in my career I won't be able to devote as much time to MDE as I did for the past three years. So here is a call for volunteer maintainers to keep this project going forward.

### Where to start?

At this time of writing this message, there are 74 open issues. It would be great if we can cut the number down to less than 50 at all time. Sometimes an issue is a misuse, but more often it is a bug or bad design.

The project source is hosted on [Github](https://github.com/SublimeText-Markdown/MarkdownEditing). `CONTRIBUTING.md` has some general guides worth checking out too.

[issues]: https://github.com/SublimeText-Markdown/MarkdownEditing/issues
