# MarkdownEditing 2.2.3 Changelog

Your _MarkdownEditing_ plugin is updated. Enjoy new version. For any type of
feedback you can use [GitHub issues][issues].

## Bug Fixes

* Link references commands (Jump/Delete/Organize) now work correctly with no-link `[link text]` style and ignore cases.
* `[link text]` is now highlighted correctly.
* Folding correctly ignores fake titles in code blocks.

## New Features

* You can now disable some of the key bindings through configuration. For example, if you want to disable the "shift+tab" => "fold current section" key binding, add `"mde.keymap_disable.fold_section": true` to your user config. For a full list of such key bindings, check the list below.
* Organize References command now sorts references by referencing order rather than alphebetic order.
* Code block highlight for clojure.
* You can use `MarkdownEditing: Change color scheme...` command in command palette to preview and change the color scheme you are using for markdown.
* Added `MDE: (Un)Fold Section` and `MDE: Jump Reference` to context menu (only appear if applicable based on the cursor's location).

### Configurable Key Bindings

```json
{
    // Jump between link/image/footnote reference and definition
    // Default keys: (OSX)super+ctrl+shift+l    (Linux/Win)ctrl+alt+g
    "mde.keymap_disable.reference_jump": false,
    // Add a new link
    // Default keys: (OSX)super+alt+r   (Linux/Win)ctrl+super+r
    "mde.keymap_disable.reference_new_reference": false,
    // Add a new inline link
    // Default keys: (OSX)super+alt+v   (Linux/Win)ctrl+super+v
    "mde.keymap_disable.reference_new_inline_link": false,
    // Add a new inline image
    // Default keys: (OSX/Linux/Win)super+shift+k
    "mde.keymap_disable.reference_new_inline_image": false,
    // Add a new footnote
    // Default keys: (OSX/Linux/Win)alt+shift+6
    "mde.keymap_disable.reference_new_footnote": false,
    // Fold current section
    // Default keys: (OSX/Linux/Win)shift+tab
    "mde.keymap_disable.fold_section": false,
    // Open a panel showing all functions related to folding
    // Default keys: (OSX/Linux/Win)ctrl+shift+tab
    "mde.keymap_disable.show_fold_all_sections": false,
    // Jump to the next heading (any level/same or higher level)
    // Default keys: (OSX)super+ctrl/shift+pagedown (Linux/Win)ctrl+shift(+alt)+pagedown
    "mde.keymap_disable.goto_next_heading": false,
    // Jump to the previous heading (any level/same or higher level)
    // Default keys: (OSX)super+ctrl/shift+pageup   (Linux/Win)ctrl+shift(+alt)+pageup
    "mde.keymap_disable.goto_previous_heading": false
}
```

## Changes

[issues]: https://github.com/SublimeText-Markdown/MarkdownEditing/issues
