# MarkdownEditing 2.0.4 Changelog

Your _MarkdownEditing_ plugin is updated. Enjoy new version. For any type of feedback you can use [GitHub issues][issues].

## Bug Fixes

* Separator (`***`) background color was almost unnoticeable, fixed for all the themes.
* Space obligation after `>` in blockquotes was removed in previous versions but it didn't apply to the _standard_ Markdown syntax file. Fixed.
* `<`, `>` and `&` characters inside list paragraphs was highlighted as error for _standard_ Markdown syntax. Fixed.
* Auto increment on ordered lists was broken for multi-digit numbers. Fixed. ([#109][])

## New Features

* Caret is now taller similar to iA Writer. Works in only Sublime Text Build 3057 and above.
* MultiMarkdown now imports GitHub flavored markdown instead of standard markdown.
    _Description_: MultiMarkdown syntax file doesn't redefine things, instead imports standard markdown syntax file. With this version, it imports GFM syntax file instead of the standard one. GFM has had many bug fixes and improvements over the standard md syntax file. So hopefully, MultiMarkdown users will benefit from this improvements, too.
* Pressing `Tab` on a blank list item now indents it. `Shift Tab` will do the reverse. List bullet will change on each indent/unindent. You can disable automatic list bullet switching or choose which bullets to be used, in your settings file.

## Changes

* Highlighting current line is now disabled. If you want it back, you can do so in your user settings file which is one of:
    - `Packages/User/Markdown.sublime-settings`
    - `Packages/User/Markdown (Standard).sublime-settings`
    - `Packages/User/MultiMarkdown.sublime-settings`

    If you are using the (immature) focus theme, you have to reenable "highlighting current line"; because, the focus theme relies on that. On the other hand, the theme is likely to be changed a lot or totally replaced by a new feature in the future.

* Listening to _too many_ users, now the plugin doesn't set any font settings in the defaults. If you were happy with the default font settings, you may want to re-add them to your user settings file of your favorite flavor which is one of:
    - `Packages/User/Markdown.sublime-settings`
    - `Packages/User/Markdown (Standard).sublime-settings`
    - `Packages/User/MultiMarkdown.sublime-settings`

    The font settings for Mac/Linux were:

        "font_face": "Menlo",
        "font_options": [ "subpixel_antialias", "no_round", "directwrite"],

    and for Windows:

        "font_face": "Consolas"

* Bold and italic key bindings (`Ctrl B/I`) are changed due to some conflicts that are reported several time by users. They are now:
    - `Super Alt B/I` for OS X
    - `Ctrl Shift B/I` for Windows/Linux

* Setting keys changed. If you used any of these in your user setting files, please reflect these changes to those files. Changes:
    * `mde_match_header_hashes`       -> `mde.match_header_hashes`
    * `mde_keep_centered`             -> `mde.keep_centered`
    * `mde_distraction_free_mode`     -> `mde.distraction_free_mode`

[issues]: https://github.com/SublimeText-Markdown/MarkdownEditing/issues
[#109]: https://github.com/SublimeText-Markdown/MarkdownEditing/issues/109
