"""
Utilities to get a password and/or the current user name.

getpass(prompt[, stream]) - Prompt for a password, with echo turned off.
getuser() - Get the user name from the environment or password database.

GetPassWarning - This UserWarning is issued when getpass() cannot prevent
                 echoing of the password contents while reading.

On Windows, the msvcrt module will be used.
"""

from typing import TextIO

__all__ = ["getpass", "getuser", "GetPassWarning"]

def getpass(prompt: str = "Password: ", stream: TextIO | None = None) -> str:
    """Prompt for password with echo off, using Windows getwch()."""
    ...
def getuser() -> str:
    """
    Get the username from the environment or password database.

    First try various environment variables, then the password
    database.  This works on Windows as long as USERNAME is set.
    Any failure to find a username raises OSError.

    .. versionchanged:: 3.13
        Previously, various exceptions beyond just :exc:`OSError`
        were raised.
    """
    ...

class GetPassWarning(UserWarning): ...
