"""
Facility to use the Expat parser to load a minidom instance
from a string or file.

This avoids all the overhead of SAX and pulldom to gain performance.
"""

from _typeshed import Incomplete, ReadableBuffer, SupportsRead
from typing import Any, NoReturn
from xml.dom.minidom import Document, DOMImplementation, Node, TypeInfo
from xml.dom.xmlbuilder import DOMBuilderFilter, Options

TEXT_NODE = Node.TEXT_NODE
CDATA_SECTION_NODE = Node.CDATA_SECTION_NODE
DOCUMENT_NODE = Node.DOCUMENT_NODE
FILTER_ACCEPT = DOMBuilderFilter.FILTER_ACCEPT
FILTER_REJECT = DOMBuilderFilter.FILTER_REJECT
FILTER_SKIP = DOMBuilderFilter.FILTER_SKIP
FILTER_INTERRUPT = DOMBuilderFilter.FILTER_INTERRUPT
theDOMImplementation: DOMImplementation | None

class ElementInfo:
    tagName: Incomplete
    def __init__(self, tagName, model: Incomplete | None = None) -> None: ...
    def getAttributeType(self, aname) -> TypeInfo: ...
    def getAttributeTypeNS(self, namespaceURI, localName) -> TypeInfo: ...
    def isElementContent(self) -> bool: ...
    def isEmpty(self) -> bool: ...
    def isId(self, aname) -> bool: ...
    def isIdNS(self, euri, ename, auri, aname) -> bool: ...

class ExpatBuilder:
    """
    Document builder that uses Expat to build a ParsedXML.DOM document
    instance.
    """
    document: Document  # Created in self.reset()
    curNode: Incomplete  # Created in self.reset()
    def __init__(self, options: Options | None = None) -> None: ...
    def createParser(self):
        """Create a new parser object."""
        ...
    def getParser(self):
        """Return the parser object, creating a new one if needed."""
        ...
    def reset(self) -> None:
        """Free all data structures used during DOM construction."""
        ...
    def install(self, parser) -> None:
        """Install the callbacks needed to build the DOM into the parser."""
        ...
    def parseFile(self, file: SupportsRead[ReadableBuffer | str]) -> Document:
        """
        Parse a document from a file object, returning the document
        node.
        """
        ...
    def parseString(self, string: str | ReadableBuffer) -> Document:
        """Parse a document from a string, returning the document node."""
        ...
    def start_doctype_decl_handler(self, doctypeName, systemId, publicId, has_internal_subset) -> None: ...
    def end_doctype_decl_handler(self) -> None: ...
    def pi_handler(self, target, data) -> None: ...
    def character_data_handler_cdata(self, data) -> None: ...
    def character_data_handler(self, data) -> None: ...
    def start_cdata_section_handler(self) -> None: ...
    def end_cdata_section_handler(self) -> None: ...
    def entity_decl_handler(self, entityName, is_parameter_entity, value, base, systemId, publicId, notationName) -> None: ...
    def notation_decl_handler(self, notationName, base, systemId, publicId) -> None: ...
    def comment_handler(self, data) -> None: ...
    def external_entity_ref_handler(self, context, base, systemId, publicId) -> int: ...
    def first_element_handler(self, name, attributes) -> None: ...
    def start_element_handler(self, name, attributes) -> None: ...
    def end_element_handler(self, name) -> None: ...
    def element_decl_handler(self, name, model) -> None: ...
    def attlist_decl_handler(self, elem, name, type, default, required) -> None: ...
    def xml_decl_handler(self, version, encoding, standalone) -> None: ...

class FilterVisibilityController:
    """
    Wrapper around a DOMBuilderFilter which implements the checks
    to make the whatToShow filter attribute work.
    """
    filter: DOMBuilderFilter
    def __init__(self, filter: DOMBuilderFilter) -> None: ...
    def startContainer(self, node: Node) -> int: ...
    def acceptNode(self, node: Node) -> int: ...

class FilterCrutch:
    def __init__(self, builder) -> None: ...

class Rejecter(FilterCrutch):
    def start_element_handler(self, *args: Any) -> None: ...
    def end_element_handler(self, *args: Any) -> None: ...

class Skipper(FilterCrutch):
    def start_element_handler(self, *args: Any) -> None: ...
    def end_element_handler(self, *args: Any) -> None: ...

class FragmentBuilder(ExpatBuilder):
    """
    Builder which constructs document fragments given XML source
    text and a context node.

    The context node is expected to provide information about the
    namespace declarations which are in scope at the start of the
    fragment.
    """
    fragment: Incomplete | None
    originalDocument: Incomplete
    context: Incomplete
    def __init__(self, context, options: Options | None = None) -> None: ...

class Namespaces:
    """Mix-in class for builders; adds support for namespaces."""
    def createParser(self):
        """Create a new namespace-handling parser."""
        ...
    def install(self, parser) -> None:
        """Insert the namespace-handlers onto the parser."""
        ...
    def start_namespace_decl_handler(self, prefix, uri) -> None:
        """Push this namespace declaration on our storage."""
        ...
    def start_element_handler(self, name, attributes) -> None: ...
    def end_element_handler(self, name) -> None: ...

class ExpatBuilderNS(Namespaces, ExpatBuilder):
    """Document builder that supports namespaces."""
    ...
class FragmentBuilderNS(Namespaces, FragmentBuilder):
    """Fragment builder that supports namespaces."""
    ...
class ParseEscape(Exception):
    """Exception raised to short-circuit parsing in InternalSubsetExtractor."""
    ...

class InternalSubsetExtractor(ExpatBuilder):
    """XML processor which can rip out the internal document type subset."""
    subset: Any | None
    def getSubset(self) -> Any | None:
        """Return the internal subset as a string."""
        ...
    def parseFile(self, file: SupportsRead[ReadableBuffer | str]) -> None: ...  # type: ignore[override]
    def parseString(self, string: str | ReadableBuffer) -> None: ...  # type: ignore[override]
    def start_doctype_decl_handler(self, name, publicId, systemId, has_internal_subset) -> None: ...  # type: ignore[override]
    def end_doctype_decl_handler(self) -> NoReturn: ...
    def start_element_handler(self, name, attrs) -> NoReturn: ...

def parse(file: str | SupportsRead[ReadableBuffer | str], namespaces: bool = True):
    """
    Parse a document, returning the resulting Document node.

    'file' may be either a file name or an open file object.
    """
    ...
def parseString(string: str | ReadableBuffer, namespaces: bool = True):
    """
    Parse a document from a string, returning the resulting
    Document node.
    """
    ...
def parseFragment(file, context, namespaces: bool = True):
    """
    Parse a fragment of a document, given the context from which it
    was originally extracted.  context should be the parent of the
    node(s) which are in the fragment.

    'file' may be either a file name or an open file object.
    """
    ...
def parseFragmentString(string: str, context, namespaces: bool = True):
    """
    Parse a fragment of a document from a string, given the context
    from which it was originally extracted.  context should be the
    parent of the node(s) which are in the fragment.
    """
    ...
def makeBuilder(options: Options) -> ExpatBuilderNS | ExpatBuilder:
    """Create a builder based on an Options object."""
    ...
