"""A pure Python implementation of import."""

import sys
from collections.abc import Mapping, Sequence
from importlib.abc import Loader
from types import ModuleType

__all__ = ["__import__", "import_module", "invalidate_caches", "reload"]

# Signature of `builtins.__import__` should be kept identical to `importlib.__import__`
def __import__(
    name: str,
    globals: Mapping[str, object] | None = None,
    locals: Mapping[str, object] | None = None,
    fromlist: Sequence[str] = (),
    level: int = 0,
) -> ModuleType:
    """
    Import a module.

    The 'globals' argument is used to infer where the import is occurring from
    to handle relative imports. The 'locals' argument is ignored. The
    'fromlist' argument specifies what should exist as attributes on the module
    being imported (e.g. ``from module import <fromlist>``).  The 'level'
    argument represents the package location to import from in a relative
    import (e.g. ``from ..pkg import mod`` would have a 'level' of 2).
    """
    ...

# `importlib.import_module` return type should be kept the same as `builtins.__import__`
def import_module(name: str, package: str | None = None) -> ModuleType:
    """
    Import a module.

    The 'package' argument is required when performing a relative import. It
    specifies the package to use as the anchor point from which to resolve the
    relative import to an absolute import.
    """
    ...

if sys.version_info < (3, 12):
    def find_loader(name: str, path: str | None = None) -> Loader | None: ...

def invalidate_caches() -> None:
    """
    Call the invalidate_caches() method on all meta path finders stored in
    sys.meta_path (where implemented).
    """
    ...
def reload(module: ModuleType) -> ModuleType:
    """
    Reload the module and return it.

    The module must have been successfully imported before.
    """
    ...
