import os
import sys
from pathlib import Path

sys.path.append(str(Path(__file__).resolve().parent.parent))

from modules.github_utils import get_latest_release_version  # noqa: E402


def main():
    latest = get_latest_release_version("clangd/clangd")
    with open("modules/version.py", "w") as f:
        f.write(f"""# This file is auto-generated by {__file__}

CLANGD_VERSION = {latest}
""")


if __name__ == "__main__":
    main()
