=> 1.2.0

## New Features

- Allow users to decide the order of strategies finding venv

  Previously, this is hard-coded. Now the user can specify the order of strategies in the settings.
  By default, a `.venv` or `venv` directory under the workspace project is prioritized.

  ```js
  {
    "settings": {
      "venvStrategies": [
        "local_dot_venv",
        "env_var_conda_prefix",
        "env_var_virtual_env",
        "rye",
        "poetry",
        "pdm",
        "hatch",
        "pipenv",
        "pyenv",
        "any_subdirectory",
      ],
    }
  }
  ```

- Templated status bar text

  If a venv is detected, its information will be shown in that status bar.
  The user can customize the status bar text with Jinja2 template grammar.

  ```js
  {
    "settings": {
      "statusText": "{% if venv %}venv: {{ venv.venv_prompt }}; py: {{ venv.python_version }}; by: {{ venv.finder_name }}{% endif %}",
    }
  }
  ```
