"""
RAL colors.

A simple code to hex map of RAL colors.

https://www.ral-farben.de/en/all-ral-colours
"""


def code2hex(name):
    """Convert color code to CSS hex."""

    return classic_2hex_map.get(name, None)


classic_2hex_map = {
    "RAL 000 15 00": "#252626",
    "RAL 000 20 00": "#2e2f2f",
    "RAL 000 25 00": "#3b3c3d",
    "RAL 000 30 00": "#444545",
    "RAL 000 35 00": "#505151",
    "RAL 000 40 00": "#5c5c5c",
    "RAL 000 45 00": "#696969",
    "RAL 000 50 00": "#737575",
    "RAL 000 55 00": "#808081",
    "RAL 000 60 00": "#8c8d8d",
    "RAL 000 65 00": "#9c9c9d",
    "RAL 000 70 00": "#a9aaaa",
    "RAL 000 75 00": "#b7b8b8",
    "RAL 000 80 00": "#c6c6c5",
    "RAL 000 85 00": "#d3d4d2",
    "RAL 000 90 00": "#e0e1df",
    "RAL 010 20 10": "#3c2d2f",
    "RAL 010 20 15": "#3f272c",
    "RAL 010 20 20": "#44242b",
    "RAL 010 20 25": "#48202b",
    "RAL 010 30 10": "#544244",
    "RAL 010 30 15": "#573e43",
    "RAL 010 30 20": "#5d3b42",
    "RAL 010 30 25": "#633640",
    "RAL 010 30 30": "#68323f",
    "RAL 010 30 35": "#6a2b3b",
    "RAL 010 30 40": "#732139",
    "RAL 010 30 44": "#79143b",
    "RAL 010 40 10": "#6a595b",
    "RAL 010 40 15": "#705458",
    "RAL 010 40 20": "#765258",
    "RAL 010 40 25": "#7c4e57",
    "RAL 010 40 30": "#824955",
    "RAL 010 40 35": "#854452",
    "RAL 010 40 40": "#8b3d51",
    "RAL 010 40 45": "#933851",
    "RAL 010 40 50": "#98304f",
    "RAL 010 40 53": "#9b274d",
    "RAL 010 50 10": "#827074",
    "RAL 010 50 15": "#886c71",
    "RAL 010 50 20": "#8d686f",
    "RAL 010 50 25": "#95646e",
    "RAL 010 50 30": "#9d5f6c",
    "RAL 010 50 35": "#a15a6a",
    "RAL 010 50 40": "#a6576a",
    "RAL 010 50 45": "#ab5168",
    "RAL 010 50 50": "#b54867",
    "RAL 010 60 10": "#9c898c",
    "RAL 010 60 15": "#a4868b",
    "RAL 010 60 20": "#ab8289",
    "RAL 010 60 25": "#b27c88",
    "RAL 010 60 30": "#b87886",
    "RAL 010 60 35": "#c07384",
    "RAL 010 60 40": "#c66e82",
    "RAL 010 60 45": "#ce6980",
    "RAL 010 70 10": "#b9a4a7",
    "RAL 010 70 15": "#bfa0a5",
    "RAL 010 70 20": "#c89ca4",
    "RAL 010 70 25": "#cf97a2",
    "RAL 010 70 30": "#d594a0",
    "RAL 010 70 35": "#dd8e9d",
    "RAL 010 80 10": "#d5bec0",
    "RAL 010 80 15": "#dcbabf",
    "RAL 010 80 20": "#e5b7be",
    "RAL 010 85 05": "#d8cecf",
    "RAL 010 85 10": "#decace",
    "RAL 010 85 15": "#e7c8ce",
    "RAL 010 85 20": "#eec7ce",
    "RAL 010 90 05": "#ebdedc",
    "RAL 010 90 10": "#edd8d6",
    "RAL 010 93 05": "#ede3e5",
    "RAL 020 20 05": "#352e2e",
    "RAL 020 20 10": "#3b2a2b",
    "RAL 020 20 20": "#452629",
    "RAL 020 20 29": "#4f1a23",
    "RAL 020 30 05": "#4b4343",
    "RAL 020 30 10": "#51403f",
    "RAL 020 30 20": "#5d3a3b",
    "RAL 020 30 30": "#653035",
    "RAL 020 30 40": "#722432",
    "RAL 020 30 48": "#7a0b2d",
    "RAL 020 40 05": "#645b5b",
    "RAL 020 40 10": "#685757",
    "RAL 020 40 20": "#745152",
    "RAL 020 40 30": "#7f494c",
    "RAL 020 40 40": "#893e47",
    "RAL 020 40 50": "#932e40",
    "RAL 020 50 05": "#7c7372",
    "RAL 020 50 10": "#816f6f",
    "RAL 020 50 20": "#8e6969",
    "RAL 020 50 30": "#9a6163",
    "RAL 020 50 40": "#a4565e",
    "RAL 020 50 50": "#b14b59",
    "RAL 020 50 58": "#bf4355",
    "RAL 020 60 05": "#948b8b",
    "RAL 020 60 10": "#9b8888",
    "RAL 020 60 20": "#a88283",
    "RAL 020 60 30": "#b5797c",
    "RAL 020 60 40": "#c27078",
    "RAL 020 70 05": "#b0a6a6",
    "RAL 020 70 10": "#b5a2a2",
    "RAL 020 70 20": "#c79d9f",
    "RAL 020 70 30": "#d59598",
    "RAL 020 80 05": "#cec3c2",
    "RAL 020 80 10": "#d3bdbd",
    "RAL 020 80 20": "#e3b7ba",
    "RAL 020 85 05": "#dacfce",
    "RAL 020 85 10": "#e0caca",
    "RAL 020 85 20": "#f1c7c6",
    "RAL 020 90 05": "#ece1dc",
    "RAL 020 90 10": "#eddbd7",
    "RAL 020 93 05": "#f1e4e1",
    "RAL 030 30 10": "#514340",
    "RAL 030 30 20": "#5b3c38",
    "RAL 030 30 30": "#653430",
    "RAL 030 30 40": "#722b2c",
    "RAL 030 30 45": "#742529",
    "RAL 030 40 10": "#665855",
    "RAL 030 40 20": "#75544f",
    "RAL 030 40 30": "#804d48",
    "RAL 030 40 40": "#8a433f",
    "RAL 030 40 50": "#963838",
    "RAL 030 40 60": "#9f2833",
    "RAL 030 50 10": "#816f6c",
    "RAL 030 50 20": "#8c6a64",
    "RAL 030 50 30": "#99635c",
    "RAL 030 50 40": "#a65c55",
    "RAL 030 50 50": "#b0524e",
    "RAL 030 50 60": "#bc4444",
    "RAL 030 60 10": "#9a8986",
    "RAL 030 60 20": "#a8837e",
    "RAL 030 60 30": "#b77674",
    "RAL 030 60 40": "#c1756e",
    "RAL 030 60 50": "#cd6b65",
    "RAL 030 70 10": "#b6a3a0",
    "RAL 030 70 20": "#c59b95",
    "RAL 030 70 30": "#d3958d",
    "RAL 030 70 40": "#e08d85",
    "RAL 030 80 10": "#d3bdba",
    "RAL 030 80 20": "#e3b6b2",
    "RAL 030 85 05": "#d9ccc7",
    "RAL 030 85 10": "#decac5",
    "RAL 030 85 20": "#ecc9bf",
    "RAL 030 90 05": "#eadeda",
    "RAL 030 90 10": "#f0ddd6",
    "RAL 030 93 05": "#f4e8e4",
    "RAL 040 20 19": "#442b21",
    "RAL 040 30 05": "#4b4441",
    "RAL 040 30 10": "#4e413a",
    "RAL 040 30 20": "#593d32",
    "RAL 040 30 30": "#633729",
    "RAL 040 30 40": "#6d3425",
    "RAL 040 40 05": "#635b58",
    "RAL 040 40 10": "#675952",
    "RAL 040 40 20": "#72554a",
    "RAL 040 40 30": "#7b4e3e",
    "RAL 040 40 40": "#854532",
    "RAL 040 40 50": "#8f412a",
    "RAL 040 40 60": "#96341e",
    "RAL 040 40 67": "#a03326",
    "RAL 040 50 05": "#7b7370",
    "RAL 040 50 10": "#80716a",
    "RAL 040 50 20": "#8c6c60",
    "RAL 040 50 30": "#986655",
    "RAL 040 50 40": "#a1604b",
    "RAL 040 50 50": "#ad5840",
    "RAL 040 50 60": "#bb5237",
    "RAL 040 50 70": "#bf4a30",
    "RAL 040 60 05": "#958c89",
    "RAL 040 60 10": "#9b8a82",
    "RAL 040 60 20": "#a58376",
    "RAL 040 60 30": "#b3806d",
    "RAL 040 60 40": "#bc7961",
    "RAL 040 60 50": "#ca7357",
    "RAL 040 60 60": "#d26c4d",
    "RAL 040 70 05": "#afa6a3",
    "RAL 040 70 10": "#b7a49c",
    "RAL 040 70 20": "#c59f91",
    "RAL 040 70 30": "#d19986",
    "RAL 040 70 40": "#d7957c",
    "RAL 040 70 50": "#e78d6f",
    "RAL 040 80 05": "#cdc3bf",
    "RAL 040 80 10": "#d5c2b9",
    "RAL 040 80 20": "#e5beaf",
    "RAL 040 80 30": "#f0b8a3",
    "RAL 040 85 05": "#dcd0cb",
    "RAL 040 85 10": "#e3cfc5",
    "RAL 040 85 20": "#f0cab9",
    "RAL 040 90 05": "#ece0d9",
    "RAL 040 90 10": "#f1dfd3",
    "RAL 040 93 05": "#f2e8e1",
    "RAL 050 20 10": "#3a3028",
    "RAL 050 20 16": "#3f2d21",
    "RAL 050 30 10": "#4c4137",
    "RAL 050 30 20": "#573f2d",
    "RAL 050 30 30": "#613c26",
    "RAL 050 30 36": "#663b20",
    "RAL 050 40 10": "#675a50",
    "RAL 050 40 20": "#6e5644",
    "RAL 050 40 30": "#775239",
    "RAL 050 40 40": "#7f4d2a",
    "RAL 050 40 50": "#8a4924",
    "RAL 050 50 10": "#7f7469",
    "RAL 050 50 20": "#89705c",
    "RAL 050 50 30": "#936b4f",
    "RAL 050 50 40": "#9c6543",
    "RAL 050 50 50": "#a66136",
    "RAL 050 50 60": "#aa5a2a",
    "RAL 050 50 70": "#b7510e",
    "RAL 050 50 78": "#be5b1c",
    "RAL 050 60 10": "#988b7f",
    "RAL 050 60 20": "#a28671",
    "RAL 050 60 30": "#b18466",
    "RAL 050 60 40": "#b77f59",
    "RAL 050 60 50": "#c37c4d",
    "RAL 050 60 60": "#cd763e",
    "RAL 050 60 70": "#d16c31",
    "RAL 050 60 80": "#dc6621",
    "RAL 050 70 10": "#b5a79c",
    "RAL 050 70 20": "#c0a48e",
    "RAL 050 70 30": "#cb9f80",
    "RAL 050 70 40": "#d79a73",
    "RAL 050 70 50": "#df9566",
    "RAL 050 70 60": "#e98f57",
    "RAL 050 80 10": "#d2c3b6",
    "RAL 050 80 20": "#ddbea6",
    "RAL 050 80 30": "#e8b999",
    "RAL 050 85 05": "#ddd1c9",
    "RAL 050 85 10": "#ddcdbf",
    "RAL 050 85 20": "#ebcbb2",
    "RAL 050 90 05": "#e9ded5",
    "RAL 050 90 10": "#f4e1d3",
    "RAL 050 93 05": "#f3eae2",
    "RAL 060 20 05": "#35322f",
    "RAL 060 30 05": "#4a453f",
    "RAL 060 30 10": "#4d4338",
    "RAL 060 30 20": "#54422d",
    "RAL 060 30 27": "#5b4125",
    "RAL 060 40 05": "#615d56",
    "RAL 060 40 10": "#655a4e",
    "RAL 060 40 20": "#6e5a42",
    "RAL 060 40 30": "#755735",
    "RAL 060 40 40": "#7f562b",
    "RAL 060 50 05": "#7a756d",
    "RAL 060 50 10": "#7e7466",
    "RAL 060 50 20": "#877259",
    "RAL 060 50 30": "#92704d",
    "RAL 060 50 40": "#986c3d",
    "RAL 060 50 50": "#a06932",
    "RAL 060 50 60": "#a36217",
    "RAL 060 50 70": "#ac630f",
    "RAL 060 60 05": "#959088",
    "RAL 060 60 10": "#9a8e80",
    "RAL 060 60 20": "#a48b71",
    "RAL 060 60 30": "#ac8a64",
    "RAL 060 60 40": "#b88b55",
    "RAL 060 60 50": "#b98044",
    "RAL 060 60 60": "#c27e32",
    "RAL 060 60 70": "#c87a1e",
    "RAL 060 60 80": "#d27610",
    "RAL 060 70 05": "#b0aaa2",
    "RAL 060 70 10": "#b5a99a",
    "RAL 060 70 20": "#bda68a",
    "RAL 060 70 30": "#c4a079",
    "RAL 060 70 40": "#d1a16f",
    "RAL 060 70 50": "#d89d5f",
    "RAL 060 70 60": "#dd974c",
    "RAL 060 70 70": "#e79539",
    "RAL 060 80 05": "#ccc6bc",
    "RAL 060 80 10": "#d0c3b4",
    "RAL 060 80 20": "#dbc2a5",
    "RAL 060 80 30": "#e7bf93",
    "RAL 060 80 40": "#edba82",
    "RAL 060 85 05": "#dbd3c9",
    "RAL 060 85 10": "#e1d3c1",
    "RAL 060 85 20": "#e9cfb2",
    "RAL 060 85 30": "#f4cda1",
    "RAL 060 90 05": "#ebe2d7",
    "RAL 060 90 10": "#f0e0cf",
    "RAL 060 90 15": "#f4ddc6",
    "RAL 060 93 05": "#f3ebe2",
    "RAL 070 30 10": "#4a4437",
    "RAL 070 30 20": "#53452e",
    "RAL 070 40 10": "#625c4d",
    "RAL 070 40 20": "#695a3e",
    "RAL 070 40 30": "#705a33",
    "RAL 070 40 40": "#755823",
    "RAL 070 50 10": "#7a7465",
    "RAL 070 50 20": "#837356",
    "RAL 070 50 30": "#887145",
    "RAL 070 50 40": "#8f6f34",
    "RAL 070 50 50": "#907031",
    "RAL 070 50 55": "#98712b",
    "RAL 070 60 10": "#948c7c",
    "RAL 070 60 20": "#9c8d6f",
    "RAL 070 60 30": "#a3895e",
    "RAL 070 60 40": "#aa894c",
    "RAL 070 60 50": "#b0893b",
    "RAL 070 60 60": "#b6862a",
    "RAL 070 60 70": "#bc8318",
    "RAL 070 60 75": "#bd8209",
    "RAL 070 70 10": "#afa897",
    "RAL 070 70 20": "#b9a787",
    "RAL 070 70 30": "#c2a877",
    "RAL 070 70 40": "#c9a565",
    "RAL 070 70 50": "#cea456",
    "RAL 070 70 60": "#d9a344",
    "RAL 070 70 70": "#d99d2c",
    "RAL 070 70 80": "#dc9914",
    "RAL 070 80 10": "#cec5b2",
    "RAL 070 80 20": "#d9c6a2",
    "RAL 070 80 30": "#e1c392",
    "RAL 070 80 40": "#e9c383",
    "RAL 070 80 50": "#f0c170",
    "RAL 070 80 60": "#f8bf5d",
    "RAL 070 85 05": "#d8d2c6",
    "RAL 070 85 10": "#ded3bf",
    "RAL 070 85 20": "#e7d1ab",
    "RAL 070 85 30": "#efd29e",
    "RAL 070 90 05": "#ece4d9",
    "RAL 070 90 10": "#eee3d0",
    "RAL 070 90 20": "#f7e2be",
    "RAL 070 93 05": "#f3ede2",
    "RAL 075 40 10": "#625d4f",
    "RAL 075 40 20": "#675b40",
    "RAL 075 40 30": "#6b5930",
    "RAL 075 40 38": "#705a23",
    "RAL 075 50 10": "#7b7566",
    "RAL 075 50 20": "#827456",
    "RAL 075 50 30": "#897547",
    "RAL 075 50 40": "#8d7337",
    "RAL 075 50 50": "#917224",
    "RAL 075 50 58": "#926f04",
    "RAL 075 60 10": "#97907f",
    "RAL 075 60 20": "#9d8e6e",
    "RAL 075 60 30": "#a38e5f",
    "RAL 075 60 40": "#a98e50",
    "RAL 075 60 50": "#ac8c3c",
    "RAL 075 60 60": "#b28925",
    "RAL 075 60 70": "#b68804",
    "RAL 075 70 10": "#b1ab99",
    "RAL 075 70 20": "#b9a985",
    "RAL 075 70 30": "#bfa976",
    "RAL 075 70 40": "#c5a764",
    "RAL 075 70 50": "#cba655",
    "RAL 075 70 60": "#d1a43f",
    "RAL 075 70 70": "#d7a427",
    "RAL 075 70 80": "#d6a209",
    "RAL 075 80 10": "#d0c6b3",
    "RAL 075 80 20": "#d7c6a2",
    "RAL 075 80 30": "#dcc58f",
    "RAL 075 80 40": "#e3c380",
    "RAL 075 80 50": "#e8c06d",
    "RAL 075 80 60": "#efbf5d",
    "RAL 075 85 10": "#dfd5c0",
    "RAL 075 85 20": "#e6d4ae",
    "RAL 075 85 30": "#edd39e",
    "RAL 075 85 40": "#f3d28d",
    "RAL 075 90 10": "#f1e6cf",
    "RAL 075 90 20": "#f5e2bd",
    "RAL 075 93 05": "#f2eee2",
    "RAL 080 20 05": "#33312b",
    "RAL 080 20 10": "#353122",
    "RAL 080 30 05": "#49453e",
    "RAL 080 30 10": "#494435",
    "RAL 080 30 20": "#4f4428",
    "RAL 080 30 26": "#52441f",
    "RAL 080 40 05": "#615d56",
    "RAL 080 40 10": "#635e4e",
    "RAL 080 40 20": "#665b3c",
    "RAL 080 40 30": "#6b5b2f",
    "RAL 080 40 40": "#715c1b",
    "RAL 080 50 05": "#78756d",
    "RAL 080 50 10": "#7b7666",
    "RAL 080 50 20": "#817656",
    "RAL 080 50 30": "#847545",
    "RAL 080 50 40": "#887436",
    "RAL 080 50 50": "#8d7524",
    "RAL 080 60 05": "#928f87",
    "RAL 080 60 10": "#948e7c",
    "RAL 080 60 20": "#9b8f6c",
    "RAL 080 60 30": "#a08e5b",
    "RAL 080 60 40": "#a38e4f",
    "RAL 080 60 50": "#a88e3c",
    "RAL 080 60 60": "#ad8e23",
    "RAL 080 60 70": "#af8d08",
    "RAL 080 70 05": "#aeaaa1",
    "RAL 080 70 10": "#b0aa97",
    "RAL 080 70 20": "#b6aa86",
    "RAL 080 70 30": "#bba976",
    "RAL 080 70 40": "#c2aa64",
    "RAL 080 70 50": "#c6a953",
    "RAL 080 70 60": "#cbaa40",
    "RAL 080 70 70": "#cfaa2c",
    "RAL 080 70 80": "#d1a706",
    "RAL 080 70 88": "#d2a600",
    "RAL 080 80 05": "#cbc6bc",
    "RAL 080 80 10": "#cfc7b3",
    "RAL 080 80 20": "#d4c69f",
    "RAL 080 80 30": "#d9c58e",
    "RAL 080 80 40": "#e0c57d",
    "RAL 080 80 50": "#e5c56c",
    "RAL 080 80 60": "#eac557",
    "RAL 080 80 70": "#ecc345",
    "RAL 080 80 80": "#f1c12b",
    "RAL 080 80 90": "#f4c208",
    "RAL 080 85 05": "#d8d2c6",
    "RAL 080 85 10": "#dbd2be",
    "RAL 080 85 20": "#e3d4af",
    "RAL 080 85 30": "#e8d39d",
    "RAL 080 85 40": "#efd38a",
    "RAL 080 90 05": "#ece6d9",
    "RAL 080 90 10": "#ece3cd",
    "RAL 080 90 20": "#f1e1bb",
    "RAL 080 90 30": "#f8e3ab",
    "RAL 080 93 05": "#f1ebdf",
    "RAL 085 40 10": "#626050",
    "RAL 085 40 20": "#645e3e",
    "RAL 085 40 30": "#6a6034",
    "RAL 085 50 10": "#7a7764",
    "RAL 085 50 20": "#7f7756",
    "RAL 085 50 30": "#837847",
    "RAL 085 50 40": "#847636",
    "RAL 085 50 50": "#887725",
    "RAL 085 60 10": "#94907f",
    "RAL 085 60 20": "#9a906e",
    "RAL 085 60 30": "#9e905e",
    "RAL 085 60 40": "#a1914e",
    "RAL 085 60 50": "#a5923b",
    "RAL 085 60 60": "#a89224",
    "RAL 085 70 10": "#adaa96",
    "RAL 085 70 20": "#b5aa87",
    "RAL 085 70 30": "#b9ab74",
    "RAL 085 70 40": "#bcaa65",
    "RAL 085 70 50": "#c1ab51",
    "RAL 085 70 60": "#c2ab3d",
    "RAL 085 70 70": "#c6a931",
    "RAL 085 70 75": "#caab1f",
    "RAL 085 80 10": "#cbc6b1",
    "RAL 085 80 20": "#d1c7a1",
    "RAL 085 80 30": "#d8c88e",
    "RAL 085 80 40": "#dbc87d",
    "RAL 085 80 50": "#dec76b",
    "RAL 085 80 60": "#e1c658",
    "RAL 085 80 70": "#e5c645",
    "RAL 085 80 80": "#e6c52e",
    "RAL 085 80 85": "#e6c526",
    "RAL 085 85 10": "#d9d2bc",
    "RAL 085 85 20": "#dfd3ab",
    "RAL 085 85 30": "#e5d39a",
    "RAL 085 85 40": "#ebd58b",
    "RAL 085 90 10": "#eee7d1",
    "RAL 085 90 20": "#f1e4bb",
    "RAL 085 90 30": "#f4e2a9",
    "RAL 085 93 05": "#f1eee2",
    "RAL 090 30 10": "#4a4738",
    "RAL 090 30 20": "#4d4829",
    "RAL 090 40 10": "#635f51",
    "RAL 090 40 20": "#655e3f",
    "RAL 090 40 30": "#696033",
    "RAL 090 50 10": "#797667",
    "RAL 090 50 20": "#7d7657",
    "RAL 090 50 30": "#827846",
    "RAL 090 50 40": "#837838",
    "RAL 090 60 10": "#928e7f",
    "RAL 090 60 20": "#988f6d",
    "RAL 090 60 30": "#9b9060",
    "RAL 090 60 40": "#9d904e",
    "RAL 090 60 50": "#9c8f3a",
    "RAL 090 60 60": "#a2942c",
    "RAL 090 70 10": "#aeaa98",
    "RAL 090 70 20": "#b2aa85",
    "RAL 090 70 30": "#b5a976",
    "RAL 090 70 40": "#bbad65",
    "RAL 090 70 50": "#bdad55",
    "RAL 090 70 60": "#beae41",
    "RAL 090 70 70": "#c0af29",
    "RAL 090 70 80": "#c0ae10",
    "RAL 090 80 10": "#cbc5b0",
    "RAL 090 80 20": "#cec4a0",
    "RAL 090 80 30": "#d5c892",
    "RAL 090 80 40": "#d8ca82",
    "RAL 090 80 50": "#dcca6b",
    "RAL 090 80 60": "#dcc956",
    "RAL 090 80 70": "#e0cc49",
    "RAL 090 80 80": "#deca28",
    "RAL 090 80 90": "#e3cd07",
    "RAL 090 85 05": "#d6d2c7",
    "RAL 090 85 10": "#d9d3bf",
    "RAL 090 85 20": "#ded5ad",
    "RAL 090 85 30": "#e2d69c",
    "RAL 090 85 40": "#e5d68a",
    "RAL 090 85 50": "#e9d879",
    "RAL 090 90 05": "#e7e3d8",
    "RAL 090 90 10": "#e9e4d0",
    "RAL 090 90 20": "#efe5bc",
    "RAL 090 90 30": "#f1e5ab",
    "RAL 090 90 40": "#f5e698",
    "RAL 090 90 50": "#f5e485",
    "RAL 090 90 60": "#f6e371",
    "RAL 090 93 05": "#eeebe0",
    "RAL 095 40 10": "#615e50",
    "RAL 095 40 20": "#635d3f",
    "RAL 095 40 30": "#635f31",
    "RAL 095 50 10": "#787466",
    "RAL 095 50 20": "#7c7759",
    "RAL 095 50 30": "#7e7848",
    "RAL 095 50 40": "#807a37",
    "RAL 095 50 50": "#7f7e24",
    "RAL 095 60 10": "#938f7f",
    "RAL 095 60 20": "#95906f",
    "RAL 095 60 30": "#98915d",
    "RAL 095 60 40": "#99924e",
    "RAL 095 60 50": "#9a953d",
    "RAL 095 60 60": "#969329",
    "RAL 095 60 70": "#979803",
    "RAL 095 70 10": "#aeaa99",
    "RAL 095 70 20": "#b2ac8a",
    "RAL 095 70 30": "#b4ad79",
    "RAL 095 70 40": "#b5ae65",
    "RAL 095 70 50": "#b5ac58",
    "RAL 095 70 60": "#b6ac47",
    "RAL 095 70 70": "#b7b12e",
    "RAL 095 80 10": "#cac6b4",
    "RAL 095 80 20": "#cfc7a4",
    "RAL 095 80 30": "#d4ca93",
    "RAL 095 80 40": "#d5cc80",
    "RAL 095 80 50": "#d6ca71",
    "RAL 095 80 60": "#d3c85e",
    "RAL 095 80 70": "#d3cc4a",
    "RAL 095 80 80": "#cfc735",
    "RAL 095 85 10": "#d9d5c2",
    "RAL 095 85 20": "#ddd7b3",
    "RAL 095 85 30": "#e0d89f",
    "RAL 095 85 40": "#e3da8d",
    "RAL 095 85 50": "#e4d97d",
    "RAL 095 90 10": "#e9e4cf",
    "RAL 095 90 20": "#ece4be",
    "RAL 095 90 30": "#eee7a9",
    "RAL 095 90 40": "#f0e696",
    "RAL 095 90 50": "#f6e988",
    "RAL 095 90 59": "#f6e979",
    "RAL 095 93 05": "#ecebe1",
    "RAL 100 20 05": "#32332d",
    "RAL 100 30 05": "#44443d",
    "RAL 100 30 10": "#464536",
    "RAL 100 30 20": "#4a4b2a",
    "RAL 100 40 05": "#5c5c54",
    "RAL 100 40 10": "#5f5e4f",
    "RAL 100 40 20": "#605f41",
    "RAL 100 40 30": "#616130",
    "RAL 100 40 40": "#5e641d",
    "RAL 100 50 05": "#75756d",
    "RAL 100 50 10": "#777564",
    "RAL 100 50 20": "#797957",
    "RAL 100 50 30": "#797848",
    "RAL 100 50 40": "#797b36",
    "RAL 100 50 50": "#767e23",
    "RAL 100 60 05": "#908f87",
    "RAL 100 60 10": "#8e8d7d",
    "RAL 100 60 20": "#93926f",
    "RAL 100 60 30": "#93925e",
    "RAL 100 60 40": "#959351",
    "RAL 100 60 50": "#969640",
    "RAL 100 60 60": "#8d9622",
    "RAL 100 70 05": "#acaba2",
    "RAL 100 70 10": "#adab98",
    "RAL 100 70 20": "#adad87",
    "RAL 100 70 30": "#aead77",
    "RAL 100 70 40": "#b2b069",
    "RAL 100 70 50": "#b0ae58",
    "RAL 100 70 60": "#afb046",
    "RAL 100 80 05": "#c5c5bb",
    "RAL 100 80 10": "#c8c6b1",
    "RAL 100 80 20": "#cdcba3",
    "RAL 100 80 30": "#ccca91",
    "RAL 100 80 40": "#cecb80",
    "RAL 100 80 50": "#cdcb70",
    "RAL 100 80 60": "#ced15b",
    "RAL 100 80 70": "#cfd24b",
    "RAL 100 80 80": "#cbd334",
    "RAL 100 85 05": "#d6d5ca",
    "RAL 100 85 10": "#d7d5c0",
    "RAL 100 85 20": "#dad8b0",
    "RAL 100 85 30": "#dcd89f",
    "RAL 100 90 05": "#e5e4d7",
    "RAL 100 90 10": "#e7e4cf",
    "RAL 100 90 20": "#eae6bd",
    "RAL 100 90 30": "#eae6a9",
    "RAL 100 90 40": "#ede999",
    "RAL 100 90 50": "#ece888",
    "RAL 100 93 05": "#edede1",
    "RAL 1000": "#c5bb8a",
    "RAL 1001": "#c6b286",
    "RAL 1002": "#c7ae72",
    "RAL 1003": "#e6b019",
    "RAL 1004": "#d2a40e",
    "RAL 1005": "#bc9611",
    "RAL 1006": "#cf9804",
    "RAL 1007": "#d49300",
    "RAL 1011": "#a38454",
    "RAL 1012": "#cfb539",
    "RAL 1013": "#dfdbc7",
    "RAL 1014": "#d4c79c",
    "RAL 1015": "#ded3b6",
    "RAL 1016": "#e8e253",
    "RAL 1017": "#e4af56",
    "RAL 1018": "#ebd346",
    "RAL 1019": "#9c917b",
    "RAL 1020": "#999167",
    "RAL 1021": "#e5c000",
    "RAL 1023": "#e6be05",
    "RAL 1024": "#ad9451",
    "RAL 1026": "#ffff00",
    "RAL 1027": "#998420",
    "RAL 1028": "#f2a500",
    "RAL 1032": "#cfa81e",
    "RAL 1033": "#e4a02d",
    "RAL 1034": "#d9a156",
    "RAL 1035": "#898271",
    "RAL 1036": "#746341",
    "RAL 1037": "#db9a17",
    "RAL 110 20 10": "#303324",
    "RAL 110 30 10": "#46483a",
    "RAL 110 30 20": "#454b2e",
    "RAL 110 40 10": "#5d5f50",
    "RAL 110 40 20": "#5a5f3f",
    "RAL 110 40 30": "#5b6434",
    "RAL 110 40 40": "#596828",
    "RAL 110 50 10": "#747666",
    "RAL 110 50 20": "#747858",
    "RAL 110 50 30": "#747b4c",
    "RAL 110 50 40": "#717d3a",
    "RAL 110 50 50": "#6b8024",
    "RAL 110 50 55": "#6b841a",
    "RAL 110 60 10": "#8d907f",
    "RAL 110 60 20": "#8b9170",
    "RAL 110 60 30": "#8e9665",
    "RAL 110 60 40": "#8b9654",
    "RAL 110 60 50": "#879a42",
    "RAL 110 60 60": "#859f2f",
    "RAL 110 60 65": "#85a11f",
    "RAL 110 70 10": "#a9ac99",
    "RAL 110 70 20": "#a8ad89",
    "RAL 110 70 30": "#a6ad7a",
    "RAL 110 70 40": "#a6b16c",
    "RAL 110 70 50": "#a7b55e",
    "RAL 110 70 60": "#a0b749",
    "RAL 110 70 70": "#97b821",
    "RAL 110 70 77": "#97b720",
    "RAL 110 80 10": "#c2c5b3",
    "RAL 110 80 20": "#c3cca2",
    "RAL 110 80 30": "#c5cc93",
    "RAL 110 80 40": "#c3cf85",
    "RAL 110 80 50": "#c3d274",
    "RAL 110 80 60": "#bed561",
    "RAL 110 80 70": "#bdd651",
    "RAL 110 85 10": "#d2d5c1",
    "RAL 110 85 20": "#d0d8af",
    "RAL 110 85 30": "#d2daa0",
    "RAL 110 85 40": "#ceda8b",
    "RAL 110 85 50": "#cfdc7c",
    "RAL 110 90 05": "#e2e2d7",
    "RAL 110 90 10": "#e3e6d0",
    "RAL 110 90 20": "#e1e8bd",
    "RAL 110 90 30": "#e2e9ab",
    "RAL 110 90 40": "#e1eb9d",
    "RAL 110 93 05": "#eaebe0",
    "RAL 110 96 02": "#f3f4ef",
    "RAL 110-1": "#e4e7e6",
    "RAL 110-2": "#dcddd6",
    "RAL 110-3": "#c5c6be",
    "RAL 110-4": "#c4c7c5",
    "RAL 110-5": "#c7cbc6",
    "RAL 110-6": "#c5c7c7",
    "RAL 110-M": "#9b9ea1",
    "RAL 120 30 05": "#42443d",
    "RAL 120 30 10": "#424739",
    "RAL 120 30 20": "#404a2e",
    "RAL 120 40 05": "#5a5c55",
    "RAL 120 40 10": "#595e4f",
    "RAL 120 40 20": "#576044",
    "RAL 120 40 30": "#546438",
    "RAL 120 40 40": "#4e6923",
    "RAL 120 50 05": "#73756d",
    "RAL 120 50 10": "#717767",
    "RAL 120 50 20": "#707a5a",
    "RAL 120 50 30": "#6c7c4c",
    "RAL 120 50 40": "#67823f",
    "RAL 120 50 50": "#638131",
    "RAL 120 60 05": "#8f9289",
    "RAL 120 60 10": "#8b9081",
    "RAL 120 60 20": "#889372",
    "RAL 120 60 30": "#879866",
    "RAL 120 60 40": "#839a58",
    "RAL 120 60 50": "#7f9d4a",
    "RAL 120 60 60": "#789e39",
    "RAL 120 60 63": "#75a133",
    "RAL 120 70 05": "#a8aba1",
    "RAL 120 70 10": "#a6ab99",
    "RAL 120 70 20": "#a3ae8c",
    "RAL 120 70 30": "#a1b37f",
    "RAL 120 70 40": "#9db771",
    "RAL 120 70 50": "#99b861",
    "RAL 120 70 60": "#92b651",
    "RAL 120 70 70": "#90bc44",
    "RAL 120 70 75": "#8ab936",
    "RAL 120 80 05": "#c3c6bd",
    "RAL 120 80 10": "#c1c7b3",
    "RAL 120 80 20": "#bfcba7",
    "RAL 120 80 30": "#bbce96",
    "RAL 120 80 40": "#b8d288",
    "RAL 120 80 50": "#b3d579",
    "RAL 120 80 60": "#b0d86c",
    "RAL 120 85 05": "#d1d4ca",
    "RAL 120 85 10": "#ced6c2",
    "RAL 120 85 20": "#cdd9b3",
    "RAL 120 85 30": "#cbdea3",
    "RAL 120 90 05": "#dfe2d7",
    "RAL 120 90 10": "#e2e7d2",
    "RAL 120 90 20": "#dce8c1",
    "RAL 120 90 30": "#d9ecb1",
    "RAL 120 93 05": "#e9ece0",
    "RAL 120-1": "#ebedeb",
    "RAL 120-2": "#f1f2ed",
    "RAL 120-3": "#eeeee6",
    "RAL 120-4": "#e5e2d5",
    "RAL 120-5": "#dedac7",
    "RAL 120-6": "#e6e2d0",
    "RAL 120-M": "#8d8d89",
    "RAL 130 30 10": "#41483b",
    "RAL 130 30 20": "#3c4a30",
    "RAL 130 40 10": "#5a6053",
    "RAL 130 40 20": "#526145",
    "RAL 130 40 30": "#4f643b",
    "RAL 130 50 10": "#6e7768",
    "RAL 130 50 20": "#6b7c5e",
    "RAL 130 50 30": "#657e51",
    "RAL 130 50 40": "#5f8146",
    "RAL 130 50 50": "#58823b",
    "RAL 130 60 10": "#899283",
    "RAL 130 60 20": "#849477",
    "RAL 130 60 30": "#7e976b",
    "RAL 130 60 40": "#789a5e",
    "RAL 130 60 50": "#719d50",
    "RAL 130 60 60": "#69a044",
    "RAL 130 70 10": "#a4ae9e",
    "RAL 130 70 20": "#a0b191",
    "RAL 130 70 30": "#98b484",
    "RAL 130 70 40": "#93b676",
    "RAL 130 70 50": "#8dba6c",
    "RAL 130 70 60": "#85bd5d",
    "RAL 130 80 10": "#c0c8b7",
    "RAL 130 80 20": "#baccab",
    "RAL 130 80 30": "#b5d09e",
    "RAL 130 80 40": "#afd492",
    "RAL 130 80 50": "#a9d684",
    "RAL 130 85 05": "#cfd5cb",
    "RAL 130 85 10": "#cdd7c4",
    "RAL 130 85 20": "#c7dab8",
    "RAL 130 85 30": "#c4deac",
    "RAL 130 90 05": "#dde2d8",
    "RAL 130 90 10": "#dee8d4",
    "RAL 130 90 20": "#d6e9c5",
    "RAL 130 93 05": "#e7ece2",
    "RAL 130-1": "#eeefbf",
    "RAL 130-2": "#eef0c6",
    "RAL 130-3": "#eef0d0",
    "RAL 130-4": "#f4f2d2",
    "RAL 130-5": "#e9e6bf",
    "RAL 130-6": "#f4e8b4",
    "RAL 130-M": "#a6aa90",
    "RAL 140 20 05": "#2d322d",
    "RAL 140 20 10": "#2b3528",
    "RAL 140 20 20": "#2a3927",
    "RAL 140 30 05": "#444944",
    "RAL 140 30 10": "#404b3d",
    "RAL 140 30 20": "#3b4e36",
    "RAL 140 30 30": "#32532a",
    "RAL 140 30 40": "#2b532a",
    "RAL 140 40 05": "#5a5f59",
    "RAL 140 40 10": "#556053",
    "RAL 140 40 20": "#4c6248",
    "RAL 140 40 30": "#47663f",
    "RAL 140 40 40": "#406b37",
    "RAL 140 40 50": "#3b6f31",
    "RAL 140 50 05": "#70766f",
    "RAL 140 50 10": "#6d786b",
    "RAL 140 50 20": "#667b60",
    "RAL 140 50 30": "#608056",
    "RAL 140 50 40": "#55824b",
    "RAL 140 50 50": "#4f8744",
    "RAL 140 50 60": "#458938",
    "RAL 140 60 05": "#898f89",
    "RAL 140 60 10": "#849183",
    "RAL 140 60 20": "#80987b",
    "RAL 140 60 30": "#789b6f",
    "RAL 140 60 40": "#729e65",
    "RAL 140 60 50": "#67a05a",
    "RAL 140 60 60": "#5fa251",
    "RAL 140 60 70": "#57a549",
    "RAL 140 70 05": "#a4aaa3",
    "RAL 140 70 10": "#9eac9e",
    "RAL 140 70 20": "#98b194",
    "RAL 140 70 30": "#90b589",
    "RAL 140 70 40": "#8bb97f",
    "RAL 140 70 50": "#7fba71",
    "RAL 140 70 60": "#7abf68",
    "RAL 140 80 05": "#c2c7bf",
    "RAL 140 80 10": "#bcc9b9",
    "RAL 140 80 20": "#b4cdad",
    "RAL 140 80 30": "#acd1a3",
    "RAL 140 80 40": "#a1d597",
    "RAL 140 85 05": "#ced6cd",
    "RAL 140 85 10": "#cad8c8",
    "RAL 140 85 20": "#c2dcbb",
    "RAL 140 85 30": "#b9e0b1",
    "RAL 140 90 05": "#dfe5da",
    "RAL 140 90 10": "#dae7d4",
    "RAL 140 93 05": "#e7eee4",
    "RAL 140-1": "#f0d6ab",
    "RAL 140-2": "#f4dea9",
    "RAL 140-3": "#f6e6c2",
    "RAL 140-4": "#f4e1bf",
    "RAL 140-5": "#f2e6c9",
    "RAL 140-6": "#ded4b7",
    "RAL 140-M": "#a89f80",
    "RAL 150 30 10": "#404c42",
    "RAL 150 30 20": "#374f3c",
    "RAL 150 30 30": "#2d5034",
    "RAL 150 40 10": "#546156",
    "RAL 150 40 20": "#4d6550",
    "RAL 150 40 30": "#416747",
    "RAL 150 40 40": "#366a3f",
    "RAL 150 40 50": "#2d6b3b",
    "RAL 150 50 10": "#6a786c",
    "RAL 150 50 20": "#627d66",
    "RAL 150 50 30": "#5a825f",
    "RAL 150 50 40": "#52855c",
    "RAL 150 50 50": "#458752",
    "RAL 150 50 60": "#3c8a4d",
    "RAL 150 60 10": "#869489",
    "RAL 150 60 20": "#7c9881",
    "RAL 150 60 30": "#729a78",
    "RAL 150 60 40": "#689e6f",
    "RAL 150 60 50": "#60a36c",
    "RAL 150 60 60": "#4fa25e",
    "RAL 150 70 10": "#9eada1",
    "RAL 150 70 20": "#96b39b",
    "RAL 150 70 30": "#8cb892",
    "RAL 150 70 40": "#82ba8a",
    "RAL 150 70 50": "#77bd80",
    "RAL 150 80 10": "#bbcabd",
    "RAL 150 80 20": "#b1cfb5",
    "RAL 150 80 30": "#a6d3ae",
    "RAL 150 80 40": "#9dd8a5",
    "RAL 150 85 05": "#ccd5cd",
    "RAL 150 85 10": "#c8d8c9",
    "RAL 150 85 20": "#bfddc0",
    "RAL 150 90 05": "#dbe3d9",
    "RAL 150 90 10": "#d8e8d7",
    "RAL 150 93 05": "#e4ede3",
    "RAL 150-1": "#f3efea",
    "RAL 150-2": "#f4ebe4",
    "RAL 150-3": "#e9e1d8",
    "RAL 150-4": "#f5e4d5",
    "RAL 150-5": "#f4e9dd",
    "RAL 150-6": "#f2dfd8",
    "RAL 150-M": "#a4978b",
    "RAL 160 20 05": "#2f3532",
    "RAL 160 20 10": "#29362f",
    "RAL 160 20 15": "#22372a",
    "RAL 160 20 20": "#1f3429",
    "RAL 160 30 05": "#414844",
    "RAL 160 30 10": "#3d4a42",
    "RAL 160 30 15": "#374a3f",
    "RAL 160 30 20": "#304c3c",
    "RAL 160 30 25": "#2d4e3a",
    "RAL 160 30 30": "#275038",
    "RAL 160 30 35": "#1e5035",
    "RAL 160 30 40": "#195235",
    "RAL 160 40 05": "#58605b",
    "RAL 160 40 10": "#516159",
    "RAL 160 40 15": "#4c6356",
    "RAL 160 40 20": "#466353",
    "RAL 160 40 25": "#416450",
    "RAL 160 40 30": "#3c674e",
    "RAL 160 40 35": "#36694c",
    "RAL 160 40 40": "#326b4c",
    "RAL 160 40 45": "#296846",
    "RAL 160 40 50": "#1d6a43",
    "RAL 160 40 55": "#1b6d43",
    "RAL 160 50 05": "#6f7772",
    "RAL 160 50 10": "#687870",
    "RAL 160 50 15": "#647c6e",
    "RAL 160 50 20": "#5e7e6c",
    "RAL 160 50 25": "#587e68",
    "RAL 160 50 30": "#538166",
    "RAL 160 50 35": "#4f8364",
    "RAL 160 50 40": "#468362",
    "RAL 160 50 45": "#438661",
    "RAL 160 50 50": "#3a865d",
    "RAL 160 50 55": "#35885c",
    "RAL 160 50 60": "#2a8758",
    "RAL 160 60 05": "#88908b",
    "RAL 160 60 10": "#819289",
    "RAL 160 60 15": "#7c9687",
    "RAL 160 60 20": "#769784",
    "RAL 160 60 25": "#719a80",
    "RAL 160 60 30": "#6b9b7f",
    "RAL 160 60 35": "#669e7d",
    "RAL 160 60 40": "#5f9d7a",
    "RAL 160 60 45": "#5aa178",
    "RAL 160 60 50": "#51a075",
    "RAL 160 60 55": "#4c9f70",
    "RAL 160 60 58": "#45a26f",
    "RAL 160 70 05": "#a2aba6",
    "RAL 160 70 10": "#9baea3",
    "RAL 160 70 15": "#94b09f",
    "RAL 160 70 20": "#90b29d",
    "RAL 160 70 25": "#8bb69c",
    "RAL 160 70 30": "#84b79a",
    "RAL 160 70 35": "#7db897",
    "RAL 160 70 40": "#78bb94",
    "RAL 160 70 45": "#71bd91",
    "RAL 160 70 50": "#6bbe91",
    "RAL 160 80 05": "#bdc6c0",
    "RAL 160 80 10": "#b6c9be",
    "RAL 160 80 15": "#afccbb",
    "RAL 160 80 20": "#a9ceb8",
    "RAL 160 80 25": "#a5d0b7",
    "RAL 160 80 30": "#a1d4b5",
    "RAL 160 85 05": "#c9d3cc",
    "RAL 160 85 10": "#c2d6c9",
    "RAL 160 85 15": "#bedac7",
    "RAL 160 90 05": "#dae3db",
    "RAL 160 90 10": "#d3e7d8",
    "RAL 160 90 15": "#cde9d5",
    "RAL 160 93 05": "#e0ebe6",
    "RAL 160-1": "#e1dfec",
    "RAL 160-2": "#e5e1e8",
    "RAL 160-3": "#ebe7e8",
    "RAL 160-4": "#eae0e2",
    "RAL 160-5": "#ebe3e0",
    "RAL 160-6": "#e9e2ea",
    "RAL 160-M": "#aaa3b4",
    "RAL 170 20 10": "#25342f",
    "RAL 170 20 15": "#21362e",
    "RAL 170 20 20": "#1a372e",
    "RAL 170 20 25": "#153c2e",
    "RAL 170 30 10": "#3b4b44",
    "RAL 170 30 15": "#334c42",
    "RAL 170 30 20": "#2e4b41",
    "RAL 170 30 25": "#264f41",
    "RAL 170 30 30": "#224f40",
    "RAL 170 30 35": "#175141",
    "RAL 170 30 40": "#0d5240",
    "RAL 170 40 10": "#4f6059",
    "RAL 170 40 15": "#496158",
    "RAL 170 40 20": "#436458",
    "RAL 170 40 25": "#3e6556",
    "RAL 170 40 30": "#396957",
    "RAL 170 40 35": "#2f6854",
    "RAL 170 40 40": "#256954",
    "RAL 170 40 45": "#1c6a54",
    "RAL 170 40 50": "#176950",
    "RAL 170 50 10": "#677973",
    "RAL 170 50 15": "#617d71",
    "RAL 170 50 20": "#5b7d70",
    "RAL 170 50 25": "#547f6e",
    "RAL 170 50 30": "#4c816e",
    "RAL 170 50 35": "#46816d",
    "RAL 170 50 40": "#3c846a",
    "RAL 170 50 45": "#37846b",
    "RAL 170 50 50": "#2a8769",
    "RAL 170 50 55": "#208568",
    "RAL 170 60 10": "#7f928b",
    "RAL 170 60 15": "#7a958a",
    "RAL 170 60 20": "#719889",
    "RAL 170 60 25": "#6c9889",
    "RAL 170 60 30": "#649a87",
    "RAL 170 60 35": "#5d9e87",
    "RAL 170 60 40": "#569e85",
    "RAL 170 60 45": "#4e9e83",
    "RAL 170 60 50": "#47a185",
    "RAL 170 70 10": "#9aaea6",
    "RAL 170 70 15": "#93b0a4",
    "RAL 170 70 20": "#8cb4a4",
    "RAL 170 70 25": "#87b6a2",
    "RAL 170 70 30": "#7eb8a3",
    "RAL 170 70 35": "#77b89f",
    "RAL 170 70 40": "#70b99e",
    "RAL 170 80 10": "#b6cac2",
    "RAL 170 80 15": "#adcdc1",
    "RAL 170 80 20": "#a8d2c0",
    "RAL 170 80 25": "#9fd1be",
    "RAL 170 85 05": "#c9d5d0",
    "RAL 170 85 10": "#c3d9cf",
    "RAL 170 85 15": "#bbdbcc",
    "RAL 170 85 20": "#b4ddcb",
    "RAL 170 90 05": "#d9e3dd",
    "RAL 170 90 10": "#d1e7dc",
    "RAL 170 93 05": "#e2ece7",
    "RAL 170-1": "#c5c7cf",
    "RAL 170-2": "#a6aabc",
    "RAL 170-3": "#bbc5d9",
    "RAL 170-4": "#cfd8ec",
    "RAL 170-5": "#c2c3d5",
    "RAL 170-6": "#c4c2d5",
    "RAL 170-M": "#a5a5b7",
    "RAL 180 20 05": "#2d3634",
    "RAL 180 20 10": "#253532",
    "RAL 180 20 15": "#1d3532",
    "RAL 180 20 20": "#123633",
    "RAL 180 30 05": "#424a49",
    "RAL 180 30 10": "#394a46",
    "RAL 180 30 15": "#334c47",
    "RAL 180 30 20": "#2c4d47",
    "RAL 180 30 25": "#254f48",
    "RAL 180 30 30": "#1a4f48",
    "RAL 180 30 35": "#135049",
    "RAL 180 40 05": "#565f5d",
    "RAL 180 40 10": "#4e615d",
    "RAL 180 40 15": "#47635d",
    "RAL 180 40 20": "#40655e",
    "RAL 180 40 25": "#39665e",
    "RAL 180 40 30": "#2e675f",
    "RAL 180 40 35": "#25665d",
    "RAL 180 40 40": "#1c665d",
    "RAL 180 40 45": "#0e675e",
    "RAL 180 50 05": "#6f7877",
    "RAL 180 50 10": "#657975",
    "RAL 180 50 15": "#5d7b75",
    "RAL 180 50 20": "#567d75",
    "RAL 180 50 25": "#4e7e76",
    "RAL 180 50 30": "#468176",
    "RAL 180 50 35": "#3e8276",
    "RAL 180 50 40": "#358175",
    "RAL 180 50 45": "#2b8377",
    "RAL 180 50 50": "#0e8376",
    "RAL 180 60 05": "#86908f",
    "RAL 180 60 10": "#7d928e",
    "RAL 180 60 15": "#76958f",
    "RAL 180 60 20": "#6e978f",
    "RAL 180 60 25": "#65988e",
    "RAL 180 60 30": "#5e9b8f",
    "RAL 180 60 35": "#579d90",
    "RAL 180 60 40": "#4d9e91",
    "RAL 180 60 45": "#439f91",
    "RAL 180 60 50": "#359f91",
    "RAL 180 70 05": "#a1aba9",
    "RAL 180 70 10": "#96ada8",
    "RAL 180 70 15": "#8fb0a9",
    "RAL 180 70 20": "#88b3aa",
    "RAL 180 70 25": "#7fb4a9",
    "RAL 180 70 30": "#79b7aa",
    "RAL 180 70 35": "#6eb8aa",
    "RAL 180 70 40": "#67bbac",
    "RAL 180 80 05": "#bdc6c3",
    "RAL 180 80 10": "#b4cac4",
    "RAL 180 80 15": "#adcec5",
    "RAL 180 80 20": "#a2cfc4",
    "RAL 180 80 25": "#9bd1c5",
    "RAL 180 80 30": "#97d6c8",
    "RAL 180 85 05": "#c8d4d1",
    "RAL 180 85 10": "#c1d8d1",
    "RAL 180 85 15": "#bbdcd2",
    "RAL 180 85 20": "#b0ddcf",
    "RAL 180 90 05": "#dae5e1",
    "RAL 180 90 10": "#d2eae2",
    "RAL 180 93 05": "#e2eeea",
    "RAL 180-1": "#afb9c5",
    "RAL 180-2": "#bccadc",
    "RAL 180-3": "#cad8eb",
    "RAL 180-4": "#cddfed",
    "RAL 180-5": "#c9dbe1",
    "RAL 180-6": "#dce8ec",
    "RAL 180-M": "#96a2a8",
    "RAL 190 20 20": "#163838",
    "RAL 190 30 15": "#334c4b",
    "RAL 190 30 20": "#2a4d4d",
    "RAL 190 30 25": "#224e4f",
    "RAL 190 30 30": "#174f51",
    "RAL 190 30 35": "#0f4f52",
    "RAL 190 40 10": "#4f6060",
    "RAL 190 40 15": "#476263",
    "RAL 190 40 20": "#3f6464",
    "RAL 190 40 25": "#366566",
    "RAL 190 40 30": "#2d6667",
    "RAL 190 40 35": "#1b6769",
    "RAL 190 40 40": "#10676a",
    "RAL 190 40 45": "#0c6a6d",
    "RAL 190 50 10": "#667979",
    "RAL 190 50 15": "#5e7b7a",
    "RAL 190 50 20": "#567c7b",
    "RAL 190 50 25": "#4d7e7d",
    "RAL 190 50 30": "#437f7f",
    "RAL 190 50 35": "#3b8081",
    "RAL 190 50 40": "#308184",
    "RAL 190 50 45": "#1b8386",
    "RAL 190 60 10": "#7e9392",
    "RAL 190 60 15": "#779493",
    "RAL 190 60 20": "#719796",
    "RAL 190 60 25": "#679998",
    "RAL 190 60 30": "#5e9a9a",
    "RAL 190 60 35": "#549b9c",
    "RAL 190 60 40": "#489c9e",
    "RAL 190 60 45": "#3c9b9d",
    "RAL 190 70 10": "#98adac",
    "RAL 190 70 15": "#90afad",
    "RAL 190 70 20": "#87b0af",
    "RAL 190 70 25": "#7fb3b2",
    "RAL 190 70 30": "#79b6b6",
    "RAL 190 70 35": "#6db5b5",
    "RAL 190 80 10": "#b3c9c6",
    "RAL 190 80 15": "#acccca",
    "RAL 190 80 20": "#a2cdcb",
    "RAL 190 80 25": "#9acfcd",
    "RAL 190 85 05": "#c5d4d3",
    "RAL 190 85 10": "#bdd8d4",
    "RAL 190 85 15": "#b2dbd5",
    "RAL 190 85 20": "#a6ddd6",
    "RAL 190 90 05": "#dae4e2",
    "RAL 190 90 10": "#d1e8e5",
    "RAL 190 93 05": "#e3ecea",
    "RAL 190-1": "#b0d6e0",
    "RAL 190-2": "#c2e2f3",
    "RAL 190-3": "#c4dce1",
    "RAL 190-4": "#c0d8d8",
    "RAL 190-5": "#d6e3e7",
    "RAL 190-6": "#a6bfbf",
    "RAL 190-M": "#94b2b2",
    "RAL 200 20 05": "#2d3535",
    "RAL 200 20 10": "#253536",
    "RAL 200 20 15": "#1c3337",
    "RAL 200 20 20": "#14363b",
    "RAL 200 20 23": "#0a373e",
    "RAL 200 30 05": "#3f4848",
    "RAL 200 30 10": "#394b4d",
    "RAL 200 30 15": "#334d50",
    "RAL 200 30 20": "#2b4e52",
    "RAL 200 30 25": "#1c4c51",
    "RAL 200 30 30": "#0c4e56",
    "RAL 200 30 33": "#014f5a",
    "RAL 200 40 05": "#555f60",
    "RAL 200 40 10": "#4f6162",
    "RAL 200 40 15": "#476265",
    "RAL 200 40 20": "#3f6468",
    "RAL 200 40 25": "#36666b",
    "RAL 200 40 30": "#2a666e",
    "RAL 200 40 35": "#186670",
    "RAL 200 40 40": "#0c6875",
    "RAL 200 50 05": "#6c7676",
    "RAL 200 50 10": "#677a7c",
    "RAL 200 50 15": "#5e7c7e",
    "RAL 200 50 20": "#557c81",
    "RAL 200 50 25": "#4c7e85",
    "RAL 200 50 30": "#407f87",
    "RAL 200 50 35": "#37828c",
    "RAL 200 50 40": "#27828e",
    "RAL 200 50 45": "#128191",
    "RAL 200 60 05": "#869191",
    "RAL 200 60 10": "#7f9394",
    "RAL 200 60 15": "#779599",
    "RAL 200 60 20": "#6f979c",
    "RAL 200 60 25": "#65989e",
    "RAL 200 60 30": "#5b9aa0",
    "RAL 200 60 35": "#539aa5",
    "RAL 200 60 40": "#489ca8",
    "RAL 200 70 05": "#a1abab",
    "RAL 200 70 10": "#99afb0",
    "RAL 200 70 15": "#8fafb2",
    "RAL 200 70 20": "#88b3b5",
    "RAL 200 70 25": "#80b5bb",
    "RAL 200 80 05": "#bec7c6",
    "RAL 200 80 10": "#b3cacb",
    "RAL 200 80 15": "#aacaca",
    "RAL 200 80 20": "#a3cfd1",
    "RAL 200 80 25": "#9bd0d5",
    "RAL 200 85 05": "#c7d5d3",
    "RAL 200 85 10": "#c2d9d8",
    "RAL 200 85 15": "#b9dcdb",
    "RAL 200 85 20": "#b0dede",
    "RAL 200 90 05": "#dce7e3",
    "RAL 200 90 10": "#d1e8e4",
    "RAL 200 93 05": "#e3eeea",
    "RAL 2000": "#c7750f",
    "RAL 2001": "#a74d23",
    "RAL 2002": "#ac3721",
    "RAL 2003": "#e17c30",
    "RAL 2004": "#cc5608",
    "RAL 2005": "#ff4612",
    "RAL 2007": "#ffad19",
    "RAL 2008": "#d66c21",
    "RAL 2009": "#c9560d",
    "RAL 2010": "#bc602d",
    "RAL 2011": "#cf7421",
    "RAL 2012": "#c2674f",
    "RAL 2013": "#824128",
    "RAL 2017": "#dc5b00",
    "RAL 210 30 10": "#39494d",
    "RAL 210 30 15": "#314b51",
    "RAL 210 30 20": "#274d56",
    "RAL 210 30 25": "#1e4c59",
    "RAL 210 30 30": "#104b5d",
    "RAL 210 40 10": "#4d5f64",
    "RAL 210 40 15": "#466269",
    "RAL 210 40 20": "#3d636c",
    "RAL 210 40 25": "#32626e",
    "RAL 210 40 30": "#206374",
    "RAL 210 40 35": "#11647a",
    "RAL 210 40 38": "#06617a",
    "RAL 210 50 10": "#65787d",
    "RAL 210 50 15": "#5e7a80",
    "RAL 210 50 20": "#537b85",
    "RAL 210 50 25": "#4a7d89",
    "RAL 210 50 30": "#3d7c8e",
    "RAL 210 50 35": "#367e92",
    "RAL 210 50 40": "#207e96",
    "RAL 210 50 45": "#107d9a",
    "RAL 210 60 10": "#7e9296",
    "RAL 210 60 15": "#749399",
    "RAL 210 60 20": "#6e97a1",
    "RAL 210 60 25": "#6499a6",
    "RAL 210 60 30": "#5a99aa",
    "RAL 210 60 35": "#4f99ad",
    "RAL 210 60 40": "#4099b2",
    "RAL 210 70 10": "#98aeb1",
    "RAL 210 70 15": "#90afb5",
    "RAL 210 70 20": "#87b1bb",
    "RAL 210 70 25": "#7eb2bf",
    "RAL 210 70 30": "#75b4c5",
    "RAL 210 70 35": "#6bb5c9",
    "RAL 210 80 10": "#b7cbce",
    "RAL 210 80 15": "#adcdd2",
    "RAL 210 80 20": "#a3cdd6",
    "RAL 210 80 25": "#9bcfdc",
    "RAL 210 85 05": "#c7d4d6",
    "RAL 210 85 10": "#bddadc",
    "RAL 210 85 15": "#b9dbde",
    "RAL 210 85 20": "#b0dce0",
    "RAL 210 90 05": "#d9e4e5",
    "RAL 210 90 10": "#cfe6e6",
    "RAL 210-1": "#cac7b3",
    "RAL 210-2": "#e8e7d4",
    "RAL 210-3": "#e1e3da",
    "RAL 210-4": "#d6e5e4",
    "RAL 210-5": "#d9e7e1",
    "RAL 210-6": "#d9e9d8",
    "RAL 210-M": "#a8ada1",
    "RAL 220 20 05": "#2b3236",
    "RAL 220 20 10": "#25343b",
    "RAL 220 20 15": "#1a343e",
    "RAL 220 20 20": "#143543",
    "RAL 220 30 05": "#3f474a",
    "RAL 220 30 10": "#394a4f",
    "RAL 220 30 15": "#344c56",
    "RAL 220 30 20": "#2a4c59",
    "RAL 220 30 25": "#1c4d5f",
    "RAL 220 30 30": "#0b4a63",
    "RAL 220 40 05": "#555f61",
    "RAL 220 40 10": "#4f6066",
    "RAL 220 40 15": "#47616d",
    "RAL 220 40 20": "#3f6271",
    "RAL 220 40 25": "#356376",
    "RAL 220 40 30": "#2b637e",
    "RAL 220 40 35": "#1c6482",
    "RAL 220 40 40": "#0e6487",
    "RAL 220 50 05": "#6f787b",
    "RAL 220 50 10": "#68787f",
    "RAL 220 50 15": "#5e7a85",
    "RAL 220 50 20": "#557b89",
    "RAL 220 50 25": "#4d7b8e",
    "RAL 220 50 30": "#407a93",
    "RAL 220 50 35": "#377d9a",
    "RAL 220 50 40": "#277da0",
    "RAL 220 60 05": "#869092",
    "RAL 220 60 10": "#7f9199",
    "RAL 220 60 15": "#78949f",
    "RAL 220 60 20": "#6d94a5",
    "RAL 220 60 25": "#6495aa",
    "RAL 220 60 30": "#5c98b1",
    "RAL 220 60 35": "#5196b3",
    "RAL 220 60 40": "#4696ba",
    "RAL 220 70 05": "#a1abaf",
    "RAL 220 70 10": "#9baeb5",
    "RAL 220 70 15": "#92b0bb",
    "RAL 220 70 20": "#89b1c0",
    "RAL 220 70 25": "#7eb0c5",
    "RAL 220 70 30": "#74b0c8",
    "RAL 220 70 35": "#6ab2d1",
    "RAL 220 80 05": "#bcc6c9",
    "RAL 220 80 10": "#b6cbd2",
    "RAL 220 80 15": "#a9c9d5",
    "RAL 220 80 20": "#a5cdde",
    "RAL 220 80 25": "#9ecfe2",
    "RAL 220 85 05": "#cbd6d9",
    "RAL 220 85 10": "#c1d7df",
    "RAL 220 85 15": "#b8d9e4",
    "RAL 220 90 05": "#d9e5e6",
    "RAL 220 90 10": "#cee4e7",
    "RAL 220-1": "#78b97a",
    "RAL 220-2": "#539a5b",
    "RAL 220-3": "#256e46",
    "RAL 220-4": "#3f835b",
    "RAL 220-5": "#427e57",
    "RAL 220-6": "#266853",
    "RAL 220-M": "#217d4c",
    "RAL 230 20 10": "#27353d",
    "RAL 230 20 15": "#213542",
    "RAL 230 20 20": "#133246",
    "RAL 230 30 10": "#3d4b53",
    "RAL 230 30 15": "#334a57",
    "RAL 230 30 20": "#2b4a5d",
    "RAL 230 30 25": "#214b64",
    "RAL 230 40 10": "#505f69",
    "RAL 230 40 15": "#49606e",
    "RAL 230 40 20": "#416275",
    "RAL 230 40 25": "#35607b",
    "RAL 230 40 30": "#2e6282",
    "RAL 230 40 35": "#176189",
    "RAL 230 40 40": "#0c608d",
    "RAL 230 50 10": "#677881",
    "RAL 230 50 15": "#607a88",
    "RAL 230 50 20": "#597b8f",
    "RAL 230 50 25": "#507a94",
    "RAL 230 50 30": "#437c9d",
    "RAL 230 50 35": "#3b7aa1",
    "RAL 230 50 40": "#2779a8",
    "RAL 230 60 10": "#81939d",
    "RAL 230 60 15": "#7892a1",
    "RAL 230 60 20": "#7093a9",
    "RAL 230 60 25": "#6692af",
    "RAL 230 60 30": "#5d92b4",
    "RAL 230 60 35": "#5394be",
    "RAL 230 60 40": "#4593c4",
    "RAL 230 70 10": "#9daeb9",
    "RAL 230 70 15": "#92afbe",
    "RAL 230 70 20": "#89aec5",
    "RAL 230 70 25": "#83afcc",
    "RAL 230 70 30": "#78b0d2",
    "RAL 230 80 10": "#b7c9d4",
    "RAL 230 80 15": "#adc7d7",
    "RAL 230 80 20": "#a6cae0",
    "RAL 230 85 05": "#cbd4db",
    "RAL 230 85 10": "#c1d4e0",
    "RAL 230 85 15": "#bbd6e7",
    "RAL 230 85 20": "#b3d8ee",
    "RAL 230 90 05": "#dae3e5",
    "RAL 230-1": "#bddea0",
    "RAL 230-2": "#9ccb76",
    "RAL 230-3": "#84b753",
    "RAL 230-4": "#689a47",
    "RAL 230-5": "#436b3f",
    "RAL 230-6": "#3f5e37",
    "RAL 230-M": "#6ca457",
    "RAL 240 20 05": "#2e3438",
    "RAL 240 20 10": "#27333d",
    "RAL 240 20 15": "#223444",
    "RAL 240 20 20": "#18334a",
    "RAL 240 20 22": "#11314b",
    "RAL 240 30 05": "#41484d",
    "RAL 240 30 10": "#3b4954",
    "RAL 240 30 15": "#364a5b",
    "RAL 240 30 20": "#2d4960",
    "RAL 240 30 25": "#1e4867",
    "RAL 240 30 30": "#12486d",
    "RAL 240 30 35": "#0b4872",
    "RAL 240 40 05": "#565e64",
    "RAL 240 40 10": "#515f6b",
    "RAL 240 40 15": "#4a6073",
    "RAL 240 40 20": "#405f78",
    "RAL 240 40 25": "#386080",
    "RAL 240 40 30": "#2c5e87",
    "RAL 240 40 35": "#125e8d",
    "RAL 240 40 40": "#0a5d94",
    "RAL 240 50 05": "#6f777c",
    "RAL 240 50 10": "#677683",
    "RAL 240 50 15": "#60788b",
    "RAL 240 50 20": "#577792",
    "RAL 240 50 25": "#4f7899",
    "RAL 240 50 30": "#4677a0",
    "RAL 240 50 35": "#3676a7",
    "RAL 240 50 40": "#2a75ad",
    "RAL 240 60 05": "#879097",
    "RAL 240 60 10": "#7e8f9c",
    "RAL 240 60 15": "#7890a4",
    "RAL 240 60 20": "#7192ad",
    "RAL 240 60 25": "#6992b4",
    "RAL 240 60 30": "#5e91bc",
    "RAL 240 60 35": "#5491c3",
    "RAL 240 60 40": "#4a92c7",
    "RAL 240 70 05": "#a2aab1",
    "RAL 240 70 10": "#9babb8",
    "RAL 240 70 15": "#93acc1",
    "RAL 240 70 20": "#8bacc7",
    "RAL 240 70 25": "#84adcf",
    "RAL 240 70 30": "#78abd5",
    "RAL 240 80 05": "#bcc5cb",
    "RAL 240 80 10": "#b8c8d6",
    "RAL 240 80 15": "#b0c8dd",
    "RAL 240 80 20": "#a7c9e5",
    "RAL 240 85 05": "#cbd4db",
    "RAL 240 85 10": "#c3d4e2",
    "RAL 240 85 15": "#bbd5ea",
    "RAL 240 90 05": "#dae3e9",
    "RAL 240 90 10": "#d1e5ef",
    "RAL 240-1": "#d6da96",
    "RAL 240-2": "#a4b36c",
    "RAL 240-3": "#8c9a5a",
    "RAL 240-4": "#788249",
    "RAL 240-5": "#5c6f41",
    "RAL 240-6": "#52703d",
    "RAL 240-M": "#617441",
    "RAL 250 20 20": "#17304b",
    "RAL 250 20 25": "#112e50",
    "RAL 250 30 15": "#34465a",
    "RAL 250 30 20": "#2c4662",
    "RAL 250 30 25": "#25476a",
    "RAL 250 30 30": "#144571",
    "RAL 250 40 10": "#525e6c",
    "RAL 250 40 15": "#4b5e74",
    "RAL 250 40 20": "#435d79",
    "RAL 250 40 25": "#3a5d82",
    "RAL 250 40 30": "#2e5d8a",
    "RAL 250 40 35": "#1f5b90",
    "RAL 250 40 40": "#155b95",
    "RAL 250 50 10": "#697684",
    "RAL 250 50 15": "#62758c",
    "RAL 250 50 20": "#5c7693",
    "RAL 250 50 25": "#54759b",
    "RAL 250 50 30": "#4b74a4",
    "RAL 250 50 35": "#4074ac",
    "RAL 250 50 40": "#3074b4",
    "RAL 250 60 10": "#818e9e",
    "RAL 250 60 15": "#7c8fa7",
    "RAL 250 60 20": "#748eaf",
    "RAL 250 60 25": "#6d8eb7",
    "RAL 250 60 30": "#648ebe",
    "RAL 250 60 35": "#5c8dc7",
    "RAL 250 60 40": "#548ecf",
    "RAL 250 70 10": "#9caaba",
    "RAL 250 70 15": "#96aac2",
    "RAL 250 70 20": "#8fa9ca",
    "RAL 250 70 25": "#89aad2",
    "RAL 250 70 30": "#80a9d9",
    "RAL 250 80 10": "#b9c6d6",
    "RAL 250 80 15": "#b4c8de",
    "RAL 250 80 20": "#a9c3e4",
    "RAL 250 85 05": "#cad0d8",
    "RAL 250 85 10": "#c4d1e2",
    "RAL 250 85 15": "#bfd3ea",
    "RAL 250 90 05": "#dbe1e8",
    "RAL 250-1": "#e9e9a9",
    "RAL 250-2": "#e1e37a",
    "RAL 250-3": "#b5bd2c",
    "RAL 250-4": "#9caa4d",
    "RAL 250-5": "#899542",
    "RAL 250-6": "#626932",
    "RAL 250-M": "#a8a94a",
    "RAL 260 20 05": "#2f343a",
    "RAL 260 20 10": "#2b333f",
    "RAL 260 20 15": "#223045",
    "RAL 260 20 20": "#1e314b",
    "RAL 260 30 05": "#42474e",
    "RAL 260 30 10": "#3f4756",
    "RAL 260 30 15": "#3a475c",
    "RAL 260 30 20": "#344663",
    "RAL 260 30 25": "#2a4569",
    "RAL 260 30 30": "#254672",
    "RAL 260 30 35": "#14437b",
    "RAL 260 40 05": "#585d64",
    "RAL 260 40 10": "#565f6e",
    "RAL 260 40 15": "#515e75",
    "RAL 260 40 20": "#485b7a",
    "RAL 260 40 25": "#435c83",
    "RAL 260 40 30": "#3d5c89",
    "RAL 260 40 35": "#335a90",
    "RAL 260 40 40": "#205a9b",
    "RAL 260 40 45": "#1458a2",
    "RAL 260 50 05": "#6f747c",
    "RAL 260 50 10": "#6c7484",
    "RAL 260 50 15": "#67748c",
    "RAL 260 50 20": "#647694",
    "RAL 260 50 25": "#5d759e",
    "RAL 260 50 30": "#5574a7",
    "RAL 260 50 35": "#4c72ac",
    "RAL 260 50 40": "#4373b7",
    "RAL 260 60 05": "#888e96",
    "RAL 260 60 10": "#848d9e",
    "RAL 260 60 15": "#8390a9",
    "RAL 260 60 20": "#7b8eaf",
    "RAL 260 60 25": "#768eb7",
    "RAL 260 60 30": "#708ec0",
    "RAL 260 60 35": "#678dc8",
    "RAL 260 70 05": "#a6abb3",
    "RAL 260 70 10": "#a1aabb",
    "RAL 260 70 15": "#9aa9c3",
    "RAL 260 70 20": "#96a9cc",
    "RAL 260 70 25": "#8ea8d4",
    "RAL 260 80 05": "#c0c5ce",
    "RAL 260 80 10": "#bbc4d6",
    "RAL 260 80 15": "#b5c4de",
    "RAL 260 85 05": "#ccd0d8",
    "RAL 260 85 10": "#c8d2e4",
    "RAL 260 90 05": "#dce0e5",
    "RAL 260-1": "#eeebb7",
    "RAL 260-2": "#ebe88b",
    "RAL 260-3": "#e8da58",
    "RAL 260-4": "#dbc53c",
    "RAL 260-5": "#d0b640",
    "RAL 260-6": "#deba33",
    "RAL 260-M": "#ab9756",
    "RAL 270 20 20": "#212e4c",
    "RAL 270 20 25": "#192c52",
    "RAL 270 20 29": "#132c5b",
    "RAL 270 30 15": "#3c455c",
    "RAL 270 30 20": "#384463",
    "RAL 270 30 25": "#32446b",
    "RAL 270 30 30": "#2a4171",
    "RAL 270 30 35": "#21407a",
    "RAL 270 30 40": "#163d81",
    "RAL 270 40 15": "#545c74",
    "RAL 270 40 20": "#4e5b7c",
    "RAL 270 40 25": "#4b5b84",
    "RAL 270 40 30": "#44588b",
    "RAL 270 40 35": "#3c5793",
    "RAL 270 40 40": "#33559a",
    "RAL 270 50 10": "#6e7586",
    "RAL 270 50 15": "#6c758f",
    "RAL 270 50 20": "#677396",
    "RAL 270 50 25": "#63739e",
    "RAL 270 50 30": "#5c70a6",
    "RAL 270 50 35": "#556eab",
    "RAL 270 50 40": "#4f6fb6",
    "RAL 270 60 10": "#868d9f",
    "RAL 270 60 15": "#858ea9",
    "RAL 270 60 20": "#808cb1",
    "RAL 270 60 25": "#7b8cb9",
    "RAL 270 60 30": "#778bc2",
    "RAL 270 60 35": "#6f88c8",
    "RAL 270 70 10": "#a3a9bc",
    "RAL 270 70 15": "#9fa8c4",
    "RAL 270 70 20": "#9ca8ce",
    "RAL 270 70 25": "#94a4d3",
    "RAL 270 80 10": "#bfc4d7",
    "RAL 270 80 15": "#b9c1de",
    "RAL 270 85 05": "#ced0d7",
    "RAL 270 85 10": "#cacfe3",
    "RAL 270 85 15": "#c5cee9",
    "RAL 270 90 05": "#dee0e8",
    "RAL 270-1": "#f6e389",
    "RAL 270-2": "#edd14f",
    "RAL 270-3": "#e5c436",
    "RAL 270-4": "#dcb800",
    "RAL 270-5": "#e4bd04",
    "RAL 270-6": "#efcb4f",
    "RAL 270-M": "#af8e36",
    "RAL 280 20 05": "#33343a",
    "RAL 280 20 10": "#303241",
    "RAL 280 20 15": "#2d3146",
    "RAL 280 20 20": "#282f4b",
    "RAL 280 20 25": "#252f53",
    "RAL 280 20 30": "#202d59",
    "RAL 280 30 05": "#44464d",
    "RAL 280 30 10": "#444756",
    "RAL 280 30 15": "#42455e",
    "RAL 280 30 20": "#3f4565",
    "RAL 280 30 25": "#3b436b",
    "RAL 280 30 30": "#344171",
    "RAL 280 30 35": "#324077",
    "RAL 280 30 40": "#2c407e",
    "RAL 280 40 05": "#5b5d64",
    "RAL 280 40 10": "#595b6c",
    "RAL 280 40 15": "#565a73",
    "RAL 280 40 20": "#54597c",
    "RAL 280 40 25": "#525984",
    "RAL 280 40 30": "#4e578a",
    "RAL 280 40 35": "#495691",
    "RAL 280 40 40": "#425499",
    "RAL 280 40 45": "#3a52a0",
    "RAL 280 50 05": "#72757e",
    "RAL 280 50 10": "#717485",
    "RAL 280 50 15": "#6f728c",
    "RAL 280 50 20": "#6c7095",
    "RAL 280 50 25": "#69709d",
    "RAL 280 50 30": "#666ea4",
    "RAL 280 50 35": "#626dab",
    "RAL 280 50 40": "#5e6db6",
    "RAL 280 60 05": "#8b8d96",
    "RAL 280 60 10": "#898b9e",
    "RAL 280 60 15": "#888aa6",
    "RAL 280 60 20": "#868aaf",
    "RAL 280 60 25": "#8288b7",
    "RAL 280 60 30": "#8088be",
    "RAL 280 60 35": "#7c87c8",
    "RAL 280 70 05": "#a5a6b0",
    "RAL 280 70 10": "#a6a8ba",
    "RAL 280 70 15": "#a3a6c2",
    "RAL 280 70 20": "#a1a5cc",
    "RAL 280 70 25": "#9ea4d3",
    "RAL 280 80 05": "#c4c5ce",
    "RAL 280 80 10": "#c1c2d5",
    "RAL 280 80 15": "#bbbfdc",
    "RAL 280 85 05": "#cfd1d8",
    "RAL 280 85 10": "#cbd0e1",
    "RAL 280 90 05": "#dee0e9",
    "RAL 280 93 05": "#e7e9f1",
    "RAL 280-1": "#f5e599",
    "RAL 280-2": "#e6d795",
    "RAL 280-3": "#d5c17d",
    "RAL 280-4": "#c9b365",
    "RAL 280-5": "#cba74a",
    "RAL 280-6": "#c19c46",
    "RAL 280-M": "#a78c49",
    "RAL 290 20 10": "#2c2c3c",
    "RAL 290 20 15": "#2f2d42",
    "RAL 290 20 20": "#2f2f4c",
    "RAL 290 20 25": "#2b2b51",
    "RAL 290 20 30": "#252855",
    "RAL 290 20 35": "#23275d",
    "RAL 290 30 10": "#444253",
    "RAL 290 30 15": "#44425a",
    "RAL 290 30 20": "#413f60",
    "RAL 290 30 25": "#403e68",
    "RAL 290 30 30": "#3e3d6f",
    "RAL 290 30 35": "#3c3d77",
    "RAL 290 30 40": "#383a7d",
    "RAL 290 40 10": "#5b5a6b",
    "RAL 290 40 15": "#5b5872",
    "RAL 290 40 20": "#59567b",
    "RAL 290 40 25": "#575380",
    "RAL 290 40 30": "#545187",
    "RAL 290 40 35": "#524f8e",
    "RAL 290 40 40": "#504f97",
    "RAL 290 40 45": "#4c4e9e",
    "RAL 290 50 10": "#727184",
    "RAL 290 50 15": "#716f89",
    "RAL 290 50 20": "#706c92",
    "RAL 290 50 25": "#706b9a",
    "RAL 290 50 30": "#6e6aa1",
    "RAL 290 50 35": "#6b68a9",
    "RAL 290 50 40": "#6967b1",
    "RAL 290 60 10": "#8b899e",
    "RAL 290 60 15": "#8b88a5",
    "RAL 290 60 20": "#8884ad",
    "RAL 290 60 25": "#8985b6",
    "RAL 290 60 30": "#8783bd",
    "RAL 290 60 35": "#8280c3",
    "RAL 290 70 10": "#a7a5ba",
    "RAL 290 70 15": "#a6a2c2",
    "RAL 290 70 20": "#a4a1c9",
    "RAL 290 70 25": "#a29ed1",
    "RAL 290 80 10": "#c2c0d4",
    "RAL 290 80 15": "#c2bfdb",
    "RAL 290 85 05": "#d4d2d9",
    "RAL 290 85 10": "#cecde7",
    "RAL 290 90 05": "#e0e0e7",
    "RAL 290 93 05": "#e7e7ef",
    "RAL 290-1": "#c8a056",
    "RAL 290-2": "#b08a43",
    "RAL 290-3": "#caae66",
    "RAL 290-4": "#bc972d",
    "RAL 290-5": "#d7b64c",
    "RAL 290-6": "#eab229",
    "RAL 290-M": "#aa833b",
    "RAL 300 20 05": "#343239",
    "RAL 300 20 10": "#312d3c",
    "RAL 300 20 15": "#312c42",
    "RAL 300 20 20": "#312a47",
    "RAL 300 20 25": "#30284b",
    "RAL 300 20 30": "#2e2653",
    "RAL 300 30 05": "#47454d",
    "RAL 300 30 10": "#474254",
    "RAL 300 30 15": "#474058",
    "RAL 300 30 20": "#473e5e",
    "RAL 300 30 25": "#483d65",
    "RAL 300 30 30": "#473b6b",
    "RAL 300 30 35": "#463a71",
    "RAL 300 30 40": "#443777",
    "RAL 300 40 05": "#5e5c64",
    "RAL 300 40 10": "#5d5869",
    "RAL 300 40 15": "#5d566f",
    "RAL 300 40 20": "#5e5476",
    "RAL 300 40 25": "#5e527d",
    "RAL 300 40 30": "#5f5084",
    "RAL 300 40 35": "#5e4f88",
    "RAL 300 40 40": "#5b4b8e",
    "RAL 300 40 45": "#5b4a96",
    "RAL 300 50 05": "#74737b",
    "RAL 300 50 10": "#767082",
    "RAL 300 50 15": "#766e89",
    "RAL 300 50 20": "#776c90",
    "RAL 300 50 25": "#776996",
    "RAL 300 50 30": "#77679d",
    "RAL 300 50 35": "#7866a4",
    "RAL 300 50 40": "#7663ab",
    "RAL 300 60 05": "#8e8d96",
    "RAL 300 60 10": "#8f899c",
    "RAL 300 60 15": "#9087a3",
    "RAL 300 60 20": "#9084aa",
    "RAL 300 60 25": "#9081b0",
    "RAL 300 60 30": "#907fb8",
    "RAL 300 60 35": "#8f7cbe",
    "RAL 300 70 05": "#a9a7b1",
    "RAL 300 70 10": "#aaa3b7",
    "RAL 300 70 15": "#aba1bf",
    "RAL 300 70 20": "#aca0c6",
    "RAL 300 70 25": "#ac9ccd",
    "RAL 300 80 05": "#c6c3cc",
    "RAL 300 80 10": "#c4bed4",
    "RAL 300 80 15": "#c7bddb",
    "RAL 300 85 05": "#d2cfd6",
    "RAL 300 85 10": "#d5cbe1",
    "RAL 300 90 05": "#e1dfe8",
    "RAL 3000": "#962a27",
    "RAL 3001": "#8f1e24",
    "RAL 3002": "#8d1f24",
    "RAL 3003": "#7c0d24",
    "RAL 3004": "#651927",
    "RAL 3005": "#561e27",
    "RAL 3007": "#3d2326",
    "RAL 3009": "#643730",
    "RAL 3011": "#6e2124",
    "RAL 3012": "#b7856e",
    "RAL 3013": "#8a2f28",
    "RAL 3014": "#bc6f72",
    "RAL 3015": "#cc9ea4",
    "RAL 3016": "#963d2f",
    "RAL 3017": "#b9535b",
    "RAL 3018": "#b63c49",
    "RAL 3020": "#ab1519",
    "RAL 3022": "#be6954",
    "RAL 3024": "#ee1729",
    "RAL 3026": "#f71027",
    "RAL 3027": "#9e1b3c",
    "RAL 3028": "#b92726",
    "RAL 3031": "#973238",
    "RAL 3032": "#661925",
    "RAL 3033": "#94352d",
    "RAL 310 20 20": "#382c46",
    "RAL 310 20 25": "#3b2a4c",
    "RAL 310 20 30": "#392650",
    "RAL 310 30 15": "#4e4359",
    "RAL 310 30 20": "#4d3e5c",
    "RAL 310 30 25": "#4f3c62",
    "RAL 310 30 30": "#523968",
    "RAL 310 30 35": "#51376a",
    "RAL 310 30 40": "#533671",
    "RAL 310 40 10": "#635b6b",
    "RAL 310 40 15": "#655971",
    "RAL 310 40 20": "#675776",
    "RAL 310 40 25": "#68537b",
    "RAL 310 40 30": "#674f7e",
    "RAL 310 40 35": "#694e84",
    "RAL 310 40 40": "#6c4c8a",
    "RAL 310 50 10": "#7a7183",
    "RAL 310 50 15": "#7c6f89",
    "RAL 310 50 20": "#7f6d8e",
    "RAL 310 50 25": "#806a94",
    "RAL 310 50 30": "#82689a",
    "RAL 310 50 35": "#82659e",
    "RAL 310 50 40": "#8363a4",
    "RAL 310 60 10": "#92899c",
    "RAL 310 60 15": "#9688a2",
    "RAL 310 60 20": "#9985a8",
    "RAL 310 60 25": "#9b82ad",
    "RAL 310 60 30": "#9d80b2",
    "RAL 310 60 35": "#9e7cba",
    "RAL 310 70 10": "#aea4b5",
    "RAL 310 70 15": "#b1a1bc",
    "RAL 310 70 20": "#b29ec1",
    "RAL 310 70 25": "#b49cc7",
    "RAL 310 80 10": "#c9bfd1",
    "RAL 310 80 15": "#cdbdd8",
    "RAL 310 85 05": "#d4d1d8",
    "RAL 310 85 10": "#d8cde0",
    "RAL 310 90 05": "#e6e1e7",
    "RAL 310-1": "#ecd8b6",
    "RAL 310-2": "#dfc59a",
    "RAL 310-3": "#d1af77",
    "RAL 310-4": "#c1975a",
    "RAL 310-5": "#ab8049",
    "RAL 310-6": "#825e33",
    "RAL 310-M": "#a98153",
    "RAL 320 20 05": "#363239",
    "RAL 320 20 10": "#372d3a",
    "RAL 320 20 15": "#382a3e",
    "RAL 320 20 20": "#3d2742",
    "RAL 320 20 25": "#3c2445",
    "RAL 320 30 05": "#49444b",
    "RAL 320 30 10": "#4c424f",
    "RAL 320 30 15": "#4d3d52",
    "RAL 320 30 20": "#503956",
    "RAL 320 30 25": "#54375b",
    "RAL 320 30 30": "#553560",
    "RAL 320 30 35": "#583264",
    "RAL 320 30 37": "#5a3168",
    "RAL 320 40 05": "#615c63",
    "RAL 320 40 10": "#625866",
    "RAL 320 40 15": "#66556b",
    "RAL 320 40 20": "#685270",
    "RAL 320 40 25": "#6a4f74",
    "RAL 320 40 30": "#6d4977",
    "RAL 320 40 35": "#70467b",
    "RAL 320 40 40": "#734382",
    "RAL 320 50 05": "#767279",
    "RAL 320 50 10": "#7a6e7e",
    "RAL 320 50 15": "#7d6b83",
    "RAL 320 50 20": "#826a88",
    "RAL 320 50 25": "#83648d",
    "RAL 320 50 30": "#876393",
    "RAL 320 50 35": "#895c95",
    "RAL 320 50 40": "#8c5d9b",
    "RAL 320 60 05": "#918c94",
    "RAL 320 60 10": "#948998",
    "RAL 320 60 15": "#98869e",
    "RAL 320 60 20": "#9b80a2",
    "RAL 320 60 25": "#9d7ea7",
    "RAL 320 60 30": "#a17aad",
    "RAL 320 60 35": "#a477b0",
    "RAL 320 70 05": "#aba5ae",
    "RAL 320 70 10": "#aea1b4",
    "RAL 320 70 15": "#b19eb9",
    "RAL 320 70 20": "#b99dc1",
    "RAL 320 70 25": "#bb97c4",
    "RAL 320 80 05": "#c8c1c9",
    "RAL 320 80 10": "#ccbecf",
    "RAL 320 80 15": "#cfb9d3",
    "RAL 320 85 05": "#d4ced6",
    "RAL 320 85 10": "#dacbdd",
    "RAL 320 90 05": "#e6dfe5",
    "RAL 320-1": "#c5ad71",
    "RAL 320-2": "#a28456",
    "RAL 320-3": "#ab8950",
    "RAL 320-4": "#926a3a",
    "RAL 320-5": "#745233",
    "RAL 320-6": "#65472d",
    "RAL 320-M": "#a97a2e",
    "RAL 330 20 20": "#40283e",
    "RAL 330 20 25": "#452543",
    "RAL 330 30 15": "#523f51",
    "RAL 330 30 20": "#563c54",
    "RAL 330 30 25": "#593857",
    "RAL 330 30 30": "#5e355a",
    "RAL 330 30 35": "#63315e",
    "RAL 330 30 40": "#652a5f",
    "RAL 330 40 10": "#665966",
    "RAL 330 40 15": "#6a5669",
    "RAL 330 40 20": "#6e546e",
    "RAL 330 40 25": "#725071",
    "RAL 330 40 30": "#784c74",
    "RAL 330 40 35": "#7c4978",
    "RAL 330 40 40": "#7c4278",
    "RAL 330 40 45": "#813d7a",
    "RAL 330 50 10": "#7d6f7d",
    "RAL 330 50 15": "#836d82",
    "RAL 330 50 20": "#876a86",
    "RAL 330 50 25": "#8b6789",
    "RAL 330 50 30": "#90648e",
    "RAL 330 50 35": "#936091",
    "RAL 330 50 40": "#985a92",
    "RAL 330 60 10": "#978998",
    "RAL 330 60 15": "#9d869d",
    "RAL 330 60 20": "#a283a0",
    "RAL 330 60 25": "#a47ea1",
    "RAL 330 60 30": "#a97ba6",
    "RAL 330 60 35": "#af76aa",
    "RAL 330 60 40": "#b273ae",
    "RAL 330 70 10": "#b3a3b3",
    "RAL 330 70 15": "#b69fb5",
    "RAL 330 70 20": "#bd9cba",
    "RAL 330 70 25": "#c398be",
    "RAL 330 70 30": "#c695bf",
    "RAL 330 80 10": "#cfbecd",
    "RAL 330 80 15": "#d3bbd1",
    "RAL 330 80 20": "#dcb8d5",
    "RAL 330 85 05": "#d7d1d8",
    "RAL 330 85 10": "#deccdc",
    "RAL 330 85 15": "#e3c9df",
    "RAL 330 90 05": "#e9e0e4",
    "RAL 330-1": "#9b695a",
    "RAL 330-2": "#814e38",
    "RAL 330-3": "#6f5041",
    "RAL 330-4": "#553e30",
    "RAL 330-5": "#4b352e",
    "RAL 330-6": "#423430",
    "RAL 330-M": "#805b45",
    "RAL 340 20 05": "#363035",
    "RAL 340 20 10": "#392b34",
    "RAL 340 20 15": "#3b2534",
    "RAL 340 20 20": "#41263a",
    "RAL 340 20 25": "#48263d",
    "RAL 340 30 05": "#4a4449",
    "RAL 340 30 10": "#4f3f4a",
    "RAL 340 30 15": "#533c4c",
    "RAL 340 30 20": "#57394d",
    "RAL 340 30 25": "#5d3552",
    "RAL 340 30 30": "#5f3052",
    "RAL 340 30 35": "#632954",
    "RAL 340 30 38": "#682455",
    "RAL 340 40 05": "#60595f",
    "RAL 340 40 10": "#665661",
    "RAL 340 40 15": "#6b5363",
    "RAL 340 40 20": "#704f65",
    "RAL 340 40 25": "#754b69",
    "RAL 340 40 30": "#79476b",
    "RAL 340 40 35": "#7b406c",
    "RAL 340 40 40": "#7f3c6d",
    "RAL 340 40 45": "#893371",
    "RAL 340 50 05": "#797277",
    "RAL 340 50 10": "#806e7a",
    "RAL 340 50 15": "#856a7c",
    "RAL 340 50 20": "#8a677e",
    "RAL 340 50 25": "#8e6281",
    "RAL 340 50 30": "#935e83",
    "RAL 340 50 35": "#975886",
    "RAL 340 50 40": "#9e5388",
    "RAL 340 50 45": "#a34d89",
    "RAL 340 60 05": "#948c92",
    "RAL 340 60 10": "#998793",
    "RAL 340 60 15": "#a08497",
    "RAL 340 60 20": "#a47f99",
    "RAL 340 60 25": "#a87a9a",
    "RAL 340 60 30": "#ad779e",
    "RAL 340 60 35": "#b473a0",
    "RAL 340 60 40": "#b86fa1",
    "RAL 340 70 05": "#ada5ab",
    "RAL 340 70 10": "#b3a1ae",
    "RAL 340 70 15": "#bb9db2",
    "RAL 340 70 20": "#bf9ab4",
    "RAL 340 70 25": "#c495b4",
    "RAL 340 70 30": "#cb90b9",
    "RAL 340 70 35": "#d18dbb",
    "RAL 340 80 05": "#cbc2c6",
    "RAL 340 80 10": "#d2bfcb",
    "RAL 340 80 15": "#d7bacd",
    "RAL 340 80 20": "#deb7cf",
    "RAL 340 85 05": "#d7ced4",
    "RAL 340 85 10": "#e0cbd9",
    "RAL 340 85 15": "#e8c9dc",
    "RAL 340 90 05": "#e9dfe2",
    "RAL 340 93 05": "#efe6ed",
    "RAL 340-1": "#b7a2a8",
    "RAL 340-2": "#9d8b91",
    "RAL 340-3": "#765553",
    "RAL 340-4": "#603e42",
    "RAL 340-5": "#4a2c30",
    "RAL 340-6": "#4a2b32",
    "RAL 340-M": "#4e373c",
    "RAL 350 20 10": "#392c34",
    "RAL 350 20 15": "#3e2934",
    "RAL 350 20 20": "#442435",
    "RAL 350 20 25": "#472136",
    "RAL 350 20 30": "#521c39",
    "RAL 350 30 10": "#4f4047",
    "RAL 350 30 15": "#553e49",
    "RAL 350 30 20": "#5b3a4a",
    "RAL 350 30 25": "#5f354b",
    "RAL 350 30 30": "#65324c",
    "RAL 350 30 35": "#682a4c",
    "RAL 350 30 40": "#6c224d",
    "RAL 350 40 10": "#685860",
    "RAL 350 40 15": "#6d5460",
    "RAL 350 40 20": "#725062",
    "RAL 350 40 25": "#764c62",
    "RAL 350 40 30": "#7d4863",
    "RAL 350 40 35": "#814264",
    "RAL 350 40 40": "#863f65",
    "RAL 350 40 45": "#8a3765",
    "RAL 350 40 50": "#922d66",
    "RAL 350 50 10": "#806e77",
    "RAL 350 50 15": "#866b78",
    "RAL 350 50 20": "#8c677a",
    "RAL 350 50 25": "#92637b",
    "RAL 350 50 30": "#97617d",
    "RAL 350 50 35": "#9f5a7c",
    "RAL 350 50 40": "#a1557b",
    "RAL 350 50 45": "#a6507e",
    "RAL 350 50 50": "#b14a7e",
    "RAL 350 60 10": "#9a8892",
    "RAL 350 60 15": "#a08492",
    "RAL 350 60 20": "#a88195",
    "RAL 350 60 25": "#ae7c94",
    "RAL 350 60 30": "#b57996",
    "RAL 350 60 35": "#b97396",
    "RAL 350 60 40": "#c06f97",
    "RAL 350 60 45": "#c36b99",
    "RAL 350 70 10": "#b6a3ab",
    "RAL 350 70 15": "#bc9eac",
    "RAL 350 70 20": "#c098ac",
    "RAL 350 70 25": "#ca97af",
    "RAL 350 70 30": "#d192b0",
    "RAL 350 70 35": "#d78eb1",
    "RAL 350 80 10": "#d2bdc6",
    "RAL 350 80 15": "#d9bac7",
    "RAL 350 80 20": "#e0b6cb",
    "RAL 350 85 05": "#d8ced4",
    "RAL 350 85 10": "#e2ccd6",
    "RAL 350 85 15": "#e8c8d6",
    "RAL 350 90 05": "#eadfe1",
    "RAL 350 90 10": "#f0dae5",
    "RAL 350 93 05": "#f1e6eb",
    "RAL 350-1": "#8e3223",
    "RAL 350-2": "#983f34",
    "RAL 350-3": "#934936",
    "RAL 350-4": "#743326",
    "RAL 350-5": "#6d3426",
    "RAL 350-6": "#5d362e",
    "RAL 350-M": "#50302c",
    "RAL 360 20 15": "#40282e",
    "RAL 360 30 05": "#4b4446",
    "RAL 360 30 10": "#503f45",
    "RAL 360 30 15": "#553b44",
    "RAL 360 30 20": "#5c3945",
    "RAL 360 30 25": "#5f3445",
    "RAL 360 30 30": "#642f44",
    "RAL 360 30 35": "#6a2942",
    "RAL 360 30 40": "#712444",
    "RAL 360 40 05": "#625a5d",
    "RAL 360 40 10": "#67565d",
    "RAL 360 40 15": "#6c525b",
    "RAL 360 40 20": "#734f5c",
    "RAL 360 40 25": "#784a5b",
    "RAL 360 40 30": "#7f465b",
    "RAL 360 40 35": "#85425c",
    "RAL 360 40 40": "#8b3d5c",
    "RAL 360 40 45": "#8f355a",
    "RAL 360 40 50": "#942a58",
    "RAL 360 50 05": "#7c7275",
    "RAL 360 50 10": "#806e75",
    "RAL 360 50 15": "#876a74",
    "RAL 360 50 20": "#8c6775",
    "RAL 360 50 25": "#946273",
    "RAL 360 50 30": "#9a5f75",
    "RAL 360 50 35": "#a25974",
    "RAL 360 50 40": "#a85773",
    "RAL 360 50 45": "#b05074",
    "RAL 360 50 50": "#b14a72",
    "RAL 360 60 05": "#958d90",
    "RAL 360 60 10": "#9a878e",
    "RAL 360 60 15": "#a1848e",
    "RAL 360 60 20": "#a9818f",
    "RAL 360 60 25": "#ae7b8e",
    "RAL 360 70 05": "#b0a7aa",
    "RAL 360 70 10": "#b6a1a8",
    "RAL 360 70 15": "#be9ea8",
    "RAL 360 80 05": "#cdc2c5",
    "RAL 360 80 10": "#d3bec4",
    "RAL 360 80 15": "#dcbac5",
    "RAL 360 85 05": "#dcd1d2",
    "RAL 360 85 10": "#e3ccd3",
    "RAL 360 90 05": "#ede0e1",
    "RAL 360 90 10": "#f2dae0",
    "RAL 360 93 05": "#f3e6e9",
    "RAL 360-1": "#cd8034",
    "RAL 360-2": "#c7782b",
    "RAL 360-3": "#b36623",
    "RAL 360-4": "#a6582e",
    "RAL 360-5": "#8c5231",
    "RAL 360-6": "#845337",
    "RAL 360-M": "#965a39",
    "RAL 370-1": "#eeb450",
    "RAL 370-2": "#eea340",
    "RAL 370-3": "#e9972b",
    "RAL 370-4": "#d4862a",
    "RAL 370-5": "#c27c2b",
    "RAL 370-6": "#ba7119",
    "RAL 370-M": "#a77743",
    "RAL 380-1": "#efa334",
    "RAL 380-2": "#ec9a18",
    "RAL 380-3": "#e48a26",
    "RAL 380-4": "#ce7528",
    "RAL 380-5": "#de7d36",
    "RAL 380-6": "#d66e2c",
    "RAL 380-M": "#985734",
    "RAL 390-1": "#d87944",
    "RAL 390-2": "#cf632c",
    "RAL 390-3": "#cb561a",
    "RAL 390-4": "#c65222",
    "RAL 390-5": "#c64918",
    "RAL 390-6": "#bc6030",
    "RAL 390-M": "#ae6740",
    "RAL 4001": "#7c5b80",
    "RAL 4002": "#823a4b",
    "RAL 4003": "#b65a88",
    "RAL 4004": "#5f1837",
    "RAL 4005": "#746395",
    "RAL 4006": "#852e6f",
    "RAL 4007": "#44263c",
    "RAL 4008": "#7c477d",
    "RAL 4009": "#95838f",
    "RAL 4010": "#ac3b71",
    "RAL 4011": "#685c80",
    "RAL 4012": "#67657a",
    "RAL 410-1": "#db8267",
    "RAL 410-2": "#d77551",
    "RAL 410-3": "#d16643",
    "RAL 410-4": "#c95f3b",
    "RAL 410-5": "#c05639",
    "RAL 410-6": "#be5e45",
    "RAL 410-M": "#9c492c",
    "RAL 420-1": "#e0ad9b",
    "RAL 420-2": "#e29e86",
    "RAL 420-3": "#d78c6d",
    "RAL 420-4": "#d16646",
    "RAL 420-5": "#ba593c",
    "RAL 420-6": "#ae5234",
    "RAL 420-M": "#904e36",
    "RAL 430-1": "#e7c2b6",
    "RAL 430-2": "#dd998a",
    "RAL 430-3": "#d47f74",
    "RAL 430-4": "#cc574e",
    "RAL 430-5": "#c3403d",
    "RAL 430-6": "#ad3a27",
    "RAL 430-M": "#984f49",
    "RAL 440-1": "#b8343e",
    "RAL 440-2": "#c1494a",
    "RAL 440-3": "#aa3a3f",
    "RAL 440-4": "#8e272e",
    "RAL 440-5": "#972f2c",
    "RAL 440-6": "#a93429",
    "RAL 440-M": "#8b1f25",
    "RAL 450-1": "#ebc5c9",
    "RAL 450-2": "#e1a2a9",
    "RAL 450-3": "#d07780",
    "RAL 450-4": "#b85561",
    "RAL 450-5": "#a12f32",
    "RAL 450-6": "#ab1522",
    "RAL 450-M": "#98111a",
    "RAL 460-1": "#e2a0a5",
    "RAL 460-2": "#d37b87",
    "RAL 460-3": "#ce5e67",
    "RAL 460-4": "#c24f54",
    "RAL 460-5": "#99363c",
    "RAL 460-6": "#80102a",
    "RAL 460-M": "#9d3d43",
    "RAL 470-1": "#e5b0bf",
    "RAL 470-2": "#d8879a",
    "RAL 470-3": "#ce6f81",
    "RAL 470-4": "#ba4865",
    "RAL 470-5": "#9e224a",
    "RAL 470-6": "#8f143e",
    "RAL 470-M": "#a34c5b",
    "RAL 480-1": "#ebc8c8",
    "RAL 480-2": "#eabebd",
    "RAL 480-3": "#e3b8bb",
    "RAL 480-4": "#e1a2af",
    "RAL 480-5": "#da8c9c",
    "RAL 480-6": "#ca6880",
    "RAL 480-M": "#9b6e73",
    "RAL 490-1": "#ebcdcf",
    "RAL 490-2": "#edc9c3",
    "RAL 490-3": "#da9991",
    "RAL 490-4": "#b57a77",
    "RAL 490-5": "#b27d8a",
    "RAL 490-6": "#c79ca6",
    "RAL 490-M": "#9a7883",
    "RAL 5000": "#35496b",
    "RAL 5001": "#294763",
    "RAL 5002": "#193278",
    "RAL 5003": "#203151",
    "RAL 5004": "#1e222c",
    "RAL 5005": "#134a85",
    "RAL 5007": "#466589",
    "RAL 5008": "#2f3a44",
    "RAL 5009": "#365875",
    "RAL 5010": "#0e457a",
    "RAL 5011": "#222c3e",
    "RAL 5012": "#457fb3",
    "RAL 5013": "#212f51",
    "RAL 5014": "#667691",
    "RAL 5015": "#3172ad",
    "RAL 5017": "#0f518a",
    "RAL 5018": "#47848d",
    "RAL 5019": "#265682",
    "RAL 5020": "#113e4d",
    "RAL 5021": "#216d76",
    "RAL 5022": "#282c58",
    "RAL 5023": "#4d648a",
    "RAL 5024": "#6c8daa",
    "RAL 5025": "#3c6379",
    "RAL 5026": "#1b2b4d",
    "RAL 510-1": "#e5c5db",
    "RAL 510-2": "#d6a0c7",
    "RAL 510-3": "#c87eac",
    "RAL 510-4": "#b75d89",
    "RAL 510-5": "#ac4173",
    "RAL 510-6": "#8f3467",
    "RAL 510-M": "#853c71",
    "RAL 520-1": "#e9cfde",
    "RAL 520-2": "#dfb6d0",
    "RAL 520-3": "#d2a0be",
    "RAL 520-4": "#ae6e90",
    "RAL 520-5": "#944a6d",
    "RAL 520-6": "#884f6d",
    "RAL 520-M": "#925387",
    "RAL 530-1": "#8c434d",
    "RAL 530-2": "#833f4e",
    "RAL 530-3": "#6f3545",
    "RAL 530-4": "#722d49",
    "RAL 530-5": "#5f243e",
    "RAL 530-6": "#5b2949",
    "RAL 530-M": "#542f3a",
    "RAL 540-1": "#cfbdd5",
    "RAL 540-2": "#b89dbe",
    "RAL 540-3": "#7a5c80",
    "RAL 540-4": "#8e6694",
    "RAL 540-5": "#795077",
    "RAL 540-6": "#512b4f",
    "RAL 540-M": "#543352",
    "RAL 550-1": "#dbcfd8",
    "RAL 550-2": "#cab8c8",
    "RAL 550-3": "#ab8fa6",
    "RAL 550-4": "#947286",
    "RAL 550-5": "#845f75",
    "RAL 550-6": "#704b5e",
    "RAL 550-M": "#a18992",
    "RAL 560-1": "#c7b9c6",
    "RAL 560-2": "#ab99ab",
    "RAL 560-3": "#856d7f",
    "RAL 560-4": "#705460",
    "RAL 560-5": "#80707e",
    "RAL 560-6": "#786c7d",
    "RAL 560-M": "#9b8a9e",
    "RAL 570-1": "#cfc9e6",
    "RAL 570-2": "#c1badf",
    "RAL 570-3": "#aca6da",
    "RAL 570-4": "#9a93cc",
    "RAL 570-5": "#7f71af",
    "RAL 570-6": "#766398",
    "RAL 570-M": "#6b5694",
    "RAL 580-1": "#c3cbe5",
    "RAL 580-2": "#bdc2de",
    "RAL 580-3": "#a8adcf",
    "RAL 580-4": "#6b6f98",
    "RAL 580-5": "#454d6c",
    "RAL 580-6": "#2a3053",
    "RAL 580-M": "#656984",
    "RAL 590-1": "#686897",
    "RAL 590-2": "#443f73",
    "RAL 590-3": "#2f3369",
    "RAL 590-4": "#2a2d59",
    "RAL 590-5": "#202b58",
    "RAL 590-6": "#1e3578",
    "RAL 590-M": "#2d315b",
    "RAL 6000": "#4a7363",
    "RAL 6001": "#40693a",
    "RAL 6002": "#3b5b2f",
    "RAL 6003": "#4f553e",
    "RAL 6004": "#214245",
    "RAL 6005": "#234235",
    "RAL 6006": "#3c3d32",
    "RAL 6007": "#2e3526",
    "RAL 6008": "#333327",
    "RAL 6009": "#2a372c",
    "RAL 6010": "#4e6e39",
    "RAL 6011": "#6a7c5b",
    "RAL 6012": "#2f3b39",
    "RAL 6013": "#777659",
    "RAL 6014": "#454339",
    "RAL 6015": "#3c3f38",
    "RAL 6016": "#256753",
    "RAL 6017": "#5c8144",
    "RAL 6018": "#689a45",
    "RAL 6019": "#b8cfad",
    "RAL 6020": "#3b4634",
    "RAL 6021": "#899b79",
    "RAL 6022": "#3b382e",
    "RAL 6024": "#3a8258",
    "RAL 6025": "#5d703e",
    "RAL 6026": "#0d5951",
    "RAL 6027": "#88b5b3",
    "RAL 6028": "#3d5547",
    "RAL 6029": "#226c45",
    "RAL 6032": "#417e57",
    "RAL 6033": "#568480",
    "RAL 6034": "#86a9ad",
    "RAL 6035": "#2e4f31",
    "RAL 6036": "#27514a",
    "RAL 6037": "#3f8c3d",
    "RAL 6038": "#20a339",
    "RAL 6039": "#abc251",
    "RAL 610-1": "#748aa9",
    "RAL 610-2": "#667692",
    "RAL 610-3": "#768fb7",
    "RAL 610-4": "#92acd6",
    "RAL 610-5": "#5670ab",
    "RAL 610-6": "#4f6397",
    "RAL 610-M": "#7f93b5",
    "RAL 620-1": "#456388",
    "RAL 620-2": "#6c8eaa",
    "RAL 620-3": "#6a7f8e",
    "RAL 620-4": "#44586a",
    "RAL 620-5": "#21344c",
    "RAL 620-6": "#242e3f",
    "RAL 620-M": "#192d41",
    "RAL 630-1": "#6b9bd1",
    "RAL 630-2": "#4f668c",
    "RAL 630-3": "#394b6e",
    "RAL 630-4": "#38486d",
    "RAL 630-5": "#283454",
    "RAL 630-6": "#253454",
    "RAL 630-M": "#24314d",
    "RAL 640-1": "#6599c3",
    "RAL 640-2": "#417fb3",
    "RAL 640-3": "#2e71ac",
    "RAL 640-4": "#14538c",
    "RAL 640-5": "#154b89",
    "RAL 640-6": "#13487d",
    "RAL 640-M": "#024282",
    "RAL 650-1": "#7baed5",
    "RAL 650-2": "#0c6da0",
    "RAL 650-3": "#176397",
    "RAL 650-4": "#0f4e77",
    "RAL 650-5": "#355777",
    "RAL 650-6": "#274762",
    "RAL 650-M": "#00659a",
    "RAL 660-1": "#378cb0",
    "RAL 660-2": "#4887a7",
    "RAL 660-3": "#6aa0b8",
    "RAL 660-4": "#6bb1cf",
    "RAL 660-5": "#84bdd4",
    "RAL 660-6": "#99c4d5",
    "RAL 660-M": "#6590a6",
    "RAL 670-1": "#9cceea",
    "RAL 670-2": "#a7d5f0",
    "RAL 670-3": "#9bc0d5",
    "RAL 670-4": "#80b5d3",
    "RAL 670-5": "#78b2d4",
    "RAL 670-6": "#76bae6",
    "RAL 670-M": "#81a5b9",
    "RAL 680-1": "#7fa6b9",
    "RAL 680-2": "#548aa3",
    "RAL 680-3": "#3b6c84",
    "RAL 680-4": "#43718c",
    "RAL 680-5": "#2a6484",
    "RAL 680-6": "#105475",
    "RAL 680-M": "#27445f",
    "RAL 690-1": "#6db8cd",
    "RAL 690-2": "#4d9bae",
    "RAL 690-3": "#2d7c8f",
    "RAL 690-4": "#12657d",
    "RAL 690-5": "#114f61",
    "RAL 690-6": "#144d62",
    "RAL 690-M": "#005e75",
    "RAL 7000": "#7b858d",
    "RAL 7001": "#8b949b",
    "RAL 7002": "#7d7965",
    "RAL 7003": "#76776a",
    "RAL 7004": "#969799",
    "RAL 7005": "#696d6b",
    "RAL 7006": "#716c60",
    "RAL 7008": "#6c6040",
    "RAL 7009": "#5b6058",
    "RAL 7010": "#575b57",
    "RAL 7011": "#535a5e",
    "RAL 7012": "#595e60",
    "RAL 7013": "#545146",
    "RAL 7015": "#51535a",
    "RAL 7016": "#3b4044",
    "RAL 7021": "#323537",
    "RAL 7022": "#4c4c47",
    "RAL 7023": "#7d7f76",
    "RAL 7024": "#45494e",
    "RAL 7026": "#394345",
    "RAL 7030": "#8c8c83",
    "RAL 7031": "#5d676d",
    "RAL 7032": "#b1b1a1",
    "RAL 7033": "#7c8273",
    "RAL 7034": "#8c8870",
    "RAL 7035": "#c2c6c3",
    "RAL 7036": "#949292",
    "RAL 7037": "#797b7b",
    "RAL 7038": "#adb0a9",
    "RAL 7039": "#68675f",
    "RAL 7040": "#969ca1",
    "RAL 7042": "#8c9190",
    "RAL 7043": "#4f5352",
    "RAL 7044": "#b3b2a9",
    "RAL 7045": "#8c9094",
    "RAL 7046": "#7c8287",
    "RAL 7047": "#c5c5c5",
    "RAL 7048": "#7a7871",
    "RAL 710-1": "#8fcdcf",
    "RAL 710-2": "#49a3aa",
    "RAL 710-3": "#45858c",
    "RAL 710-4": "#297079",
    "RAL 710-5": "#115764",
    "RAL 710-6": "#264649",
    "RAL 710-M": "#005e6d",
    "RAL 720-1": "#c6e2df",
    "RAL 720-2": "#b1e0dd",
    "RAL 720-3": "#99cfd5",
    "RAL 720-4": "#77b9c2",
    "RAL 720-5": "#558ea0",
    "RAL 720-6": "#417786",
    "RAL 720-M": "#488894",
    "RAL 730-1": "#cee6e3",
    "RAL 730-2": "#a4d0d4",
    "RAL 730-3": "#8ab5ba",
    "RAL 730-4": "#89b6b5",
    "RAL 730-5": "#84a9ac",
    "RAL 730-6": "#588581",
    "RAL 730-M": "#6b9c91",
    "RAL 740-1": "#c6dbcf",
    "RAL 740-2": "#b7d5ca",
    "RAL 740-3": "#9cc2b4",
    "RAL 740-4": "#578476",
    "RAL 740-5": "#306d60",
    "RAL 740-6": "#145b53",
    "RAL 740-M": "#466c60",
    "RAL 750-1": "#c0d7ca",
    "RAL 750-2": "#93b3a1",
    "RAL 750-3": "#4c7465",
    "RAL 750-4": "#264339",
    "RAL 750-5": "#3c554c",
    "RAL 750-6": "#333f3e",
    "RAL 750-M": "#243832",
    "RAL 760-1": "#d4e4cc",
    "RAL 760-2": "#b7cead",
    "RAL 760-3": "#aebf9e",
    "RAL 760-4": "#899b7c",
    "RAL 760-5": "#6c7f5f",
    "RAL 760-6": "#4e664c",
    "RAL 760-M": "#374b33",
    "RAL 770-1": "#959e86",
    "RAL 770-2": "#a4a991",
    "RAL 770-3": "#75765d",
    "RAL 770-4": "#7c7a68",
    "RAL 770-5": "#afafa0",
    "RAL 770-6": "#7c8275",
    "RAL 770-M": "#898866",
    "RAL 780-1": "#e4decd",
    "RAL 780-2": "#e0d7ba",
    "RAL 780-3": "#d4c69c",
    "RAL 780-4": "#c6b388",
    "RAL 780-5": "#9b8e7a",
    "RAL 780-6": "#6f695e",
    "RAL 780-M": "#a79f78",
    "RAL 790-1": "#41494b",
    "RAL 790-2": "#3d4248",
    "RAL 790-3": "#33373a",
    "RAL 790-4": "#313234",
    "RAL 790-5": "#232527",
    "RAL 790-6": "#24252f",
    "RAL 790-M": "#262524",
    "RAL 8000": "#816d44",
    "RAL 8001": "#8f6833",
    "RAL 8002": "#704f40",
    "RAL 8003": "#74502f",
    "RAL 8004": "#814d37",
    "RAL 8007": "#67492f",
    "RAL 8008": "#694f2b",
    "RAL 8011": "#533a29",
    "RAL 8012": "#5c3128",
    "RAL 8014": "#453729",
    "RAL 8015": "#57332b",
    "RAL 8016": "#483026",
    "RAL 8017": "#42332e",
    "RAL 8019": "#3b3736",
    "RAL 8022": "#201f20",
    "RAL 8023": "#965d33",
    "RAL 8024": "#6f543c",
    "RAL 8025": "#6e5b4b",
    "RAL 8028": "#4c3e30",
    "RAL 8029": "#764537",
    "RAL 810-1": "#969ba1",
    "RAL 810-2": "#899298",
    "RAL 810-3": "#7a868d",
    "RAL 810-4": "#5f6972",
    "RAL 810-5": "#51585d",
    "RAL 810-6": "#3b4247",
    "RAL 810-M": "#404549",
    "RAL 820-1": "#c2c6c9",
    "RAL 820-2": "#a7acb1",
    "RAL 820-3": "#8b9195",
    "RAL 820-4": "#7c8388",
    "RAL 820-5": "#51555d",
    "RAL 820-6": "#454a51",
    "RAL 820-M": "#919293",
    "RAL 830-1": "#b7bab9",
    "RAL 830-2": "#a1a5a4",
    "RAL 830-3": "#8b9091",
    "RAL 830-4": "#6a6f6d",
    "RAL 830-5": "#515555",
    "RAL 830-6": "#575e61",
    "RAL 830-M": "#7f7f7e",
    "RAL 840-1": "#e3e3d9",
    "RAL 840-2": "#d3d4cc",
    "RAL 840-3": "#b3b3a8",
    "RAL 840-4": "#7d8078",
    "RAL 840-5": "#595e56",
    "RAL 840-6": "#454438",
    "RAL 840-M": "#464441",
    "RAL 850-1": "#bfc1b9",
    "RAL 850-2": "#adb0aa",
    "RAL 850-3": "#a3a5a0",
    "RAL 850-4": "#8d8d86",
    "RAL 850-5": "#686761",
    "RAL 850-6": "#4b4c48",
    "RAL 850-M": "#5d5c58",
    "RAL 860-1": "#d5d8da",
    "RAL 860-2": "#cccfd4",
    "RAL 860-3": "#bec0c4",
    "RAL 860-4": "#97999a",
    "RAL 860-5": "#777979",
    "RAL 860-6": "#5a5f60",
    "RAL 860-M": "#9f9e9d",
    "RAL 870-1": "#cfcecf",
    "RAL 870-2": "#929191",
    "RAL 870-3": "#616164",
    "RAL 870-4": "#504e50",
    "RAL 870-5": "#494849",
    "RAL 870-6": "#3c393a",
    "RAL 870-M": "#4a4748",
    "RAL 9001": "#e5e1d4",
    "RAL 9002": "#d4d5cd",
    "RAL 9003": "#ebecea",
    "RAL 9004": "#2f3133",
    "RAL 9005": "#131516",
    "RAL 9006": "#9a9d9d",
    "RAL 9007": "#828280",
    "RAL 9010": "#efeee5",
    "RAL 9011": "#25282a",
    "RAL 9012": "#f2f1e1",
    "RAL 9016": "#eff0eb",
    "RAL 9017": "#262625",
    "RAL 9018": "#c6cbc6",
    "RAL 9022": "#818382",
    "RAL 9023": "#767779"
}
