"""Color matching functions."""

# CIE 1931 2 Degree Standard Observer
# http://www-cvrl.ucsd.edu/cmfs.htm
CIE_1931_2DEG = {
    360: (0.000129900000, 0.000003917000, 0.000606100000),
    361: (0.000145847000, 0.000004393581, 0.000680879200),
    362: (0.000163802100, 0.000004929604, 0.000765145600),
    363: (0.000184003700, 0.000005532136, 0.000860012400),
    364: (0.000206690200, 0.000006208245, 0.000966592800),
    365: (0.000232100000, 0.000006965000, 0.001086000000),
    366: (0.000260728000, 0.000007813219, 0.001220586000),
    367: (0.000293075000, 0.000008767336, 0.001372729000),
    368: (0.000329388000, 0.000009839844, 0.001543579000),
    369: (0.000369914000, 0.000011043230, 0.001734286000),
    370: (0.000414900000, 0.000012390000, 0.001946000000),
    371: (0.000464158700, 0.000013886410, 0.002177777000),
    372: (0.000518986000, 0.000015557280, 0.002435809000),
    373: (0.000581854000, 0.000017442960, 0.002731953000),
    374: (0.000655234700, 0.000019583750, 0.003078064000),
    375: (0.000741600000, 0.000022020000, 0.003486000000),
    376: (0.000845029600, 0.000024839650, 0.003975227000),
    377: (0.000964526800, 0.000028041260, 0.004540880000),
    378: (0.001094949000, 0.000031531040, 0.005158320000),
    379: (0.001231154000, 0.000035215210, 0.005802907000),
    380: (0.001368000000, 0.000039000000, 0.006450001000),
    381: (0.001502050000, 0.000042826400, 0.007083216000),
    382: (0.001642328000, 0.000046914600, 0.007745488000),
    383: (0.001802382000, 0.000051589600, 0.008501152000),
    384: (0.001995757000, 0.000057176400, 0.009414544000),
    385: (0.002236000000, 0.000064000000, 0.010549990000),
    386: (0.002535385000, 0.000072344210, 0.011965800000),
    387: (0.002892603000, 0.000082212240, 0.013655870000),
    388: (0.003300829000, 0.000093508160, 0.015588050000),
    389: (0.003753236000, 0.000106136100, 0.017730150000),
    390: (0.004243000000, 0.000120000000, 0.020050010000),
    391: (0.004762389000, 0.000134984000, 0.022511360000),
    392: (0.005330048000, 0.000151492000, 0.025202880000),
    393: (0.005978712000, 0.000170208000, 0.028279720000),
    394: (0.006741117000, 0.000191816000, 0.031897040000),
    395: (0.007650000000, 0.000217000000, 0.036210000000),
    396: (0.008751373000, 0.000246906700, 0.041437710000),
    397: (0.010028880000, 0.000281240000, 0.047503720000),
    398: (0.011421700000, 0.000318520000, 0.054119880000),
    399: (0.012869010000, 0.000357266700, 0.060998030000),
    400: (0.014310000000, 0.000396000000, 0.067850010000),
    401: (0.015704430000, 0.000433714700, 0.074486320000),
    402: (0.017147440000, 0.000473024000, 0.081361560000),
    403: (0.018781220000, 0.000517876000, 0.089153640000),
    404: (0.020748010000, 0.000572218700, 0.098540480000),
    405: (0.023190000000, 0.000640000000, 0.110200000000),
    406: (0.026207360000, 0.000724560000, 0.124613300000),
    407: (0.029782480000, 0.000825500000, 0.141701700000),
    408: (0.033880920000, 0.000941160000, 0.161303500000),
    409: (0.038468240000, 0.001069880000, 0.183256800000),
    410: (0.043510000000, 0.001210000000, 0.207400000000),
    411: (0.048995600000, 0.001362091000, 0.233692100000),
    412: (0.055022600000, 0.001530752000, 0.262611400000),
    413: (0.061718800000, 0.001720368000, 0.294774600000),
    414: (0.069212000000, 0.001935323000, 0.330798500000),
    415: (0.077630000000, 0.002180000000, 0.371300000000),
    416: (0.086958110000, 0.002454800000, 0.416209100000),
    417: (0.097176720000, 0.002764000000, 0.465464200000),
    418: (0.108406300000, 0.003117800000, 0.519694800000),
    419: (0.120767200000, 0.003526400000, 0.579530300000),
    420: (0.134380000000, 0.004000000000, 0.645600000000),
    421: (0.149358200000, 0.004546240000, 0.718483800000),
    422: (0.165395700000, 0.005159320000, 0.796713300000),
    423: (0.181983100000, 0.005829280000, 0.877845900000),
    424: (0.198611000000, 0.006546160000, 0.959439000000),
    425: (0.214770000000, 0.007300000000, 1.039050100000),
    426: (0.230186800000, 0.008086507000, 1.115367300000),
    427: (0.244879700000, 0.008908720000, 1.188497100000),
    428: (0.258777300000, 0.009767680000, 1.258123300000),
    429: (0.271807900000, 0.010664430000, 1.323929600000),
    430: (0.283900000000, 0.011600000000, 1.385600000000),
    431: (0.294943800000, 0.012573170000, 1.442635200000),
    432: (0.304896500000, 0.013582720000, 1.494803500000),
    433: (0.313787300000, 0.014629680000, 1.542190300000),
    434: (0.321645400000, 0.015715090000, 1.584880700000),
    435: (0.328500000000, 0.016840000000, 1.622960000000),
    436: (0.334351300000, 0.018007360000, 1.656404800000),
    437: (0.339210100000, 0.019214480000, 1.685295900000),
    438: (0.343121300000, 0.020453920000, 1.709874500000),
    439: (0.346129600000, 0.021718240000, 1.730382100000),
    440: (0.348280000000, 0.023000000000, 1.747060000000),
    441: (0.349599900000, 0.024294610000, 1.760044600000),
    442: (0.350147400000, 0.025610240000, 1.769623300000),
    443: (0.350013000000, 0.026958570000, 1.776263700000),
    444: (0.349287000000, 0.028351250000, 1.780433400000),
    445: (0.348060000000, 0.029800000000, 1.782600000000),
    446: (0.346373300000, 0.031310830000, 1.782968200000),
    447: (0.344262400000, 0.032883680000, 1.781699800000),
    448: (0.341808800000, 0.034521120000, 1.779198200000),
    449: (0.339094100000, 0.036225710000, 1.775867100000),
    450: (0.336200000000, 0.038000000000, 1.772110000000),
    451: (0.333197700000, 0.039846670000, 1.768258900000),
    452: (0.330041100000, 0.041768000000, 1.764039000000),
    453: (0.326635700000, 0.043766000000, 1.758943800000),
    454: (0.322886800000, 0.045842670000, 1.752466300000),
    455: (0.318700000000, 0.048000000000, 1.744100000000),
    456: (0.314025100000, 0.050243680000, 1.733559500000),
    457: (0.308884000000, 0.052573040000, 1.720858100000),
    458: (0.303290400000, 0.054980560000, 1.705936900000),
    459: (0.297257900000, 0.057458720000, 1.688737200000),
    460: (0.290800000000, 0.060000000000, 1.669200000000),
    461: (0.283970100000, 0.062601970000, 1.647528700000),
    462: (0.276721400000, 0.065277520000, 1.623412700000),
    463: (0.268917800000, 0.068042080000, 1.596022300000),
    464: (0.260422700000, 0.070911090000, 1.564528000000),
    465: (0.251100000000, 0.073900000000, 1.528100000000),
    466: (0.240847500000, 0.077016000000, 1.486111400000),
    467: (0.229851200000, 0.080266400000, 1.439521500000),
    468: (0.218407200000, 0.083666800000, 1.389879900000),
    469: (0.206811500000, 0.087232800000, 1.338736200000),
    470: (0.195360000000, 0.090980000000, 1.287640000000),
    471: (0.184213600000, 0.094917550000, 1.237422300000),
    472: (0.173327300000, 0.099045840000, 1.187824300000),
    473: (0.162688100000, 0.103367400000, 1.138761100000),
    474: (0.152283300000, 0.107884600000, 1.090148000000),
    475: (0.142100000000, 0.112600000000, 1.041900000000),
    476: (0.132178600000, 0.117532000000, 0.994197600000),
    477: (0.122569600000, 0.122674400000, 0.947347300000),
    478: (0.113275200000, 0.127992800000, 0.901453100000),
    479: (0.104297900000, 0.133452800000, 0.856619300000),
    480: (0.095640000000, 0.139020000000, 0.812950100000),
    481: (0.087299550000, 0.144676400000, 0.770517300000),
    482: (0.079308040000, 0.150469300000, 0.729444800000),
    483: (0.071717760000, 0.156461900000, 0.689913600000),
    484: (0.064580990000, 0.162717700000, 0.652104900000),
    485: (0.057950010000, 0.169300000000, 0.616200000000),
    486: (0.051862110000, 0.176243100000, 0.582328600000),
    487: (0.046281520000, 0.183558100000, 0.550416200000),
    488: (0.041150880000, 0.191273500000, 0.520337600000),
    489: (0.036412830000, 0.199418000000, 0.491967300000),
    490: (0.032010000000, 0.208020000000, 0.465180000000),
    491: (0.027917200000, 0.217119900000, 0.439924600000),
    492: (0.024144400000, 0.226734500000, 0.416183600000),
    493: (0.020687000000, 0.236857100000, 0.393882200000),
    494: (0.017540400000, 0.247481200000, 0.372945900000),
    495: (0.014700000000, 0.258600000000, 0.353300000000),
    496: (0.012161790000, 0.270184900000, 0.334857800000),
    497: (0.009919960000, 0.282293900000, 0.317552100000),
    498: (0.007967240000, 0.295050500000, 0.301337500000),
    499: (0.006296346000, 0.308578000000, 0.286168600000),
    500: (0.004900000000, 0.323000000000, 0.272000000000),
    501: (0.003777173000, 0.338402100000, 0.258817100000),
    502: (0.002945320000, 0.354685800000, 0.246483800000),
    503: (0.002424880000, 0.371698600000, 0.234771800000),
    504: (0.002236293000, 0.389287500000, 0.223453300000),
    505: (0.002400000000, 0.407300000000, 0.212300000000),
    506: (0.002925520000, 0.425629900000, 0.201169200000),
    507: (0.003836560000, 0.444309600000, 0.190119600000),
    508: (0.005174840000, 0.463394400000, 0.179225400000),
    509: (0.006982080000, 0.482939500000, 0.168560800000),
    510: (0.009300000000, 0.503000000000, 0.158200000000),
    511: (0.012149490000, 0.523569300000, 0.148138300000),
    512: (0.015535880000, 0.544512000000, 0.138375800000),
    513: (0.019477520000, 0.565690000000, 0.128994200000),
    514: (0.023992770000, 0.586965300000, 0.120075100000),
    515: (0.029100000000, 0.608200000000, 0.111700000000),
    516: (0.034814850000, 0.629345600000, 0.103904800000),
    517: (0.041120160000, 0.650306800000, 0.096667480000),
    518: (0.047985040000, 0.670875200000, 0.089982720000),
    519: (0.055378610000, 0.690842400000, 0.083845310000),
    520: (0.063270000000, 0.710000000000, 0.078249990000),
    521: (0.071635010000, 0.728185200000, 0.073208990000),
    522: (0.080462240000, 0.745463600000, 0.068678160000),
    523: (0.089739960000, 0.761969400000, 0.064567840000),
    524: (0.099456450000, 0.777836800000, 0.060788350000),
    525: (0.109600000000, 0.793200000000, 0.057250010000),
    526: (0.120167400000, 0.808110400000, 0.053904350000),
    527: (0.131114500000, 0.822496200000, 0.050746640000),
    528: (0.142367900000, 0.836306800000, 0.047752760000),
    529: (0.153854200000, 0.849491600000, 0.044898590000),
    530: (0.165500000000, 0.862000000000, 0.042160000000),
    531: (0.177257100000, 0.873810800000, 0.039507280000),
    532: (0.189140000000, 0.884962400000, 0.036935640000),
    533: (0.201169400000, 0.895493600000, 0.034458360000),
    534: (0.213365800000, 0.905443200000, 0.032088720000),
    535: (0.225749900000, 0.914850100000, 0.029840000000),
    536: (0.238320900000, 0.923734800000, 0.027711810000),
    537: (0.251066800000, 0.932092400000, 0.025694440000),
    538: (0.263992200000, 0.939922600000, 0.023787160000),
    539: (0.277101700000, 0.947225200000, 0.021989250000),
    540: (0.290400000000, 0.954000000000, 0.020300000000),
    541: (0.303891200000, 0.960256100000, 0.018718050000),
    542: (0.317572600000, 0.966007400000, 0.017240360000),
    543: (0.331438400000, 0.971260600000, 0.015863640000),
    544: (0.345482800000, 0.976022500000, 0.014584610000),
    545: (0.359700000000, 0.980300000000, 0.013400000000),
    546: (0.374083900000, 0.984092400000, 0.012307230000),
    547: (0.388639600000, 0.987418200000, 0.011301880000),
    548: (0.403378400000, 0.990312800000, 0.010377920000),
    549: (0.418311500000, 0.992811600000, 0.009529306000),
    550: (0.433449900000, 0.994950100000, 0.008749999000),
    551: (0.448795300000, 0.996710800000, 0.008035200000),
    552: (0.464336000000, 0.998098300000, 0.007381600000),
    553: (0.480064000000, 0.999112000000, 0.006785400000),
    554: (0.495971300000, 0.999748200000, 0.006242800000),
    555: (0.512050100000, 1.000000000000, 0.005749999000),
    556: (0.528295900000, 0.999856700000, 0.005303600000),
    557: (0.544691600000, 0.999304600000, 0.004899800000),
    558: (0.561209400000, 0.998325500000, 0.004534200000),
    559: (0.577821500000, 0.996898700000, 0.004202400000),
    560: (0.594500000000, 0.995000000000, 0.003900000000),
    561: (0.611220900000, 0.992600500000, 0.003623200000),
    562: (0.627975800000, 0.989742600000, 0.003370600000),
    563: (0.644760200000, 0.986444400000, 0.003141400000),
    564: (0.661569700000, 0.982724100000, 0.002934800000),
    565: (0.678400000000, 0.978600000000, 0.002749999000),
    566: (0.695239200000, 0.974083700000, 0.002585200000),
    567: (0.712058600000, 0.969171200000, 0.002438600000),
    568: (0.728828400000, 0.963856800000, 0.002309400000),
    569: (0.745518800000, 0.958134900000, 0.002196800000),
    570: (0.762100000000, 0.952000000000, 0.002100000000),
    571: (0.778543200000, 0.945450400000, 0.002017733000),
    572: (0.794825600000, 0.938499200000, 0.001948200000),
    573: (0.810926400000, 0.931162800000, 0.001889800000),
    574: (0.826824800000, 0.923457600000, 0.001840933000),
    575: (0.842500000000, 0.915400000000, 0.001800000000),
    576: (0.857932500000, 0.907006400000, 0.001766267000),
    577: (0.873081600000, 0.898277200000, 0.001737800000),
    578: (0.887894400000, 0.889204800000, 0.001711200000),
    579: (0.902318100000, 0.879781600000, 0.001683067000),
    580: (0.916300000000, 0.870000000000, 0.001650001000),
    581: (0.929799500000, 0.859861300000, 0.001610133000),
    582: (0.942798400000, 0.849392000000, 0.001564400000),
    583: (0.955277600000, 0.838622000000, 0.001513600000),
    584: (0.967217900000, 0.827581300000, 0.001458533000),
    585: (0.978600000000, 0.816300000000, 0.001400000000),
    586: (0.989385600000, 0.804794700000, 0.001336667000),
    587: (0.999548800000, 0.793082000000, 0.001270000000),
    588: (1.009089200000, 0.781192000000, 0.001205000000),
    589: (1.018006400000, 0.769154700000, 0.001146667000),
    590: (1.026300000000, 0.757000000000, 0.001100000000),
    591: (1.033982700000, 0.744754100000, 0.001068800000),
    592: (1.040986000000, 0.732422400000, 0.001049400000),
    593: (1.047188000000, 0.720003600000, 0.001035600000),
    594: (1.052466700000, 0.707496500000, 0.001021200000),
    595: (1.056700000000, 0.694900000000, 0.001000000000),
    596: (1.059794400000, 0.682219200000, 0.000968640000),
    597: (1.061799200000, 0.669471600000, 0.000929920000),
    598: (1.062806800000, 0.656674400000, 0.000886880000),
    599: (1.062909600000, 0.643844800000, 0.000842560000),
    600: (1.062200000000, 0.631000000000, 0.000800000000),
    601: (1.060735200000, 0.618155500000, 0.000760960000),
    602: (1.058443600000, 0.605314400000, 0.000723680000),
    603: (1.055224400000, 0.592475600000, 0.000685920000),
    604: (1.050976800000, 0.579637900000, 0.000645440000),
    605: (1.045600000000, 0.566800000000, 0.000600000000),
    606: (1.039036900000, 0.553961100000, 0.000547866700),
    607: (1.031360800000, 0.541137200000, 0.000491600000),
    608: (1.022666200000, 0.528352800000, 0.000435400000),
    609: (1.013047700000, 0.515632300000, 0.000383466700),
    610: (1.002600000000, 0.503000000000, 0.000340000000),
    611: (0.991367500000, 0.490468800000, 0.000307253300),
    612: (0.979331400000, 0.478030400000, 0.000283160000),
    613: (0.966491600000, 0.465677600000, 0.000265440000),
    614: (0.952847900000, 0.453403200000, 0.000251813300),
    615: (0.938400000000, 0.441200000000, 0.000240000000),
    616: (0.923194000000, 0.429080000000, 0.000229546700),
    617: (0.907244000000, 0.417036000000, 0.000220640000),
    618: (0.890502000000, 0.405032000000, 0.000211960000),
    619: (0.872920000000, 0.393032000000, 0.000202186700),
    620: (0.854449900000, 0.381000000000, 0.000190000000),
    621: (0.835084000000, 0.368918400000, 0.000174213300),
    622: (0.814946000000, 0.356827200000, 0.000155640000),
    623: (0.794186000000, 0.344776800000, 0.000135960000),
    624: (0.772954000000, 0.332817600000, 0.000116853300),
    625: (0.751400000000, 0.321000000000, 0.000100000000),
    626: (0.729583600000, 0.309338100000, 0.000086133330),
    627: (0.707588800000, 0.297850400000, 0.000074600000),
    628: (0.685602200000, 0.286593600000, 0.000065000000),
    629: (0.663810400000, 0.275624500000, 0.000056933330),
    630: (0.642400000000, 0.265000000000, 0.000049999990),
    631: (0.621514900000, 0.254763200000, 0.000044160000),
    632: (0.601113800000, 0.244889600000, 0.000039480000),
    633: (0.581105200000, 0.235334400000, 0.000035720000),
    634: (0.561397700000, 0.226052800000, 0.000032640000),
    635: (0.541900000000, 0.217000000000, 0.000030000000),
    636: (0.522599500000, 0.208161600000, 0.000027653330),
    637: (0.503546400000, 0.199548800000, 0.000025560000),
    638: (0.484743600000, 0.191155200000, 0.000023640000),
    639: (0.466193900000, 0.182974400000, 0.000021813330),
    640: (0.447900000000, 0.175000000000, 0.000020000000),
    641: (0.429861300000, 0.167223500000, 0.000018133330),
    642: (0.412098000000, 0.159646400000, 0.000016200000),
    643: (0.394644000000, 0.152277600000, 0.000014200000),
    644: (0.377533300000, 0.145125900000, 0.000012133330),
    645: (0.360800000000, 0.138200000000, 0.000010000000),
    646: (0.344456300000, 0.131500300000, 0.000007733333),
    647: (0.328516800000, 0.125024800000, 0.000005400000),
    648: (0.313019200000, 0.118779200000, 0.000003200000),
    649: (0.298001100000, 0.112769100000, 0.000001333333),
    650: (0.283500000000, 0.107000000000, 0.000000000000),
    651: (0.269544800000, 0.101476200000, 0.000000000000),
    652: (0.256118400000, 0.096188640000, 0.000000000000),
    653: (0.243189600000, 0.091122960000, 0.000000000000),
    654: (0.230727200000, 0.086264850000, 0.000000000000),
    655: (0.218700000000, 0.081600000000, 0.000000000000),
    656: (0.207097100000, 0.077120640000, 0.000000000000),
    657: (0.195923200000, 0.072825520000, 0.000000000000),
    658: (0.185170800000, 0.068710080000, 0.000000000000),
    659: (0.174832300000, 0.064769760000, 0.000000000000),
    660: (0.164900000000, 0.061000000000, 0.000000000000),
    661: (0.155366700000, 0.057396210000, 0.000000000000),
    662: (0.146230000000, 0.053955040000, 0.000000000000),
    663: (0.137490000000, 0.050673760000, 0.000000000000),
    664: (0.129146700000, 0.047549650000, 0.000000000000),
    665: (0.121200000000, 0.044580000000, 0.000000000000),
    666: (0.113639700000, 0.041758720000, 0.000000000000),
    667: (0.106465000000, 0.039084960000, 0.000000000000),
    668: (0.099690440000, 0.036563840000, 0.000000000000),
    669: (0.093330610000, 0.034200480000, 0.000000000000),
    670: (0.087400000000, 0.032000000000, 0.000000000000),
    671: (0.081900960000, 0.029962610000, 0.000000000000),
    672: (0.076804280000, 0.028076640000, 0.000000000000),
    673: (0.072077120000, 0.026329360000, 0.000000000000),
    674: (0.067686640000, 0.024708050000, 0.000000000000),
    675: (0.063600000000, 0.023200000000, 0.000000000000),
    676: (0.059806850000, 0.021800770000, 0.000000000000),
    677: (0.056282160000, 0.020501120000, 0.000000000000),
    678: (0.052971040000, 0.019281080000, 0.000000000000),
    679: (0.049818610000, 0.018120690000, 0.000000000000),
    680: (0.046770000000, 0.017000000000, 0.000000000000),
    681: (0.043784050000, 0.015903790000, 0.000000000000),
    682: (0.040875360000, 0.014837180000, 0.000000000000),
    683: (0.038072640000, 0.013810680000, 0.000000000000),
    684: (0.035404610000, 0.012834780000, 0.000000000000),
    685: (0.032900000000, 0.011920000000, 0.000000000000),
    686: (0.030564190000, 0.011068310000, 0.000000000000),
    687: (0.028380560000, 0.010273390000, 0.000000000000),
    688: (0.026344840000, 0.009533311000, 0.000000000000),
    689: (0.024452750000, 0.008846157000, 0.000000000000),
    690: (0.022700000000, 0.008210000000, 0.000000000000),
    691: (0.021084290000, 0.007623781000, 0.000000000000),
    692: (0.019599880000, 0.007085424000, 0.000000000000),
    693: (0.018237320000, 0.006591476000, 0.000000000000),
    694: (0.016987170000, 0.006138485000, 0.000000000000),
    695: (0.015840000000, 0.005723000000, 0.000000000000),
    696: (0.014790640000, 0.005343059000, 0.000000000000),
    697: (0.013831320000, 0.004995796000, 0.000000000000),
    698: (0.012948680000, 0.004676404000, 0.000000000000),
    699: (0.012129200000, 0.004380075000, 0.000000000000),
    700: (0.011359160000, 0.004102000000, 0.000000000000),
    701: (0.010629350000, 0.003838453000, 0.000000000000),
    702: (0.009938846000, 0.003589099000, 0.000000000000),
    703: (0.009288422000, 0.003354219000, 0.000000000000),
    704: (0.008678854000, 0.003134093000, 0.000000000000),
    705: (0.008110916000, 0.002929000000, 0.000000000000),
    706: (0.007582388000, 0.002738139000, 0.000000000000),
    707: (0.007088746000, 0.002559876000, 0.000000000000),
    708: (0.006627313000, 0.002393244000, 0.000000000000),
    709: (0.006195408000, 0.002237275000, 0.000000000000),
    710: (0.005790346000, 0.002091000000, 0.000000000000),
    711: (0.005409826000, 0.001953587000, 0.000000000000),
    712: (0.005052583000, 0.001824580000, 0.000000000000),
    713: (0.004717512000, 0.001703580000, 0.000000000000),
    714: (0.004403507000, 0.001590187000, 0.000000000000),
    715: (0.004109457000, 0.001484000000, 0.000000000000),
    716: (0.003833913000, 0.001384496000, 0.000000000000),
    717: (0.003575748000, 0.001291268000, 0.000000000000),
    718: (0.003334342000, 0.001204092000, 0.000000000000),
    719: (0.003109075000, 0.001122744000, 0.000000000000),
    720: (0.002899327000, 0.001047000000, 0.000000000000),
    721: (0.002704348000, 0.000976589600, 0.000000000000),
    722: (0.002523020000, 0.000911108800, 0.000000000000),
    723: (0.002354168000, 0.000850133200, 0.000000000000),
    724: (0.002196616000, 0.000793238400, 0.000000000000),
    725: (0.002049190000, 0.000740000000, 0.000000000000),
    726: (0.001910960000, 0.000690082700, 0.000000000000),
    727: (0.001781438000, 0.000643310000, 0.000000000000),
    728: (0.001660110000, 0.000599496000, 0.000000000000),
    729: (0.001546459000, 0.000558454700, 0.000000000000),
    730: (0.001439971000, 0.000520000000, 0.000000000000),
    731: (0.001340042000, 0.000483913600, 0.000000000000),
    732: (0.001246275000, 0.000450052800, 0.000000000000),
    733: (0.001158471000, 0.000418345200, 0.000000000000),
    734: (0.001076430000, 0.000388718400, 0.000000000000),
    735: (0.000999949300, 0.000361100000, 0.000000000000),
    736: (0.000928735800, 0.000335383500, 0.000000000000),
    737: (0.000862433200, 0.000311440400, 0.000000000000),
    738: (0.000800750300, 0.000289165600, 0.000000000000),
    739: (0.000743396000, 0.000268453900, 0.000000000000),
    740: (0.000690078600, 0.000249200000, 0.000000000000),
    741: (0.000640515600, 0.000231301900, 0.000000000000),
    742: (0.000594502100, 0.000214685600, 0.000000000000),
    743: (0.000551864600, 0.000199288400, 0.000000000000),
    744: (0.000512429000, 0.000185047500, 0.000000000000),
    745: (0.000476021300, 0.000171900000, 0.000000000000),
    746: (0.000442453600, 0.000159778100, 0.000000000000),
    747: (0.000411511700, 0.000148604400, 0.000000000000),
    748: (0.000382981400, 0.000138301600, 0.000000000000),
    749: (0.000356649100, 0.000128792500, 0.000000000000),
    750: (0.000332301100, 0.000120000000, 0.000000000000),
    751: (0.000309758600, 0.000111859500, 0.000000000000),
    752: (0.000288887100, 0.000104322400, 0.000000000000),
    753: (0.000269539400, 0.000097335600, 0.000000000000),
    754: (0.000251568200, 0.000090845870, 0.000000000000),
    755: (0.000234826100, 0.000084800000, 0.000000000000),
    756: (0.000219171000, 0.000079146670, 0.000000000000),
    757: (0.000204525800, 0.000073858000, 0.000000000000),
    758: (0.000190840500, 0.000068916000, 0.000000000000),
    759: (0.000178065400, 0.000064302670, 0.000000000000),
    760: (0.000166150500, 0.000060000000, 0.000000000000),
    761: (0.000155023600, 0.000055981870, 0.000000000000),
    762: (0.000144621900, 0.000052225600, 0.000000000000),
    763: (0.000134909800, 0.000048718400, 0.000000000000),
    764: (0.000125852000, 0.000045447470, 0.000000000000),
    765: (0.000117413000, 0.000042400000, 0.000000000000),
    766: (0.000109551500, 0.000039561040, 0.000000000000),
    767: (0.000102224500, 0.000036915120, 0.000000000000),
    768: (0.000095394450, 0.000034448680, 0.000000000000),
    769: (0.000089023900, 0.000032148160, 0.000000000000),
    770: (0.000083075270, 0.000030000000, 0.000000000000),
    771: (0.000077512690, 0.000027991250, 0.000000000000),
    772: (0.000072313040, 0.000026113560, 0.000000000000),
    773: (0.000067457780, 0.000024360240, 0.000000000000),
    774: (0.000062928440, 0.000022724610, 0.000000000000),
    775: (0.000058706520, 0.000021200000, 0.000000000000),
    776: (0.000054770280, 0.000019778550, 0.000000000000),
    777: (0.000051099180, 0.000018452850, 0.000000000000),
    778: (0.000047676540, 0.000017216870, 0.000000000000),
    779: (0.000044485670, 0.000016064590, 0.000000000000),
    780: (0.000041509940, 0.000014990000, 0.000000000000),
    781: (0.000038733240, 0.000013987280, 0.000000000000),
    782: (0.000036142030, 0.000013051550, 0.000000000000),
    783: (0.000033723520, 0.000012178180, 0.000000000000),
    784: (0.000031464870, 0.000011362540, 0.000000000000),
    785: (0.000029353260, 0.000010600000, 0.000000000000),
    786: (0.000027375730, 0.000009885877, 0.000000000000),
    787: (0.000025524330, 0.000009217304, 0.000000000000),
    788: (0.000023793760, 0.000008592362, 0.000000000000),
    789: (0.000022178700, 0.000008009133, 0.000000000000),
    790: (0.000020673830, 0.000007465700, 0.000000000000),
    791: (0.000019272260, 0.000006959567, 0.000000000000),
    792: (0.000017966400, 0.000006487995, 0.000000000000),
    793: (0.000016749910, 0.000006048699, 0.000000000000),
    794: (0.000015616480, 0.000005639396, 0.000000000000),
    795: (0.000014559770, 0.000005257800, 0.000000000000),
    796: (0.000013573870, 0.000004901771, 0.000000000000),
    797: (0.000012654360, 0.000004569720, 0.000000000000),
    798: (0.000011797230, 0.000004260194, 0.000000000000),
    799: (0.000010998440, 0.000003971739, 0.000000000000),
    800: (0.000010253980, 0.000003702900, 0.000000000000),
    801: (0.000009559646, 0.000003452163, 0.000000000000),
    802: (0.000008912044, 0.000003218302, 0.000000000000),
    803: (0.000008308358, 0.000003000300, 0.000000000000),
    804: (0.000007745769, 0.000002797139, 0.000000000000),
    805: (0.000007221456, 0.000002607800, 0.000000000000),
    806: (0.000006732475, 0.000002431220, 0.000000000000),
    807: (0.000006276423, 0.000002266531, 0.000000000000),
    808: (0.000005851304, 0.000002113013, 0.000000000000),
    809: (0.000005455118, 0.000001969943, 0.000000000000),
    810: (0.000005085868, 0.000001836600, 0.000000000000),
    811: (0.000004741466, 0.000001712230, 0.000000000000),
    812: (0.000004420236, 0.000001596228, 0.000000000000),
    813: (0.000004120783, 0.000001488090, 0.000000000000),
    814: (0.000003841716, 0.000001387314, 0.000000000000),
    815: (0.000003581652, 0.000001293400, 0.000000000000),
    816: (0.000003339127, 0.000001205820, 0.000000000000),
    817: (0.000003112949, 0.000001124143, 0.000000000000),
    818: (0.000002902121, 0.000001048009, 0.000000000000),
    819: (0.000002705645, 0.000000977058, 0.000000000000),
    820: (0.000002522525, 0.000000910930, 0.000000000000),
    821: (0.000002351726, 0.000000849251, 0.000000000000),
    822: (0.000002192415, 0.000000791721, 0.000000000000),
    823: (0.000002043902, 0.000000738090, 0.000000000000),
    824: (0.000001905497, 0.000000688110, 0.000000000000),
    825: (0.000001776509, 0.000000641530, 0.000000000000),
    826: (0.000001656215, 0.000000598090, 0.000000000000),
    827: (0.000001544022, 0.000000557575, 0.000000000000),
    828: (0.000001439440, 0.000000519808, 0.000000000000),
    829: (0.000001341977, 0.000000484612, 0.000000000000),
    830: (0.000001251141, 0.000000451810, 0.000000000000)
}

# CIE 1964 10 Degree Standard Observer
# http://www-cvrl.ucsd.edu/cmfs.htm
CIE_1964_10DEG = {
    360: (0.000000122200, 0.000000013398, 0.000000535027),
    361: (0.000000185138, 0.000000020294, 0.000000810720),
    362: (0.000000278830, 0.000000030560, 0.000001221200),
    363: (0.000000417470, 0.000000045740, 0.000001828700),
    364: (0.000000621330, 0.000000068050, 0.000002722200),
    365: (0.000000919270, 0.000000100650, 0.000004028300),
    366: (0.000001351980, 0.000000147980, 0.000005925700),
    367: (0.000001976540, 0.000000216270, 0.000008665100),
    368: (0.000002872500, 0.000000314200, 0.000012596000),
    369: (0.000004149500, 0.000000453700, 0.000018201000),
    370: (0.000005958600, 0.000000651100, 0.000026143700),
    371: (0.000008505600, 0.000000928800, 0.000037330000),
    372: (0.000012068600, 0.000001317500, 0.000052987000),
    373: (0.000017022600, 0.000001857200, 0.000074764000),
    374: (0.000023868000, 0.000002602000, 0.000104870000),
    375: (0.000033266000, 0.000003625000, 0.000146220000),
    376: (0.000046087000, 0.000005019000, 0.000202660000),
    377: (0.000063472000, 0.000006907000, 0.000279230000),
    378: (0.000086892000, 0.000009449000, 0.000382450000),
    379: (0.000118246000, 0.000012848000, 0.000520720000),
    380: (0.000159952000, 0.000017364000, 0.000704776000),
    381: (0.000215080000, 0.000023327000, 0.000948230000),
    382: (0.000287490000, 0.000031150000, 0.001268200000),
    383: (0.000381990000, 0.000041350000, 0.001686100000),
    384: (0.000504550000, 0.000054560000, 0.002228500000),
    385: (0.000662440000, 0.000071560000, 0.002927800000),
    386: (0.000864500000, 0.000093300000, 0.003823700000),
    387: (0.001121500000, 0.000120870000, 0.004964200000),
    388: (0.001446160000, 0.000155640000, 0.006406700000),
    389: (0.001853590000, 0.000199200000, 0.008219300000),
    390: (0.002361600000, 0.000253400000, 0.010482200000),
    391: (0.002990600000, 0.000320200000, 0.013289000000),
    392: (0.003764500000, 0.000402400000, 0.016747000000),
    393: (0.004710200000, 0.000502300000, 0.020980000000),
    394: (0.005858100000, 0.000623200000, 0.026127000000),
    395: (0.007242300000, 0.000768500000, 0.032344000000),
    396: (0.008899600000, 0.000941700000, 0.039802000000),
    397: (0.010870900000, 0.001147800000, 0.048691000000),
    398: (0.013198900000, 0.001390300000, 0.059210000000),
    399: (0.015929200000, 0.001674000000, 0.071576000000),
    400: (0.019109700000, 0.002004400000, 0.086010900000),
    401: (0.022788000000, 0.002386000000, 0.102740000000),
    402: (0.027011000000, 0.002822000000, 0.122000000000),
    403: (0.031829000000, 0.003319000000, 0.144020000000),
    404: (0.037278000000, 0.003880000000, 0.168990000000),
    405: (0.043400000000, 0.004509000000, 0.197120000000),
    406: (0.050223000000, 0.005209000000, 0.228570000000),
    407: (0.057764000000, 0.005985000000, 0.263470000000),
    408: (0.066038000000, 0.006833000000, 0.301900000000),
    409: (0.075033000000, 0.007757000000, 0.343870000000),
    410: (0.084736000000, 0.008756000000, 0.389366000000),
    411: (0.095041000000, 0.009816000000, 0.437970000000),
    412: (0.105836000000, 0.010918000000, 0.489220000000),
    413: (0.117066000000, 0.012058000000, 0.542900000000),
    414: (0.128682000000, 0.013237000000, 0.598810000000),
    415: (0.140638000000, 0.014456000000, 0.656760000000),
    416: (0.152893000000, 0.015717000000, 0.716580000000),
    417: (0.165416000000, 0.017025000000, 0.778120000000),
    418: (0.178191000000, 0.018399000000, 0.841310000000),
    419: (0.191214000000, 0.019848000000, 0.906110000000),
    420: (0.204492000000, 0.021391000000, 0.972542000000),
    421: (0.217650000000, 0.022992000000, 1.038900000000),
    422: (0.230267000000, 0.024598000000, 1.103100000000),
    423: (0.242311000000, 0.026213000000, 1.165100000000),
    424: (0.253793000000, 0.027841000000, 1.224900000000),
    425: (0.264737000000, 0.029497000000, 1.282500000000),
    426: (0.275195000000, 0.031195000000, 1.338200000000),
    427: (0.285301000000, 0.032927000000, 1.392600000000),
    428: (0.295143000000, 0.034738000000, 1.446100000000),
    429: (0.304869000000, 0.036654000000, 1.499400000000),
    430: (0.314679000000, 0.038676000000, 1.553480000000),
    431: (0.324355000000, 0.040792000000, 1.607200000000),
    432: (0.333570000000, 0.042946000000, 1.658900000000),
    433: (0.342243000000, 0.045114000000, 1.708200000000),
    434: (0.350312000000, 0.047333000000, 1.754800000000),
    435: (0.357719000000, 0.049602000000, 1.798500000000),
    436: (0.364482000000, 0.051934000000, 1.839200000000),
    437: (0.370493000000, 0.054337000000, 1.876600000000),
    438: (0.375727000000, 0.056822000000, 1.910500000000),
    439: (0.380158000000, 0.059399000000, 1.940800000000),
    440: (0.383734000000, 0.062077000000, 1.967280000000),
    441: (0.386327000000, 0.064737000000, 1.989100000000),
    442: (0.387858000000, 0.067285000000, 2.005700000000),
    443: (0.388396000000, 0.069764000000, 2.017400000000),
    444: (0.387978000000, 0.072218000000, 2.024400000000),
    445: (0.386726000000, 0.074704000000, 2.027300000000),
    446: (0.384696000000, 0.077272000000, 2.026400000000),
    447: (0.382006000000, 0.079979000000, 2.022300000000),
    448: (0.378709000000, 0.082874000000, 2.015300000000),
    449: (0.374915000000, 0.086000000000, 2.006000000000),
    450: (0.370702000000, 0.089456000000, 1.994800000000),
    451: (0.366089000000, 0.092947000000, 1.981400000000),
    452: (0.361045000000, 0.096275000000, 1.965300000000),
    453: (0.355518000000, 0.099535000000, 1.946400000000),
    454: (0.349486000000, 0.102829000000, 1.924800000000),
    455: (0.342957000000, 0.106256000000, 1.900700000000),
    456: (0.335893000000, 0.109901000000, 1.874100000000),
    457: (0.328284000000, 0.113835000000, 1.845100000000),
    458: (0.320150000000, 0.118167000000, 1.813900000000),
    459: (0.311475000000, 0.122932000000, 1.780600000000),
    460: (0.302273000000, 0.128201000000, 1.745370000000),
    461: (0.292858000000, 0.133457000000, 1.709100000000),
    462: (0.283502000000, 0.138323000000, 1.672300000000),
    463: (0.274044000000, 0.143042000000, 1.634700000000),
    464: (0.264263000000, 0.147787000000, 1.595600000000),
    465: (0.254085000000, 0.152761000000, 1.554900000000),
    466: (0.243392000000, 0.158102000000, 1.512200000000),
    467: (0.232187000000, 0.163941000000, 1.467300000000),
    468: (0.220488000000, 0.170362000000, 1.419900000000),
    469: (0.208198000000, 0.177425000000, 1.370000000000),
    470: (0.195618000000, 0.185190000000, 1.317560000000),
    471: (0.183034000000, 0.193025000000, 1.262400000000),
    472: (0.170222000000, 0.200313000000, 1.205000000000),
    473: (0.157348000000, 0.207156000000, 1.146600000000),
    474: (0.144650000000, 0.213644000000, 1.088000000000),
    475: (0.132349000000, 0.219940000000, 1.030200000000),
    476: (0.120584000000, 0.226170000000, 0.973830000000),
    477: (0.109456000000, 0.232467000000, 0.919430000000),
    478: (0.099042000000, 0.239025000000, 0.867460000000),
    479: (0.089388000000, 0.245997000000, 0.818280000000),
    480: (0.080507000000, 0.253589000000, 0.772125000000),
    481: (0.072034000000, 0.261876000000, 0.728290000000),
    482: (0.063710000000, 0.270643000000, 0.686040000000),
    483: (0.055694000000, 0.279645000000, 0.645530000000),
    484: (0.048117000000, 0.288694000000, 0.606850000000),
    485: (0.041072000000, 0.297665000000, 0.570060000000),
    486: (0.034642000000, 0.306469000000, 0.535220000000),
    487: (0.028896000000, 0.315035000000, 0.502340000000),
    488: (0.023876000000, 0.323335000000, 0.471400000000),
    489: (0.019628000000, 0.331366000000, 0.442390000000),
    490: (0.016172000000, 0.339133000000, 0.415254000000),
    491: (0.013300000000, 0.347860000000, 0.390024000000),
    492: (0.010759000000, 0.358326000000, 0.366399000000),
    493: (0.008542000000, 0.370001000000, 0.344015000000),
    494: (0.006661000000, 0.382464000000, 0.322689000000),
    495: (0.005132000000, 0.395379000000, 0.302356000000),
    496: (0.003982000000, 0.408482000000, 0.283036000000),
    497: (0.003239000000, 0.421588000000, 0.264816000000),
    498: (0.002934000000, 0.434619000000, 0.247848000000),
    499: (0.003114000000, 0.447601000000, 0.232318000000),
    500: (0.003816000000, 0.460777000000, 0.218502000000),
    501: (0.005095000000, 0.474340000000, 0.205851000000),
    502: (0.006936000000, 0.488200000000, 0.193596000000),
    503: (0.009299000000, 0.502340000000, 0.181736000000),
    504: (0.012147000000, 0.516740000000, 0.170281000000),
    505: (0.015444000000, 0.531360000000, 0.159249000000),
    506: (0.019156000000, 0.546190000000, 0.148673000000),
    507: (0.023250000000, 0.561180000000, 0.138609000000),
    508: (0.027690000000, 0.576290000000, 0.129096000000),
    509: (0.032444000000, 0.591500000000, 0.120215000000),
    510: (0.037465000000, 0.606741000000, 0.112044000000),
    511: (0.042956000000, 0.622150000000, 0.104710000000),
    512: (0.049114000000, 0.637830000000, 0.098196000000),
    513: (0.055920000000, 0.653710000000, 0.092361000000),
    514: (0.063349000000, 0.669680000000, 0.087088000000),
    515: (0.071358000000, 0.685660000000, 0.082248000000),
    516: (0.079901000000, 0.701550000000, 0.077744000000),
    517: (0.088909000000, 0.717230000000, 0.073456000000),
    518: (0.098293000000, 0.732570000000, 0.069268000000),
    519: (0.107949000000, 0.747460000000, 0.065060000000),
    520: (0.117749000000, 0.761757000000, 0.060709000000),
    521: (0.127839000000, 0.775340000000, 0.056457000000),
    522: (0.138450000000, 0.788220000000, 0.052609000000),
    523: (0.149516000000, 0.800460000000, 0.049122000000),
    524: (0.161041000000, 0.812140000000, 0.045954000000),
    525: (0.172953000000, 0.823330000000, 0.043050000000),
    526: (0.185209000000, 0.834120000000, 0.040368000000),
    527: (0.197755000000, 0.844600000000, 0.037839000000),
    528: (0.210538000000, 0.854870000000, 0.035384000000),
    529: (0.223460000000, 0.865040000000, 0.032949000000),
    530: (0.236491000000, 0.875211000000, 0.030451000000),
    531: (0.249633000000, 0.885370000000, 0.028029000000),
    532: (0.262972000000, 0.895370000000, 0.025862000000),
    533: (0.276515000000, 0.905150000000, 0.023920000000),
    534: (0.290269000000, 0.914650000000, 0.022174000000),
    535: (0.304213000000, 0.923810000000, 0.020584000000),
    536: (0.318361000000, 0.932550000000, 0.019127000000),
    537: (0.332705000000, 0.940810000000, 0.017740000000),
    538: (0.347232000000, 0.948520000000, 0.016403000000),
    539: (0.361926000000, 0.955600000000, 0.015064000000),
    540: (0.376772000000, 0.961988000000, 0.013676000000),
    541: (0.391683000000, 0.967540000000, 0.012308000000),
    542: (0.406594000000, 0.972230000000, 0.011056000000),
    543: (0.421539000000, 0.976170000000, 0.009915000000),
    544: (0.436517000000, 0.979460000000, 0.008872000000),
    545: (0.451584000000, 0.982200000000, 0.007918000000),
    546: (0.466782000000, 0.984520000000, 0.007030000000),
    547: (0.482147000000, 0.986520000000, 0.006223000000),
    548: (0.497738000000, 0.988320000000, 0.005453000000),
    549: (0.513606000000, 0.990020000000, 0.004714000000),
    550: (0.529826000000, 0.991761000000, 0.003988000000),
    551: (0.546440000000, 0.993530000000, 0.003289000000),
    552: (0.563426000000, 0.995230000000, 0.002646000000),
    553: (0.580726000000, 0.996770000000, 0.002063000000),
    554: (0.598290000000, 0.998090000000, 0.001533000000),
    555: (0.616053000000, 0.999110000000, 0.001091000000),
    556: (0.633948000000, 0.999770000000, 0.000711000000),
    557: (0.651901000000, 1.000000000000, 0.000407000000),
    558: (0.669824000000, 0.999710000000, 0.000184000000),
    559: (0.687632000000, 0.998850000000, 0.000047000000),
    560: (0.705224000000, 0.997340000000, 0.000000000000),
    561: (0.722773000000, 0.995260000000, 0.000000000000),
    562: (0.740483000000, 0.992740000000, 0.000000000000),
    563: (0.758273000000, 0.989750000000, 0.000000000000),
    564: (0.776083000000, 0.986300000000, 0.000000000000),
    565: (0.793832000000, 0.982380000000, 0.000000000000),
    566: (0.811436000000, 0.977980000000, 0.000000000000),
    567: (0.828822000000, 0.973110000000, 0.000000000000),
    568: (0.845879000000, 0.967740000000, 0.000000000000),
    569: (0.862525000000, 0.961890000000, 0.000000000000),
    570: (0.878655000000, 0.955552000000, 0.000000000000),
    571: (0.894208000000, 0.948601000000, 0.000000000000),
    572: (0.909206000000, 0.940981000000, 0.000000000000),
    573: (0.923672000000, 0.932798000000, 0.000000000000),
    574: (0.937638000000, 0.924158000000, 0.000000000000),
    575: (0.951162000000, 0.915175000000, 0.000000000000),
    576: (0.964283000000, 0.905954000000, 0.000000000000),
    577: (0.977068000000, 0.896608000000, 0.000000000000),
    578: (0.989590000000, 0.887249000000, 0.000000000000),
    579: (1.001910000000, 0.877986000000, 0.000000000000),
    580: (1.014160000000, 0.868934000000, 0.000000000000),
    581: (1.026500000000, 0.860164000000, 0.000000000000),
    582: (1.038800000000, 0.851519000000, 0.000000000000),
    583: (1.051000000000, 0.842963000000, 0.000000000000),
    584: (1.062900000000, 0.834393000000, 0.000000000000),
    585: (1.074300000000, 0.825623000000, 0.000000000000),
    586: (1.085200000000, 0.816764000000, 0.000000000000),
    587: (1.095200000000, 0.807544000000, 0.000000000000),
    588: (1.104200000000, 0.797947000000, 0.000000000000),
    589: (1.112000000000, 0.787893000000, 0.000000000000),
    590: (1.118520000000, 0.777405000000, 0.000000000000),
    591: (1.123800000000, 0.766490000000, 0.000000000000),
    592: (1.128000000000, 0.755309000000, 0.000000000000),
    593: (1.131100000000, 0.743845000000, 0.000000000000),
    594: (1.133200000000, 0.732190000000, 0.000000000000),
    595: (1.134300000000, 0.720353000000, 0.000000000000),
    596: (1.134300000000, 0.708281000000, 0.000000000000),
    597: (1.133300000000, 0.696055000000, 0.000000000000),
    598: (1.131200000000, 0.683621000000, 0.000000000000),
    599: (1.128100000000, 0.671048000000, 0.000000000000),
    600: (1.123990000000, 0.658341000000, 0.000000000000),
    601: (1.118900000000, 0.645545000000, 0.000000000000),
    602: (1.112900000000, 0.632718000000, 0.000000000000),
    603: (1.105900000000, 0.619815000000, 0.000000000000),
    604: (1.098000000000, 0.606887000000, 0.000000000000),
    605: (1.089100000000, 0.593878000000, 0.000000000000),
    606: (1.079200000000, 0.580781000000, 0.000000000000),
    607: (1.068400000000, 0.567653000000, 0.000000000000),
    608: (1.056700000000, 0.554490000000, 0.000000000000),
    609: (1.044000000000, 0.541228000000, 0.000000000000),
    610: (1.030480000000, 0.527963000000, 0.000000000000),
    611: (1.016000000000, 0.514634000000, 0.000000000000),
    612: (1.000800000000, 0.501363000000, 0.000000000000),
    613: (0.984790000000, 0.488124000000, 0.000000000000),
    614: (0.968080000000, 0.474935000000, 0.000000000000),
    615: (0.950740000000, 0.461834000000, 0.000000000000),
    616: (0.932800000000, 0.448823000000, 0.000000000000),
    617: (0.914340000000, 0.435917000000, 0.000000000000),
    618: (0.895390000000, 0.423153000000, 0.000000000000),
    619: (0.876030000000, 0.410526000000, 0.000000000000),
    620: (0.856297000000, 0.398057000000, 0.000000000000),
    621: (0.836350000000, 0.385835000000, 0.000000000000),
    622: (0.816290000000, 0.373951000000, 0.000000000000),
    623: (0.796050000000, 0.362311000000, 0.000000000000),
    624: (0.775610000000, 0.350863000000, 0.000000000000),
    625: (0.754930000000, 0.339554000000, 0.000000000000),
    626: (0.733990000000, 0.328309000000, 0.000000000000),
    627: (0.712780000000, 0.317118000000, 0.000000000000),
    628: (0.691290000000, 0.305936000000, 0.000000000000),
    629: (0.669520000000, 0.294737000000, 0.000000000000),
    630: (0.647467000000, 0.283493000000, 0.000000000000),
    631: (0.625110000000, 0.272222000000, 0.000000000000),
    632: (0.602520000000, 0.260990000000, 0.000000000000),
    633: (0.579890000000, 0.249877000000, 0.000000000000),
    634: (0.557370000000, 0.238946000000, 0.000000000000),
    635: (0.535110000000, 0.228254000000, 0.000000000000),
    636: (0.513240000000, 0.217853000000, 0.000000000000),
    637: (0.491860000000, 0.207780000000, 0.000000000000),
    638: (0.471080000000, 0.198072000000, 0.000000000000),
    639: (0.450960000000, 0.188748000000, 0.000000000000),
    640: (0.431567000000, 0.179828000000, 0.000000000000),
    641: (0.412870000000, 0.171285000000, 0.000000000000),
    642: (0.394750000000, 0.163059000000, 0.000000000000),
    643: (0.377210000000, 0.155151000000, 0.000000000000),
    644: (0.360190000000, 0.147535000000, 0.000000000000),
    645: (0.343690000000, 0.140211000000, 0.000000000000),
    646: (0.327690000000, 0.133170000000, 0.000000000000),
    647: (0.312170000000, 0.126400000000, 0.000000000000),
    648: (0.297110000000, 0.119892000000, 0.000000000000),
    649: (0.282500000000, 0.113640000000, 0.000000000000),
    650: (0.268329000000, 0.107633000000, 0.000000000000),
    651: (0.254590000000, 0.101870000000, 0.000000000000),
    652: (0.241300000000, 0.096347000000, 0.000000000000),
    653: (0.228480000000, 0.091063000000, 0.000000000000),
    654: (0.216140000000, 0.086010000000, 0.000000000000),
    655: (0.204300000000, 0.081187000000, 0.000000000000),
    656: (0.192950000000, 0.076583000000, 0.000000000000),
    657: (0.182110000000, 0.072198000000, 0.000000000000),
    658: (0.171770000000, 0.068024000000, 0.000000000000),
    659: (0.161920000000, 0.064052000000, 0.000000000000),
    660: (0.152568000000, 0.060281000000, 0.000000000000),
    661: (0.143670000000, 0.056697000000, 0.000000000000),
    662: (0.135200000000, 0.053292000000, 0.000000000000),
    663: (0.127130000000, 0.050059000000, 0.000000000000),
    664: (0.119480000000, 0.046998000000, 0.000000000000),
    665: (0.112210000000, 0.044096000000, 0.000000000000),
    666: (0.105310000000, 0.041345000000, 0.000000000000),
    667: (0.098786000000, 0.038750700000, 0.000000000000),
    668: (0.092610000000, 0.036297800000, 0.000000000000),
    669: (0.086773000000, 0.033983200000, 0.000000000000),
    670: (0.081260600000, 0.031800400000, 0.000000000000),
    671: (0.076048000000, 0.029739500000, 0.000000000000),
    672: (0.071114000000, 0.027791800000, 0.000000000000),
    673: (0.066454000000, 0.025955100000, 0.000000000000),
    674: (0.062062000000, 0.024226300000, 0.000000000000),
    675: (0.057930000000, 0.022601700000, 0.000000000000),
    676: (0.054050000000, 0.021077900000, 0.000000000000),
    677: (0.050412000000, 0.019650500000, 0.000000000000),
    678: (0.047006000000, 0.018315300000, 0.000000000000),
    679: (0.043823000000, 0.017068600000, 0.000000000000),
    680: (0.040850800000, 0.015905100000, 0.000000000000),
    681: (0.038072000000, 0.014818300000, 0.000000000000),
    682: (0.035468000000, 0.013800800000, 0.000000000000),
    683: (0.033031000000, 0.012849500000, 0.000000000000),
    684: (0.030753000000, 0.011960700000, 0.000000000000),
    685: (0.028623000000, 0.011130300000, 0.000000000000),
    686: (0.026635000000, 0.010355500000, 0.000000000000),
    687: (0.024781000000, 0.009633200000, 0.000000000000),
    688: (0.023052000000, 0.008959900000, 0.000000000000),
    689: (0.021441000000, 0.008332400000, 0.000000000000),
    690: (0.019941300000, 0.007748800000, 0.000000000000),
    691: (0.018544000000, 0.007204600000, 0.000000000000),
    692: (0.017241000000, 0.006697500000, 0.000000000000),
    693: (0.016027000000, 0.006225100000, 0.000000000000),
    694: (0.014896000000, 0.005785000000, 0.000000000000),
    695: (0.013842000000, 0.005375100000, 0.000000000000),
    696: (0.012862000000, 0.004994100000, 0.000000000000),
    697: (0.011949000000, 0.004639200000, 0.000000000000),
    698: (0.011100000000, 0.004309300000, 0.000000000000),
    699: (0.010311000000, 0.004002800000, 0.000000000000),
    700: (0.009576880000, 0.003717740000, 0.000000000000),
    701: (0.008894000000, 0.003452620000, 0.000000000000),
    702: (0.008258100000, 0.003205830000, 0.000000000000),
    703: (0.007666400000, 0.002976230000, 0.000000000000),
    704: (0.007116300000, 0.002762810000, 0.000000000000),
    705: (0.006605200000, 0.002564560000, 0.000000000000),
    706: (0.006130600000, 0.002380480000, 0.000000000000),
    707: (0.005690300000, 0.002209710000, 0.000000000000),
    708: (0.005281900000, 0.002051320000, 0.000000000000),
    709: (0.004903300000, 0.001904490000, 0.000000000000),
    710: (0.004552630000, 0.001768470000, 0.000000000000),
    711: (0.004227500000, 0.001642360000, 0.000000000000),
    712: (0.003925800000, 0.001525350000, 0.000000000000),
    713: (0.003645700000, 0.001416720000, 0.000000000000),
    714: (0.003385900000, 0.001315950000, 0.000000000000),
    715: (0.003144700000, 0.001222390000, 0.000000000000),
    716: (0.002920800000, 0.001135550000, 0.000000000000),
    717: (0.002713000000, 0.001054940000, 0.000000000000),
    718: (0.002520200000, 0.000980140000, 0.000000000000),
    719: (0.002341100000, 0.000910660000, 0.000000000000),
    720: (0.002174960000, 0.000846190000, 0.000000000000),
    721: (0.002020600000, 0.000786290000, 0.000000000000),
    722: (0.001877300000, 0.000730680000, 0.000000000000),
    723: (0.001744100000, 0.000678990000, 0.000000000000),
    724: (0.001620500000, 0.000631010000, 0.000000000000),
    725: (0.001505700000, 0.000586440000, 0.000000000000),
    726: (0.001399200000, 0.000545110000, 0.000000000000),
    727: (0.001300400000, 0.000506720000, 0.000000000000),
    728: (0.001208700000, 0.000471110000, 0.000000000000),
    729: (0.001123600000, 0.000438050000, 0.000000000000),
    730: (0.001044760000, 0.000407410000, 0.000000000000),
    731: (0.000971560000, 0.000378962000, 0.000000000000),
    732: (0.000903600000, 0.000352543000, 0.000000000000),
    733: (0.000840480000, 0.000328001000, 0.000000000000),
    734: (0.000781870000, 0.000305208000, 0.000000000000),
    735: (0.000727450000, 0.000284041000, 0.000000000000),
    736: (0.000676900000, 0.000264375000, 0.000000000000),
    737: (0.000629960000, 0.000246109000, 0.000000000000),
    738: (0.000586370000, 0.000229143000, 0.000000000000),
    739: (0.000545870000, 0.000213376000, 0.000000000000),
    740: (0.000508258000, 0.000198730000, 0.000000000000),
    741: (0.000473300000, 0.000185115000, 0.000000000000),
    742: (0.000440800000, 0.000172454000, 0.000000000000),
    743: (0.000410580000, 0.000160678000, 0.000000000000),
    744: (0.000382490000, 0.000149730000, 0.000000000000),
    745: (0.000356380000, 0.000139550000, 0.000000000000),
    746: (0.000332110000, 0.000130086000, 0.000000000000),
    747: (0.000309550000, 0.000121290000, 0.000000000000),
    748: (0.000288580000, 0.000113106000, 0.000000000000),
    749: (0.000269090000, 0.000105501000, 0.000000000000),
    750: (0.000250969000, 0.000098428000, 0.000000000000),
    751: (0.000234130000, 0.000091853000, 0.000000000000),
    752: (0.000218470000, 0.000085738000, 0.000000000000),
    753: (0.000203910000, 0.000080048000, 0.000000000000),
    754: (0.000190350000, 0.000074751000, 0.000000000000),
    755: (0.000177730000, 0.000069819000, 0.000000000000),
    756: (0.000165970000, 0.000065222000, 0.000000000000),
    757: (0.000155020000, 0.000060939000, 0.000000000000),
    758: (0.000144800000, 0.000056942000, 0.000000000000),
    759: (0.000135280000, 0.000053217000, 0.000000000000),
    760: (0.000126390000, 0.000049737000, 0.000000000000),
    761: (0.000118100000, 0.000046491000, 0.000000000000),
    762: (0.000110370000, 0.000043464000, 0.000000000000),
    763: (0.000103150000, 0.000040635000, 0.000000000000),
    764: (0.000096427000, 0.000038000000, 0.000000000000),
    765: (0.000090151000, 0.000035540500, 0.000000000000),
    766: (0.000084294000, 0.000033244800, 0.000000000000),
    767: (0.000078830000, 0.000031100600, 0.000000000000),
    768: (0.000073729000, 0.000029099000, 0.000000000000),
    769: (0.000068969000, 0.000027230700, 0.000000000000),
    770: (0.000064525800, 0.000025486000, 0.000000000000),
    771: (0.000060376000, 0.000023856100, 0.000000000000),
    772: (0.000056500000, 0.000022333200, 0.000000000000),
    773: (0.000052880000, 0.000020910400, 0.000000000000),
    774: (0.000049498000, 0.000019580800, 0.000000000000),
    775: (0.000046339000, 0.000018338400, 0.000000000000),
    776: (0.000043389000, 0.000017177700, 0.000000000000),
    777: (0.000040634000, 0.000016093400, 0.000000000000),
    778: (0.000038060000, 0.000015080000, 0.000000000000),
    779: (0.000035657000, 0.000014133600, 0.000000000000),
    780: (0.000033411700, 0.000013249000, 0.000000000000),
    781: (0.000031315000, 0.000012422600, 0.000000000000),
    782: (0.000029355000, 0.000011649900, 0.000000000000),
    783: (0.000027524000, 0.000010927700, 0.000000000000),
    784: (0.000025811000, 0.000010251900, 0.000000000000),
    785: (0.000024209000, 0.000009619600, 0.000000000000),
    786: (0.000022711000, 0.000009028100, 0.000000000000),
    787: (0.000021308000, 0.000008474000, 0.000000000000),
    788: (0.000019994000, 0.000007954800, 0.000000000000),
    789: (0.000018764000, 0.000007468600, 0.000000000000),
    790: (0.000017611500, 0.000007012800, 0.000000000000),
    791: (0.000016532000, 0.000006585800, 0.000000000000),
    792: (0.000015521000, 0.000006185700, 0.000000000000),
    793: (0.000014574000, 0.000005810700, 0.000000000000),
    794: (0.000013686000, 0.000005459000, 0.000000000000),
    795: (0.000012855000, 0.000005129800, 0.000000000000),
    796: (0.000012075000, 0.000004820600, 0.000000000000),
    797: (0.000011345000, 0.000004531200, 0.000000000000),
    798: (0.000010659000, 0.000004259100, 0.000000000000),
    799: (0.000010017000, 0.000004004200, 0.000000000000),
    800: (0.000009413630, 0.000003764730, 0.000000000000),
    801: (0.000008847900, 0.000003539950, 0.000000000000),
    802: (0.000008317100, 0.000003329140, 0.000000000000),
    803: (0.000007819000, 0.000003131150, 0.000000000000),
    804: (0.000007351600, 0.000002945290, 0.000000000000),
    805: (0.000006913000, 0.000002770810, 0.000000000000),
    806: (0.000006501500, 0.000002607050, 0.000000000000),
    807: (0.000006115300, 0.000002453290, 0.000000000000),
    808: (0.000005752900, 0.000002308940, 0.000000000000),
    809: (0.000005412700, 0.000002173380, 0.000000000000),
    810: (0.000005093470, 0.000002046130, 0.000000000000),
    811: (0.000004793800, 0.000001926620, 0.000000000000),
    812: (0.000004512500, 0.000001814400, 0.000000000000),
    813: (0.000004248300, 0.000001708950, 0.000000000000),
    814: (0.000004000200, 0.000001609880, 0.000000000000),
    815: (0.000003767100, 0.000001516770, 0.000000000000),
    816: (0.000003548000, 0.000001429210, 0.000000000000),
    817: (0.000003342100, 0.000001346860, 0.000000000000),
    818: (0.000003148500, 0.000001269450, 0.000000000000),
    819: (0.000002966500, 0.000001196620, 0.000000000000),
    820: (0.000002795310, 0.000001128090, 0.000000000000),
    821: (0.000002634500, 0.000001063680, 0.000000000000),
    822: (0.000002483400, 0.000001003130, 0.000000000000),
    823: (0.000002341400, 0.000000946220, 0.000000000000),
    824: (0.000002207800, 0.000000892630, 0.000000000000),
    825: (0.000002082000, 0.000000842160, 0.000000000000),
    826: (0.000001963600, 0.000000794640, 0.000000000000),
    827: (0.000001851900, 0.000000749780, 0.000000000000),
    828: (0.000001746500, 0.000000707440, 0.000000000000),
    829: (0.000001647100, 0.000000667480, 0.000000000000),
    830: (0.000001553140, 0.000000629700, 0.000000000000)
}

# CIE 2015 2 Degree Standard Observer (noted as 2006, but they are the same)
# http://www-cvrl.ucsd.edu/cmfs.htm
CIE_2015_2DEG = {
    390: (3.769647E-03, 4.146161E-04, 1.84726E-02),
    391: (4.532416E-03, 5.028333E-04, 2.221101E-02),
    392: (5.446553E-03, 6.084991E-04, 2.669819E-02),
    393: (6.538868E-03, 7.344436E-04, 3.206937E-02),
    394: (7.839699E-03, 8.837389E-04, 3.847832E-02),
    395: (9.382967E-03, 1.059646E-03, 4.609784E-02),
    396: (1.120608E-02, 1.265532E-03, 5.511953E-02),
    397: (1.334965E-02, 1.504753E-03, 6.575257E-02),
    398: (1.58569E-02, 1.780493E-03, 7.822113E-02),
    399: (1.877286E-02, 2.095572E-03, 9.276013E-02),
    400: (2.214302E-02, 2.452194E-03, 1.09609E-01),
    401: (2.601285E-02, 2.852216E-03, 1.290077E-01),
    402: (3.043036E-02, 3.299115E-03, 1.512047E-01),
    403: (3.544325E-02, 3.797466E-03, 1.764441E-01),
    404: (4.10964E-02, 4.352768E-03, 2.049517E-01),
    405: (4.742986E-02, 4.971717E-03, 2.369246E-01),
    406: (5.447394E-02, 5.661014E-03, 2.725123E-01),
    407: (6.223612E-02, 6.421615E-03, 3.11782E-01),
    408: (7.070048E-02, 7.250312E-03, 3.547064E-01),
    409: (7.982513E-02, 8.140173E-03, 4.011473E-01),
    410: (8.953803E-02, 9.07986E-03, 4.508369E-01),
    411: (9.974848E-02, 1.005608E-02, 5.034164E-01),
    412: (1.104019E-01, 1.106456E-02, 5.586361E-01),
    413: (1.214566E-01, 1.210522E-02, 6.162734E-01),
    414: (1.328741E-01, 1.318014E-02, 6.760982E-01),
    415: (1.446214E-01, 1.429377E-02, 7.378822E-01),
    416: (1.566468E-01, 1.545004E-02, 8.013019E-01),
    417: (1.687901E-01, 1.664093E-02, 8.655573E-01),
    418: (1.808328E-01, 1.785302E-02, 9.295791E-01),
    419: (1.925216E-01, 1.907018E-02, 9.921293E-01),
    420: (2.035729E-01, 2.027369E-02, 1.051821E+00),
    421: (2.137531E-01, 2.144805E-02, 1.107509E+00),
    422: (2.231348E-01, 2.260041E-02, 1.159527E+00),
    423: (2.319245E-01, 2.374789E-02, 1.208869E+00),
    424: (2.403892E-01, 2.491247E-02, 1.256834E+00),
    425: (2.488523E-01, 2.612106E-02, 1.305008E+00),
    426: (2.575896E-01, 2.739923E-02, 1.354758E+00),
    427: (2.664991E-01, 2.874993E-02, 1.405594E+00),
    428: (2.753532E-01, 3.016909E-02, 1.456414E+00),
    429: (2.838921E-01, 3.165145E-02, 1.50596E+00),
    430: (2.918246E-01, 3.319038E-02, 1.552826E+00),
    431: (2.9892E-01, 3.477912E-02, 1.595902E+00),
    432: (3.052993E-01, 3.641495E-02, 1.635768E+00),
    433: (3.112031E-01, 3.809569E-02, 1.673573E+00),
    434: (3.169047E-01, 3.981843E-02, 1.710604E+00),
    435: (3.227087E-01, 4.15794E-02, 1.74828E+00),
    436: (3.288194E-01, 4.337098E-02, 1.787504E+00),
    437: (3.349242E-01, 4.51718E-02, 1.826609E+00),
    438: (3.405452E-01, 4.69542E-02, 1.863108E+00),
    439: (3.451688E-01, 4.868718E-02, 1.894332E+00),
    440: (3.482554E-01, 5.033657E-02, 1.917479E+00),
    441: (3.494153E-01, 5.187611E-02, 1.930529E+00),
    442: (3.489075E-01, 5.332218E-02, 1.934819E+00),
    443: (3.471746E-01, 5.470603E-02, 1.93265E+00),
    444: (3.446705E-01, 5.606335E-02, 1.926395E+00),
    445: (3.418483E-01, 5.743393E-02, 1.918437E+00),
    446: (3.39024E-01, 5.885107E-02, 1.91043E+00),
    447: (3.359926E-01, 6.030809E-02, 1.901224E+00),
    448: (3.324276E-01, 6.178644E-02, 1.889E+00),
    449: (3.280157E-01, 6.32657E-02, 1.871996E+00),
    450: (3.224637E-01, 6.472352E-02, 1.848545E+00),
    451: (3.156225E-01, 6.614749E-02, 1.817792E+00),
    452: (3.078201E-01, 6.757256E-02, 1.781627E+00),
    453: (2.994771E-01, 6.904928E-02, 1.742514E+00),
    454: (2.909776E-01, 7.06328E-02, 1.702749E+00),
    455: (2.826646E-01, 7.238339E-02, 1.664439E+00),
    456: (2.747962E-01, 7.43596E-02, 1.629207E+00),
    457: (2.674312E-01, 7.659383E-02, 1.59736E+00),
    458: (2.605847E-01, 7.911436E-02, 1.568896E+00),
    459: (2.542749E-01, 8.195345E-02, 1.543823E+00),
    460: (2.485254E-01, 8.514816E-02, 1.522157E+00),
    461: (2.433039E-01, 8.872657E-02, 1.503611E+00),
    462: (2.383414E-01, 9.266008E-02, 1.486673E+00),
    463: (2.333253E-01, 9.689723E-02, 1.469595E+00),
    464: (2.279619E-01, 1.013746E-01, 1.450709E+00),
    465: (2.219781E-01, 1.060145E-01, 1.42844E+00),
    466: (2.151735E-01, 1.107377E-01, 1.401587E+00),
    467: (2.075619E-01, 1.155111E-01, 1.370094E+00),
    468: (1.992183E-01, 1.203122E-01, 1.33422E+00),
    469: (1.90229E-01, 1.251161E-01, 1.294275E+00),
    470: (1.806905E-01, 1.298957E-01, 1.25061E+00),
    471: (1.707154E-01, 1.346299E-01, 1.203696E+00),
    472: (1.604471E-01, 1.393309E-01, 1.154316E+00),
    473: (1.500244E-01, 1.440235E-01, 1.103284E+00),
    474: (1.395705E-01, 1.487372E-01, 1.051347E+00),
    475: (1.29192E-01, 1.535066E-01, 9.991789E-01),
    476: (1.189859E-01, 1.583644E-01, 9.473958E-01),
    477: (1.090615E-01, 1.633199E-01, 8.966222E-01),
    478: (9.951424E-02, 1.683761E-01, 8.473981E-01),
    479: (9.04185E-02, 1.735365E-01, 8.001576E-01),
    480: (8.182895E-02, 1.788048E-01, 7.552379E-01),
    481: (7.376817E-02, 1.841819E-01, 7.127879E-01),
    482: (6.619477E-02, 1.896559E-01, 6.725198E-01),
    483: (5.90638E-02, 1.952101E-01, 6.340976E-01),
    484: (5.234242E-02, 2.008259E-01, 5.972433E-01),
    485: (4.600865E-02, 2.064828E-01, 5.617313E-01),
    486: (4.006154E-02, 2.121826E-01, 5.274921E-01),
    487: (3.454373E-02, 2.180279E-01, 4.948809E-01),
    488: (2.949091E-02, 2.241586E-01, 4.642586E-01),
    489: (2.49214E-02, 2.307302E-01, 4.358841E-01),
    490: (2.083981E-02, 2.37916E-01, 4.099313E-01),
    491: (1.723591E-02, 2.458706E-01, 3.864261E-01),
    492: (1.407924E-02, 2.546023E-01, 3.650566E-01),
    493: (1.134516E-02, 2.64076E-01, 3.454812E-01),
    494: (9.019658E-03, 2.74249E-01, 3.274095E-01),
    495: (7.097731E-03, 2.85068E-01, 3.105939E-01),
    496: (5.571145E-03, 2.964837E-01, 2.948102E-01),
    497: (4.394566E-03, 3.08501E-01, 2.798194E-01),
    498: (3.516303E-03, 3.211393E-01, 2.6541E-01),
    499: (2.887638E-03, 3.344175E-01, 2.514084E-01),
    500: (2.461588E-03, 3.483536E-01, 2.376753E-01),
    501: (2.206348E-03, 3.629601E-01, 2.241211E-01),
    502: (2.149559E-03, 3.782275E-01, 2.107484E-01),
    503: (2.337091E-03, 3.941359E-01, 1.975839E-01),
    504: (2.818931E-03, 4.106582E-01, 1.846574E-01),
    505: (3.649178E-03, 4.277595E-01, 1.720018E-01),
    506: (4.891359E-03, 4.453993E-01, 1.596918E-01),
    507: (6.629364E-03, 4.635396E-01, 1.479415E-01),
    508: (8.942902E-03, 4.821376E-01, 1.369428E-01),
    509: (1.190224E-02, 5.01143E-01, 1.268279E-01),
    510: (1.556989E-02, 5.204972E-01, 1.176796E-01),
    511: (1.997668E-02, 5.401387E-01, 1.09497E-01),
    512: (2.504698E-02, 5.600208E-01, 1.020943E-01),
    513: (3.06753E-02, 5.800972E-01, 9.527993E-02),
    514: (3.674999E-02, 6.003172E-01, 8.890075E-02),
    515: (4.315171E-02, 6.206256E-01, 8.283548E-02),
    516: (4.978584E-02, 6.409398E-01, 7.700982E-02),
    517: (5.668554E-02, 6.610772E-01, 7.144001E-02),
    518: (6.391651E-02, 6.808134E-01, 6.615436E-02),
    519: (7.154352E-02, 6.999044E-01, 6.117199E-02),
    520: (7.962917E-02, 7.18089E-01, 5.650407E-02),
    521: (8.821473E-02, 7.351593E-01, 5.215121E-02),
    522: (9.726978E-02, 7.511821E-01, 4.809566E-02),
    523: (1.067504E-01, 7.663143E-01, 4.43172E-02),
    524: (1.166192E-01, 7.807352E-01, 4.079734E-02),
    525: (1.268468E-01, 7.946448E-01, 3.751912E-02),
    526: (1.37406E-01, 8.082074E-01, 3.446846E-02),
    527: (1.482471E-01, 8.213817E-01, 3.163764E-02),
    528: (1.593076E-01, 8.340701E-01, 2.901901E-02),
    529: (1.705181E-01, 8.461711E-01, 2.660364E-02),
    530: (1.818026E-01, 8.575799E-01, 2.438164E-02),
    531: (1.93109E-01, 8.682408E-01, 2.234097E-02),
    532: (2.045085E-01, 8.783061E-01, 2.046415E-02),
    533: (2.161166E-01, 8.879907E-01, 1.873456E-02),
    534: (2.28065E-01, 8.975211E-01, 1.713788E-02),
    535: (2.405015E-01, 9.071347E-01, 1.566174E-02),
    536: (2.535441E-01, 9.169947E-01, 1.429644E-02),
    537: (2.6713E-01, 9.269295E-01, 1.303702E-02),
    538: (2.811351E-01, 9.366731E-01, 1.187897E-02),
    539: (2.954164E-01, 9.459482E-01, 1.081725E-02),
    540: (3.098117E-01, 9.544675E-01, 9.84647E-03),
    541: (3.241678E-01, 9.619834E-01, 8.960687E-03),
    542: (3.384319E-01, 9.68439E-01, 8.152811E-03),
    543: (3.525786E-01, 9.738289E-01, 7.416025E-03),
    544: (3.665839E-01, 9.781519E-01, 6.744115E-03),
    545: (3.804244E-01, 9.814106E-01, 6.131421E-03),
    546: (3.940988E-01, 9.836669E-01, 5.572778E-03),
    547: (4.076972E-01, 9.852081E-01, 5.063463E-03),
    548: (4.213484E-01, 9.863813E-01, 4.599169E-03),
    549: (4.352003E-01, 9.875357E-01, 4.175971E-03),
    550: (4.494206E-01, 9.890228E-01, 3.790291E-03),
    551: (4.641616E-01, 9.910811E-01, 3.438952E-03),
    552: (4.794395E-01, 9.934913E-01, 3.119341E-03),
    553: (4.95218E-01, 9.959172E-01, 2.829038E-03),
    554: (5.114395E-01, 9.980205E-01, 2.565722E-03),
    555: (5.280233E-01, 9.994608E-01, 2.327186E-03),
    556: (5.448696E-01, 9.99993E-01, 2.11128E-03),
    557: (5.618898E-01, 9.997557E-01, 1.915766E-03),
    558: (5.790137E-01, 9.989839E-01, 1.738589E-03),
    559: (5.961882E-01, 9.979123E-01, 1.57792E-03),
    560: (6.133784E-01, 9.967737E-01, 1.432128E-03),
    561: (6.305897E-01, 9.957356E-01, 1.299781E-03),
    562: (6.479223E-01, 9.947115E-01, 1.179667E-03),
    563: (6.654866E-01, 9.935534E-01, 1.070694E-03),
    564: (6.833782E-01, 9.921156E-01, 9.718623E-04),
    565: (7.016774E-01, 9.902549E-01, 8.822531E-04),
    566: (7.20411E-01, 9.878596E-01, 8.010231E-04),
    567: (7.394495E-01, 9.849324E-01, 7.273884E-04),
    568: (7.586285E-01, 9.815036E-01, 6.606347E-04),
    569: (7.777885E-01, 9.776035E-01, 6.001146E-04),
    570: (7.96775E-01, 9.732611E-01, 5.452416E-04),
    571: (8.15453E-01, 9.684764E-01, 4.954847E-04),
    572: (8.337389E-01, 9.631369E-01, 4.503642E-04),
    573: (8.515493E-01, 9.571062E-01, 4.094455E-04),
    574: (8.687862E-01, 9.50254E-01, 3.723345E-04),
    575: (8.853376E-01, 9.424569E-01, 3.386739E-04),
    576: (9.011588E-01, 9.336897E-01, 3.081396E-04),
    577: (9.165278E-01, 9.242893E-01, 2.80437E-04),
    578: (9.318245E-01, 9.146707E-01, 2.552996E-04),
    579: (9.474524E-01, 9.052333E-01, 2.324859E-04),
    580: (9.638388E-01, 8.963613E-01, 2.117772E-04),
    581: (9.812596E-01, 8.883069E-01, 1.929758E-04),
    582: (9.992953E-01, 8.808462E-01, 1.759024E-04),
    583: (1.017343E+00, 8.736445E-01, 1.603947E-04),
    584: (1.03479E+00, 8.663755E-01, 1.463059E-04),
    585: (1.051011E+00, 8.587203E-01, 1.335031E-04),
    586: (1.065522E+00, 8.504295E-01, 1.21866E-04),
    587: (1.078421E+00, 8.415047E-01, 1.112857E-04),
    588: (1.089944E+00, 8.320109E-01, 1.016634E-04),
    589: (1.10032E+00, 8.220154E-01, 9.291003E-05),
    590: (1.109767E+00, 8.115868E-01, 8.494468E-05),
    591: (1.118438E+00, 8.007874E-01, 7.769425E-05),
    592: (1.126266E+00, 7.896515E-01, 7.109247E-05),
    593: (1.133138E+00, 7.782053E-01, 6.507936E-05),
    594: (1.138952E+00, 7.664733E-01, 5.960061E-05),
    595: (1.14362E+00, 7.544785E-01, 5.460706E-05),
    596: (1.147095E+00, 7.422473E-01, 5.005417E-05),
    597: (1.149464E+00, 7.298229E-01, 4.590157E-05),
    598: (1.150838E+00, 7.172525E-01, 4.211268E-05),
    599: (1.151326E+00, 7.045818E-01, 3.865437E-05),
    600: (1.151033E+00, 6.918553E-01, 3.549661E-05),
    601: (1.150002E+00, 6.791009E-01, 3.26122E-05),
    602: (1.148061E+00, 6.662846E-01, 2.997643E-05),
    603: (1.144998E+00, 6.533595E-01, 2.756693E-05),
    604: (1.140622E+00, 6.402807E-01, 2.536339E-05),
    605: (1.134757E+00, 6.270066E-01, 2.334738E-05),
    606: (1.127298E+00, 6.135148E-01, 2.150221E-05),
    607: (1.118342E+00, 5.998494E-01, 1.981268E-05),
    608: (1.108033E+00, 5.860682E-01, 1.8265E-05),
    609: (1.096515E+00, 5.722261E-01, 1.684667E-05),
    610: (1.083928E+00, 5.583746E-01, 1.554631E-05),
    611: (1.070387E+00, 5.445535E-01, 1.43536E-05),
    612: (1.055934E+00, 5.307673E-01, 1.325915E-05),
    613: (1.040592E+00, 5.17013E-01, 1.225443E-05),
    614: (1.024385E+00, 5.032889E-01, 1.133169E-05),
    615: (1.007344E+00, 4.89595E-01, 1.048387E-05),
    616: (9.895268E-01, 4.759442E-01, 0E+00),
    617: (9.711213E-01, 4.623958E-01, 0E+00),
    618: (9.523257E-01, 4.490154E-01, 0E+00),
    619: (9.333248E-01, 4.358622E-01, 0E+00),
    620: (9.142877E-01, 4.229897E-01, 0E+00),
    621: (8.952798E-01, 4.104152E-01, 0E+00),
    622: (8.760157E-01, 3.980356E-01, 0E+00),
    623: (8.561607E-01, 3.8573E-01, 0E+00),
    624: (8.354235E-01, 3.733907E-01, 0E+00),
    625: (8.135565E-01, 3.609245E-01, 0E+00),
    626: (7.904565E-01, 3.48286E-01, 0E+00),
    627: (7.664364E-01, 3.355702E-01, 0E+00),
    628: (7.418777E-01, 3.228963E-01, 0E+00),
    629: (7.171219E-01, 3.103704E-01, 0E+00),
    630: (6.924717E-01, 2.980865E-01, 0E+00),
    631: (6.6816E-01, 2.86116E-01, 0E+00),
    632: (6.442697E-01, 2.744822E-01, 0E+00),
    633: (6.20845E-01, 2.631953E-01, 0E+00),
    634: (5.979243E-01, 2.522628E-01, 0E+00),
    635: (5.75541E-01, 2.416902E-01, 0E+00),
    636: (5.537296E-01, 2.314809E-01, 0E+00),
    637: (5.325412E-01, 2.216378E-01, 0E+00),
    638: (5.120218E-01, 2.121622E-01, 0E+00),
    639: (4.92207E-01, 2.030542E-01, 0E+00),
    640: (4.731224E-01, 1.943124E-01, 0E+00),
    641: (4.547417E-01, 1.859227E-01, 0E+00),
    642: (4.368719E-01, 1.778274E-01, 0E+00),
    643: (4.193121E-01, 1.699654E-01, 0E+00),
    644: (4.01898E-01, 1.622841E-01, 0E+00),
    645: (3.844986E-01, 1.547397E-01, 0E+00),
    646: (3.670592E-01, 1.473081E-01, 0E+00),
    647: (3.497167E-01, 1.400169E-01, 0E+00),
    648: (3.326305E-01, 1.329013E-01, 0E+00),
    649: (3.159341E-01, 1.259913E-01, 0E+00),
    650: (2.997374E-01, 1.19312E-01, 0E+00),
    651: (2.841189E-01, 1.12882E-01, 0E+00),
    652: (2.691053E-01, 1.067113E-01, 0E+00),
    653: (2.547077E-01, 1.008052E-01, 0E+00),
    654: (2.409319E-01, 9.516653E-02, 0E+00),
    655: (2.277792E-01, 8.979594E-02, 0E+00),
    656: (2.152431E-01, 8.469044E-02, 0E+00),
    657: (2.03301E-01, 7.984009E-02, 0E+00),
    658: (1.919276E-01, 7.523372E-02, 0E+00),
    659: (1.810987E-01, 7.086061E-02, 0E+00),
    660: (1.707914E-01, 6.671045E-02, 0E+00),
    661: (1.609842E-01, 6.27736E-02, 0E+00),
    662: (1.516577E-01, 5.904179E-02, 0E+00),
    663: (1.427936E-01, 5.550703E-02, 0E+00),
    664: (1.343737E-01, 5.216139E-02, 0E+00),
    665: (1.263808E-01, 4.899699E-02, 0E+00),
    666: (1.187979E-01, 4.600578E-02, 0E+00),
    667: (1.116088E-01, 4.317885E-02, 0E+00),
    668: (1.047975E-01, 4.050755E-02, 0E+00),
    669: (9.834835E-02, 3.798376E-02, 0E+00),
    670: (9.224597E-02, 3.559982E-02, 0E+00),
    671: (8.647506E-02, 3.334856E-02, 0E+00),
    672: (8.101986E-02, 3.122332E-02, 0E+00),
    673: (7.586514E-02, 2.92178E-02, 0E+00),
    674: (7.099633E-02, 2.732601E-02, 0E+00),
    675: (6.63996E-02, 2.554223E-02, 0E+00),
    676: (6.206225E-02, 2.386121E-02, 0E+00),
    677: (5.797409E-02, 2.227859E-02, 0E+00),
    678: (5.412533E-02, 2.07902E-02, 0E+00),
    679: (5.0506E-02, 1.939185E-02, 0E+00),
    680: (4.710606E-02, 1.807939E-02, 0E+00),
    681: (4.391411E-02, 1.684817E-02, 0E+00),
    682: (4.091411E-02, 1.569188E-02, 0E+00),
    683: (3.809067E-02, 1.460446E-02, 0E+00),
    684: (3.543034E-02, 1.358062E-02, 0E+00),
    685: (3.292138E-02, 1.261573E-02, 0E+00),
    686: (3.055672E-02, 1.170696E-02, 0E+00),
    687: (2.834146E-02, 1.085608E-02, 0E+00),
    688: (2.628033E-02, 1.006476E-02, 0E+00),
    689: (2.437465E-02, 9.333376E-03, 0E+00),
    690: (2.262306E-02, 8.661284E-03, 0E+00),
    691: (2.101935E-02, 8.046048E-03, 0E+00),
    692: (1.954647E-02, 7.48113E-03, 0E+00),
    693: (1.818727E-02, 6.959987E-03, 0E+00),
    694: (1.692727E-02, 6.47707E-03, 0E+00),
    695: (1.575417E-02, 6.027677E-03, 0E+00),
    696: (1.465854E-02, 5.608169E-03, 0E+00),
    697: (1.363571E-02, 5.216691E-03, 0E+00),
    698: (1.268205E-02, 4.851785E-03, 0E+00),
    699: (1.179394E-02, 4.512008E-03, 0E+00),
    700: (1.096778E-02, 4.195941E-03, 0E+00),
    701: (1.019964E-02, 3.902057E-03, 0E+00),
    702: (9.484317E-03, 3.628371E-03, 0E+00),
    703: (8.816851E-03, 3.373005E-03, 0E+00),
    704: (8.192921E-03, 3.134315E-03, 0E+00),
    705: (7.60875E-03, 2.910864E-03, 0E+00),
    706: (7.061391E-03, 2.701528E-03, 0E+00),
    707: (6.549509E-03, 2.505796E-03, 0E+00),
    708: (6.07197E-03, 2.323231E-03, 0E+00),
    709: (5.627476E-03, 2.153333E-03, 0E+00),
    710: (5.214608E-03, 1.995557E-03, 0E+00),
    711: (4.831848E-03, 1.849316E-03, 0E+00),
    712: (4.477579E-03, 1.713976E-03, 0E+00),
    713: (4.150166E-03, 1.588899E-03, 0E+00),
    714: (3.847988E-03, 1.473453E-03, 0E+00),
    715: (3.569452E-03, 1.367022E-03, 0E+00),
    716: (3.312857E-03, 1.268954E-03, 0E+00),
    717: (3.076022E-03, 1.178421E-03, 0E+00),
    718: (2.856894E-03, 1.094644E-03, 0E+00),
    719: (2.653681E-03, 1.016943E-03, 0E+00),
    720: (2.464821E-03, 9.447269E-04, 0E+00),
    721: (2.28906E-03, 8.775171E-04, 0E+00),
    722: (2.125694E-03, 8.150438E-04, 0E+00),
    723: (1.974121E-03, 7.570755E-04, 0E+00),
    724: (1.833723E-03, 7.033755E-04, 0E+00),
    725: (1.703876E-03, 6.53705E-04, 0E+00),
    726: (1.583904E-03, 6.078048E-04, 0E+00),
    727: (1.472939E-03, 5.653435E-04, 0E+00),
    728: (1.370151E-03, 5.260046E-04, 0E+00),
    729: (1.274803E-03, 4.895061E-04, 0E+00),
    730: (1.186238E-03, 4.55597E-04, 0E+00),
    731: (1.103871E-03, 4.240548E-04, 0E+00),
    732: (1.027194E-03, 3.94686E-04, 0E+00),
    733: (9.557493E-04, 3.673178E-04, 0E+00),
    734: (8.891262E-04, 3.417941E-04, 0E+00),
    735: (8.269535E-04, 3.179738E-04, 0E+00),
    736: (7.689351E-04, 2.957441E-04, 0E+00),
    737: (7.149425E-04, 2.750558E-04, 0E+00),
    738: (6.64859E-04, 2.55864E-04, 0E+00),
    739: (6.185421E-04, 2.381142E-04, 0E+00),
    740: (5.758303E-04, 2.217445E-04, 0E+00),
    741: (5.365046E-04, 2.066711E-04, 0E+00),
    742: (5.001842E-04, 1.927474E-04, 0E+00),
    743: (4.665005E-04, 1.798315E-04, 0E+00),
    744: (4.351386E-04, 1.678023E-04, 0E+00),
    745: (4.058303E-04, 1.565566E-04, 0E+00),
    746: (3.783733E-04, 1.460168E-04, 0E+00),
    747: (3.526892E-04, 1.361535E-04, 0E+00),
    748: (3.287199E-04, 1.269451E-04, 0E+00),
    749: (3.063998E-04, 1.183671E-04, 0E+00),
    750: (2.856577E-04, 1.103928E-04, 0E+00),
    751: (2.664108E-04, 1.029908E-04, 0E+00),
    752: (2.485462E-04, 9.611836E-05, 0E+00),
    753: (2.319529E-04, 8.973323E-05, 0E+00),
    754: (2.1653E-04, 8.379694E-05, 0E+00),
    755: (2.021853E-04, 7.827442E-05, 0E+00),
    756: (1.888338E-04, 7.313312E-05, 0E+00),
    757: (1.763935E-04, 6.834142E-05, 0E+00),
    758: (1.647895E-04, 6.387035E-05, 0E+00),
    759: (1.539542E-04, 5.969389E-05, 0E+00),
    760: (1.43827E-04, 5.578862E-05, 0E+00),
    761: (1.343572E-04, 5.213509E-05, 0E+00),
    762: (1.255141E-04, 4.872179E-05, 0E+00),
    763: (1.172706E-04, 4.553845E-05, 0E+00),
    764: (1.095983E-04, 4.257443E-05, 0E+00),
    765: (1.024685E-04, 3.981884E-05, 0E+00),
    766: (9.584715E-05, 3.725877E-05, 0E+00),
    767: (8.968316E-05, 3.487467E-05, 0E+00),
    768: (8.392734E-05, 3.264765E-05, 0E+00),
    769: (7.853708E-05, 3.05614E-05, 0E+00),
    770: (7.347551E-05, 2.860175E-05, 0E+00),
    771: (6.871576E-05, 2.675841E-05, 0E+00),
    772: (6.425257E-05, 2.502943E-05, 0E+00),
    773: (6.008292E-05, 2.341373E-05, 0E+00),
    774: (5.620098E-05, 2.190914E-05, 0E+00),
    775: (5.25987E-05, 2.051259E-05, 0E+00),
    776: (4.926279E-05, 1.921902E-05, 0E+00),
    777: (4.616623E-05, 1.801796E-05, 0E+00),
    778: (4.328212E-05, 1.689899E-05, 0E+00),
    779: (4.058715E-05, 1.585309E-05, 0E+00),
    780: (3.806114E-05, 1.487243E-05, 0E+00),
    781: (3.568818E-05, 1.395085E-05, 0E+00),
    782: (3.346023E-05, 1.308528E-05, 0E+00),
    783: (3.13709E-05, 1.227327E-05, 0E+00),
    784: (2.941371E-05, 1.151233E-05, 0E+00),
    785: (2.758222E-05, 1.080001E-05, 0E+00),
    786: (2.586951E-05, 1.013364E-05, 0E+00),
    787: (2.426701E-05, 9.509919E-06, 0E+00),
    788: (2.276639E-05, 8.92563E-06, 0E+00),
    789: (2.136009E-05, 8.377852E-06, 0E+00),
    790: (2.004122E-05, 7.86392E-06, 0E+00),
    791: (1.88038E-05, 7.381539E-06, 0E+00),
    792: (1.764358E-05, 6.929096E-06, 0E+00),
    793: (1.655671E-05, 6.505136E-06, 0E+00),
    794: (1.553939E-05, 6.108221E-06, 0E+00),
    795: (1.458792E-05, 5.736935E-06, 0E+00),
    796: (1.369853E-05, 5.389831E-06, 0E+00),
    797: (1.286705E-05, 5.065269E-06, 0E+00),
    798: (1.208947E-05, 4.761667E-06, 0E+00),
    799: (1.136207E-05, 4.477561E-06, 0E+00),
    800: (1.068141E-05, 4.211597E-06, 0E+00),
    801: (1.004411E-05, 3.962457E-06, 0E+00),
    802: (9.446399E-06, 3.728674E-06, 0E+00),
    803: (8.884754E-06, 3.508881E-06, 0E+00),
    804: (8.35605E-06, 3.301868E-06, 0E+00),
    805: (7.857521E-06, 3.106561E-06, 0E+00),
    806: (7.386996E-06, 2.922119E-06, 0E+00),
    807: (6.943576E-06, 2.748208E-06, 0E+00),
    808: (6.526548E-06, 2.58456E-06, 0E+00),
    809: (6.135087E-06, 2.430867E-06, 0E+00),
    810: (5.768284E-06, 2.286786E-06, 0E+00),
    811: (5.425069E-06, 2.151905E-06, 0E+00),
    812: (5.103974E-06, 2.025656E-06, 0E+00),
    813: (4.803525E-06, 1.907464E-06, 0E+00),
    814: (4.52235E-06, 1.796794E-06, 0E+00),
    815: (4.259166E-06, 1.693147E-06, 0E+00),
    816: (4.012715E-06, 1.596032E-06, 0E+00),
    817: (3.781597E-06, 1.504903E-06, 0E+00),
    818: (3.564496E-06, 1.419245E-06, 0E+00),
    819: (3.360236E-06, 1.3386E-06, 0E+00),
    820: (3.167765E-06, 1.262556E-06, 0E+00),
    821: (2.986206E-06, 1.190771E-06, 0E+00),
    822: (2.814999E-06, 1.123031E-06, 0E+00),
    823: (2.653663E-06, 1.059151E-06, 0E+00),
    824: (2.501725E-06, 9.989507E-07, 0E+00),
    825: (2.358723E-06, 9.422514E-07, 0E+00),
    826: (2.224206E-06, 8.888804E-07, 0E+00),
    827: (2.097737E-06, 8.38669E-07, 0E+00),
    828: (1.978894E-06, 7.914539E-07, 0E+00),
    829: (1.867268E-06, 7.47077E-07, 0E+00),
    830: (1.762465E-06, 7.05386E-07, 0E+00),
}

# CIE 2015 10 Degree Standard Observer (noted as 2006, but they are the same)
# http://www-cvrl.ucsd.edu/cmfs.htm
CIE_2015_10DEG = {
    390: (2.95242E-03, 4.076779E-04, 1.318752E-02),
    391: (3.577275E-03, 4.977769E-04, 1.597879E-02),
    392: (4.332146E-03, 6.064754E-04, 1.935758E-02),
    393: (5.241609E-03, 7.37004E-04, 2.343758E-02),
    394: (6.333902E-03, 8.929388E-04, 2.835021E-02),
    395: (7.641137E-03, 1.078166E-03, 3.424588E-02),
    396: (9.199401E-03, 1.296816E-03, 4.129467E-02),
    397: (1.104869E-02, 1.553159E-03, 4.968641E-02),
    398: (1.323262E-02, 1.851463E-03, 5.962964E-02),
    399: (1.579791E-02, 2.195795E-03, 7.134926E-02),
    400: (1.879338E-02, 2.589775E-03, 8.508254E-02),
    401: (2.226949E-02, 3.036799E-03, 1.010753E-01),
    402: (2.627978E-02, 3.541926E-03, 1.195838E-01),
    403: (3.087862E-02, 4.111422E-03, 1.408647E-01),
    404: (3.61189E-02, 4.752618E-03, 1.651644E-01),
    405: (4.204986E-02, 5.474207E-03, 1.927065E-01),
    406: (4.871256E-02, 6.285034E-03, 2.236782E-01),
    407: (5.612868E-02, 7.188068E-03, 2.582109E-01),
    408: (6.429866E-02, 8.181786E-03, 2.963632E-01),
    409: (7.319818E-02, 9.260417E-03, 3.381018E-01),
    410: (8.277331E-02, 1.041303E-02, 3.832822E-01),
    411: (9.295327E-02, 1.162642E-02, 4.316884E-01),
    412: (1.037137E-01, 1.289884E-02, 4.83244E-01),
    413: (1.15052E-01, 1.423442E-02, 5.379345E-01),
    414: (1.269771E-01, 1.56408E-02, 5.95774E-01),
    415: (1.395127E-01, 1.712968E-02, 6.568187E-01),
    416: (1.526661E-01, 1.871265E-02, 7.210459E-01),
    417: (1.663054E-01, 2.038394E-02, 7.878635E-01),
    418: (1.802197E-01, 2.212935E-02, 8.563391E-01),
    419: (1.941448E-01, 2.392985E-02, 9.253017E-01),
    420: (2.077647E-01, 2.576133E-02, 9.933444E-01),
    421: (2.207911E-01, 2.760156E-02, 1.059178E+00),
    422: (2.332355E-01, 2.945513E-02, 1.122832E+00),
    423: (2.452462E-01, 3.133884E-02, 1.184947E+00),
    424: (2.570397E-01, 3.327575E-02, 1.246476E+00),
    425: (2.688989E-01, 3.529554E-02, 1.308674E+00),
    426: (2.810677E-01, 3.742705E-02, 1.372628E+00),
    427: (2.933967E-01, 3.967137E-02, 1.437661E+00),
    428: (3.055933E-01, 4.201998E-02, 1.502449E+00),
    429: (3.173165E-01, 4.446166E-02, 1.565456E+00),
    430: (3.281798E-01, 4.698226E-02, 1.62494E+00),
    431: (3.378678E-01, 4.956742E-02, 1.679488E+00),
    432: (3.465097E-01, 5.221219E-02, 1.729668E+00),
    433: (3.543953E-01, 5.491387E-02, 1.776755E+00),
    434: (3.618655E-01, 5.766919E-02, 1.822228E+00),
    435: (3.693084E-01, 6.047429E-02, 1.867751E+00),
    436: (3.770107E-01, 6.332195E-02, 1.914504E+00),
    437: (3.84685E-01, 6.619271E-02, 1.961055E+00),
    438: (3.918591E-01, 6.906185E-02, 2.005136E+00),
    439: (3.980192E-01, 7.19019E-02, 2.044296E+00),
    440: (4.026189E-01, 7.468288E-02, 2.075946E+00),
    441: (4.052637E-01, 7.738452E-02, 2.098231E+00),
    442: (4.062482E-01, 8.003601E-02, 2.112591E+00),
    443: (4.06066E-01, 8.268524E-02, 2.121427E+00),
    444: (4.052283E-01, 8.538745E-02, 2.127239E+00),
    445: (4.042529E-01, 8.820537E-02, 2.132574E+00),
    446: (4.034808E-01, 9.118925E-02, 2.139093E+00),
    447: (4.025362E-01, 9.431041E-02, 2.144815E+00),
    448: (4.008675E-01, 9.751346E-02, 2.146832E+00),
    449: (3.979327E-01, 1.007349E-01, 2.14225E+00),
    450: (3.932139E-01, 1.03903E-01, 2.128264E+00),
    451: (3.864108E-01, 1.069639E-01, 2.103205E+00),
    452: (3.779513E-01, 1.099676E-01, 2.069388E+00),
    453: (3.684176E-01, 1.129992E-01, 2.03003E+00),
    454: (3.583473E-01, 1.161541E-01, 1.988178E+00),
    455: (3.482214E-01, 1.195389E-01, 1.946651E+00),
    456: (3.38383E-01, 1.232503E-01, 1.907521E+00),
    457: (3.288309E-01, 1.273047E-01, 1.870689E+00),
    458: (3.194977E-01, 1.316964E-01, 1.835578E+00),
    459: (3.103345E-01, 1.364178E-01, 1.801657E+00),
    460: (3.013112E-01, 1.414586E-01, 1.76844E+00),
    461: (2.923754E-01, 1.468003E-01, 1.735338E+00),
    462: (2.833273E-01, 1.524002E-01, 1.701254E+00),
    463: (2.739463E-01, 1.582021E-01, 1.665053E+00),
    464: (2.640352E-01, 1.6414E-01, 1.625712E+00),
    465: (2.534221E-01, 1.701373E-01, 1.582342E+00),
    466: (2.420135E-01, 1.761233E-01, 1.534439E+00),
    467: (2.299346E-01, 1.820896E-01, 1.482544E+00),
    468: (2.173617E-01, 1.880463E-01, 1.427438E+00),
    469: (2.044672E-01, 1.940065E-01, 1.369876E+00),
    470: (1.914176E-01, 1.999859E-01, 1.310576E+00),
    471: (1.783672E-01, 2.060054E-01, 1.250226E+00),
    472: (1.654407E-01, 2.120981E-01, 1.189511E+00),
    473: (1.527391E-01, 2.183041E-01, 1.12905E+00),
    474: (1.403439E-01, 2.246686E-01, 1.069379E+00),
    475: (1.283167E-01, 2.312426E-01, 1.010952E+00),
    476: (1.167124E-01, 2.380741E-01, 9.541809E-01),
    477: (1.056121E-01, 2.451798E-01, 8.995253E-01),
    478: (9.508569E-02, 2.525682E-01, 8.47372E-01),
    479: (8.518206E-02, 2.602479E-01, 7.980093E-01),
    480: (7.59312E-02, 2.682271E-01, 7.516389E-01),
    481: (6.733159E-02, 2.765005E-01, 7.082645E-01),
    482: (5.932018E-02, 2.850035E-01, 6.673867E-01),
    483: (5.184106E-02, 2.936475E-01, 6.284798E-01),
    484: (4.486119E-02, 3.023319E-01, 5.911174E-01),
    485: (3.83677E-02, 3.109438E-01, 5.549619E-01),
    486: (3.237296E-02, 3.194105E-01, 5.198843E-01),
    487: (2.692095E-02, 3.278683E-01, 4.862772E-01),
    488: (2.20407E-02, 3.365263E-01, 4.545497E-01),
    489: (1.773951E-02, 3.456176E-01, 4.249955E-01),
    490: (1.400745E-02, 3.554018E-01, 3.978114E-01),
    491: (1.082291E-02, 3.660893E-01, 3.730218E-01),
    492: (8.168996E-03, 3.775857E-01, 3.502618E-01),
    493: (6.044623E-03, 3.89696E-01, 3.291407E-01),
    494: (4.462638E-03, 4.021947E-01, 3.093356E-01),
    495: (3.44681E-03, 4.148227E-01, 2.905816E-01),
    496: (3.009513E-03, 4.273539E-01, 2.726773E-01),
    497: (3.090744E-03, 4.398206E-01, 2.555143E-01),
    498: (3.611221E-03, 4.52336E-01, 2.390188E-01),
    499: (4.491435E-03, 4.650298E-01, 2.231335E-01),
    500: (5.652072E-03, 4.780482E-01, 2.078158E-01),
    501: (7.035322E-03, 4.915173E-01, 1.930407E-01),
    502: (8.669631E-03, 5.054224E-01, 1.788089E-01),
    503: (1.060755E-02, 5.197057E-01, 1.651287E-01),
    504: (1.290468E-02, 5.343012E-01, 1.520103E-01),
    505: (1.561956E-02, 5.491344E-01, 1.394643E-01),
    506: (1.88164E-02, 5.641302E-01, 1.275353E-01),
    507: (2.256923E-02, 5.792416E-01, 1.163771E-01),
    508: (2.694456E-02, 5.944264E-01, 1.061161E-01),
    509: (3.19991E-02, 6.096388E-01, 9.682266E-02),
    510: (3.778185E-02, 6.248296E-01, 8.852389E-02),
    511: (4.430635E-02, 6.399656E-01, 8.118263E-02),
    512: (5.146516E-02, 6.550943E-01, 7.463132E-02),
    513: (5.912224E-02, 6.702903E-01, 6.870644E-02),
    514: (6.71422E-02, 6.856375E-01, 6.327834E-02),
    515: (7.538941E-02, 7.012292E-01, 5.824484E-02),
    516: (8.376697E-02, 7.171103E-01, 5.353812E-02),
    517: (9.233581E-02, 7.330917E-01, 4.914863E-02),
    518: (1.01194E-01, 7.489041E-01, 4.507511E-02),
    519: (1.104362E-01, 7.64253E-01, 4.131175E-02),
    520: (1.201511E-01, 7.788199E-01, 3.784916E-02),
    521: (1.30396E-01, 7.92341E-01, 3.467234E-02),
    522: (1.41131E-01, 8.04851E-01, 3.175471E-02),
    523: (1.522944E-01, 8.164747E-01, 2.907029E-02),
    524: (1.638288E-01, 8.27352E-01, 2.659651E-02),
    525: (1.756832E-01, 8.376358E-01, 2.431375E-02),
    526: (1.878114E-01, 8.474653E-01, 2.220677E-02),
    527: (2.001621E-01, 8.568868E-01, 2.026852E-02),
    528: (2.126822E-01, 8.659242E-01, 1.849246E-02),
    529: (2.253199E-01, 8.746041E-01, 1.687084E-02),
    530: (2.380254E-01, 8.829552E-01, 1.539505E-02),
    531: (2.507787E-01, 8.910274E-01, 1.40545E-02),
    532: (2.636778E-01, 8.989495E-01, 1.283354E-02),
    533: (2.768607E-01, 9.068753E-01, 1.171754E-02),
    534: (2.904792E-01, 9.149652E-01, 1.069415E-02),
    535: (3.046991E-01, 9.233858E-01, 9.753E-03),
    536: (3.196485E-01, 9.322325E-01, 8.886096E-03),
    537: (3.352447E-01, 9.412862E-01, 8.089323E-03),
    538: (3.51329E-01, 9.502378E-01, 7.359131E-03),
    539: (3.677148E-01, 9.587647E-01, 6.691736E-03),
    540: (3.841856E-01, 9.665325E-01, 6.083223E-03),
    541: (4.005312E-01, 9.732504E-01, 5.529423E-03),
    542: (4.166669E-01, 9.788415E-01, 5.025504E-03),
    543: (4.32542E-01, 9.832867E-01, 4.566879E-03),
    544: (4.481063E-01, 9.86572E-01, 4.149405E-03),
    545: (4.633109E-01, 9.886887E-01, 3.769336E-03),
    546: (4.78144E-01, 9.897056E-01, 3.423302E-03),
    547: (4.927483E-01, 9.899849E-01, 3.108313E-03),
    548: (5.073315E-01, 9.899624E-01, 2.82165E-03),
    549: (5.221315E-01, 9.900731E-01, 2.56083E-03),
    550: (5.37417E-01, 9.9075E-01, 2.323578E-03),
    551: (5.534217E-01, 9.922826E-01, 2.107847E-03),
    552: (5.701242E-01, 9.943837E-01, 1.911867E-03),
    553: (5.874093E-01, 9.966221E-01, 1.734006E-03),
    554: (6.051269E-01, 9.985649E-01, 1.572736E-03),
    555: (6.230892E-01, 9.997775E-01, 1.426627E-03),
    556: (6.410999E-01, 9.99944E-01, 1.294325E-03),
    557: (6.590659E-01, 9.9922E-01, 1.174475E-03),
    558: (6.769436E-01, 9.978793E-01, 1.065842E-03),
    559: (6.947143E-01, 9.961934E-01, 9.673215E-04),
    560: (7.123849E-01, 9.944304E-01, 8.779264E-04),
    561: (7.299978E-01, 9.927831E-01, 7.967847E-04),
    562: (7.476478E-01, 9.911578E-01, 7.231502E-04),
    563: (7.65425E-01, 9.893925E-01, 6.563501E-04),
    564: (7.834009E-01, 9.873288E-01, 5.957678E-04),
    565: (8.016277E-01, 9.848127E-01, 5.408385E-04),
    566: (8.201041E-01, 9.817253E-01, 4.910441E-04),
    567: (8.386843E-01, 9.780714E-01, 4.459046E-04),
    568: (8.571936E-01, 9.73886E-01, 4.049826E-04),
    569: (8.754652E-01, 9.692028E-01, 3.678818E-04),
    570: (8.933408E-01, 9.640545E-01, 3.342429E-04),
    571: (9.106772E-01, 9.584409E-01, 3.037407E-04),
    572: (9.273554E-01, 9.522379E-01, 2.760809E-04),
    573: (9.432502E-01, 9.452968E-01, 2.50997E-04),
    574: (9.582244E-01, 9.374773E-01, 2.282474E-04),
    575: (9.721304E-01, 9.286495E-01, 2.076129E-04),
    576: (9.849237E-01, 9.187953E-01, 1.888948E-04),
    577: (9.970067E-01, 9.083014E-01, 1.719127E-04),
    578: (1.008907E+00, 8.976352E-01, 1.56503E-04),
    579: (1.021163E+00, 8.872401E-01, 1.425177E-04),
    580: (1.034327E+00, 8.77536E-01, 1.29823E-04),
    581: (1.048753E+00, 8.68792E-01, 1.182974E-04),
    582: (1.063937E+00, 8.607474E-01, 1.07831E-04),
    583: (1.079166E+00, 8.530233E-01, 9.832455E-05),
    584: (1.093723E+00, 8.452535E-01, 8.968787E-05),
    585: (1.106886E+00, 8.370838E-01, 8.183954E-05),
    586: (1.118106E+00, 8.282409E-01, 7.470582E-05),
    587: (1.127493E+00, 8.18732E-01, 6.821991E-05),
    588: (1.135317E+00, 8.086352E-01, 6.232132E-05),
    589: (1.141838E+00, 7.980296E-01, 5.695534E-05),
    590: (1.147304E+00, 7.86995E-01, 5.207245E-05),
    591: (1.151897E+00, 7.75604E-01, 4.762781E-05),
    592: (1.155582E+00, 7.638996E-01, 4.358082E-05),
    593: (1.158284E+00, 7.519157E-01, 3.989468E-05),
    594: (1.159934E+00, 7.396832E-01, 3.653612E-05),
    595: (1.160477E+00, 7.272309E-01, 3.347499E-05),
    596: (1.15989E+00, 7.145878E-01, 3.0684E-05),
    597: (1.158259E+00, 7.017926E-01, 2.813839E-05),
    598: (1.155692E+00, 6.888866E-01, 2.581574E-05),
    599: (1.152293E+00, 6.759103E-01, 2.369574E-05),
    600: (1.148163E+00, 6.629035E-01, 2.175998E-05),
    601: (1.143345E+00, 6.498911E-01, 1.999179E-05),
    602: (1.137685E+00, 6.36841E-01, 1.837603E-05),
    603: (1.130993E+00, 6.237092E-01, 1.689896E-05),
    604: (1.123097E+00, 6.104541E-01, 1.554815E-05),
    605: (1.113846E+00, 5.970375E-01, 1.431231E-05),
    606: (1.103152E+00, 5.834395E-01, 1.318119E-05),
    607: (1.091121E+00, 5.697044E-01, 1.214548E-05),
    608: (1.077902E+00, 5.558892E-01, 1.119673E-05),
    609: (1.063644E+00, 5.420475E-01, 1.032727E-05),
    610: (1.048485E+00, 5.282296E-01, 9.53013E-06),
    611: (1.032546E+00, 5.144746E-01, 8.798979E-06),
    612: (1.01587E+00, 5.007881E-01, 8.128065E-06),
    613: (9.984859E-01, 4.871687E-01, 7.51216E-06),
    614: (9.804227E-01, 4.73616E-01, 6.946506E-06),
    615: (9.617111E-01, 4.601308E-01, 6.426776E-06),
    616: (9.424119E-01, 4.46726E-01, 0E+00),
    617: (9.227049E-01, 4.334589E-01, 0E+00),
    618: (9.027804E-01, 4.203919E-01, 0E+00),
    619: (8.828123E-01, 4.07581E-01, 0E+00),
    620: (8.629581E-01, 3.950755E-01, 0E+00),
    621: (8.432731E-01, 3.828894E-01, 0E+00),
    622: (8.234742E-01, 3.70919E-01, 0E+00),
    623: (8.032342E-01, 3.590447E-01, 0E+00),
    624: (7.822715E-01, 3.471615E-01, 0E+00),
    625: (7.603498E-01, 3.351794E-01, 0E+00),
    626: (7.373739E-01, 3.230562E-01, 0E+00),
    627: (7.13647E-01, 3.108859E-01, 0E+00),
    628: (6.895336E-01, 2.98784E-01, 0E+00),
    629: (6.653567E-01, 2.868527E-01, 0E+00),
    630: (6.413984E-01, 2.751807E-01, 0E+00),
    631: (6.178723E-01, 2.638343E-01, 0E+00),
    632: (5.948484E-01, 2.52833E-01, 0E+00),
    633: (5.7236E-01, 2.421835E-01, 0E+00),
    634: (5.504353E-01, 2.318904E-01, 0E+00),
    635: (5.290979E-01, 2.219564E-01, 0E+00),
    636: (5.083728E-01, 2.123826E-01, 0E+00),
    637: (4.883006E-01, 2.031698E-01, 0E+00),
    638: (4.689171E-01, 1.943179E-01, 0E+00),
    639: (4.502486E-01, 1.85825E-01, 0E+00),
    640: (4.323126E-01, 1.776882E-01, 0E+00),
    641: (4.15079E-01, 1.698926E-01, 0E+00),
    642: (3.983657E-01, 1.623822E-01, 0E+00),
    643: (3.819846E-01, 1.550986E-01, 0E+00),
    644: (3.657821E-01, 1.479918E-01, 0E+00),
    645: (3.496358E-01, 1.410203E-01, 0E+00),
    646: (3.334937E-01, 1.341614E-01, 0E+00),
    647: (3.174776E-01, 1.274401E-01, 0E+00),
    648: (3.017298E-01, 1.208887E-01, 0E+00),
    649: (2.863684E-01, 1.145345E-01, 0E+00),
    650: (2.7149E-01, 1.083996E-01, 0E+00),
    651: (2.571632E-01, 1.025007E-01, 0E+00),
    652: (2.434102E-01, 9.684588E-02, 0E+00),
    653: (2.302389E-01, 9.143944E-02, 0E+00),
    654: (2.176527E-01, 8.628318E-02, 0E+00),
    655: (2.056507E-01, 8.137687E-02, 0E+00),
    656: (1.942251E-01, 7.671708E-02, 0E+00),
    657: (1.83353E-01, 7.229404E-02, 0E+00),
    658: (1.730097E-01, 6.809696E-02, 0E+00),
    659: (1.631716E-01, 6.411549E-02, 0E+00),
    660: (1.538163E-01, 6.033976E-02, 0E+00),
    661: (1.44923E-01, 5.676054E-02, 0E+00),
    662: (1.364729E-01, 5.336992E-02, 0E+00),
    663: (1.284483E-01, 5.016027E-02, 0E+00),
    664: (1.20832E-01, 4.712405E-02, 0E+00),
    665: (1.136072E-01, 4.425383E-02, 0E+00),
    666: (1.067579E-01, 4.154205E-02, 0E+00),
    667: (1.002685E-01, 3.898042E-02, 0E+00),
    668: (9.412394E-02, 3.656091E-02, 0E+00),
    669: (8.830929E-02, 3.427597E-02, 0E+00),
    670: (8.28101E-02, 3.211852E-02, 0E+00),
    671: (7.761208E-02, 3.008192E-02, 0E+00),
    672: (7.270064E-02, 2.816001E-02, 0E+00),
    673: (6.806167E-02, 2.634698E-02, 0E+00),
    674: (6.368176E-02, 2.463731E-02, 0E+00),
    675: (5.954815E-02, 2.302574E-02, 0E+00),
    676: (5.564917E-02, 2.150743E-02, 0E+00),
    677: (5.197543E-02, 2.007838E-02, 0E+00),
    678: (4.851788E-02, 1.873474E-02, 0E+00),
    679: (4.526737E-02, 1.747269E-02, 0E+00),
    680: (4.221473E-02, 1.628841E-02, 0E+00),
    681: (3.934954E-02, 1.517767E-02, 0E+00),
    682: (3.66573E-02, 1.413473E-02, 0E+00),
    683: (3.412407E-02, 1.315408E-02, 0E+00),
    684: (3.173768E-02, 1.223092E-02, 0E+00),
    685: (2.948752E-02, 1.136106E-02, 0E+00),
    686: (2.736717E-02, 1.05419E-02, 0E+00),
    687: (2.538113E-02, 9.77505E-03, 0E+00),
    688: (2.353356E-02, 9.061962E-03, 0E+00),
    689: (2.182558E-02, 8.402962E-03, 0E+00),
    690: (2.02559E-02, 7.797457E-03, 0E+00),
    691: (1.881892E-02, 7.24323E-03, 0E+00),
    692: (1.74993E-02, 6.734381E-03, 0E+00),
    693: (1.628167E-02, 6.265001E-03, 0E+00),
    694: (1.515301E-02, 5.830085E-03, 0E+00),
    695: (1.41023E-02, 5.425391E-03, 0E+00),
    696: (1.312106E-02, 5.047634E-03, 0E+00),
    697: (1.220509E-02, 4.69514E-03, 0E+00),
    698: (1.135114E-02, 4.366592E-03, 0E+00),
    699: (1.055593E-02, 4.060685E-03, 0E+00),
    700: (9.816228E-03, 3.77614E-03, 0E+00),
    701: (9.128517E-03, 3.511578E-03, 0E+00),
    702: (8.488116E-03, 3.265211E-03, 0E+00),
    703: (7.890589E-03, 3.035344E-03, 0E+00),
    704: (7.332061E-03, 2.820496E-03, 0E+00),
    705: (6.809147E-03, 2.619372E-03, 0E+00),
    706: (6.319204E-03, 2.43096E-03, 0E+00),
    707: (5.861036E-03, 2.254796E-03, 0E+00),
    708: (5.433624E-03, 2.090489E-03, 0E+00),
    709: (5.035802E-03, 1.937586E-03, 0E+00),
    710: (4.666298E-03, 1.795595E-03, 0E+00),
    711: (4.32375E-03, 1.663989E-03, 0E+00),
    712: (4.006709E-03, 1.542195E-03, 0E+00),
    713: (3.713708E-03, 1.429639E-03, 0E+00),
    714: (3.443294E-03, 1.325752E-03, 0E+00),
    715: (3.194041E-03, 1.22998E-03, 0E+00),
    716: (2.964424E-03, 1.141734E-03, 0E+00),
    717: (2.752492E-03, 1.060269E-03, 0E+00),
    718: (2.556406E-03, 9.848854E-04, 0E+00),
    719: (2.374564E-03, 9.149703E-04, 0E+00),
    720: (2.205568E-03, 8.499903E-04, 0E+00),
    721: (2.048294E-03, 7.895158E-04, 0E+00),
    722: (1.902113E-03, 7.333038E-04, 0E+00),
    723: (1.766485E-03, 6.811458E-04, 0E+00),
    724: (1.640857E-03, 6.328287E-04, 0E+00),
    725: (1.524672E-03, 5.881375E-04, 0E+00),
    726: (1.417322E-03, 5.468389E-04, 0E+00),
    727: (1.318031E-03, 5.086349E-04, 0E+00),
    728: (1.226059E-03, 4.732403E-04, 0E+00),
    729: (1.140743E-03, 4.404016E-04, 0E+00),
    730: (1.061495E-03, 4.098928E-04, 0E+00),
    731: (9.877949E-04, 3.815137E-04, 0E+00),
    732: (9.191847E-04, 3.550902E-04, 0E+00),
    733: (8.552568E-04, 3.304668E-04, 0E+00),
    734: (7.956433E-04, 3.07503E-04, 0E+00),
    735: (7.40012E-04, 2.860718E-04, 0E+00),
    736: (6.88098E-04, 2.660718E-04, 0E+00),
    737: (6.397864E-04, 2.474586E-04, 0E+00),
    738: (5.949726E-04, 2.301919E-04, 0E+00),
    739: (5.535291E-04, 2.142225E-04, 0E+00),
    740: (5.153113E-04, 1.994949E-04, 0E+00),
    741: (4.801234E-04, 1.859336E-04, 0E+00),
    742: (4.476245E-04, 1.734067E-04, 0E+00),
    743: (4.174846E-04, 1.617865E-04, 0E+00),
    744: (3.894221E-04, 1.509641E-04, 0E+00),
    745: (3.631969E-04, 1.408466E-04, 0E+00),
    746: (3.386279E-04, 1.313642E-04, 0E+00),
    747: (3.156452E-04, 1.224905E-04, 0E+00),
    748: (2.941966E-04, 1.14206E-04, 0E+00),
    749: (2.742235E-04, 1.064886E-04, 0E+00),
    750: (2.556624E-04, 9.931439E-05, 0E+00),
    751: (2.38439E-04, 9.265512E-05, 0E+00),
    752: (2.224525E-04, 8.647225E-05, 0E+00),
    753: (2.076036E-04, 8.07278E-05, 0E+00),
    754: (1.938018E-04, 7.538716E-05, 0E+00),
    755: (1.809649E-04, 7.041878E-05, 0E+00),
    756: (1.690167E-04, 6.579338E-05, 0E+00),
    757: (1.578839E-04, 6.14825E-05, 0E+00),
    758: (1.474993E-04, 5.746008E-05, 0E+00),
    759: (1.378026E-04, 5.370272E-05, 0E+00),
    760: (1.287394E-04, 5.018934E-05, 0E+00),
    761: (1.202644E-04, 4.690245E-05, 0E+00),
    762: (1.123502E-04, 4.383167E-05, 0E+00),
    763: (1.049725E-04, 4.09678E-05, 0E+00),
    764: (9.810596E-05, 3.830123E-05, 0E+00),
    765: (9.172477E-05, 3.582218E-05, 0E+00),
    766: (8.579861E-05, 3.351903E-05, 0E+00),
    767: (8.028174E-05, 3.137419E-05, 0E+00),
    768: (7.513013E-05, 2.937068E-05, 0E+00),
    769: (7.030565E-05, 2.74938E-05, 0E+00),
    770: (6.577532E-05, 2.573083E-05, 0E+00),
    771: (6.151508E-05, 2.407249E-05, 0E+00),
    772: (5.752025E-05, 2.251704E-05, 0E+00),
    773: (5.378813E-05, 2.10635E-05, 0E+00),
    774: (5.03135E-05, 1.970991E-05, 0E+00),
    775: (4.708916E-05, 1.845353E-05, 0E+00),
    776: (4.410322E-05, 1.728979E-05, 0E+00),
    777: (4.13315E-05, 1.620928E-05, 0E+00),
    778: (3.874992E-05, 1.520262E-05, 0E+00),
    779: (3.633762E-05, 1.426169E-05, 0E+00),
    780: (3.407653E-05, 1.337946E-05, 0E+00),
    781: (3.195242E-05, 1.255038E-05, 0E+00),
    782: (2.995808E-05, 1.177169E-05, 0E+00),
    783: (2.808781E-05, 1.104118E-05, 0E+00),
    784: (2.633581E-05, 1.035662E-05, 0E+00),
    785: (2.46963E-05, 9.715798E-06, 0E+00),
    786: (2.316311E-05, 9.116316E-06, 0E+00),
    787: (2.172855E-05, 8.555201E-06, 0E+00),
    788: (2.038519E-05, 8.029561E-06, 0E+00),
    789: (1.912625E-05, 7.536768E-06, 0E+00),
    790: (1.794555E-05, 7.074424E-06, 0E+00),
    791: (1.683776E-05, 6.640464E-06, 0E+00),
    792: (1.579907E-05, 6.233437E-06, 0E+00),
    793: (1.482604E-05, 5.852035E-06, 0E+00),
    794: (1.391527E-05, 5.494963E-06, 0E+00),
    795: (1.306345E-05, 5.160948E-06, 0E+00),
    796: (1.22672E-05, 4.848687E-06, 0E+00),
    797: (1.152279E-05, 4.556705E-06, 0E+00),
    798: (1.082663E-05, 4.28358E-06, 0E+00),
    799: (1.01754E-05, 4.027993E-06, 0E+00),
    800: (9.565993E-06, 3.788729E-06, 0E+00),
    801: (8.995405E-06, 3.564599E-06, 0E+00),
    802: (8.460253E-06, 3.354285E-06, 0E+00),
    803: (7.957382E-06, 3.156557E-06, 0E+00),
    804: (7.483997E-06, 2.970326E-06, 0E+00),
    805: (7.037621E-06, 2.794625E-06, 0E+00),
    806: (6.616311E-06, 2.628701E-06, 0E+00),
    807: (6.219265E-06, 2.472248E-06, 0E+00),
    808: (5.845844E-06, 2.32503E-06, 0E+00),
    809: (5.495311E-06, 2.186768E-06, 0E+00),
    810: (5.166853E-06, 2.057152E-06, 0E+00),
    811: (4.859511E-06, 1.935813E-06, 0E+00),
    812: (4.571973E-06, 1.822239E-06, 0E+00),
    813: (4.30292E-06, 1.715914E-06, 0E+00),
    814: (4.051121E-06, 1.616355E-06, 0E+00),
    815: (3.815429E-06, 1.523114E-06, 0E+00),
    816: (3.594719E-06, 1.43575E-06, 0E+00),
    817: (3.387736E-06, 1.353771E-06, 0E+00),
    818: (3.193301E-06, 1.276714E-06, 0E+00),
    819: (3.010363E-06, 1.204166E-06, 0E+00),
    820: (2.83798E-06, 1.135758E-06, 0E+00),
    821: (2.675365E-06, 1.071181E-06, 0E+00),
    822: (2.52202E-06, 1.010243E-06, 0E+00),
    823: (2.377511E-06, 9.527779E-07, 0E+00),
    824: (2.241417E-06, 8.986224E-07, 0E+00),
    825: (2.113325E-06, 8.476168E-07, 0E+00),
    826: (1.99283E-06, 7.996052E-07, 0E+00),
    827: (1.879542E-06, 7.544361E-07, 0E+00),
    828: (1.773083E-06, 7.119624E-07, 0E+00),
    829: (1.673086E-06, 6.720421E-07, 0E+00),
    830: (1.579199E-06, 6.34538E-07, 0E+00),
}
