# MarkdownTOC - 3.0.0

---

**NOTE**
This upgrade contains **breaking changes**.
Please follow "Upgrade guide from v2 to v3" for instructions.

---

## Changes

1. `MarkdownTOC.sublime-settings` format has been changed.
2. `default_bullets` is deprecated, use `defaults.bullets` instead.
3. `default_depth` is deprecated, use `levels` instead. Ref: #55
4. `lowercase_only_ascii` is deprecated, use `lowercase` instead with new value format. Ref: #105
5. `defaults.bracket`(ex `default_bracket`) default value is changed to `"round"`
6. Allow regular expressions in 'id_replacements', the format has been changed. Ref: #113


# Upgrade Guide

## Upgrading from MarkdownTOC v2.x to v3

First of all `default_xxx` moves to `defaults.xxx`.
Please modify your settings if you have your own **User Settings**(`Packages/User/MarkdownTOC.sublime-settings`).


### 1. `MarkdownTOC.sublime-settings` format has been changed

Old format:

```json

{
  "default_autoanchor": false,
  "default_autolink": false,
  "default_indent": "\t",
  "default_remove_image": true,
  "default_link_prefix": "",
  "default_style": "unordered",
  "default_uri_encoding": true,
  "default_markdown_preview": false
}
```

New format:

```json
{
  "defaults": {
    "autoanchor": false,
    "autolink": false,
    "indent": "\t",
    "remove_image": true,
    "link_prefix": "",
    "style": "unordered",
    "uri_encoding": true,
    "markdown_preview": false
  }
}
```


### 2. `default_bullets` is deprecated, use `defaults.bullets` instead

Old format:

```json
{
  "default_bullets": "-+*"
}
```

or value could also be array.

```json
{
  "default_bullets": ["-","+","*"]
}
```

New format:

```json
{
  "defaults": {
    "bullets": ["-","+","*"]
  }
}
```

Note: Values type is 'array'

You can also override it as attribute

```markdown
<!-- MarkdownTOC bullets="-,+,*" -->
```

Note: Values type is 'comma separated strings'


### 3. `default_depth` is deprecated, use `defaults.levels` instead

Old format:

```json
{
  "default_depth": 0
}
```

New format:

```json
{
  "defaults": {
    "levels": [1,2,3,4,5,6]
  }
}
```

Note: Values type is 'array'

You can also override it as attribute

```markdown
<!-- MarkdownTOC levels="1,2,3" -->
```

Note:

- Values type is 'comma separated strings'
- The default value changed to `[1,2,3,4,5,6]`, it means all headings(`h1`...`h6`) appear in TOC. Please override in your **User Settings**(`Packages/User/MarkdownTOC.sublime-settings`) if you prefer previous settings (e.g. `[1,2]`) or any others.


### 4. `lowercase_only_ascii` is deprecated, use `defaults.lowercase` instead

Old format:

```json
{
  "lowercase": true,
  "lowercase_only_ascii": true
}
```

New format:

```json
{
  "defaults": {
    "lowercase": "only_ascii"
  }
}
```

Note: Values type is 'string' and allows following values `"only_ascii"`(default), `"all"` and `"false"`.

You can also override it as attribute

```markdown
<!-- MarkdownTOC lowercase="all" -->
```

See [docs](https://github.com/naokazuterada/MarkdownTOC#lowercasing-in-ids) for more detail.


### 5. `defaults.bracket`(ex `default_bracket`) default value is changed to `"round"`

The default value has been changed. So if you prefer `"square"` style, please override in your **User Settings**(`Packages/User/MarkdownTOC.sublime-settings`)


### 6. Allow regular expressions in 'id_replacements', the format has been changed

Setting format has been changed.
You have to modify `id_replacements` section if you customised **User Settings**(`Packages/User/MarkdownTOC.sublime-settings`) yourself.

Old format:

```json
{
  "id_replacements": {
    "-": " ",
    "" : ["!","#","$"]
  }
}
```

New format:

```json
{
  "id_replacements": [
    {
      "pattern": "\\s",
      "replacement": "-"
    },
    {
      "pattern": "!|#|$",
      "replacement": ""
    }
  ]
}
```
