[![DeepScan grade](https://deepscan.io/api/projects/3277/branches/27824/badge/grade.svg)](https://deepscan.io/dashboard#view=project&pid=3277&bid=27824)

Sublime-JSLint
==============

Easy JSLint for Sublime Text.

   * It has JSLint built in; requires only [Node.JS](http://nodejs.org) installed on your system.
   * It can automatically run JSLint when you save a `.js` file.
   * Support for ES6: The Good Parts.
   * Now supports JSON.
   * Fully configurable linting options.
   * Jump to errors using F4 / Shift+F4.
   * Works on Linux, MacOS and Windows.

Prerequisites
-------------
NodeJS must be installed on your system and you must be able to run 'node' from the command line. Alternatively, if you have a different `jslint` utility already installed on your system, you may update the settings to use it instead.

Installation
------------

### Using Package Control:
   * Install the [Package Control](https://sublime.wbond.net/installation) plugin if you don't have it
   * Press Ctrl+Shift+P to bring up the Command Palette (or use Tools > Command Palette menu)
   * Select Package Control: Install Package
   * Type 'JSLint' to find JSLint (with node) for Sublime Text 2
   * Select 'JSLint (with node) for Sublime Text 2' to install


### Not using Package Control:
   * Get files from the [package archive](https://github.com/darrenderidder/Sublime-JSLint/archive/master.zip)
   * unzip to Packages/JSLint directory (use "2" or "3" depending on which version you have):
      * Linux: ~/.config/sublime-text-2/Packages/JSLint
      * Mac: ~/Library/Application Support/Sublime Text 2/Packages/JSLint
      * Windows: %APPDATA%/Sublime Text 2/Packages/JSLint
   * Relaunch Sublime Text

Usage
-----
Any of the following will work:

   * Bring up the **Command Palette** (`Command+Shift+P` on OS X, `Control+Shift+P` on Linux/Windows), then type `JSLint`.
   * Click the **Tools > JSLint** menu entry.
   * Press `CTRL+L`.
   * Just save a `.js` file.

Settings
--------
* Navigate to **Preferences > Package Settings > JSLint > Settings - Default**.
* To preserve custom settings:
  * copy default settings to **Preferences > Package Settings > JSLint > Settings - User**
  * modify them to your requirements


Troubleshooting
---------------

### "No such file or directory" when saving

When, on saving a .js file, you get this:

    [Errno 2] No such file or directory
    [cmd:  [u'node', ...]]


the command to run node might not be in your path. 

Mac OS X users, ensure that `/usr/local/bin` is in your `$PATH` environment variable.

Linux users, if your node command is 'nodejs', as is the case when installing from some Linux repos,  
navigate to **Preferences > Package Settings > JSLint > Settings - User** to change it, e.g.
```js
{
   "jslint": ["nodejs", "~/.config/sublime-text-2/Packages/JSLint/linter.js"]
}
```

