# Hyperflask

[Hyperflask Components][] syntax definition for [Sublime Text][] based on [Jinja2][] syntax.

![](preview.png)
## Features

Syntax Highlighting for

- AlpineJS
- HTMX
- [Jinjapy][] frontmatter
- [Jinja Super Macros][] (e.g. `<{Component arg-name=[val for val in any.values] }/>`)
- [Jinja2 Templates][]

## Installation

### Requirements

This package requires:

- Sublime Text 4152+
- [Hyperscript][]
- [Jinja2][]

### Package Control

The easiest way to install is using [Package Control][]. It's listed as `Hyperflask`.

1. Open `Command Palette` using <kbd>ctrl+shift+P</kbd> or menu item `Tools → Command Palette...`
2. Choose `Package Control: Install Package`
3. Find `Jinja2` and hit <kbd>Enter</kbd>
4. Find `Hyperscript` and hit <kbd>Enter</kbd>
5. Find `Hyperflask` and hit <kbd>Enter</kbd>

### Manual Install

1. Download [Hyperflask.sublime-package][].
2. Download [Hyperscript][] package.
3. Download [Jinja2.sublime-package][] package.
4. Copy them into _Installed Packages_ directory

> [!NOTE]
>
> To find _Installed Packages_...
>
> 1. call _Menu > Preferences > Browse Packages.._
> 2. Navigate to parent folder

> [!WARNING]
>
> Manually installed packages are not automatically updated by Package Control.

[Hyperflask Components]: https://hyperflask.dev/guides/components/
[Hyperflask.sublime-package]: https://github.com/SublimeText/Hyperflask/releases/
[Hyperscript]: https://packagecontrol.io/packages/Hyperscript
[Jinja2]: https://packagecontrol.io/packages/Jinja2
[Jinja2.sublime-package]: https://github.com/Sublime-Instincts/BetterJinja/releases/
[Jinja2 Templates]: https://pypi.org/project/jinja2/
[Jinjapy]: https://pypi.org/project/jinjapy/
[Jinja Super Macros]: https://pypi.org/project/jinja-super-macros/
[Package Control]: https://packagecontrol.io
[Sublime Text]: https://www.sublimetext.com
